/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.joshedit;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.print.PrintService;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.CaretListener;
import org.lateralgm.joshedit.Code;
import org.lateralgm.joshedit.JoshText;
import org.lateralgm.joshedit.LineNumberPanel;
import org.lateralgm.joshedit.QuickFind;
import org.lateralgm.joshedit.Runner;
import org.lateralgm.joshedit.TokenMarker;

public class JoshTextPanel
extends JPanel
implements Printable {
    private static final long serialVersionUID = 1L;
    public JScrollPane scroller;
    public JoshText text;
    public LineNumberPanel lines;
    public QuickFind find;
    public static ScrollPaneProvider scrollPaneProvider = new ScrollPaneProvider(){

        @Override
        public JScrollPane get(JoshText text) {
            return new JScrollPane(text);
        }
    };
    public AbstractAction actPrint = new AbstractAction("PRINT"){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                JoshTextPanel.this.Print();
            }
            catch (PrinterException pe) {
                pe.printStackTrace();
            }
        }
    };

    public JoshTextPanel() {
        this((String[])null, (Font)null);
    }

    public JoshTextPanel(String code) {
        this(Runner.splitLines(code), null);
    }

    public JoshTextPanel(String code, Font font) {
        this(Runner.splitLines(code), font);
    }

    public JoshTextPanel(String[] codeLines) {
        this(codeLines, null);
    }

    public JoshTextPanel(String[] codeLines, Font font) {
        this(codeLines, font, true);
    }

    public JoshTextPanel(String[] codeLines, Font font, boolean startZero) {
        super(new BorderLayout());
        this.text = new JoshText(codeLines, font);
        this.lines = new LineNumberPanel(this.text, this.text.code.size(), startZero);
        this.text.code.addCodeListener(new Code.CodeListener(){

            @Override
            public void codeChanged(Code.CodeEvent e) {
                JoshTextPanel.this.lines.setLines(JoshTextPanel.this.text.code.size());
            }
        });
        this.find = new QuickFind(this.text);
        this.text.finder = this.find;
        this.text.mapAction(this.actPrint);
        this.scroller = scrollPaneProvider.get(this.text);
        this.scroller.setRowHeaderView(this.lines);
        this.add((Component)this.scroller, "Center");
        this.add((Component)this.find, "South");
    }

    public int getCaretLine() {
        return this.text.caret.row;
    }

    public int getCaretColumn() {
        return this.text.caret.col;
    }

    public void setCaretPosition(int row, int col) {
        this.text.caret.row = row;
        this.text.caret.col = col;
        this.text.caret.colw = this.text.line_wid_at(row, col);
        this.text.sel.deselect(false);
        this.text.caret.positionChanged();
    }

    public void addCaretListener(CaretListener cl) {
        this.text.caret.addCaretListener(cl);
    }

    public String getTextCompat() {
        StringBuilder res = new StringBuilder();
        int i = 0;
        while (i < this.text.code.size()) {
            if (i != 0) {
                res.append("\r\n");
            }
            res.append((CharSequence)this.text.code.getsb(i));
            ++i;
        }
        return res.toString();
    }

    public boolean isChanged() {
        return this.text.isChanged();
    }

    public void setText(String s) {
        this.text.setText(s == null ? null : s.split("\r?\n"));
    }

    public String getLineText(int line) {
        return this.text.code.getsb(line).toString();
    }

    public int getLineCount() {
        return this.text.code.size();
    }

    public void setTabSize(int spaces) {
        JoshText.Settings.indentSizeInSpaces = spaces;
    }

    public void setTokenMarker(TokenMarker tm) {
        this.text.setTokenMarker(tm);
    }

    public void setSelection(int row, int col, int row2, int col2) {
        this.text.sel.row = row;
        this.text.sel.col = col;
        this.text.caret.row = row2;
        this.text.caret.col = col2;
        this.text.caret.colw = this.text.line_wid_at(row, col);
        this.text.caret.positionChanged();
        this.text.sel.selectionChanged();
    }

    public boolean Print() throws PrinterException {
        HashPrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
        PrinterJob pj = PrinterJob.getPrinterJob();
        pj.setPrintable(this);
        PrintService[] services = PrinterJob.lookupPrintServices();
        if (services.length > 0) {
            pj.setPrintService(services[0]);
            if (pj.printDialog(aset)) {
                pj.print(aset);
                return true;
            }
        }
        return false;
    }

    @Override
    public int print(Graphics g, PageFormat pf, int pageIndex) throws PrinterException {
        return this.text.print(this.lines, g, pf, pageIndex);
    }

    public static interface ScrollPaneProvider {
        public JScrollPane get(JoshText var1);
    }
}

