/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.joshedit;

import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import org.lateralgm.joshedit.Caret;
import org.lateralgm.joshedit.Code;
import org.lateralgm.joshedit.ColorProfile;
import org.lateralgm.joshedit.FindDialog;
import org.lateralgm.joshedit.Line;
import org.lateralgm.joshedit.LineNumberPanel;
import org.lateralgm.joshedit.Selection;
import org.lateralgm.joshedit.SyntaxDesc;
import org.lateralgm.joshedit.TokenMarker;
import org.lateralgm.joshedit.preferences.KeybindingsPanel;

public class JoshText
extends JComponent
implements Scrollable,
ComponentListener,
ClipboardOwner,
FocusListener,
Printable {
    private static final long serialVersionUID = 1L;
    private Color whitespaceColor = Color.RED;
    private Color lineHighlightColor = new Color(230, 240, 255);
    private Color matchingCharColor = new Color(100, 100, 100);
    private Color noMatchingCharColor = Color.RED;
    private Color backgroundColor = Color.WHITE;
    private Color defaultFontColor = Color.BLACK;
    private Font baseFont = null;
    private final HashMap<Integer, Font> specialFonts = new HashMap();
    Code code;
    Selection sel;
    Caret caret;
    DragListener dragger;
    private TokenMarker marker;
    public ArrayList<Highlighter> highlighters = new ArrayList();
    private final int monoAdvance;
    private final int lineHeight;
    private final int lineAscent;
    private final int lineLeading;
    private int maxRowSize;
    Queue<String> infoMessages = new LinkedList<String>();
    public FindDialog.FindNavigator finder;
    private JEFileChooser fileChooser = new DefaultJEFileChooser();
    SyntaxDesc myLang;
    CodeMetrics metrics = new CodeMetrics(){

        @Override
        public int stringWidth(String l, int end) {
            end = Math.min(end, l.length());
            int w = 0;
            int i = 0;
            while (i < end) {
                if (l.charAt(i) == '\t') {
                    int wf = JoshText.this.monoAdvance * Settings.indentSizeInSpaces;
                    w = (w + wf) / wf * wf;
                } else {
                    w += JoshText.this.monoAdvance;
                }
                ++i;
            }
            return w;
        }

        @Override
        public int lineWidth(int y, int end) {
            return this.stringWidth(JoshText.this.code.getsb(y).toString(), end);
        }

        @Override
        public int glyphWidth() {
            return JoshText.this.monoAdvance;
        }

        @Override
        public int lineHeight() {
            return JoshText.this.lineHeight;
        }
    };
    private static final char[] chType = new char[256];
    public AbstractAction actCut = new AbstractAction("CUT"){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            JoshText.this.Cut();
        }
    };
    public AbstractAction actCopy = new AbstractAction("COPY"){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            JoshText.this.Copy();
        }
    };
    public AbstractAction actPaste = new AbstractAction("PASTE"){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            JoshText.this.Paste();
        }
    };
    public AbstractAction actUndo = new AbstractAction("UNDO"){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            JoshText.this.Undo();
        }
    };
    public AbstractAction actRedo = new AbstractAction("REDO"){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            JoshText.this.Redo();
        }
    };
    public AbstractAction actFind = new AbstractAction("FIND"){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            JoshText.this.ShowFind();
        }
    };
    public AbstractAction actQuickFind = new AbstractAction("QUICKFIND"){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            JoshText.this.ShowQuickFind();
        }
    };
    public AbstractAction actLineDel = new AbstractAction("LINEDEL"){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            JoshText.this.LineDel();
        }
    };
    public AbstractAction actLineDup = new AbstractAction("LINEDUP"){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            JoshText.this.LineDup();
        }
    };
    public AbstractAction actLineSwap = new AbstractAction("LINESWAP"){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            JoshText.this.LineSwap();
        }
    };
    public AbstractAction actLineUnSwap = new AbstractAction("LINEUNSWAP"){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            JoshText.this.LineUnSwap();
        }
    };
    public AbstractAction actSelAll = new AbstractAction("SELALL"){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            JoshText.this.SelectAll();
        }
    };
    FindDialog findDialog = FindDialog.getInstance();
    private final MouseAutoScroll mas = new MouseAutoScroll();
    private boolean shouldHandleRelease = false;
    private final ArrayList<UndoPatch> undoPatches = new ArrayList();
    private boolean undoCanMerge = true;
    private int patchIndex = 0;

    static {
        int i = 0;
        while (i < 256) {
            JoshText.chType[i] = '\u0000';
            ++i;
        }
        i = 97;
        while (i <= 122) {
            JoshText.chType[i] = '\u0001';
            ++i;
        }
        i = 65;
        while (i <= 90) {
            JoshText.chType[i] = '\u0001';
            ++i;
        }
        i = 48;
        while (i <= 57) {
            JoshText.chType[i] = '\u0001';
            ++i;
        }
        JoshText.chType[95] = '\u0001';
        JoshText.chType[32] = 2;
        JoshText.chType[9] = 2;
        JoshText.chType[13] = 2;
        JoshText.chType[10] = 2;
    }

    public JEFileChooser getFileChooser() {
        return this.fileChooser;
    }

    public void setFileChooser(JEFileChooser fileChooser) {
        this.fileChooser = fileChooser;
    }

    public JoshText() {
        this(null, null);
    }

    public JoshText(String[] lines, Font font) {
        this.setPreferredSize(new Dimension(320, 240));
        if (font == null) {
            this.setFont(new Font("Monospaced", 0, 12));
        } else {
            this.setFont(font);
        }
        this.setBackground(this.backgroundColor);
        this.setForeground(this.defaultFontColor);
        this.setCursor(Cursor.getPredefinedCursor(2));
        this.setOpaque(true);
        this.getInsets().left = 4;
        this.setFocusable(true);
        this.focusGained(null);
        this.setFocusTraversalKeysEnabled(false);
        this.setTransferHandler(new JoshTextTransferHandler());
        KeybindingsPanel.readMappings(this.getInputMap());
        this.mapActions();
        this.enableEvents(56L);
        this.code = new Code();
        if (lines == null || lines.length == 0) {
            this.code.add(new StringBuilder());
        } else {
            String[] stringArray = lines;
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                this.code.add(line);
                ++n2;
            }
        }
        FontMetrics fm = this.getFontMetrics(this.getFont());
        this.lineAscent = fm.getAscent();
        this.lineHeight = fm.getHeight();
        this.lineLeading = fm.getLeading();
        this.monoAdvance = fm.getWidths()[77];
        this.caret = new Caret(this);
        this.sel = new Selection(this.code, this, this.caret);
        this.dragger = new DragListener();
        this.myLang = new SyntaxDesc();
        this.myLang.set_language("Shitbag");
        if (Settings.highlight_line) {
            this.highlighters.add(new Highlighter(){

                @Override
                public void paint(Graphics g, Insets i, CodeMetrics gm, int line_start, int line_end) {
                    if (JoshText.this.sel.row == JoshText.this.caret.row) {
                        Color rc = g.getColor();
                        g.setColor(JoshText.this.lineHighlightColor);
                        Rectangle clip = g.getClipBounds();
                        g.fillRect(i.left + clip.x, i.top + JoshText.this.caret.row * gm.lineHeight(), clip.width, gm.lineHeight());
                        g.setColor(rc);
                    }
                }
            });
        }
        this.highlighters.add(this.sel);
        BracketHighlighter bm = new BracketHighlighter();
        this.highlighters.add(bm);
        this.caret.addCaretListener(bm);
        this.caret.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                if (!JoshText.this.mas.isRunning()) {
                    JoshText.this.doShowCaret();
                }
            }
        });
        this.doCodeSize(true);
    }

    void setColorProfile(ColorProfile profile) {
        if (profile.getWhitespaceColor() != null) {
            this.whitespaceColor = profile.getWhitespaceColor();
        }
        if (profile.getLineHighlightColor() != null) {
            this.lineHighlightColor = profile.getLineHighlightColor();
        }
        if (profile.getMatchingCharColor() != null) {
            this.matchingCharColor = profile.getMatchingCharColor();
        }
        if (profile.getNoMatchingCharColor() != null) {
            this.noMatchingCharColor = profile.getNoMatchingCharColor();
        }
        if (profile.getBackgroundColor() != null) {
            this.backgroundColor = profile.getBackgroundColor();
        }
        if (profile.getDefaultFontColor() != null) {
            this.defaultFontColor = profile.getDefaultFontColor();
        }
    }

    public boolean checkPointInSelection(Point p) {
        return this.sel.containsPoint(p);
    }

    public void setCaretPosition(int row, int col) {
        this.caret.col = col;
        this.caret.row = row;
        this.sel.deselect(true);
        this.caret.colw = this.line_wid_at(row, col);
    }

    public void setCaretPositionFromPoint(Point p) {
        Point rowCol = this.mouseToPoint(p, true);
        this.setCaretPosition(rowCol.y, rowCol.x);
    }

    public void showCaret() {
        this.doShowCaret();
    }

    public void centerCaret() {
        this.doShowCaret(-1, -1, 0, 0);
    }

    public void setAbsoluteCaretPositionFromPoint(Point p) {
        Point rowCol = this.mouseToPoint(p, false);
        this.sel.col = this.caret.col = rowCol.x;
        this.sel.row = this.caret.row = rowCol.y;
        this.sel.type = Selection.ST.RECT;
        this.caret.colw = this.line_wid_at(rowCol.y, rowCol.x);
    }

    public void setText(String[] lines) {
        this.code.clear();
        if (lines == null || lines.length == 0) {
            this.code.add(new StringBuilder());
        } else {
            String[] stringArray = lines;
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                this.code.add(line);
                ++n2;
            }
        }
        if (this.code.isEmpty()) {
            this.code.add("");
        }
        this.fireLineChange(0, this.code.size());
        this.doCodeSize(true);
    }

    public String[] getLines() {
        String[] res = new String[this.code.size()];
        int i = 0;
        while (i < this.code.size()) {
            res[i] = ((Line)this.code.get((int)i)).sbuild.toString();
            ++i;
        }
        return res;
    }

    public int getLineCount() {
        return this.code.size();
    }

    public String getText() {
        StringBuilder res = new StringBuilder();
        int i = 0;
        while (i < this.code.size()) {
            res.append(String.valueOf(((Line)this.code.get((int)i)).sbuild.toString()) + "\n");
            ++i;
        }
        return res.toString();
    }

    private static String htmlSpecialChars(String x) {
        if (x == null) {
            return "";
        }
        x = x.replace("/", "&#47;").replace("\\", "&#92;");
        x = x.replace("&", "&amp;").replace("\"", "&quot;");
        x = x.replace("<", "&lt;").replace(">", "&gt;");
        return x;
    }

    public String getHTML() {
        StringBuilder res = new StringBuilder(this.code.size() * 100);
        int i = 0;
        while (i < this.code.size()) {
            Line l = (Line)this.code.get(i);
            StringBuilder lsb = l.sbuild;
            int from = 0;
            ArrayList<TokenMarker.TokenMarkerInfo> tmall = this.marker.getStyles(l);
            for (TokenMarker.TokenMarkerInfo ti : tmall) {
                if (ti.startPos > from) {
                    res.append(JoshText.htmlSpecialChars(lsb.substring(from, ti.startPos)));
                }
                if (ti.startPos < ti.endPos) {
                    res.append("<span style=\"");
                    if ((ti.fontStyle & 1) != 0) {
                        res.append("font-weight:bold;");
                    }
                    if ((ti.fontStyle & 2) != 0) {
                        res.append("font-style:italic;");
                    }
                    if (ti.color != null) {
                        res.append("color:#" + Integer.toHexString(ti.color.getRGB()).substring(2) + ";");
                    }
                    res.append("\">");
                    res.append(JoshText.htmlSpecialChars(lsb.substring(ti.startPos, ti.endPos)));
                    res.append("</span>");
                }
                from = ti.endPos;
            }
            res.append("\n");
            ++i;
        }
        return res.toString();
    }

    public void loadFromFile(String name) {
        try {
            BufferedReader br = new BufferedReader(new FileReader(name));
            this.code.clear();
            String line = br.readLine();
            try {
                while (line != null) {
                    this.code.add(line);
                    line = br.readLine();
                }
            }
            finally {
                br.close();
                if (this.code.isEmpty()) {
                    this.code.add("");
                }
            }
            this.fireLineChange(0, this.code.size());
            this.doCodeSize(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static boolean hasExtension(String pathName) {
        File fn = new File(pathName);
        String name = fn.getName();
        return name.lastIndexOf(46) == -1;
    }

    public void saveToFile(String name) {
        if (!JoshText.hasExtension(name)) {
            name = String.valueOf(name) + ".txt";
        }
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(name));){
            int i = 0;
            while (i < this.code.size()) {
                bw.write(String.valueOf(this.code.getsb(i).toString()) + "\n");
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setTokenMarker(TokenMarker tm) {
        if (this.marker != null) {
            this.removeLineChangeListener(this.marker);
        }
        this.marker = tm;
        this.addLineChangeListener(this.marker);
        this.fireLineChange(0, this.code.size());
    }

    public void LineDel() {
    }

    public void LineDup() {
        UndoPatch up = new UndoPatch();
        up.realize(up.startRow + this.sel.duplicate());
        this.storeUndo(up, 8);
    }

    public void LineSwap() {
        if (this.caret.row == this.sel.row) {
            if (this.caret.row == 0) {
                return;
            }
            UndoPatch up = new UndoPatch(this.caret.row - 1, this.caret.row);
            StringBuilder swb = this.code.getsb(this.caret.row - 1);
            ((Line)this.code.get((int)(this.caret.row - 1))).sbuild = ((Line)this.code.get((int)this.caret.row)).sbuild;
            ((Line)this.code.get((int)this.caret.row)).sbuild = swb;
            up.realize(this.caret.row);
            this.storeUndo(up, 10);
            if (this.sel.type != Selection.ST.RECT) {
                this.sel.col = this.caret.col = this.line_offset_from(this.caret.row, this.caret.colw);
            }
        } else {
            UndoPatch up = new UndoPatch();
            int srow = Math.min(this.sel.row, this.caret.row);
            int erow = Math.max(this.sel.row, this.caret.row);
            StringBuilder swb = this.code.getsb(srow);
            int i = srow;
            while (i < erow) {
                ((Line)this.code.get((int)i)).sbuild = ((Line)this.code.get((int)(i + 1))).sbuild;
                ++i;
            }
            ((Line)this.code.get((int)erow)).sbuild = swb;
            up.realize(erow);
            if (this.sel.type != Selection.ST.RECT) {
                this.sel.col = this.caret.col = this.line_offset_from(this.caret.row, this.caret.colw);
            }
            this.storeUndo(up, 10);
        }
    }

    public void LineUnSwap() {
        if (this.caret.row == this.sel.row) {
            if (this.caret.row >= this.code.size() - 1) {
                return;
            }
            UndoPatch up = new UndoPatch(this.caret.row, this.caret.row + 1);
            StringBuilder swb = this.code.getsb(this.caret.row + 1);
            ((Line)this.code.get((int)(this.caret.row + 1))).sbuild = ((Line)this.code.get((int)this.caret.row)).sbuild;
            ((Line)this.code.get((int)this.caret.row)).sbuild = swb;
            up.realize(this.caret.row);
            this.storeUndo(up, 11);
            if (this.sel.type != Selection.ST.RECT) {
                this.sel.col = this.caret.col = this.line_offset_from(this.caret.row, this.caret.colw);
            }
        } else {
            UndoPatch up = new UndoPatch();
            int srow = Math.min(this.sel.row, this.caret.row);
            int erow = Math.max(this.sel.row, this.caret.row);
            StringBuilder swb = this.code.getsb(erow);
            int i = erow;
            while (i > srow) {
                ((Line)this.code.get((int)i)).sbuild = ((Line)this.code.get((int)(i - 1))).sbuild;
                --i;
            }
            ((Line)this.code.get((int)srow)).sbuild = swb;
            up.realize(erow);
            this.storeUndo(up, 11);
            if (this.sel.type != Selection.ST.RECT) {
                this.sel.col = this.caret.col = this.line_offset_from(this.caret.row, this.caret.colw);
            }
        }
    }

    public void SelectAll() {
        this.sel.col = 0;
        this.sel.row = 0;
        this.caret.row = this.code.size() - 1;
        this.caret.col = this.code.getsb(this.caret.row).length();
        this.sel.type = Selection.ST.NORM;
        this.sel.selectionChanged();
        this.repaint();
    }

    public void Save() {
        String path = this.fileChooser.getSaveFilename();
        if (path != null) {
            this.saveToFile(path);
        }
    }

    public void Load() {
        String path = this.fileChooser.getLoadFilename();
        this.loadFromFile(path);
        this.repaint();
    }

    public void Copy() {
        this.sel.copy();
    }

    public void Cut() {
        if (this.sel.isEmpty()) {
            return;
        }
        this.sel.copy();
        UndoPatch up = new UndoPatch();
        this.sel.deleteSel();
        up.realize(Math.max(this.caret.row, this.sel.row));
        this.storeUndo(up, 3);
        this.doCodeSize(true);
        this.repaint();
    }

    public void Paste() {
        UndoPatch up = new UndoPatch(Math.min(this.caret.row, this.sel.row), Math.max(Math.max(this.caret.row, this.sel.row), Math.min(this.code.size() - 1, Math.min(this.caret.row, this.sel.row) + this.sel.getPasteRipple() - 1)));
        up.realize(this.sel.paste());
        this.storeUndo(up, 6);
        this.doCodeSize(true);
        this.repaint();
    }

    public void Undo() {
        this.undo();
        this.doCodeSize(true);
        this.repaint();
    }

    public void Redo() {
        this.redo();
        this.doCodeSize(true);
        this.repaint();
    }

    public void ShowFind() {
        this.findDialog.present(this);
    }

    public void ShowQuickFind() {
        this.finder.present();
    }

    public int print(LineNumberPanel lineNumPanel, Graphics g, PageFormat pf, int pageIndex) throws PrinterException {
        int pageLines = (int)Math.floor(pf.getImageableHeight() / (double)this.lineHeight);
        int pageCount = (int)Math.ceil((float)this.getLineCount() / (float)pageLines);
        if (pageIndex >= pageCount) {
            return 1;
        }
        Graphics2D graphics2D = (Graphics2D)g;
        graphics2D.translate(pf.getImageableX(), pf.getImageableY());
        Object map = Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
        if (map != null) {
            graphics2D.addRenderingHints((Map)map);
        }
        int insetY = this.lineLeading + this.lineAscent;
        int lastLines = pageIndex * pageLines;
        int lineCount = this.getLineCount();
        if (lineNumPanel != null) {
            lineNumPanel.printLineNumbers(g, lastLines, Math.min(pageLines, lineCount - lastLines), lineNumPanel.getLineNumberWidth(lineCount));
            graphics2D.translate(lineNumPanel.getLineNumberWidth(lastLines + lineCount), 0);
        }
        int lineNum = 0;
        while (lineNum < pageLines && lineNum + lastLines < lineCount) {
            this.drawLine(g, lineNum + lastLines, insetY + lineNum * this.lineHeight);
            ++lineNum;
        }
        return 0;
    }

    @Override
    public int print(Graphics g, PageFormat pf, int pageIndex) throws PrinterException {
        return this.print(null, g, pf, pageIndex);
    }

    private void mapActions() {
        ActionMap am = this.getActionMap();
        Action[] acts = new Action[]{this.actLineDel, this.actLineDup, this.actLineSwap, this.actLineUnSwap, this.actSelAll, this.actCopy, this.actCut, this.actPaste, this.actUndo, this.actRedo, this.actFind, this.actQuickFind};
        InputMap map = this.getInputMap();
        KeyStroke[] keys = map.allKeys();
        Action[] actionArray = acts;
        int n = acts.length;
        int n2 = 0;
        while (n2 < n) {
            Action a = actionArray[n2];
            KeyStroke[] keyStrokeArray = keys;
            int n3 = keys.length;
            int n4 = 0;
            while (n4 < n3) {
                KeyStroke key = keyStrokeArray[n4];
                if (map.get(key).equals(a.getValue("Name"))) {
                    a.putValue("AcceleratorKey", key);
                }
                ++n4;
            }
            am.put(a.getValue("Name"), a);
            ++n2;
        }
    }

    public void mapAction(Action act) {
        KeyStroke[] keys;
        ActionMap am = this.getActionMap();
        InputMap map = this.getInputMap();
        KeyStroke[] keyStrokeArray = keys = map.allKeys();
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            KeyStroke key = keyStrokeArray[n2];
            if (map.get(key).equals(act.getValue("Name"))) {
                act.putValue("AcceleratorKey", key);
            }
            ++n2;
        }
        am.put(act.getValue("Name"), act);
    }

    void indent(int row) {
        this.code.getsb(row).insert(0, Settings.indentRepString);
    }

    IndentInfo unindent(int row) {
        StringBuilder sb = ((Line)this.code.get((int)row)).sbuild;
        int cellCount = 0;
        int charCount = 0;
        while (charCount < sb.length() && Character.isWhitespace(sb.charAt(charCount))) {
            if (sb.charAt(charCount++) == '\t') {
                cellCount = JoshText.nextTabCharCount(cellCount);
                continue;
            }
            ++cellCount;
        }
        if (cellCount > 0) {
            int desiredCells = JoshText.prevTabCharCount(cellCount - 1);
            int cellAt = 0;
            int i = 0;
            while (i < charCount) {
                if (cellAt == desiredCells) {
                    String removed = sb.substring(i, charCount);
                    sb.delete(i, charCount);
                    return new IndentInfo(cellCount - desiredCells, "", removed);
                }
                if (cellAt > desiredCells) {
                    String removed = sb.substring(i, charCount);
                    sb.delete(i, charCount);
                    StringBuilder inserted = new StringBuilder(desiredCells - cellAt);
                    i = cellAt;
                    while (i < desiredCells) {
                        inserted.append(" ");
                        ++i;
                    }
                    sb.insert(i, inserted);
                    return new IndentInfo(cellCount - desiredCells, inserted.toString(), removed);
                }
                cellAt = sb.charAt(i) == '\t' ? JoshText.nextTabCharCount(cellAt) : ++cellAt;
                ++i;
            }
        }
        return new IndentInfo(0, "", "");
    }

    private static int prevTabCharCount(int charCount) {
        return charCount / Settings.indentSizeInSpaces * Settings.indentSizeInSpaces;
    }

    private static int nextTabCharCount(int charCount) {
        return (charCount + Settings.indentSizeInSpaces) / Settings.indentSizeInSpaces * Settings.indentSizeInSpaces;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.getParent().addComponentListener(this);
    }

    public static KeyStroke key(String s) throws IllegalArgumentException {
        int ch;
        if (s == null) {
            return null;
        }
        int index = s.indexOf(43);
        String key = s.substring(index + 1);
        if (key.length() == 0) {
            throw new IllegalArgumentException("Invalid key stroke: " + s);
        }
        int modifiers = 0;
        if (index != -1) {
            int i = 0;
            while (i < index) {
                switch (Character.toUpperCase(s.charAt(i))) {
                    case 'A': {
                        modifiers |= 0x200;
                        break;
                    }
                    case 'C': {
                        modifiers |= 0x80;
                        break;
                    }
                    case 'G': {
                        modifiers |= 0x2000;
                        break;
                    }
                    case 'M': {
                        modifiers |= 0x100;
                        break;
                    }
                    case 'S': {
                        modifiers |= 0x40;
                    }
                }
                ++i;
            }
        }
        if (key.length() == 1) {
            ch = Character.toUpperCase(key.charAt(0));
            if (modifiers == 0) {
                return KeyStroke.getKeyStroke((char)ch);
            }
            return KeyStroke.getKeyStroke(ch, modifiers);
        }
        try {
            ch = KeyEvent.class.getField("VK_".concat(key)).getInt(null);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid key stroke: " + s, e);
        }
        return KeyStroke.getKeyStroke(ch, modifiers);
    }

    void fitToCode() {
        int insetY = this.lineLeading;
        int w = (this.maxRowSize + 1) * this.monoAdvance + this.getInsets().left + 1;
        int h = this.code.size() * this.lineHeight + insetY;
        this.setMinimumSize(new Dimension(w, h));
        this.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.fireResize();
        this.repaint();
    }

    void doCodeSize(boolean rs) {
        this.maxRowSize = 0;
        int i = 0;
        while (i < this.code.size()) {
            if (this.code.getsb(i).length() > this.maxRowSize) {
                this.maxRowSize = this.code.getsb(i).length();
            }
            ++i;
        }
        if (rs) {
            this.fitToCode();
        }
    }

    private void doShowCaret() {
        this.doShowCaret(0, 0, 0, 5);
    }

    private void doShowCaret(int hPad, int vPad, int rowSkip, int colSkip) {
        int maxHPad;
        if (!(this.getParent() instanceof JViewport)) {
            return;
        }
        JViewport viewport = (JViewport)this.getParent();
        Rectangle viewRect = viewport.getViewRect();
        int maxVPad = (viewport.getHeight() - this.lineHeight * (rowSkip + 1)) / 2 - 5;
        if (vPad > maxVPad || vPad < 0) {
            vPad = maxVPad;
        }
        if (hPad > (maxHPad = (viewport.getWidth() - this.monoAdvance * (colSkip + 1)) / 2 - 5) || hPad < 0) {
            hPad = maxHPad;
        }
        Rectangle caretRect = new Rectangle(this.caret.col * this.monoAdvance, this.caret.row * this.lineHeight, this.monoAdvance, this.lineHeight);
        Point topLeft = new Point(viewRect.x, viewRect.y);
        if (caretRect.y + caretRect.height + vPad > viewRect.y + viewRect.height) {
            topLeft.y = caretRect.y + caretRect.height + vPad + rowSkip * this.lineHeight - viewRect.height;
            topLeft.y = Math.min(this.getHeight() - viewport.getHeight(), topLeft.y);
        } else if (caretRect.y - vPad < viewRect.y) {
            topLeft.y = Math.max(0, caretRect.y - vPad - rowSkip * this.lineHeight);
        }
        if (caretRect.x + caretRect.width + hPad > viewRect.x + viewRect.width) {
            topLeft.x = caretRect.x + caretRect.width + hPad - viewRect.width + colSkip * this.monoAdvance;
            topLeft.x = Math.min(this.getWidth() - viewport.getWidth(), topLeft.x);
        } else if (caretRect.x - hPad < viewRect.x) {
            topLeft.x = Math.max(0, caretRect.x - hPad - colSkip * this.monoAdvance);
        }
        if (topLeft.x != viewRect.x || topLeft.y != viewRect.y) {
            viewport.setViewPosition(topLeft);
        }
    }

    private void updateMouseAutoScroll(Point point) {
        if (!(this.getParent() instanceof JViewport)) {
            return;
        }
        JViewport p = (JViewport)this.getParent();
        Rectangle vr = p.getViewRect();
        Point rp = new Point(0, 0);
        if (point.x > vr.x + vr.width) {
            rp.x = (int)((double)rp.x + Math.pow(3.0, Math.max(0.0, Math.log10(point.x - vr.x - vr.width) - 1.0)));
        }
        if (point.x < vr.x) {
            rp.x = (int)((double)rp.x - Math.pow(3.0, Math.max(0.0, Math.log10(vr.x - point.x) - 1.0)));
        }
        if (point.y > vr.y + vr.height) {
            rp.y = (int)((double)rp.y + Math.pow(5.0, Math.max(0.0, Math.log10(point.y - vr.y - vr.height) - 1.0)));
        }
        if (point.y < vr.y) {
            rp.y = (int)((double)rp.y - Math.pow(5.0, Math.max(0.0, Math.log10(vr.y - point.y) - 1.0)));
        }
        rp.x = Math.max(0, Math.min(this.maxRowSize, rp.x));
        rp.y = Math.max(0, Math.min(this.code.size() * this.lineHeight - vr.height, rp.y));
        this.mas.p = p;
        this.mas.rp = rp;
        if (rp.x != 0 || rp.y != 0) {
            this.mas.start();
        } else {
            this.mas.stop();
        }
    }

    void removeMouseAutoScroll() {
        this.mas.stop();
    }

    public int line_wid_at(int row, int pos) {
        return this.metrics.stringWidth(this.code.getsb(row).toString(), pos);
    }

    public int line_offset_from(int line, int wid) {
        String l = this.code.getsb(line).toString();
        int w = 0;
        int lw = 0;
        int ret = 0;
        while (ret < l.length() && w < wid) {
            lw = w;
            if (l.charAt(ret) == '\t') {
                int wf = this.monoAdvance * Settings.indentSizeInSpaces;
                w = (w + wf) / wf * wf;
            } else {
                w += this.monoAdvance;
            }
            ++ret;
        }
        if (Math.abs(lw - wid) < Math.abs(w - wid)) {
            return Math.min(l.length(), ret - 1);
        }
        return Math.min(l.length(), ret);
    }

    public int index_to_column(int line, int n) {
        int col = 0;
        StringBuilder l = this.code.getsb(line);
        n = Math.min(n, l.length());
        int i = 0;
        while (i < n) {
            if (l.charAt(i) == '\t') {
                col += Settings.indentSizeInSpaces;
                col /= Settings.indentSizeInSpaces;
                col *= Settings.indentSizeInSpaces;
            } else {
                ++col;
            }
            ++i;
        }
        return col;
    }

    public int column_to_index(int line, int col) {
        int ind = 0;
        StringBuilder l = this.code.getsb(line);
        int i = 0;
        while (i < col && ind < l.length()) {
            if (l.charAt(ind) == '\t') {
                i += Settings.indentSizeInSpaces;
                i /= Settings.indentSizeInSpaces;
                i *= Settings.indentSizeInSpaces;
            } else {
                ++i;
            }
            ++ind;
        }
        return ind;
    }

    public int column_to_index_unsafe(int line, int col) {
        int ind = 0;
        StringBuilder l = this.code.getsb(line);
        int i = 0;
        while (i < col && ind < l.length()) {
            if (l.charAt(ind) == '\t') {
                i += Settings.indentSizeInSpaces;
                i /= Settings.indentSizeInSpaces;
                i *= Settings.indentSizeInSpaces;
            } else {
                ++i;
            }
            ++ind;
        }
        return ind += col - i;
    }

    public boolean column_in_tab(int line, int col) {
        int ind = 0;
        StringBuilder l = this.code.getsb(line);
        int i = 0;
        while (i < col && ind < l.length()) {
            if (l.charAt(ind) == '\t') {
                i += Settings.indentSizeInSpaces;
                i /= Settings.indentSizeInSpaces;
                if ((i *= Settings.indentSizeInSpaces) > col) {
                    return true;
                }
            } else {
                ++i;
            }
            ++ind;
        }
        return false;
    }

    public static int selGetKind(CharSequence str, int pos) {
        if (pos < 0 || pos >= str.length()) {
            return 2;
        }
        char ohfukku = str.charAt(pos);
        if (ohfukku > '\u00ff') {
            return 1;
        }
        return chType[ohfukku];
    }

    public static boolean selOfKind(CharSequence str, int pos, int otype) {
        if (pos < 0 || pos >= str.length()) {
            return otype == 2;
        }
        char ohfukku = str.charAt(pos);
        if (ohfukku > '\u00ff') {
            return otype == 1;
        }
        return chType[ohfukku] == otype;
    }

    public FontMetrics getFontMetrics() {
        return this.getFontMetrics(this.getFont());
    }

    public Dimension getMaxGlyphSize() {
        return new Dimension(this.monoAdvance, this.lineHeight);
    }

    private int drawChars(Graphics g, char[] a, int sp, int ep, int xx, int ty) {
        Color c = g.getColor();
        int i = sp;
        while (i < ep) {
            if (a[i] == '\t') {
                int incby = Settings.indentSizeInSpaces * this.monoAdvance;
                int xxp = xx;
                xx = (xx + incby) / incby * incby;
                if (Settings.renderTabs) {
                    g.setColor(this.whitespaceColor);
                    g.drawLine(xxp + 2, ty - this.lineHeight / 3, xx - 2, ty - this.lineHeight / 3);
                    g.drawLine(xxp + 2, ty - this.lineHeight / 3 - this.lineHeight / 5, xxp + 2, ty - this.lineHeight / 3 + this.lineHeight / 5);
                    g.drawLine(xx - 2, ty - this.lineHeight / 3 - this.lineHeight / 5, xx - 2, ty - this.lineHeight / 3 + this.lineHeight / 5);
                    g.setColor(c);
                }
            } else {
                g.drawChars(a, i, 1, xx, this.getInsets().top + ty);
                xx += this.monoAdvance;
                g.setColor(c);
            }
            ++i;
        }
        return xx;
    }

    private void drawLine(Graphics g, int lineNum, int ty) {
        if (this.baseFont != this.getFont()) {
            this.baseFont = this.getFont();
            this.specialFonts.clear();
        }
        g.setColor(this.getForeground());
        Font drawingFont = this.baseFont;
        g.setFont(drawingFont);
        int fontFlags = 0;
        StringBuilder line = this.code.getsb(lineNum);
        int xx = 1 + this.getInsets().left;
        char[] a = line.toString().toCharArray();
        Color c = g.getColor();
        if (this.marker == null) {
            this.drawChars(g, a, 0, a.length, xx, ty);
        } else {
            ArrayList<TokenMarker.TokenMarkerInfo> tmall = this.marker.getStyles((Line)this.code.get(lineNum));
            int pos = 0;
            for (TokenMarker.TokenMarkerInfo tm : tmall) {
                xx = this.drawChars(g, a, pos, tm.startPos, xx, ty);
                g.setColor(tm.color != null ? tm.color : c);
                fontFlags = tm.fontStyle;
                if (this.specialFonts.containsKey(fontFlags)) {
                    drawingFont = this.specialFonts.get(fontFlags);
                } else {
                    drawingFont = this.baseFont.deriveFont(fontFlags);
                    this.specialFonts.put(fontFlags, drawingFont);
                }
                g.setFont(drawingFont);
                xx = this.drawChars(g, a, tm.startPos, tm.endPos, xx, ty);
                pos = tm.endPos;
                g.setFont(this.baseFont);
                g.setColor(c);
            }
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        Object map = Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
        if (map != null) {
            ((Graphics2D)g).addRenderingHints((Map)map);
        }
        Rectangle clip = g.getClipBounds();
        g.setColor(this.getBackground());
        g.fillRect(clip.x, clip.y, clip.width, clip.height);
        for (Highlighter a : this.highlighters) {
            a.paint(g, this.getInsets(), this.metrics, 0, this.code.size());
        }
        int insetY = this.lineLeading + this.lineAscent;
        int lineNum = clip.y / this.lineHeight;
        int ty = lineNum * this.lineHeight + insetY;
        while (ty < clip.y + clip.height + this.lineHeight && lineNum < this.code.size()) {
            this.drawLine(g, lineNum++, ty);
            ty += this.lineHeight;
        }
        if (this.isFocusOwner()) {
            this.caret.paint(g, this.sel);
        }
    }

    public void repaint(int col, int row, int w, int h, boolean convert) {
        if (convert) {
            Dimension g = this.getMaxGlyphSize();
            col *= g.width;
            row *= g.height;
        }
        this.repaint(col, row, w, h);
    }

    public Point mouseToPoint(Point m, boolean bound) {
        int col;
        Point p = m;
        int row = p.y / this.lineHeight;
        row = Math.max(Math.min(row, this.code.size() - 1), 0);
        int n = col = bound ? this.line_offset_from(row, p.x) : (int)Math.round((double)p.x / (double)this.monoAdvance);
        if (!bound) {
            return new Point(Math.max(col, 0), row);
        }
        col = Math.max(Math.min(col, this.code.getsb(row).length()), 0);
        return new Point(col, row);
    }

    protected void handleMouseEvent(MouseEvent e) {
        if (e.getID() == 501) {
            this.requestFocusInWindow();
        }
        if (SwingUtilities.isLeftMouseButton(e)) {
            switch (e.getID()) {
                case 504: {
                    return;
                }
                case 501: {
                    this.dragger.mousePressed(e);
                    if (!e.isConsumed()) break;
                    this.shouldHandleRelease = true;
                    break;
                }
                case 502: {
                    this.dragger.mouseReleased(e);
                    this.removeMouseAutoScroll();
                    break;
                }
                case 506: {
                    if (!this.hasFocus()) {
                        return;
                    }
                    this.dragger.mouseDragged(e);
                }
            }
            if (e.isConsumed() || e.getID() == 505) {
                return;
            }
            if ((e.getModifiersEx() & 0x280) != 0) {
                this.sel.changeType(Selection.ST.RECT);
            } else {
                this.sel.changeType(Selection.ST.NORM);
            }
            Point sp = new Point(this.caret.col, this.caret.row);
            Point p = this.mouseToPoint(e.getPoint(), this.sel.type != Selection.ST.RECT);
            this.caret.col = p.x;
            this.caret.row = p.y;
            int n = this.caret.colw = this.sel.type == Selection.ST.RECT ? this.caret.col * this.monoAdvance : this.line_wid_at(this.caret.row, this.caret.col);
            if (e.getClickCount() == 2) {
                this.sel.special.setHandler(this.sel.wordSelHandler);
            } else if (e.getClickCount() == 3) {
                this.sel.special.setHandler(this.sel.lineSelHandler);
            } else if (e.getID() == 501) {
                this.sel.special.valid = false;
            }
            if (e.getID() != 502) {
                this.updateMouseAutoScroll(e.getPoint());
            }
            if (this.sel.special.valid) {
                this.sel.special.adjust();
            }
            if (!this.sel.special.valid && (e.getModifiersEx() & 0x40) == 0 && (e.getID() == 501 || e.getID() == 502 && this.shouldHandleRelease)) {
                this.sel.deselect(false);
            }
            this.shouldHandleRelease = false;
            this.caret.flashOn();
            if (sp.x != this.caret.col || sp.y != this.caret.row) {
                this.caret.positionChanged();
                this.undoCanMerge = false;
            }
            if (e.getID() == 502) {
                this.sel.selectionChanged();
            }
            this.repaint();
            return;
        }
        if (SwingUtilities.isMiddleMouseButton(e)) {
            if (e.getID() != 501) {
                return;
            }
            Point p = this.mouseToPoint(e.getPoint(), true);
            Selection.ST sto = this.sel.type;
            this.sel.type = Selection.ST.NORM;
            UndoPatch up = new UndoPatch(p.y, Math.min(this.code.size() - 1, p.y + this.sel.getMiddlePasteRipple() - 1));
            up.cbefore.stype = sto;
            this.sel.col = this.caret.col = p.x;
            this.sel.row = this.caret.row = p.y;
            this.caret.positionChanged();
            int mcr = this.sel.middleClickPaste();
            this.doCodeSize(true);
            up.realize(mcr);
            this.storeUndo(up, 6);
            this.repaint();
        }
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        super.processMouseEvent(e);
        this.handleMouseEvent(e);
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent e) {
        super.processMouseMotionEvent(e);
        this.handleMouseEvent(e);
    }

    protected void processKeyTyped(KeyEvent e) {
        Point sc = new Point(this.caret.col, this.caret.row);
        switch (e.getKeyChar()) {
            case '\n': {
                if (this.sel.type == Selection.ST.NORM) {
                    int iind;
                    UndoPatch up = new UndoPatch();
                    this.sel.deleteSel();
                    StringBuilder nr = this.code.getsb(this.caret.row);
                    int offset = 0;
                    StringBuilder ins = new StringBuilder();
                    int i = 0;
                    while (i < nr.length() && i < this.caret.col) {
                        if (!Character.isWhitespace(nr.charAt(i))) break;
                        ++offset;
                        ins.append(nr.charAt(i));
                        ++i;
                    }
                    if ((iind = this.myLang.hasIndentAfter(nr.toString())) != -1) {
                        String ind = this.myLang.getIndent(iind);
                        ins.append(ind);
                        offset += ind.length();
                    }
                    this.code.add(++this.caret.row, ins + nr.substring(this.caret.col));
                    nr.delete(this.caret.col, nr.length());
                    this.sel.col = this.caret.col = offset;
                    this.caret.colw = this.line_wid_at(this.caret.row, this.caret.col);
                    up.realize(this.caret.row);
                    this.storeUndo(up, 5);
                }
                this.sel.deselect(true);
                break;
            }
            case '\b': {
                switch (this.sel.type) {
                    case NORM: {
                        UndoPatch up = new UndoPatch();
                        int otype = JoshText.selGetKind(this.code.getsb(this.caret.row), this.caret.col - 1);
                        if (!this.sel.deleteSel()) {
                            if (Settings.smartBackspace && otype == 2 && this.caret.col > 0 && JoshText.all_white(this.code.getsb(this.caret.row).substring(0, this.caret.col))) {
                                IndentInfo chInd = this.unindent(this.caret.row);
                                int delta = chInd.removed.length() - chInd.inserted.length();
                                this.caret.col -= delta;
                                this.sel.col -= delta;
                                up.realize(this.caret.row);
                                this.storeUndo(up, 2);
                                break;
                            }
                            do {
                                if (this.caret.col > 0) {
                                    this.code.getsb(this.caret.row).delete(this.caret.col - 1, this.caret.col);
                                    --this.caret.col;
                                    continue;
                                }
                                if (this.caret.row <= 0) break;
                                StringBuilder s1 = this.code.getsb(this.caret.row - 1);
                                StringBuilder s2 = this.code.getsb(this.caret.row);
                                this.code.remove(this.caret.row--);
                                up.prefix_row((Line)this.code.get(this.caret.row));
                                this.caret.col = s1.length();
                                s1.append((CharSequence)s2);
                            } while (e.isControlDown() && JoshText.selOfKind(this.code.getsb(this.caret.row), this.caret.col - 1, otype));
                        }
                        this.caret.colw = this.line_wid_at(this.caret.row, this.caret.col);
                        this.sel.deselect(false);
                        up.realize(this.caret.row);
                        this.storeUndo(up, 2);
                        break;
                    }
                    case RECT: {
                        UndoPatch up = new UndoPatch();
                        int otype = JoshText.selGetKind(this.code.getsb(this.caret.row), this.caret.col - 1);
                        if (!this.sel.deleteSel()) {
                            if (e.isControlDown()) {
                                int mindist = -1;
                                int y = Math.min(this.sel.row, this.caret.row);
                                while (y <= Math.max(this.sel.row, this.caret.row)) {
                                    int actcol = this.column_to_index(y, this.caret.col);
                                    StringBuilder sb = this.code.getsb(y);
                                    otype = JoshText.selGetKind(sb, actcol - 1);
                                    int mcol = actcol;
                                    int mydist = 0;
                                    while (mcol > 0) {
                                        if (mcol < sb.length()) {
                                            if (sb.charAt(mcol--) == '\t') {
                                                mydist += Settings.indentSizeInSpaces;
                                                mydist /= Settings.indentSizeInSpaces;
                                                mydist *= Settings.indentSizeInSpaces;
                                            } else {
                                                ++mydist;
                                            }
                                        } else {
                                            ++mydist;
                                            --mcol;
                                        }
                                        if (JoshText.selOfKind(this.code.getsb(y), mcol - 1, otype)) continue;
                                    }
                                    if (mindist == -1 || mydist < mindist) {
                                        mindist = mydist;
                                    }
                                    ++y;
                                }
                                int cs = this.caret.col - mindist;
                                int ce = this.caret.col;
                                this.sel.col = this.caret.col = cs;
                                this.caret.colw = this.line_wid_at(this.caret.row, this.caret.col);
                                int y2 = Math.min(this.sel.row, this.caret.row);
                                while (y2 <= Math.max(this.sel.row, this.caret.row)) {
                                    this.code.getsb(y2).delete(this.column_to_index(y2, cs), this.column_to_index(y2, ce));
                                    ++y2;
                                }
                            } else if (this.caret.col > 0) {
                                int y = Math.min(this.sel.row, this.caret.row);
                                while (y <= Math.max(this.sel.row, this.caret.row)) {
                                    this.code.getsb(y).delete(this.column_to_index(y, this.caret.col - 1), this.column_to_index(y, this.caret.col));
                                    ++y;
                                }
                                this.sel.col = --this.caret.col;
                                this.caret.colw = this.caret.col * this.monoAdvance;
                            }
                        }
                        up.realize(Math.max(this.caret.row, this.sel.row));
                        this.storeUndo(up, 2);
                    }
                }
                break;
            }
            case '\u007f': {
                switch (this.sel.type) {
                    case NORM: {
                        UndoPatch up = new UndoPatch();
                        int otype = JoshText.selGetKind(this.code.getsb(this.caret.row), this.caret.col);
                        if (!this.sel.deleteSel()) {
                            do {
                                if (this.caret.col < this.code.getsb(this.caret.row).length()) {
                                    this.code.getsb(this.caret.row).delete(this.caret.col, this.caret.col + 1);
                                    continue;
                                }
                                if (this.caret.row + 1 >= this.code.size()) break;
                                StringBuilder s1 = this.code.getsb(this.caret.row);
                                StringBuilder s2 = this.code.getsb(this.caret.row + 1);
                                this.code.remove(this.caret.row + 1);
                                s1.append((CharSequence)s2);
                            } while (e.isControlDown() && JoshText.selOfKind(this.code.getsb(this.caret.row), this.caret.col, otype));
                        }
                        up.realize(this.caret.row);
                        this.storeUndo(up, 3);
                        break;
                    }
                    case RECT: {
                        UndoPatch up = new UndoPatch();
                        int otype = JoshText.selGetKind(this.code.getsb(this.caret.row), this.caret.col);
                        if (!this.sel.deleteSel()) {
                            int y = Math.min(this.sel.row, this.caret.row);
                            while (y <= Math.max(this.sel.row, this.caret.row)) {
                                int dcol = this.column_to_index(y, this.caret.col);
                                otype = JoshText.selGetKind(this.code.getsb(y), dcol);
                                while (dcol < this.code.getsb(y).length()) {
                                    this.code.getsb(y).delete(dcol, dcol + 1);
                                    if (e.isControlDown() && JoshText.selOfKind(this.code.getsb(y), dcol, otype)) continue;
                                }
                                ++y;
                            }
                        }
                        up.realize(this.caret.row);
                        this.storeUndo(up, 3);
                    }
                }
                break;
            }
            case '\t': {
                System.out.println("Tab");
                if (!this.sel.isCompletelyEmpty()) {
                    UndoPatch up = new UndoPatch();
                    String tab = Settings.indentRepString;
                    int yx = Math.max(this.sel.row, this.caret.row);
                    if (!e.isShiftDown()) {
                        int y = Math.min(this.sel.row, this.caret.row);
                        while (y <= yx) {
                            this.indent(y);
                            ++y;
                        }
                        if (this.sel.type != Selection.ST.RECT) {
                            this.sel.col += tab.length();
                            this.caret.col += tab.length();
                        }
                    } else {
                        int y = Math.min(this.sel.row, this.caret.row);
                        while (y <= yx) {
                            IndentInfo chInd = this.unindent(y);
                            if (this.sel.type != Selection.ST.RECT) {
                                if (this.sel.row == y) {
                                    this.sel.col = Math.max(0, this.sel.col - chInd.removed.length() - chInd.inserted.length());
                                }
                                if (this.caret.row == y) {
                                    this.caret.col = Math.max(0, this.caret.col - chInd.removed.length() - chInd.inserted.length());
                                }
                            }
                            ++y;
                        }
                    }
                    if (this.sel.type != Selection.ST.RECT) {
                        this.caret.colw = this.line_wid_at(this.caret.row, this.caret.col);
                    }
                    up.realize(Math.max(this.sel.row, this.caret.row));
                    this.storeUndo(up, 7);
                    break;
                }
                UndoPatch up = new UndoPatch();
                if (!e.isShiftDown()) {
                    this.sel.insert(Settings.indentRepString);
                } else {
                    this.unindent(this.caret.row);
                    int P = 0;
                    while (P < this.code.getsb(this.caret.row).length() && Character.isWhitespace(this.code.getsb(this.caret.row).charAt(P))) {
                        ++P;
                    }
                    this.caret.col = this.sel.col = P;
                    this.caret.colw = this.line_wid_at(this.caret.row, this.caret.col);
                }
                up.realize(this.caret.row);
                this.storeUndo(up, 1);
                break;
            }
            case '\u0018': 
            case '\u001b': 
            case '\uffff': {
                break;
            }
            default: {
                if (e.isControlDown() || e.isAltDown()) {
                    e.getKeyCode();
                    break;
                }
                UndoPatch up2 = new UndoPatch();
                this.sel.insert(e.getKeyChar());
                up2.realize(this.caret.row);
                this.storeUndo(up2, e.getKeyChar() == ' ' ? 4 : 1);
            }
        }
        this.doCodeSize(true);
        if (sc.x != this.caret.col || sc.y != this.caret.row) {
            this.caret.positionChanged();
        }
    }

    private static boolean all_white(String str) {
        int i = 0;
        while (i < str.length()) {
            if (!Character.isWhitespace(str.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void processKeyPressed(KeyEvent e) {
        Point sc = new Point(this.caret.col, this.caret.row);
        switch (e.getKeyCode()) {
            case 155: {
                this.caret.insert ^= true;
                e.consume();
                break;
            }
            case 37: {
                int otype = JoshText.selGetKind(this.code.getsb(this.caret.row), this.caret.col - 1);
                int moved = 0;
                if (!(this.sel.isCompletelyEmpty() || e.isAltDown() || e.isShiftDown())) {
                    this.sel.deselectStart(true);
                } else {
                    do {
                        if (this.caret.col > 0) {
                            --this.caret.col;
                        } else {
                            if (this.caret.row <= 0 || this.sel.type == Selection.ST.RECT) break;
                            --this.caret.row;
                            this.caret.col = this.code.getsb(this.caret.row).length();
                        }
                        if (moved == 0 && !JoshText.selOfKind(this.code.getsb(this.caret.row), this.caret.col - 1, otype)) {
                            otype = JoshText.selGetKind(this.code.getsb(this.caret.row), this.caret.col - 1);
                        }
                        ++moved;
                    } while (e.isControlDown() && JoshText.selOfKind(this.code.getsb(this.caret.row), this.caret.col - 1, otype));
                    this.undoCanMerge = false;
                    if (e.isAltDown()) {
                        this.sel.changeType(Selection.ST.RECT);
                    } else if (e.isShiftDown()) {
                        this.sel.changeType(Selection.ST.NORM);
                    } else {
                        this.sel.deselect(true);
                    }
                }
                this.caret.colw = this.line_wid_at(this.caret.row, this.caret.col);
                this.doCodeSize(false);
                e.consume();
                break;
            }
            case 39: {
                int otype = JoshText.selGetKind(this.code.getsb(this.caret.row), this.caret.col);
                int moved = 0;
                if (!(this.sel.isCompletelyEmpty() || e.isAltDown() || e.isShiftDown())) {
                    this.sel.deselectEnd(true);
                } else {
                    do {
                        if (this.sel.type == Selection.ST.RECT || this.caret.col < this.code.getsb(this.caret.row).length()) {
                            ++this.caret.col;
                        } else {
                            if (this.caret.row + 1 >= this.code.size() || this.sel.type == Selection.ST.RECT) break;
                            ++this.caret.row;
                            this.caret.col = 0;
                        }
                        if (moved == 0 && !JoshText.selOfKind(this.code.getsb(this.caret.row), this.caret.col, otype)) {
                            otype = JoshText.selGetKind(this.code.getsb(this.caret.row), this.caret.col);
                        }
                        ++moved;
                    } while (e.isControlDown() && JoshText.selOfKind(this.code.getsb(this.caret.row), this.caret.col, otype));
                    this.undoCanMerge = false;
                    if (e.isAltDown()) {
                        this.sel.changeType(Selection.ST.RECT);
                    } else if (e.isShiftDown()) {
                        this.sel.changeType(Selection.ST.NORM);
                    } else {
                        this.sel.deselect(true);
                    }
                }
                this.caret.colw = this.line_wid_at(this.caret.row, this.caret.col);
                e.consume();
                break;
            }
            case 38: {
                if (this.caret.row > 0) {
                    if (this.sel.type == Selection.ST.RECT) {
                        --this.caret.row;
                    } else {
                        this.caret.col = this.line_offset_from(--this.caret.row, this.caret.colw);
                        if (this.caret.col > this.code.getsb(this.caret.row).length()) {
                            this.caret.col = this.code.getsb(this.caret.row).length();
                        }
                    }
                } else {
                    this.caret.col = 0;
                    this.caret.colw = 0;
                }
                this.undoCanMerge = false;
                if (e.isAltDown()) {
                    this.sel.changeType(Selection.ST.RECT);
                } else if (e.isShiftDown()) {
                    this.sel.changeType(Selection.ST.NORM);
                } else {
                    this.sel.deselect(true);
                }
                e.consume();
                break;
            }
            case 40: {
                if (this.caret.row + 1 < this.code.size()) {
                    if (this.sel.type == Selection.ST.RECT) {
                        ++this.caret.row;
                    } else {
                        this.caret.col = this.line_offset_from(++this.caret.row, this.caret.colw);
                        if (this.caret.col > this.code.getsb(this.caret.row).length()) {
                            this.caret.col = this.code.getsb(this.caret.row).length();
                        }
                    }
                } else {
                    this.caret.col = this.code.getsb(this.caret.row).length();
                    this.caret.colw = this.line_wid_at(this.caret.row, this.caret.col);
                }
                this.undoCanMerge = false;
                if (e.isAltDown()) {
                    this.sel.changeType(Selection.ST.RECT);
                } else if (e.isShiftDown()) {
                    this.sel.changeType(Selection.ST.NORM);
                } else {
                    this.sel.deselect(true);
                }
                e.consume();
                break;
            }
            case 35: {
                if (e.isControlDown()) {
                    this.caret.row = this.code.size() - 1;
                }
                this.caret.col = this.code.getsb(this.caret.row).length();
                this.caret.colw = this.line_wid_at(this.caret.row, this.caret.col);
                if (e.isAltDown()) {
                    this.sel.changeType(Selection.ST.RECT);
                } else if (!e.isShiftDown()) {
                    this.sel.deselect(true);
                }
                e.consume();
                break;
            }
            case 36: {
                if (e.isControlDown()) {
                    this.caret.row = 0;
                }
                int P = 0;
                while (P < this.code.getsb(this.caret.row).length() && Character.isWhitespace(this.code.getsb(this.caret.row).charAt(P))) {
                    ++P;
                }
                if (this.caret.col == P) {
                    P = 0;
                }
                this.caret.col = P;
                this.caret.colw = this.line_wid_at(this.caret.row, this.caret.col);
                if (e.isAltDown()) {
                    this.sel.changeType(Selection.ST.RECT);
                } else if (e.isShiftDown()) {
                    this.sel.changeType(Selection.ST.NORM);
                } else {
                    this.sel.deselect(true);
                }
                e.consume();
                break;
            }
            case 33: {
                int height = this.getParent() instanceof JViewport ? this.getParent().getHeight() : this.getHeight();
                this.caret.row = Math.max(0, this.caret.row - height / this.lineHeight);
                if (this.sel.type != Selection.ST.RECT) {
                    this.caret.col = Math.min(this.caret.col, this.code.getsb(this.caret.row).length());
                }
                if (!e.isShiftDown()) {
                    this.sel.deselect(true);
                }
                e.consume();
                break;
            }
            case 34: {
                int height = this.getParent() instanceof JViewport ? this.getParent().getHeight() : this.getHeight();
                this.caret.row = Math.min(this.code.size() - 1, this.caret.row + height / this.lineHeight);
                if (this.sel.type != Selection.ST.RECT) {
                    this.caret.col = Math.min(this.caret.col, this.code.getsb(this.caret.row).length());
                }
                if (!e.isShiftDown()) {
                    this.sel.deselect(true);
                }
                e.consume();
            }
        }
        if (sc.x != this.caret.col || sc.y != this.caret.row) {
            this.caret.positionChanged();
            this.sel.selectionChanged();
        }
        this.fitToCode();
    }

    @Override
    protected void processComponentKeyEvent(KeyEvent e) {
        this.caret.flashOn();
        switch (e.getID()) {
            case 400: {
                this.processKeyTyped(e);
                break;
            }
            case 401: {
                this.processKeyPressed(e);
            }
        }
    }

    public void addLineChangeListener(LineChangeListener listener) {
        this.listenerList.add(LineChangeListener.class, listener);
    }

    public void removeLineChangeListener(LineChangeListener listener) {
        this.listenerList.remove(LineChangeListener.class, listener);
    }

    protected void fireLineChange(int start, int end) {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == LineChangeListener.class) {
                ((LineChangeListener)listeners[i + 1]).linesChanged(this.code, start, end);
            }
            i -= 2;
        }
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return new Dimension(320, 240);
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        switch (orientation) {
            case 1: {
                return this.getFontMetrics(this.getFont()).getHeight();
            }
            case 0: {
                return this.monoAdvance;
            }
        }
        throw new IllegalArgumentException("Invalid orientation: " + orientation);
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        switch (orientation) {
            case 1: {
                return visibleRect.height;
            }
            case 0: {
                return visibleRect.width;
            }
        }
        throw new IllegalArgumentException("Invalid orientation: " + orientation);
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    void fireResize() {
        Container a = this.getParent();
        Dimension ps = this.getMinimumSize();
        if (a != null) {
            int w = a.getWidth();
            int h = a.getHeight();
            ps.width = Math.max(ps.width, w);
            ps.height = Math.max(ps.height, h);
        }
        this.setPreferredSize(ps);
        this.setSize(ps);
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.fireResize();
    }

    @Override
    public void componentHidden(ComponentEvent e) {
        this.repaint();
    }

    @Override
    public void componentMoved(ComponentEvent e) {
        this.repaint();
    }

    @Override
    public void componentShown(ComponentEvent e) {
        this.repaint();
    }

    @Override
    public void lostOwnership(Clipboard arg0, Transferable arg1) {
    }

    public boolean canUndo() {
        return this.patchIndex > 0 && this.undoPatches.size() > 0;
    }

    public boolean canRedo() {
        return this.patchIndex < this.undoPatches.size();
    }

    public void undo() {
        if (this.patchIndex == 0) {
            return;
        }
        UndoPatch p = this.undoPatches.get(--this.patchIndex);
        int prow = 0;
        while (prow < p.patchText.length) {
            if (prow >= p.oldText.length) {
                int da = p.patchText.length - prow;
                while (da > 0) {
                    this.code.remove(p.startRow + prow);
                    --da;
                }
                break;
            }
            this.code.set(p.startRow + prow, new Line(p.oldText[prow]));
            ++prow;
        }
        while (prow < p.oldText.length) {
            this.code.add(p.startRow + prow, new Line(p.oldText[prow]));
            ++prow;
        }
        p.cbefore.replace();
        this.fireLineChange(p.startRow, p.startRow + p.oldText.length);
        this.repaint();
    }

    public void redo() {
        if (this.patchIndex >= this.undoPatches.size()) {
            return;
        }
        UndoPatch p = this.undoPatches.get(this.patchIndex++);
        int prow = 0;
        while (prow < p.oldText.length) {
            if (prow >= p.patchText.length) {
                int da = p.oldText.length - prow;
                while (da > 0) {
                    this.code.remove(p.startRow + prow);
                    --da;
                }
                break;
            }
            this.code.set(p.startRow + prow, new Line(p.patchText[prow]));
            ++prow;
        }
        while (prow < p.patchText.length) {
            this.code.add(p.startRow + prow, new Line(p.patchText[prow]));
            ++prow;
        }
        p.cafter.replace();
        this.fireLineChange(p.startRow, p.startRow + p.oldText.length);
        this.repaint();
    }

    public void storeUndo(UndoPatch undo, int patchType) {
        undo.opTag = patchType;
        while (this.patchIndex < this.undoPatches.size()) {
            this.undoPatches.remove(this.undoPatches.size() - 1);
        }
        if (!this.undoCanMerge || this.patchIndex == 0 || !JoshText.undoCompatible(this.undoPatches.get(this.patchIndex - 1), undo)) {
            this.undoPatches.add(undo);
            this.undoCanMerge = true;
            ++this.patchIndex;
        } else {
            JoshText.undoMerge(undo, this.undoPatches.get(this.patchIndex - 1));
        }
    }

    private static void undoMerge(UndoPatch merge, UndoPatch into) {
        into.patchText = merge.patchText;
        into.cafter.copy(merge.cafter);
        into.opTag = merge.opTag;
    }

    private static boolean undoCompatible(UndoPatch up1, UndoPatch up2) {
        if (up1.opTag != up2.opTag && up2.opTag != 4 || up1.startRow != up2.startRow) {
            return false;
        }
        return up1.oldText.length == up1.patchText.length && up1.oldText.length == up2.oldText.length && up2.patchText.length == up2.patchText.length;
    }

    @Override
    public void focusGained(FocusEvent arg0) {
        FindDialog.getInstance().selectedJoshText = this;
    }

    @Override
    public void focusLost(FocusEvent arg0) {
    }

    public boolean isChanged() {
        return !this.undoPatches.isEmpty();
    }

    class BracketHighlighter
    implements Highlighter,
    CaretListener {
        MatchState matching;
        int matchLine;
        int matchPos;

        BracketHighlighter() {
        }

        @Override
        public void paint(Graphics g, Insets i, CodeMetrics gm, int line_start, int line_end) {
            Color c = g.getColor();
            if (this.matchLine < line_end) {
                if (this.matching == MatchState.MATCHING) {
                    g.setColor(JoshText.this.matchingCharColor);
                    g.drawRect(JoshText.this.line_wid_at(this.matchLine, this.matchPos), this.matchLine * JoshText.this.lineHeight, JoshText.this.monoAdvance, JoshText.this.lineHeight);
                } else if (this.matching == MatchState.NO_MATCH) {
                    g.setColor(JoshText.this.noMatchingCharColor);
                    g.fillRect(JoshText.this.line_wid_at(this.matchLine, this.matchPos), this.matchLine * JoshText.this.lineHeight, JoshText.this.monoAdvance, JoshText.this.lineHeight);
                }
            }
            g.setColor(c);
        }

        private boolean matchFound(BracketMatch m, int x, int y) {
            m.count = (short)(m.count - 1);
            if (m.count <= 0) {
                this.matchLine = y;
                this.matchPos = x;
                this.matching = MatchState.MATCHING;
                return true;
            }
            return false;
        }

        private void findMatchForward(int row, int col, BracketMatch match) {
            int y = row;
            int blockType = 0;
            StringBuilder sb = JoshText.this.code.getsb(y);
            ArrayList<TokenMarker.TokenMarkerInfo> tmall = JoshText.this.marker.getStyles((Line)JoshText.this.code.get(y));
            int offset = 0;
            while (offset < tmall.size()) {
                TokenMarker.TokenMarkerInfo tm = tmall.get(offset);
                if (col < tm.startPos) break;
                if (col >= tm.startPos && col < tm.endPos) {
                    blockType = tm.blockHash;
                    break;
                }
                ++offset;
            }
            if (this.subFindMatchForward(match, sb, tmall, offset, col, blockType, y)) {
                return;
            }
            ++y;
            while (y < JoshText.this.code.size()) {
                tmall = JoshText.this.marker.getStyles((Line)JoshText.this.code.get(y));
                if (this.subFindMatchForward(match, JoshText.this.code.getsb(y), tmall, 0, 0, blockType, y)) {
                    return;
                }
                ++y;
            }
        }

        private boolean subFindMatchForward(BracketMatch match, StringBuilder sb, ArrayList<TokenMarker.TokenMarkerInfo> tmall, int offset, int spos, int blockType, int y) {
            int pos = spos;
            int i = offset;
            while (i < tmall.size()) {
                TokenMarker.TokenMarkerInfo tm = tmall.get(i);
                if (blockType == 0) {
                    while (pos < tm.startPos) {
                        if (sb.charAt(pos) == match.match) {
                            if (this.matchFound(match, pos, y)) {
                                return true;
                            }
                        } else if (sb.charAt(pos) == match.opposite) {
                            match.count = (short)(match.count + 1);
                        }
                        ++pos;
                    }
                }
                if (blockType == tmall.get((int)i).blockHash) {
                    pos = Math.max(spos, tm.startPos);
                    while (pos < tm.endPos) {
                        if (sb.charAt(pos) == match.match) {
                            if (this.matchFound(match, pos, y)) {
                                return true;
                            }
                        } else if (sb.charAt(pos) == match.opposite) {
                            match.count = (short)(match.count + 1);
                        }
                        ++pos;
                    }
                }
                pos = tm.endPos;
                ++i;
            }
            return false;
        }

        private void findMatchBackward(int row, int col, BracketMatch match) {
            int y = row;
            int blockType = 0;
            StringBuilder sb = JoshText.this.code.getsb(y);
            ArrayList<TokenMarker.TokenMarkerInfo> tmall = JoshText.this.marker.getStyles((Line)JoshText.this.code.get(y));
            int offset = 0;
            while (offset < tmall.size()) {
                TokenMarker.TokenMarkerInfo tm = tmall.get(offset);
                if (col < tm.startPos) break;
                if (col >= tm.startPos && col < tm.endPos) {
                    blockType = tm.blockHash;
                    break;
                }
                ++offset;
            }
            if (this.subFindMatchBackward(match, sb, tmall, offset, JoshText.this.caret.col, blockType, y)) {
                return;
            }
            --y;
            while (y >= 0) {
                tmall = JoshText.this.marker.getStyles((Line)JoshText.this.code.get(y));
                if (this.subFindMatchBackward(match, JoshText.this.code.getsb(y), tmall, tmall.size() - 1, JoshText.this.code.getsb(y).length(), blockType, y)) {
                    return;
                }
                --y;
            }
        }

        /*
         * Unable to fully structure code
         */
        private boolean subFindMatchBackward(BracketMatch match, StringBuilder sb, ArrayList<TokenMarker.TokenMarkerInfo> tmall, int offset, int spos, int blockType, int y) {
            pos = spos;
            i = offset;
            tm = tmall.get(i);
            block0: while (true) {
                if (blockType == tmall.get((int)i).blockHash) {
                    pos = Math.min(spos, tm.endPos - 1);
                    while (pos >= tm.startPos) {
                        if (sb.charAt(pos) == match.match) {
                            if (this.matchFound(match, pos, y)) {
                                return true;
                            }
                        } else if (sb.charAt(pos) == match.opposite) {
                            match.count = (short)(match.count + 1);
                        }
                        --pos;
                    }
                }
                if (i <= 0) break;
                tm = tmall.get(--i);
                if (blockType != 0) continue;
                pos = tm.startPos - 1;
                while (true) {
                    if (pos >= tm.endPos) ** break;
                    continue block0;
                    if (sb.charAt(pos) == match.match) {
                        if (this.matchFound(match, pos, y)) {
                            return true;
                        }
                    } else if (sb.charAt(pos) == match.opposite) {
                        match.count = (short)(match.count + 1);
                    }
                    --pos;
                }
                break;
            }
            if (blockType == 0) {
                pos = tm.startPos - 1;
                while (pos >= 0) {
                    if (sb.charAt(pos) == match.match) {
                        if (this.matchFound(match, pos, y)) {
                            return true;
                        }
                    } else if (sb.charAt(pos) == match.opposite) {
                        match.count = (short)(match.count + 1);
                    }
                    --pos;
                }
            }
            return false;
        }

        @Override
        public void caretUpdate(CaretEvent ce) {
            this.matching = MatchState.NOT_MATCHING;
            StringBuilder sb = JoshText.this.code.getsb(JoshText.this.caret.row);
            String start = "([{";
            String end = ")]}";
            int[] nArray = new int[]{JoshText.this.caret.col - 1, JoshText.this.caret.col};
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int x = nArray[n2];
                if (x >= 0 && x < sb.length()) {
                    char c = sb.charAt(x);
                    int p = start.indexOf(c);
                    if (p != -1) {
                        this.findMatchForward(JoshText.this.caret.row, x, new BracketMatch(end.charAt(p), start.charAt(p), 0));
                        return;
                    }
                    p = end.indexOf(c);
                    if (p != -1) {
                        this.findMatchBackward(JoshText.this.caret.row, x, new BracketMatch(start.charAt(p), end.charAt(p), 0));
                        return;
                    }
                }
                ++n2;
            }
        }

        class BracketMatch {
            char match;
            char opposite;
            short count;

            public BracketMatch(char m, char o, short c) {
                this.match = m;
                this.opposite = o;
                this.count = c;
            }
        }
    }

    public static final class ChType {
        public static final int NONE = 0;
        public static final int WORD = 1;
        public static final int WHITE = 2;
    }

    public static interface CodeMetrics {
        public int stringWidth(String var1, int var2);

        public int lineWidth(int var1, int var2);

        public int glyphWidth();

        public int lineHeight();
    }

    private class DefaultJEFileChooser
    implements JEFileChooser {
        JFileChooser fileChooser = new JFileChooser();

        private DefaultJEFileChooser() {
        }

        @Override
        public String getLoadFilename() {
            if (this.fileChooser.showOpenDialog(JoshText.this) != 0) {
                return null;
            }
            return this.fileChooser.getSelectedFile().getPath();
        }

        @Override
        public String getSaveFilename() {
            if (this.fileChooser.showSaveDialog(JoshText.this) != 0) {
                return null;
            }
            return this.fileChooser.getSelectedFile().getPath();
        }
    }

    class DragListener {
        private boolean dragStarted;
        private final int motionThreshold = this.getDefaultThreshold();
        private MouseEvent dndArmedEvent;

        public int getDefaultThreshold() {
            Integer ti = (Integer)Toolkit.getDefaultToolkit().getDesktopProperty("DnD.gestureMotionThreshold");
            return ti == null ? 5 : ti;
        }

        public void mousePressed(MouseEvent e) {
            this.dragStarted = false;
            if (this.isDragPossible(e.getPoint())) {
                this.dndArmedEvent = e;
                e.consume();
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (this.dragStarted) {
                e.consume();
            }
            this.dndArmedEvent = null;
        }

        public void mouseDragged(MouseEvent e) {
            if (this.dragStarted) {
                e.consume();
                return;
            }
            if (this.dndArmedEvent == null) {
                return;
            }
            int dx = Math.abs(e.getX() - this.dndArmedEvent.getX());
            int dy = Math.abs(e.getY() - this.dndArmedEvent.getY());
            if (dx > this.motionThreshold || dy > this.motionThreshold) {
                TransferHandler th = JoshText.this.getTransferHandler();
                int act = e.isControlDown() ? 1 : 2;
                this.dragStarted = true;
                th.exportAsDrag(JoshText.this, this.dndArmedEvent, act);
                this.dndArmedEvent = null;
            }
            e.consume();
        }

        protected boolean isDragPossible(Point mousePt) {
            Point p = JoshText.this.mouseToPoint(mousePt, false);
            return JoshText.this.sel.contains(p.y, p.x);
        }

        public void query() {
            System.out.println(String.valueOf(this.dragStarted) + "," + this.dndArmedEvent);
        }
    }

    public static interface Highlighter {
        public void paint(Graphics var1, Insets var2, CodeMetrics var3, int var4, int var5);
    }

    static class IndentInfo {
        public int cellWidth;
        public String inserted;
        public String removed;

        public IndentInfo(int cellWidth, String inserted, String removed) {
            this.cellWidth = cellWidth;
            this.inserted = inserted;
            this.removed = removed;
        }
    }

    public static interface JEFileChooser {
        public String getLoadFilename();

        public String getSaveFilename();
    }

    class JoshTextTransferHandler
    extends TransferHandler {
        private static final long serialVersionUID = 1L;

        public JoshTextTransferHandler() {
            JoshText.this.addPropertyChangeListener("dropLocation", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent pce) {
                    JoshTextTransferHandler.this.repaintDropLocation(pce.getOldValue());
                    JoshTextTransferHandler.this.repaintDropLocation(pce.getNewValue());
                }
            });
        }

        public void repaintDropLocation(Object drop) {
            if (drop == null || !(drop instanceof TransferHandler.DropLocation)) {
                JoshText.this.repaint();
                return;
            }
            TransferHandler.DropLocation loc = (TransferHandler.DropLocation)drop;
            loc.getDropPoint();
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 3;
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            if (!(c instanceof JoshText)) {
                return null;
            }
            JoshText j = (JoshText)c;
            if (j.sel.isEmpty()) {
                return null;
            }
            return new StringSelection(j.sel.getSelectedTextForCopy());
        }

        @Override
        protected void exportDone(JComponent source, Transferable data, int action) {
            UndoPatch up = new UndoPatch();
            if (action == 2 && source instanceof JoshText) {
                ((JoshText)source).sel.deleteSel();
                up.realize(Math.max(JoshText.this.caret.row, JoshText.this.sel.row));
                JoshText.this.storeUndo(up, 3);
            }
            JoshText.this.repaint();
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport info) {
            return info.isDataFlavorSupported(DataFlavor.stringFlavor);
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport info) {
            String data;
            Transferable t = info.getTransferable();
            try {
                data = (String)t.getTransferData(DataFlavor.stringFlavor);
            }
            catch (Exception e) {
                return false;
            }
            UndoPatch up = new UndoPatch();
            if (info.isDrop()) {
                Point p = JoshText.this.mouseToPoint(info.getDropLocation().getDropPoint(), true);
                JoshText.this.caret.row = p.y;
                JoshText.this.caret.col = p.x;
                JoshText.this.sel.deselect(false);
                JoshText.this.sel.type = Selection.ST.NORM;
                up.startRow = JoshText.this.caret.row;
                up.reconstruct(p.y, Math.min(JoshText.this.code.size() - 1, p.y + JoshText.this.sel.getInsertRipple(data) - 1));
            }
            int er = 0;
            if (data.length() > 0 && data.charAt(data.length() - 1) == '\u0000') {
                er = Math.max(1, JoshText.this.sel.insertRect(data.substring(0, data.length() - 1))) - 1;
            } else {
                JoshText.this.sel.insert(data);
            }
            up.realize(JoshText.this.caret.row + er);
            JoshText.this.storeUndo(up, 6);
            JoshText.this.repaint();
            return true;
        }
    }

    public static interface LineChangeListener
    extends EventListener {
        public void linesChanged(Code var1, int var2, int var3);
    }

    static enum MatchState {
        NOT_MATCHING,
        NO_MATCH,
        MATCHING;

    }

    class MouseAutoScroll {
        Point rp;
        JViewport p;
        private boolean running = false;
        TimerTask doMouseAutoScroll = new TimerTask(){

            @Override
            public void run() {
                if (!MouseAutoScroll.this.running) {
                    return;
                }
                Point po = MouseAutoScroll.this.p.getViewPosition();
                int x = po.x + MouseAutoScroll.this.rp.x * JoshText.this.monoAdvance;
                int y = po.y + MouseAutoScroll.this.rp.y * JoshText.this.lineHeight;
                Dimension viewSize = MouseAutoScroll.this.p.getViewSize();
                int maxx = viewSize.width - MouseAutoScroll.this.p.getWidth();
                int maxy = viewSize.height - MouseAutoScroll.this.p.getHeight();
                x = x > maxx ? maxx : x;
                y = y > maxy ? maxy : y;
                MouseAutoScroll.this.p.setViewPosition(new Point(x < 0 ? 0 : x, y < 0 ? 0 : y));
                JoshText.this.updateUI();
            }
        };

        MouseAutoScroll() {
            new Timer().scheduleAtFixedRate(this.doMouseAutoScroll, 100L, 100L);
        }

        void start() {
            this.running = true;
        }

        void stop() {
            this.running = false;
        }

        boolean isRunning() {
            return this.running;
        }
    }

    static final class OPT {
        public static final int OTHER = 0;
        public static final int TYPED = 1;
        public static final int BACKSPACE = 2;
        public static final int DELETE = 3;
        public static final int SPACE = 4;
        public static final int ENTER = 5;
        public static final int PASTE = 6;
        public static final int INDENT = 7;
        public static final int DUPLICATE = 8;
        public static final int REPLACE = 9;
        public static final int SWAP = 10;
        public static final int UNSWAP = 11;

        OPT() {
        }
    }

    public static class Settings {
        public static boolean indentUseTabs = true;
        public static int indentSizeInSpaces = 8;
        public static String indentRepString = "\t";
        public static boolean smartBackspace = true;
        public static boolean highlight_line = true;
        public static boolean renderTabs;
    }

    class UndoPatch {
        int opTag;
        Line[] oldText;
        Line[] patchText;
        int startRow;
        CaretData cbefore = new CaretData();
        CaretData cafter = new CaretData();

        UndoPatch(Line[] t, Line[] ot, int sr) {
            this.oldText = ot;
            this.patchText = t;
            this.startRow = sr;
        }

        public void prefix_row(Line ln) {
            --this.startRow;
            Line[] ancient = this.oldText;
            this.oldText = new Line[this.oldText.length + 1];
            this.oldText[0] = ln;
            int i = 0;
            while (i < ancient.length) {
                this.oldText[i + 1] = ancient[i];
                ++i;
            }
        }

        UndoPatch() {
            this(Math.min(joshText.caret.row, joshText.sel.row), Math.max(joshText.caret.row, joshText.sel.row));
        }

        UndoPatch(int startRow, int endRow) {
            int lc = endRow - startRow + 1;
            this.oldText = new Line[lc];
            int i = 0;
            while (i < lc) {
                this.oldText[i] = new Line((Line)JoshText.this.code.get(startRow + i));
                ++i;
            }
            this.startRow = startRow;
            this.cbefore.grab();
        }

        public void reconstruct(int newStartRow, int newEndRow) {
            int lc = newEndRow - newStartRow + 1;
            this.oldText = new Line[lc];
            int i = 0;
            while (i < lc) {
                this.oldText[i] = new Line((Line)JoshText.this.code.get(this.startRow + i));
                ++i;
            }
            this.startRow = newStartRow;
        }

        public void realize(int endRow) {
            JoshText.this.fireLineChange(this.startRow, endRow);
            int lc = endRow - this.startRow + 1;
            this.patchText = new Line[lc];
            int i = 0;
            while (i < lc) {
                this.patchText[i] = new Line((Line)JoshText.this.code.get(this.startRow + i));
                ++i;
            }
            this.cafter.grab();
        }

        class CaretData {
            public int ccol;
            public int crow;
            public int scol;
            public int srow;
            Selection.ST stype;

            CaretData() {
            }

            public void grab() {
                this.ccol = ((UndoPatch)UndoPatch.this).JoshText.this.caret.col;
                this.crow = ((UndoPatch)UndoPatch.this).JoshText.this.caret.row;
                this.scol = ((UndoPatch)UndoPatch.this).JoshText.this.sel.col;
                this.srow = ((UndoPatch)UndoPatch.this).JoshText.this.sel.row;
                this.stype = ((UndoPatch)UndoPatch.this).JoshText.this.sel.type;
            }

            public void replace() {
                ((UndoPatch)UndoPatch.this).JoshText.this.caret.col = this.ccol;
                ((UndoPatch)UndoPatch.this).JoshText.this.caret.row = this.crow;
                ((UndoPatch)UndoPatch.this).JoshText.this.sel.col = this.scol;
                ((UndoPatch)UndoPatch.this).JoshText.this.sel.row = this.srow;
                ((UndoPatch)UndoPatch.this).JoshText.this.sel.type = this.stype;
            }

            public void copy(CaretData cfrom) {
                this.ccol = cfrom.ccol;
                this.crow = cfrom.crow;
                this.scol = cfrom.scol;
                this.srow = cfrom.srow;
                this.stype = cfrom.stype;
            }
        }
    }
}

