/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.joshedit;

import java.awt.Frame;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import org.lateralgm.joshedit.ButGroup;
import org.lateralgm.joshedit.JoshText;
import org.lateralgm.joshedit.Runner;

public class FindDialog
extends JDialog
implements WindowListener,
ActionListener,
ComponentListener {
    private static final long serialVersionUID = 1L;
    public static JComboBox<String> tFind;
    public static JComboBox<String> tReplace;
    public static JCheckBox whole;
    public static JCheckBox start;
    public static JCheckBox sens;
    public static JCheckBox esc;
    public static JCheckBox regex;
    public static JCheckBox wrap;
    public static JCheckBox backward;
    public static JRadioButton scGame;
    public static JRadioButton scObject;
    public static JRadioButton scEvent;
    public static JRadioButton scCode;
    public static JRadioButton scSel;
    public static JButton bFind;
    public static JButton bReplace;
    public static JButton bRepAll;
    protected static FindDialog INSTANCE;
    protected Set<ActionListener> listenerList = new HashSet<ActionListener>();
    protected static Set<ActionListener> permListenerList;
    public JoshText selectedJoshText = null;
    private boolean userPositioned = false;
    private Point previousLocation;
    private static List<FindDialogCreationListener> createListeners;

    static {
        permListenerList = new HashSet<ActionListener>();
        createListeners = new ArrayList<FindDialogCreationListener>();
    }

    public static void addDialogCreationListener(FindDialogCreationListener listener) {
        createListeners.add(listener);
    }

    private FindDialog() {
        super((Frame)null, Runner.editorInterface.getString("FindDialog.TITLE"));
        this.applyLayout();
        this.addWindowListener(this);
        this.addComponentListener(this);
        this.pack();
        this.setMinimumSize(this.getSize());
        this.setIconImage(Runner.editorInterface.getIconForKey("JoshText.FIND").getImage());
    }

    public static FindDialog getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new FindDialog();
            FindDialog.fireCreationEvent(INSTANCE);
        }
        return INSTANCE;
    }

    private static void fireCreationEvent(FindDialog findDialog) {
        for (FindDialogCreationListener listener : createListeners) {
            listener.dialogCreated(findDialog);
        }
    }

    public void present(JoshText selectedEditor) {
        this.selectedJoshText = selectedEditor;
        if (!this.isVisible()) {
            if (!this.userPositioned) {
                Window centeringComponent = this.selectedJoshText == null ? null : SwingUtilities.getWindowAncestor(this.selectedJoshText);
                this.setLocationRelativeTo(centeringComponent);
                this.getLocation(this.previousLocation);
            }
            this.setVisible(true);
        } else {
            this.requestFocus();
        }
    }

    private void applyLayout() {
        GroupLayout gl = new GroupLayout(this.getContentPane());
        gl.setAutoCreateContainerGaps(true);
        gl.setAutoCreateGaps(true);
        this.setLayout(gl);
        JLabel lFind = new JLabel(Runner.editorInterface.getString("FindDialog.FIND_LABEL"));
        tFind = new JComboBox();
        tFind.setEditable(true);
        tFind.getEditor().addActionListener(new EnterListener());
        JLabel lReplace = new JLabel(Runner.editorInterface.getString("FindDialog.REPLACE_LABEL"));
        tReplace = new JComboBox();
        tReplace.setEditable(true);
        tReplace.getEditor().addActionListener(new EnterListener());
        JPanel options = new JPanel();
        options.setLayout(new BoxLayout(options, 3));
        options.setBorder(BorderFactory.createTitledBorder(Runner.editorInterface.getString("FindDialog.OPTIONS")));
        whole = new JCheckBox(Runner.editorInterface.getString("FindDialog.WHOLE_WORD"));
        options.add(whole);
        start = new JCheckBox(Runner.editorInterface.getString("FindDialog.WORD_START"));
        options.add(start);
        wrap = new JCheckBox(Runner.editorInterface.getString("FindDialog.WRAP_EOF"));
        options.add(wrap);
        wrap.setSelected(true);
        sens = new JCheckBox(Runner.editorInterface.getString("FindDialog.CASE_SENSITIVE"));
        options.add(sens);
        esc = new JCheckBox(Runner.editorInterface.getString("FindDialog.ESCAPE_SEQS"));
        options.add(esc);
        regex = new JCheckBox(Runner.editorInterface.getString("FindDialog.REGEX"));
        options.add(regex);
        backward = new JCheckBox(Runner.editorInterface.getString("FindDialog.BACKWARDS"));
        options.add(backward);
        new ButGroup(whole, start);
        new ButGroup(esc, regex);
        regex.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean b = regex.isSelected();
                backward.setEnabled(!b);
            }
        });
        JPanel scope = new JPanel();
        scope.setLayout(new BoxLayout(scope, 3));
        scope.setBorder(BorderFactory.createTitledBorder(Runner.editorInterface.getString("FindDialog.SCOPE")));
        ButtonGroup bg = new ButtonGroup();
        scGame = new JRadioButton(Runner.editorInterface.getString("FindDialog.GAME"));
        bg.add(scGame);
        scope.add(scGame);
        scObject = new JRadioButton(Runner.editorInterface.getString("FindDialog.OBJECT"));
        bg.add(scObject);
        scope.add(scObject);
        scEvent = new JRadioButton(Runner.editorInterface.getString("FindDialog.EVENT"));
        bg.add(scEvent);
        scope.add(scEvent);
        scCode = new JRadioButton(Runner.editorInterface.getString("FindDialog.CODE"), true);
        bg.add(scCode);
        scope.add(scCode);
        scSel = new JRadioButton(Runner.editorInterface.getString("FindDialog.SELECTION"));
        bg.add(scSel);
        scope.add(scSel);
        bFind = new JButton(Runner.editorInterface.getString("FindDialog.FIND"));
        bFind.addActionListener(this);
        this.getRootPane().setDefaultButton(bFind);
        bReplace = new JButton(Runner.editorInterface.getString("FindDialog.REPLACE"));
        bReplace.addActionListener(this);
        bRepAll = new JButton(Runner.editorInterface.getString("FindDialog.REPLACE_ALL"));
        bRepAll.addActionListener(this);
        JButton bClose = new JButton(Runner.editorInterface.getString("FindDialog.CLOSE"));
        bFind.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FindDialog.this.selectedJoshText == null) {
                    System.err.println("No text editor selected. Ever.");
                    return;
                }
                FindDialog.this.setVisible(false);
                FindDialog.this.selectedJoshText.finder.updateParameters((String)tFind.getEditor().getItem(), (String)tReplace.getEditor().getItem());
                FindDialog.this.selectedJoshText.finder.present();
                if (backward.isSelected()) {
                    FindDialog.this.selectedJoshText.finder.findPrevious();
                } else {
                    FindDialog.this.selectedJoshText.finder.findNext();
                }
            }
        });
        bReplace.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FindDialog.this.selectedJoshText == null) {
                    System.err.println("No text editor selected. Ever.");
                    return;
                }
                FindDialog.this.setVisible(false);
                FindDialog.this.selectedJoshText.finder.updateParameters((String)tFind.getEditor().getItem(), (String)tReplace.getEditor().getItem());
                FindDialog.this.selectedJoshText.finder.present();
                if (backward.isSelected()) {
                    FindDialog.this.selectedJoshText.finder.replacePrevious();
                } else {
                    FindDialog.this.selectedJoshText.finder.replaceNext();
                }
            }
        });
        bRepAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FindDialog.this.selectedJoshText == null) {
                    System.err.println("No text editor selected. Ever.");
                    return;
                }
                FindDialog.this.setVisible(false);
                FindDialog.this.selectedJoshText.finder.updateParameters((String)tFind.getEditor().getItem(), (String)tReplace.getEditor().getItem());
                int results = FindDialog.this.selectedJoshText.finder.replaceAll();
                JOptionPane.showMessageDialog(null, String.format(Runner.editorInterface.getString("FindDialog.OCCURRENCES_REPL"), results));
            }
        });
        bClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindDialog.this.dispose();
            }
        });
        int pref = -2;
        gl.setHorizontalGroup(gl.createParallelGroup().addGroup(gl.createSequentialGroup().addGroup(gl.createParallelGroup().addComponent(lFind).addComponent(lReplace)).addGroup(gl.createParallelGroup().addComponent(tFind).addComponent(tReplace))).addGroup(gl.createSequentialGroup().addComponent(options, pref, pref, Integer.MAX_VALUE).addComponent(scope, pref, pref, Integer.MAX_VALUE)).addGroup(gl.createSequentialGroup().addComponent(bFind, pref, pref, Integer.MAX_VALUE).addComponent(bReplace, pref, pref, Integer.MAX_VALUE).addComponent(bRepAll, pref, pref, Integer.MAX_VALUE).addComponent(bClose, pref, pref, Integer.MAX_VALUE)));
        gl.setVerticalGroup(gl.createSequentialGroup().addGroup(gl.createParallelGroup().addComponent(lFind).addComponent(tFind, pref, pref, pref)).addGroup(gl.createParallelGroup().addComponent(lReplace).addComponent(tReplace, pref, pref, pref)).addGroup(gl.createParallelGroup().addComponent(options, pref, pref, Integer.MAX_VALUE).addComponent(scope, pref, pref, Integer.MAX_VALUE)).addGroup(gl.createParallelGroup().addComponent(bFind).addComponent(bReplace).addComponent(bRepAll).addComponent(bClose)));
    }

    public void addActionListener(ActionListener l) {
        this.listenerList.add(l);
    }

    public static void addPermanentActionListener(ActionListener l) {
        permListenerList.add(l);
    }

    public static void removePermanentActionListener(ActionListener l) {
        permListenerList.remove(l);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        for (ActionListener l : this.listenerList) {
            l.actionPerformed(e);
        }
        for (ActionListener l : permListenerList) {
            l.actionPerformed(e);
        }
    }

    @Override
    public void windowClosed(WindowEvent e) {
        this.listenerList.clear();
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.listenerList.clear();
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
        if (this.userPositioned) {
            return;
        }
        if (this.previousLocation == null) {
            this.previousLocation = this.getLocation();
            return;
        }
        if (!this.getLocation().equals(this.previousLocation)) {
            this.userPositioned = true;
        }
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    class EnterListener
    implements ActionListener {
        EnterListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            bFind.doClick();
        }
    }

    public static interface FindDialogCreationListener {
        public void dialogCreated(FindDialog var1);
    }

    public static interface FindNavigator {
        public void updateParameters(String var1, String var2);

        public void present();

        public void findNext();

        public void findPrevious();

        public void replaceNext();

        public int replaceAll();

        public void replacePrevious();

        public void doReplace();
    }
}

