/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.joshedit;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.lateralgm.joshedit.Code;
import org.lateralgm.joshedit.ColorProfile;
import org.lateralgm.joshedit.Line;
import org.lateralgm.joshedit.TokenMarker;

public abstract class DefaultTokenMarker
implements TokenMarker {
    private int line_count;
    private int invalid_line = 0;
    public boolean caseSensitive = true;
    public ArrayList<BlockDescriptor> schemes = new ArrayList();
    public ArrayList<KeywordSet> tmKeywords = new ArrayList();
    public KeywordSet default_kws = null;
    public ArrayList<CharSymbolSet> tmChars = new ArrayList();
    public Pattern identifier_pattern = Pattern.compile("[a-z_A-Z]([a-z_A-Z0-9]*)");
    public ArrayList<SimpleToken> otherTokens = new ArrayList();

    public DefaultTokenMarker() {
    }

    public DefaultTokenMarker(boolean caseSens) {
        this.caseSensitive = caseSens;
    }

    public KeywordSet addKeywordSet(String groupName, Color markColor, int fontStyle) {
        return this.addKeywordSet(groupName, markColor, fontStyle, this.caseSensitive);
    }

    public KeywordSet addKeywordSet(String groupName, ColorProfile profile) {
        ColorProfile.ColorProfileEntry entry = profile.get(groupName);
        return this.addKeywordSet(groupName, entry.color, entry.fontStyle, this.caseSensitive);
    }

    public KeywordSet addKeywordSet(String groupName, Color markColor, int fontStyle, boolean caseSensitiveTK) {
        KeywordSet ks = new KeywordSet(groupName, markColor, fontStyle, caseSensitiveTK);
        this.tmKeywords.add(ks);
        return ks;
    }

    private void mark(Code code) {
        do {
            if (this.invalid_line == 0) {
                ((Line)code.get((int)this.invalid_line)).attr = 0L;
                continue;
            }
            --this.invalid_line;
        } while (((Line)code.get((int)this.invalid_line)).attr < 0L);
        while (this.invalid_line < this.line_count - 1) {
            ArrayList<TokenMarker.TokenMarkerInfo> styles = this.getStyles((Line)code.get(this.invalid_line));
            TokenMarkerInfoEx tmi = (TokenMarkerInfoEx)styles.get(styles.size() - 1);
            ++this.invalid_line;
            ((Line)code.get((int)this.invalid_line)).attr = ((Line)code.get((int)this.invalid_line)).attr < 1L ? 0L : (((Line)code.get((int)this.invalid_line)).attr &= 0xFFFFFFFFFF0000FFL);
            if (tmi.schemeInfo.type != SchemeInfo.SchemeType.UNTERMBLOCK) continue;
            ((Line)code.get((int)this.invalid_line)).attr |= (long)(tmi.schemeInfo.id + 1 << 8);
        }
        this.invalid_line = -1;
    }

    @Override
    public void formatCode(Code code) {
    }

    @Override
    public void linesChanged(Code code, int start, int end) {
        this.line_count = code.size();
        if (start < this.invalid_line || this.invalid_line == -1) {
            this.invalid_line = start;
        }
        if (start > code.size()) {
            start = code.size();
        }
        if (end > code.size()) {
            end = code.size();
        }
        int i = start;
        while (i < end) {
            if (((Line)code.get((int)i)).attr > 0L) {
                ((Line)code.get((int)i)).attr = -((Line)code.get((int)i)).attr;
            } else if (((Line)code.get((int)i)).attr > 0L) {
                ((Line)code.get((int)i)).attr = -1L;
            }
            ++i;
        }
        this.mark(code);
    }

    @Override
    public ArrayList<TokenMarker.TokenMarkerInfo> getStyles(Line jline) {
        ArrayList<TokenMarker.TokenMarkerInfo> res = new ArrayList<TokenMarker.TokenMarkerInfo>();
        StringBuilder line = jline.sbuild;
        int ischeme = (int)(((jline.attr & 0xFFFF00L) >> 8) - 1L);
        boolean pushCapstone = true;
        int i = 0;
        block0: while (true) {
            int mmin;
            int shm = -1;
            int mminend = mmin = line.length();
            if (ischeme < 0) {
                int si = 0;
                while (si < this.schemes.size()) {
                    Matcher m = this.schemes.get((int)si).begin.matcher(line.toString()).region(i, line.length()).useTransparentBounds(true);
                    if (m.find() && m.start() < mmin) {
                        mmin = m.start();
                        mminend = m.end();
                        shm = si;
                    }
                    ++si;
                }
            } else {
                mmin = 0;
                mminend = 0;
                shm = ischeme;
                ischeme = -1;
            }
            if (shm == -1) break;
            while (true) {
                Matcher mmatcher;
                if (!(mmatcher = this.schemes.get((int)shm).end.matcher(line.toString()).region(mminend, line.length())).find()) {
                    res.add(new TokenMarkerInfoEx(this.schemes.get((int)shm).fontStyle, this.schemes.get((int)shm).color, mmin, line.length(), shm, new SchemeInfo(SchemeInfo.SchemeType.UNTERMBLOCK, shm)));
                    pushCapstone = false;
                    break block0;
                }
                i = mmatcher.end();
                if (!this.schemes.get((int)shm).escapeend) {
                    res.add(new TokenMarkerInfoEx(this.schemes.get((int)shm).fontStyle, this.schemes.get((int)shm).color, mmin, i, shm, new SchemeInfo(SchemeInfo.SchemeType.BLOCK, shm)));
                    continue block0;
                }
                char escc = this.schemes.get((int)shm).escapeChar;
                boolean end_escaped = false;
                int cp = mminend;
                while (cp < mmatcher.start()) {
                    if (line.charAt(cp) == escc) {
                        if (cp + 1 < mmatcher.start()) {
                            ++cp;
                        } else {
                            end_escaped = true;
                        }
                    }
                    ++cp;
                }
                if (!end_escaped) {
                    res.add(new TokenMarkerInfoEx(this.schemes.get((int)shm).fontStyle, this.schemes.get((int)shm).color, mmin, i, shm, new SchemeInfo(SchemeInfo.SchemeType.BLOCK, shm)));
                    continue block0;
                }
                if (cp >= line.length()) {
                    res.add(new TokenMarkerInfoEx(this.schemes.get((int)shm).fontStyle, this.schemes.get((int)shm).color, mmin, line.length(), shm, new SchemeInfo(SchemeInfo.SchemeType.UNTERMBLOCK, shm)));
                    pushCapstone = false;
                    break block0;
                }
                mminend = i;
            }
            break;
        }
        i = 0;
        if (pushCapstone) {
            res.add(new TokenMarkerInfoEx(0, null, line.length(), line.length(), 0, new SchemeInfo(SchemeInfo.SchemeType.NOTHING, 0)));
        }
        int bi = 0;
        while (bi < res.size()) {
            int sp = res.get((int)bi).startPos;
            block5: while (i < sp) {
                if (Character.isWhitespace(line.charAt(i))) {
                    while (++i < line.length() && Character.isWhitespace(line.charAt(i))) {
                    }
                    continue;
                }
                Matcher lookingat = this.identifier_pattern.matcher(line).region(i, line.length());
                if (lookingat.lookingAt()) {
                    boolean fnd = false;
                    String f = line.substring(i, lookingat.end());
                    int sn = 0;
                    while (sn < this.tmKeywords.size()) {
                        if (this.tmKeywords.get((int)sn).words.contains(this.tmKeywords.get((int)sn).caseSensitive ? f : f.toLowerCase())) {
                            res.add(bi++, new TokenMarkerInfoEx(this.tmKeywords.get((int)sn).fontStyle, this.tmKeywords.get((int)sn).color, lookingat.start(), lookingat.end(), 0, new SchemeInfo(SchemeInfo.SchemeType.KEYWORD, sn)));
                            fnd = true;
                            break;
                        }
                        ++sn;
                    }
                    if (!fnd && this.default_kws != null) {
                        res.add(bi++, new TokenMarkerInfoEx(this.default_kws.fontStyle, this.default_kws.color, lookingat.start(), lookingat.end(), 0, new SchemeInfo(SchemeInfo.SchemeType.DEFKEYWORD, 0)));
                    }
                    i = lookingat.end();
                    continue;
                }
                int tt = 0;
                while (tt < this.otherTokens.size()) {
                    lookingat = this.otherTokens.get((int)tt).pattern.matcher(line).region(i, line.length());
                    if (lookingat.lookingAt()) {
                        res.add(bi++, new TokenMarkerInfoEx(this.otherTokens.get((int)tt).fontStyle, this.otherTokens.get((int)tt).color, lookingat.start(), lookingat.end(), 0, new SchemeInfo(SchemeInfo.SchemeType.TOKEN, tt)));
                        i = lookingat.end();
                        continue block5;
                    }
                    ++tt;
                }
                char c = line.charAt(i);
                int sn = 0;
                while (sn < this.tmChars.size()) {
                    if (this.tmChars.get((int)sn).chars.contains(Character.valueOf(c))) {
                        res.add(bi++, new TokenMarkerInfoEx(this.tmChars.get((int)sn).fontStyle, this.tmChars.get((int)sn).color, i, i + 1, 0, new SchemeInfo(SchemeInfo.SchemeType.SYMBOL, sn)));
                    }
                    ++sn;
                }
                ++i;
            }
            i = res.get((int)bi++).endPos;
        }
        return res;
    }

    public static class BlockDescriptor {
        String name;
        Pattern begin;
        Pattern end;
        boolean multiline;
        boolean escapeend;
        char escapeChar;
        Color color;
        int fontStyle;

        public BlockDescriptor(String block_name, String begin_regex, String end_regex, boolean allow_multiline, boolean escape_endmarkers, char escape_char, Color markColor, int font_style) {
            this.name = block_name;
            this.begin = Pattern.compile(begin_regex);
            this.end = Pattern.compile(end_regex);
            this.multiline = allow_multiline;
            this.escapeend = escape_endmarkers;
            this.escapeChar = escape_char;
            this.color = markColor;
            this.fontStyle = font_style;
        }

        public BlockDescriptor(String blockName, String beginRegex, String endRegex, boolean allowMultiline, boolean escapeEndMarkers, char escapeChar, ColorProfile profile) {
            this(blockName, beginRegex, endRegex, allowMultiline, escapeEndMarkers, escapeChar, profile.get(blockName));
        }

        public BlockDescriptor(String blockName, String begin_regex, String endRegex, boolean allowMultiline, boolean escapeEndMarkers, char escapeChar, ColorProfile.ColorProfileEntry ent) {
            this(blockName, begin_regex, endRegex, ent.color, ent.fontStyle);
        }

        public BlockDescriptor(String blockName, String beginRegex, String endRegex, Color markColor, int fontStyle) {
            this(blockName, beginRegex, endRegex, true, false, '\u0000', markColor, fontStyle);
        }

        public BlockDescriptor(String block_name, String begin_regex, String end_regex, ColorProfile profile) {
            this(block_name, begin_regex, end_regex, profile.get(block_name));
        }

        public BlockDescriptor(String block_name, String begin_regex, String end_regex, ColorProfile.ColorProfileEntry colorEntry) {
            this(block_name, begin_regex, end_regex, colorEntry.color, colorEntry.fontStyle);
        }
    }

    public static class CharSymbolSet {
        public String name;
        public Set<Character> chars;
        public Color color;
        public int fontStyle;

        public CharSymbolSet(String group_name, Color markColor, int font_style) {
            this.name = group_name;
            this.color = markColor;
            this.fontStyle = font_style;
            this.chars = new HashSet<Character>();
        }

        public CharSymbolSet(String group_name, ColorProfile.ColorProfileEntry colorProfileEntry) {
            this(group_name, colorProfileEntry.color, colorProfileEntry.fontStyle);
        }

        public CharSymbolSet(String group_name, ColorProfile profile) {
            this(group_name, profile.get(group_name));
        }
    }

    public static class KeywordSet {
        String name;
        public Set<String> words;
        Color color;
        int fontStyle;
        public final boolean caseSensitive;

        public KeywordSet(String groupName, Color markColor, int fontStyle, boolean caseSens) {
            this.name = groupName;
            this.color = markColor;
            this.fontStyle = fontStyle;
            this.caseSensitive = caseSens;
            this.words = new HashSet<String>();
        }
    }

    static final class SchemeInfo {
        SchemeType type;
        int id;

        public SchemeInfo() {
            this.type = SchemeType.NOTHING;
            this.id = 0;
        }

        public SchemeInfo(SchemeType scheme_type) {
            this.type = scheme_type;
            this.id = 0;
        }

        public SchemeInfo(SchemeType scheme_type, int scheme_id) {
            this.type = scheme_type;
            this.id = scheme_id;
        }

        static enum SchemeType {
            NOTHING,
            TOKEN,
            BLOCK,
            KEYWORD,
            SYMBOL,
            DEFKEYWORD,
            UNTERMBLOCK;

        }
    }

    public static class SimpleToken {
        public String name;
        public Pattern pattern;
        public int fontStyle;
        public Color color;

        public SimpleToken(String token_name, String regex, int font_style, Color markColor) {
            this.name = token_name;
            this.pattern = Pattern.compile(regex);
            this.fontStyle = font_style;
            this.color = markColor;
        }

        public SimpleToken(String token_name, String regex, ColorProfile.ColorProfileEntry entry) {
            this(token_name, regex, entry.fontStyle, entry.color);
        }

        public SimpleToken(String token_name, String regex, ColorProfile profile) {
            this(token_name, regex, profile.get(token_name));
        }
    }

    class TokenMarkerInfoEx
    extends TokenMarker.TokenMarkerInfo {
        SchemeInfo schemeInfo;

        public TokenMarkerInfoEx(int fs, Color col, int start, int end, int hash, SchemeInfo si) {
            super(fs, col, start, end, hash);
            this.schemeInfo = si;
        }
    }
}

