/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.joshedit;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DefaultKeywords {

    public static class Constant
    extends Keyword {
        public Constant(String input) {
            this.name = input;
        }
    }

    public static class Construct
    extends Keyword {
        public Construct(String input) {
            this.name = input;
        }
    }

    public static class Function
    extends Keyword {
        public final String description;
        public final String[] arguments;
        public final int dynArgIndex;
        public final int dynArgMin;
        public final int dynArgMax;

        public Function(String input) {
            String re = "(\\w+)\\(((\\w+,)*)((\\w+)\\{(\\d+),(\\d+)}((?=\\))|,))?(\\w+)?\\)";
            Matcher m = Pattern.compile(re).matcher(input);
            if (!m.matches()) {
                System.err.println("Invalid function: " + input);
            }
            this.name = m.group(1);
            String a1 = m.group(2);
            String da = m.group(5);
            String daMin = m.group(6);
            String daMax = m.group(7);
            String a2 = m.group(9);
            String[] aa1 = a1.length() > 0 ? a1.split(",") : new String[]{};
            this.arguments = new String[aa1.length + (da != null ? 1 : 0) + (a2 != null ? 1 : 0)];
            System.arraycopy(aa1, 0, this.arguments, 0, aa1.length);
            if (da == null) {
                this.dynArgIndex = -1;
                this.dynArgMin = 0;
                this.dynArgMax = 0;
            } else {
                this.dynArgIndex = aa1.length;
                this.dynArgMin = Integer.parseInt(daMin);
                this.dynArgMax = Integer.parseInt(daMax);
                this.arguments[aa1.length] = da;
            }
            if (a2 != null) {
                this.arguments[this.arguments.length - 1] = a2;
            }
            this.description = "";
        }

        public Function(String func, String args, String desc) {
            this.name = func;
            this.arguments = args.split(",");
            this.description = desc;
            this.dynArgIndex = -1;
            this.dynArgMin = 0;
            this.dynArgMax = 0;
        }
    }

    public static interface HasKeywords {
        public Keyword[][] getKeywords();
    }

    public static abstract class Keyword {
        protected String name;

        public String getName() {
            return this.name;
        }
    }

    public static class Operator
    extends Keyword {
        public Operator(String input) {
            this.name = input;
        }
    }

    public static class Variable
    extends Keyword {
        public final boolean readOnly;
        public final int arraySize;

        public Variable(String input) {
            Matcher m = Pattern.compile("(\\w+)(\\[(\\d+)])?(\\*)?").matcher(input);
            if (!m.matches()) {
                System.err.println("Invalid variable: " + input);
            }
            this.name = m.group(1);
            String s = m.group(3);
            this.arraySize = s != null ? Integer.valueOf(m.group(3)) : 0;
            this.readOnly = "*".equals(m.group(4));
        }
    }
}

