/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.joshedit;

import java.applet.Applet;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.UIManager;
import org.lateralgm.joshedit.JoshText;

public class CompletionMenu {
    protected JoshText area;
    private final JScrollPane scroll;
    private final Completion[] completions;
    private Completion[] options;
    private String word;
    private final JList<Completion> completionList;
    private final KeyHandler keyHandler;
    protected int row;
    protected int wordStart;
    protected int wordEnd;
    protected int caret;
    protected PopupHandler ph;
    protected Point loc;

    public CompletionMenu(Frame owner, JoshText a, int y, int x1, int x2, int caret, Completion[] c) {
        this.area = a;
        this.row = y;
        this.wordStart = x1;
        this.wordEnd = x2;
        this.caret = caret;
        this.completions = c;
        this.keyHandler = new KeyHandler();
        this.completionList = new JList();
        this.completionList.setFixedCellHeight(12);
        this.completionList.setFont(new Font("Monospace", 0, 10));
        this.completionList.setSelectionMode(0);
        this.completionList.addKeyListener(this.keyHandler);
        this.completionList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (CompletionMenu.this.apply()) {
                    e.consume();
                } else {
                    CompletionMenu.this.dispose();
                }
            }
        });
        this.scroll = new JScrollPane(this.completionList);
        this.scroll.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.ph = new PopupHandler(owner, this.scroll);
        this.ph.addHideListener(new PopupHandler.HideListener(){

            @Override
            public void hidePerformed(boolean wasVisible) {
                CompletionMenu.this.dispose();
            }
        });
        this.reset();
    }

    public void show() {
        this.ph.show(this.loc.x, this.loc.y);
    }

    public void dispose() {
        this.ph.dispose();
        this.area.requestFocusInWindow();
    }

    public void setLocation() {
        Point p = this.area.getLocationOnScreen();
        int y = (this.row + 1) * this.area.metrics.lineHeight();
        int x = this.area.metrics.lineWidth(this.row, this.wordEnd);
        p.x += Math.min(this.area.getWidth(), Math.max(0, x));
        p.y += Math.min(this.area.getHeight(), Math.max(0, y)) + 3;
        this.loc = p;
    }

    public void reset() {
        String w = this.area.code.getsb(this.row).toString().substring(this.wordStart, this.wordEnd);
        if (w.isEmpty()) {
            this.options = this.completions;
        } else if (this.options != null && this.word != null && w.startsWith(this.word)) {
            ArrayList<Completion> l = new ArrayList<Completion>();
            Completion[] completionArray = this.options;
            int n = this.options.length;
            int n2 = 0;
            while (n2 < n) {
                Completion c = completionArray[n2];
                if (c.match(w)) {
                    l.add(c);
                }
                ++n2;
            }
            this.options = l.toArray(new Completion[l.size()]);
        } else {
            ArrayList<Completion> l = new ArrayList<Completion>();
            Completion[] completionArray = this.completions;
            int n = this.completions.length;
            int n3 = 0;
            while (n3 < n) {
                Completion c = completionArray[n3];
                if (c.match(w)) {
                    l.add(c);
                }
                ++n3;
            }
            this.options = l.toArray(new Completion[l.size()]);
        }
        if (this.options.length <= 0) {
            this.dispose();
            return;
        }
        this.word = w;
        this.completionList.setListData((Completion[])this.options);
        this.completionList.setVisibleRowCount(Math.min(this.options.length, 8));
        this.setLocation();
        this.select(0);
        this.show();
        this.completionList.requestFocusInWindow();
    }

    public void select(int n) {
        this.completionList.setSelectedIndex(n);
        this.completionList.ensureIndexIsVisible(n);
    }

    public void selectRelative(int n) {
        int s = this.completionList.getModel().getSize();
        if (s <= 1) {
            return;
        }
        int i = this.completionList.getSelectedIndex();
        this.select((s + (i + n) % s) % s);
    }

    public boolean apply() {
        return this.apply('\u0000');
    }

    public boolean apply(char input) {
        Completion o = this.completionList.getSelectedValue();
        if (o instanceof Completion) {
            Completion c = o;
            this.dispose();
            if (input == '\n') {
                input = '\u0000';
            }
            return c.apply(this.area, input, this.row, this.wordStart, this.wordEnd);
        }
        return false;
    }

    public void setSelectedText(String s) {
        this.area.sel.insert(s);
    }

    public static abstract class Completion {
        protected String name;

        public boolean match(String start) {
            return Completion.match(start, this.name) >= 0;
        }

        public abstract boolean apply(JoshText var1, char var2, int var3, int var4, int var5);

        public static boolean replace(JoshText d, int row, int start, int end, String text) {
            d.code.getsb(row).replace(start, end, text);
            d.code.fireLinesChanged();
            d.fireLineChange(row, row);
            d.repaint();
            return true;
        }

        public static int match(String input, String name) {
            String nl;
            if (input.equals(name)) {
                return 0;
            }
            if (name.startsWith(input)) {
                return 1;
            }
            String il = input.toLowerCase();
            if (il.equals(nl = name.toLowerCase())) {
                return 2;
            }
            if (nl.startsWith(il)) {
                return 3;
            }
            String re = "(?<!(^|_))" + (name.matches("[A-Z_]+") ? "." : "[a-z_]");
            String ns = name.replaceAll(re, "").toLowerCase();
            if (il.equals(ns)) {
                return 4;
            }
            if (ns.startsWith(il)) {
                return 5;
            }
            return -1;
        }

        public String toString() {
            return this.name;
        }
    }

    private class KeyHandler
    extends KeyAdapter {
        @Override
        public void keyPressed(KeyEvent e) {
            switch (e.getKeyCode()) {
                case 8: {
                    if (CompletionMenu.this.area.sel.isEmpty()) {
                        if (CompletionMenu.this.caret <= 0) {
                            CompletionMenu.this.dispose();
                        } else {
                            --CompletionMenu.this.caret;
                        }
                        --CompletionMenu.this.wordEnd;
                    } else {
                        CompletionMenu.this.setSelectedText(new String());
                    }
                    e.consume();
                    CompletionMenu.this.reset();
                    break;
                }
                case 37: {
                    if (CompletionMenu.this.caret <= 0) {
                        CompletionMenu.this.dispose();
                    } else {
                        --CompletionMenu.this.caret;
                    }
                    e.consume();
                    CompletionMenu.this.reset();
                    break;
                }
                case 39: {
                    if (CompletionMenu.this.caret >= CompletionMenu.this.wordEnd) {
                        CompletionMenu.this.dispose();
                    } else {
                        ++CompletionMenu.this.caret;
                    }
                    e.consume();
                    CompletionMenu.this.reset();
                    break;
                }
                case 27: {
                    CompletionMenu.this.dispose();
                    e.consume();
                    break;
                }
                case 38: {
                    CompletionMenu.this.selectRelative(-1);
                    e.consume();
                    break;
                }
                case 40: {
                    CompletionMenu.this.selectRelative(1);
                    e.consume();
                }
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
            if ((e.getModifiersEx() & 0x80) != 0) {
                return;
            }
            char c = e.getKeyChar();
            if (c == '\b') {
                return;
            }
            if (c == '\n' || c == '\t' || c == ' ') {
                CompletionMenu.this.apply(c);
                e.consume();
                CompletionMenu.this.dispose();
                return;
            }
            CompletionMenu.this.setSelectedText(String.valueOf(c));
            e.consume();
            CompletionMenu.this.reset();
        }
    }

    public static class PopupHandler
    implements AWTEventListener,
    WindowListener,
    ComponentListener {
        protected Popup pop;
        protected Window invoker;
        protected Component contents;
        protected int lastX;
        protected int lastY;
        protected List<HideListener> hll = new ArrayList<HideListener>();

        public PopupHandler(Window invoker, Component contents) {
            this.invoker = invoker;
            this.contents = contents;
            this.install();
        }

        public void setContents(Component contents) {
            this.contents = contents;
            this.show(this.lastX, this.lastY);
        }

        protected void install() {
            long mask = 131088L;
            Toolkit.getDefaultToolkit().addAWTEventListener(this, mask);
            this.invoker.addWindowListener(this);
            this.invoker.addComponentListener(this);
        }

        public void dispose() {
            if (this.pop != null) {
                this.pop.hide();
            }
            this.pop = null;
            this.uninstall();
        }

        protected void uninstall() {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this);
            this.invoker.removeWindowListener(this);
            this.invoker.removeComponentListener(this);
        }

        public void show(int x, int y) {
            this.lastX = x;
            this.lastY = y;
            if (this.pop != null) {
                this.pop.hide();
            }
            this.pop = PopupFactory.getSharedInstance().getPopup(this.invoker, this.contents, x, y);
            this.pop.show();
        }

        public void hide() {
            if (this.pop != null) {
                this.pop.hide();
            }
            this.fireHide(this.pop != null);
            this.pop = null;
        }

        public void addHideListener(HideListener e) {
            this.hll.add(e);
        }

        public void removeHideListener(HideListener e) {
            this.hll.remove(e);
        }

        protected void fireHide(boolean wasVisible) {
            for (HideListener hl : this.hll) {
                hl.hidePerformed(wasVisible);
            }
        }

        protected boolean isInPopup(Component src) {
            Component c = src;
            while (c != null) {
                if (c == this.contents) {
                    return true;
                }
                if (c instanceof Applet || c instanceof Window) {
                    return false;
                }
                c = c.getParent();
            }
            return false;
        }

        @Override
        public void eventDispatched(AWTEvent ev) {
            if (!(ev instanceof MouseEvent)) {
                return;
            }
            MouseEvent me = (MouseEvent)ev;
            Component src = me.getComponent();
            switch (me.getID()) {
                case 501: {
                    if (this.isInPopup(src)) {
                        return;
                    }
                    this.hide();
                    if (!UIManager.getBoolean("PopupMenu.consumeEventOnClose")) break;
                    me.consume();
                    break;
                }
                case 507: {
                    if (this.isInPopup(src)) {
                        return;
                    }
                    this.hide();
                }
            }
        }

        @Override
        public void componentResized(ComponentEvent e) {
            this.hide();
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            this.hide();
        }

        @Override
        public void componentShown(ComponentEvent e) {
            this.hide();
        }

        @Override
        public void componentHidden(ComponentEvent e) {
            this.hide();
        }

        @Override
        public void windowClosing(WindowEvent e) {
            this.hide();
        }

        @Override
        public void windowClosed(WindowEvent e) {
            this.hide();
        }

        @Override
        public void windowIconified(WindowEvent e) {
            this.hide();
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
            this.hide();
        }

        @Override
        public void windowOpened(WindowEvent e) {
        }

        @Override
        public void windowDeiconified(WindowEvent e) {
        }

        @Override
        public void windowActivated(WindowEvent e) {
        }

        public static interface HideListener
        extends EventListener {
            public void hidePerformed(boolean var1);
        }
    }

    public static class WordCompletion
    extends Completion {
        public WordCompletion(String w) {
            this.name = w;
        }

        @Override
        public boolean apply(JoshText a, char input, int row, int wordStart, int wordEnd) {
            String s = String.valueOf(this.name) + (input != '\u0000' ? String.valueOf(input) : new String());
            if (!WordCompletion.replace(a, row, wordStart, wordEnd, s)) {
                return false;
            }
            a.caret.row = row;
            a.caret.col = wordStart + s.length();
            a.caret.positionChanged();
            return true;
        }
    }
}

