/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.joshedit;

import java.awt.Color;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.lateralgm.joshedit.Runner;

public class ColorProfile
implements Iterable<ColorProfileEntry> {
    private final String name;
    private final Map<String, ColorProfileEntry> colors;
    private final Color lineNumberColor;
    private final Color lineNumberPanelColor;
    private final Color whitespaceColor;
    private final Color lineHighlightColor;
    private final Color matchingCharColor;
    private final Color noMatchingCharColor;
    private final Color backgroundColor;
    private final Color defaultFontColor;
    private static final String LINE_NUMBER_COLOR = "LINE_NUMBER_COLOR";
    private static final String LINE_NUMBER_PANEL_COLOR = "LINE_NUMBER_PANEL_COLOR";
    private static final String WHITESPACE_COLOR = "WHITESPACE_COLOR";
    private static final String LINE_HIGHLIGHT_COLOR = "LINE_HIGHLIGHT_COLOR";
    private static final String MATCHING_CHAR_COLOR = "MATCHING_CHAR_COLOR";
    private static final String NO_MATCHING_CHAR_COLOR = "NO_MATCHING_CHAR_COLOR";
    private static final String BACKGROUND_COLOR = "BACKGROUND_COLOR";
    private static final String DEFAULT_FONT_COLOR = "DEFAULT_FONT_COLOR";

    private ColorProfile(String name, Map<String, ColorProfileEntry> colors, Color lineNumberColor, Color lineNumberPanelColor, Color whitespaceColor, Color lineHighlightColor, Color matchingCharColor, Color noMatchingCharColor, Color backgroundColor, Color defaultFontColor) {
        this.name = name;
        this.colors = Collections.unmodifiableMap(colors);
        this.lineNumberColor = lineNumberColor;
        this.lineNumberPanelColor = lineNumberPanelColor;
        this.whitespaceColor = whitespaceColor;
        this.lineHighlightColor = lineHighlightColor;
        this.matchingCharColor = matchingCharColor;
        this.noMatchingCharColor = noMatchingCharColor;
        this.backgroundColor = backgroundColor;
        this.defaultFontColor = defaultFontColor;
    }

    public ColorProfile(String name, ColorProfile otherProfile) {
        this.name = name;
        this.colors = otherProfile.colors;
        this.lineNumberColor = otherProfile.lineNumberColor;
        this.lineNumberPanelColor = otherProfile.lineNumberPanelColor;
        this.whitespaceColor = otherProfile.whitespaceColor;
        this.lineHighlightColor = otherProfile.lineHighlightColor;
        this.matchingCharColor = otherProfile.matchingCharColor;
        this.noMatchingCharColor = otherProfile.noMatchingCharColor;
        this.backgroundColor = otherProfile.backgroundColor;
        this.defaultFontColor = otherProfile.defaultFontColor;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(String name) {
        return new Builder(name);
    }

    public static Builder newBuilder(String name, Map<String, ColorProfileEntry> colors) {
        return new Builder(name, colors);
    }

    public Color getLineNumberColor() {
        return this.lineNumberColor;
    }

    public Color getLineNumberPanelColor() {
        return this.lineNumberPanelColor;
    }

    public Color getWhitespaceColor() {
        return this.whitespaceColor;
    }

    public Color getLineHighlightColor() {
        return this.lineHighlightColor;
    }

    public Color getMatchingCharColor() {
        return this.matchingCharColor;
    }

    public Color getNoMatchingCharColor() {
        return this.noMatchingCharColor;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public Color getDefaultFontColor() {
        return this.defaultFontColor;
    }

    public static ColorProfileEntry makeEntry(String nlsKey, int r, int g, int b, int transform) {
        return new ColorProfileEntry(ColorProfile.translate(nlsKey), new Color(r, g, b), transform);
    }

    public static ColorProfileEntry makeEntry(String nlsKey, Color color, int transform) {
        return new ColorProfileEntry(ColorProfile.translate(nlsKey), color, transform);
    }

    public String getName() {
        return this.name;
    }

    public ColorProfileEntry get(String key) {
        return this.colors.get(key);
    }

    public Set<String> keySet() {
        return this.colors.keySet();
    }

    public Collection<ColorProfileEntry> values() {
        return this.colors.values();
    }

    public Set<Map.Entry<String, ColorProfileEntry>> entrySet() {
        return this.colors.entrySet();
    }

    @Override
    public Iterator<ColorProfileEntry> iterator() {
        return this.colors.values().iterator();
    }

    public Iterable<Map.Entry<String, Color>> colorProperties() {
        LinkedHashMap<String, Color> map = new LinkedHashMap<String, Color>();
        map.put(LINE_NUMBER_COLOR, this.lineNumberColor);
        map.put(LINE_NUMBER_PANEL_COLOR, this.lineNumberPanelColor);
        map.put(WHITESPACE_COLOR, this.whitespaceColor);
        map.put(LINE_HIGHLIGHT_COLOR, this.lineHighlightColor);
        map.put(MATCHING_CHAR_COLOR, this.matchingCharColor);
        map.put(NO_MATCHING_CHAR_COLOR, this.noMatchingCharColor);
        map.put(BACKGROUND_COLOR, this.backgroundColor);
        map.put(DEFAULT_FONT_COLOR, this.defaultFontColor);
        return map.entrySet();
    }

    public static String getPropertyNlsName(String key) {
        return Runner.editorInterface.getString("ThemeColor." + key);
    }

    private static String translate(String key) {
        return Runner.editorInterface.getString("HighlightBlocks." + key);
    }

    /* synthetic */ ColorProfile(String string, Map map, Color color, Color color2, Color color3, Color color4, Color color5, Color color6, Color color7, Color color8, ColorProfile colorProfile) {
        this(string, map, color, color2, color3, color4, color5, color6, color7, color8);
    }

    public static final class Builder {
        private String name;
        private final Map<String, ColorProfileEntry> colors;
        private Color lineNumberColor;
        private Color lineNumberPanelColor;
        private Color whitespaceColor;
        private Color lineHighlightColor;
        private Color matchingCharColor;
        private Color noMatchingCharColor;
        private Color backgroundColor;
        private Color defaultFontColor;

        public Builder() {
            this.name = "";
            this.colors = new LinkedHashMap<String, ColorProfileEntry>();
        }

        public Builder(String name) {
            this.name = name;
            this.colors = new LinkedHashMap<String, ColorProfileEntry>();
        }

        public Builder(String name, Map<String, ColorProfileEntry> colors) {
            this.name = name;
            this.colors = colors;
        }

        public final Builder setName(String name) {
            this.name = name;
            return this;
        }

        public final Builder addProfileEntry(String key, ColorProfileEntry entry) {
            this.colors.put(key, entry);
            return this;
        }

        public final Builder add(String key, ColorProfileEntry entry) {
            this.colors.put(key, entry);
            return this;
        }

        public final Builder setLineNumberColor(Color lineNumberColor) {
            this.lineNumberColor = lineNumberColor;
            return this;
        }

        public final Builder setLineNumberPanelColor(Color lineNumberPanelColor) {
            this.lineNumberPanelColor = lineNumberPanelColor;
            return this;
        }

        public final Builder setWhitespaceColor(Color whitespaceColor) {
            this.whitespaceColor = whitespaceColor;
            return this;
        }

        public final Builder setLineHighlightColor(Color lineHighlightColor) {
            this.lineHighlightColor = lineHighlightColor;
            return this;
        }

        public final Builder setMatchingCharColor(Color matchingCharColor) {
            this.matchingCharColor = matchingCharColor;
            return this;
        }

        public final Builder setNoMatchingCharColor(Color noMatchingCharColor) {
            this.noMatchingCharColor = noMatchingCharColor;
            return this;
        }

        public final Builder setBackgroundColor(Color backgroundColor) {
            this.backgroundColor = backgroundColor;
            return this;
        }

        public final Builder setDefaultFontColor(Color defaultFontColor) {
            this.defaultFontColor = defaultFontColor;
            return this;
        }

        public ColorProfile build() {
            return new ColorProfile(this.name, this.colors, this.lineNumberColor, this.lineNumberPanelColor, this.whitespaceColor, this.lineHighlightColor, this.matchingCharColor, this.noMatchingCharColor, this.backgroundColor, this.defaultFontColor, null);
        }

        public void setColorByProperty(String property, Color color) {
            switch (property) {
                case "LINE_NUMBER_COLOR": {
                    this.lineNumberColor = color;
                    break;
                }
                case "LINE_NUMBER_PANEL_COLOR": {
                    this.lineNumberPanelColor = color;
                    break;
                }
                case "WHITESPACE_COLOR": {
                    this.whitespaceColor = color;
                    break;
                }
                case "LINE_HIGHLIGHT_COLOR": {
                    this.lineHighlightColor = color;
                    break;
                }
                case "MATCHING_CHAR_COLOR": {
                    this.matchingCharColor = color;
                    break;
                }
                case "NO_MATCHING_CHAR_COLOR": {
                    this.noMatchingCharColor = color;
                    break;
                }
                case "BACKGROUND_COLOR": {
                    this.backgroundColor = color;
                    break;
                }
                case "DEFAULT_FONT_COLOR": {
                    this.defaultFontColor = color;
                }
            }
        }
    }

    public static class ColorProfileEntry {
        public final String nlsName;
        public final Color color;
        public final int fontStyle;

        public ColorProfileEntry(String nlsName, Color color, int transform) {
            this.nlsName = nlsName;
            this.color = color;
            this.fontStyle = transform;
        }
    }
}

