/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.joshedit;

import java.awt.AWTEvent;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.lateralgm.joshedit.FindDialog;
import org.lateralgm.joshedit.Line;

public class Code
extends ArrayList<Line> {
    private static final long serialVersionUID = 1L;
    public List<CodeListener> listenerList = new LinkedList<CodeListener>();

    @Override
    public void add(int index, StringBuilder sb) {
        super.add(index, new Line(sb));
        this.fireLinesChanged();
    }

    @Override
    public void add(int index, String string) {
        this.add(index, new StringBuilder(string));
    }

    @Override
    public boolean add(StringBuilder sb) {
        boolean r = super.add(new Line(sb));
        this.fireLinesChanged();
        return r;
    }

    @Override
    public boolean add(String s) {
        return this.add(new StringBuilder(s));
    }

    @Override
    public Line remove(int index) {
        Line r = (Line)super.remove(index);
        this.fireLinesChanged();
        return r;
    }

    public StringBuilder getsb(int index) {
        return ((Line)super.get((int)index)).sbuild;
    }

    public void addCodeListener(CodeListener l) {
        this.listenerList.add(l);
    }

    public void removeCodeListener(CodeListener l) {
        this.listenerList.remove(l);
    }

    protected void fireLinesChanged() {
        for (CodeListener l : this.listenerList) {
            l.codeChanged(new CodeEvent(this, 0));
        }
    }

    public FindResults findPrevious(String[] findme, int lineFrom, int posFrom) {
        int y = lineFrom;
        while (y >= 0) {
            int io;
            if (findme.length == 1 && (io = Code.find_prev_in(this.getsb(y), findme[0].toLowerCase(), y == lineFrom ? posFrom : this.getsb(y).length())) != -1) {
                return new FindResults(y, io, findme[0].length());
            }
            --y;
        }
        return null;
    }

    private static int find_prev_in(StringBuilder sb, String findme, int from) {
        if (from == 0) {
            return -1;
        }
        if (FindDialog.sens.isSelected()) {
            return sb.lastIndexOf(findme, from - 1);
        }
        return sb.toString().toLowerCase().lastIndexOf(findme.toLowerCase(), from - 1);
    }

    public FindResults findNext(Pattern p, int lineFrom, int posFrom) {
        int y = lineFrom;
        while (y < this.size()) {
            int si;
            Matcher m = p.matcher(this.getsb(y).toString());
            int n = si = y == lineFrom ? posFrom : 0;
            if (m.find(si)) {
                return new FindResults(y, m.start(), y, m.end());
            }
            ++y;
        }
        return null;
    }

    public FindResults findNext(String[] findme, int lineFrom, int posFrom) {
        int y = lineFrom;
        while (y < this.size()) {
            block6: {
                int io = Code.find_next_in(this.getsb(y), findme[0], y == lineFrom ? posFrom : 0);
                if (io != -1) {
                    if (findme.length == 1) {
                        return new FindResults(y, io, findme[0].length());
                    }
                    int intermediate = 1;
                    while (intermediate < findme.length - 1) {
                        if (findme[intermediate].equals(this.getsb(y + intermediate))) {
                            ++intermediate;
                            continue;
                        }
                        break block6;
                    }
                    if (this.getsb(y + intermediate).length() >= findme[intermediate].length() && this.getsb(y + intermediate).substring(0, findme[intermediate].length()).equals(findme[intermediate])) {
                        return new FindResults(io, y, findme[intermediate].length(), y + intermediate);
                    }
                }
            }
            ++y;
        }
        return null;
    }

    private static int find_next_in(StringBuilder sb, String findme, int from) {
        if (FindDialog.sens.isSelected()) {
            return sb.indexOf(findme, from);
        }
        return sb.toString().toLowerCase().indexOf(findme, from);
    }

    public static class CodeEvent
    extends AWTEvent {
        private static final long serialVersionUID = 1L;
        public static final int LINES_CHANGED = 0;

        public CodeEvent(Object source, int id) {
            super(source, id);
        }
    }

    public static interface CodeListener
    extends EventListener {
        public void codeChanged(CodeEvent var1);
    }

    class FindResults {
        int line;
        int pos;
        int endLine;
        int endPos;

        FindResults(int l, int p, int L) {
            this.line = l;
            this.pos = p;
            this.endLine = l;
            this.endPos = p + L;
        }

        FindResults(int l, int p, int le, int pe) {
            this.line = l;
            this.pos = p;
            this.endLine = le;
            this.endPos = pe;
        }
    }
}

