/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.joshedit;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import org.lateralgm.joshedit.JoshText;
import org.lateralgm.joshedit.Selection;

public class Caret
implements ActionListener {
    public int col;
    public int row;
    public int colw;
    public boolean insert = true;
    private boolean visible = true;
    private Timer flasher;
    private JComponent painter;
    private JoshText joshText;
    private final ArrayList<CaretListener> caretListeners = new ArrayList();
    private Selection lastSelection;

    public Caret(JoshText jt) {
        this.setBlinkRate(Caret.getDefaultBlinkRate());
        this.joshText = jt;
        this.painter = jt;
        this.flasher.start();
    }

    public Caret(Caret caret) {
        this.col = caret.col;
        this.row = caret.row;
        this.colw = caret.colw;
    }

    public static int getDefaultBlinkRate() {
        Object oblink = UIManager.get("TextArea.caretBlinkRate", null);
        int blink = 500;
        if (oblink != null && oblink instanceof Number) {
            blink = ((Number)oblink).intValue();
        }
        return blink;
    }

    public void setBlinkRate(int rate) {
        if (this.flasher == null) {
            this.flasher = new Timer(rate, this);
        } else {
            this.flasher.setDelay(rate);
        }
    }

    public void flashOn() {
        this.flasher.restart();
        if (!this.visible) {
            this.visible = true;
            this.repaint();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.visible = !this.visible;
        this.repaint();
    }

    protected final synchronized void repaint() {
        if (this.painter != null) {
            Selection.ST type = this.lastSelection == null ? Selection.ST.NORM : this.lastSelection.type;
            int row = this.lastSelection == null ? this.row : this.lastSelection.row;
            Rectangle rect = this.computeCaretRect(row, type);
            this.painter.repaint(rect.x, rect.y, rect.width, rect.height);
        }
    }

    public void paint(Graphics g, Selection sel) {
        if (this.visible) {
            g.setXORMode(Color.WHITE);
            Rectangle rect = this.computeCaretRect(sel.row, sel.type);
            g.fillRect(rect.x, rect.y, rect.width, rect.height);
            g.setPaintMode();
            this.lastSelection = sel;
        }
    }

    private Rectangle computeCaretRect(int selRow, Selection.ST selType) {
        Rectangle rect;
        JoshText.CodeMetrics cm = this.joshText.metrics;
        Insets i = this.painter.getInsets();
        int gw = cm.glyphWidth();
        int gh = cm.lineHeight();
        if (selType == Selection.ST.RECT) {
            rect = new Rectangle(1 + i.left + this.col * gw, i.top + Math.min(this.row, selRow) * gh, this.insert ? 1 : gw, (Math.abs(this.row - selRow) + 1) * gh);
        } else {
            int off = this.insert ? 1 : 0;
            rect = new Rectangle(off + i.left + this.joshText.line_wid_at(this.row, this.col), i.top + this.row * gh, this.insert ? 1 : gw, gh);
        }
        return rect;
    }

    public void resetcoords(Caret scar) {
        this.col = scar.col;
        this.row = scar.row;
        this.colw = scar.colw;
    }

    public int getPositionRepresentation(Selection selection) {
        return selection.type == Selection.ST.RECT ? this.joshText.column_to_index(this.row, this.col) : this.col;
    }

    public void addCaretListener(CaretListener cl) {
        this.caretListeners.add(cl);
    }

    public void positionChanged() {
        int i = 0;
        while (i < this.caretListeners.size()) {
            this.caretListeners.get(i).caretUpdate(new CaretEvent(this.joshText){
                private static final long serialVersionUID = 1L;

                @Override
                public int getMark() {
                    return Caret.this.col;
                }

                @Override
                public int getDot() {
                    return ((Caret)Caret.this).joshText.sel.col;
                }
            });
            ++i;
        }
    }
}

