/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.file.iconio;

import java.util.HashMap;
import java.util.Map;

public final class TypeCompression {
    private static final Map<Long, TypeCompression> TYPES;
    public static final TypeCompression BI_RGB;
    public static final TypeCompression BI_RLE8;
    public static final TypeCompression BI_RLE4;
    public static final TypeCompression BI_BITFIELDS;
    public static final TypeCompression BI_PNG;
    private final int value;
    private final String name;
    private final String comment;

    static {
        BI_RGB = new TypeCompression("BI_RGB", 0, "Uncompressed (any BPP)");
        BI_RLE8 = new TypeCompression("BI_RLE8", 1, "8 Bit RLE Compression (8 BPP only)");
        BI_RLE4 = new TypeCompression("BI_RLE4", 2, "4 Bit RLE Compression (4 BPP only)");
        BI_BITFIELDS = new TypeCompression("BI_BITFIELDS", 3, "Uncompressed (16 & 32 BPP only)");
        BI_PNG = new TypeCompression("BI_PNG", -1, "PNG Compression");
        TYPES = new HashMap<Long, TypeCompression>();
        TypeCompression.register(BI_RGB);
        TypeCompression.register(BI_RLE8);
        TypeCompression.register(BI_RLE4);
        TypeCompression.register(BI_BITFIELDS);
        TypeCompression.register(BI_PNG);
    }

    private TypeCompression(String pName, int pValue, String pComment) {
        this.name = pName;
        this.value = pValue;
        this.comment = pComment;
    }

    private static void register(TypeCompression pType) {
        TYPES.put(Long.valueOf(pType.getValue()), pType);
    }

    public String toString() {
        return String.valueOf(this.name) + " (" + this.comment + ")";
    }

    public String getName() {
        return this.name;
    }

    public int getValue() {
        return this.value;
    }

    public static TypeCompression getType(long pValue) {
        TypeCompression lResult = TYPES.get(pValue);
        if (lResult == null) {
            throw new IllegalArgumentException("Compression type " + pValue + " unknown");
        }
        return lResult;
    }
}

