/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.file.iconio;

import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import org.lateralgm.file.iconio.BitmapDescriptor;
import org.lateralgm.file.iconio.ICOFile;
import org.lateralgm.file.iconio.ImageInputStreamAdapter;

public class ICOReader
extends ImageReader {
    private static final int[] ONE = new int[1];
    protected ICOFile icoFile;
    protected ImageInputStream stream;

    public ICOReader(ImageReaderSpi pProvider) {
        super(pProvider);
    }

    @Override
    public int getHeight(int pImageIndex) {
        return this.getICOEntry(pImageIndex).getHeight();
    }

    @Override
    public IIOMetadata getImageMetadata(int pImageIndex) {
        return null;
    }

    @Override
    public Iterator<ImageTypeSpecifier> getImageTypes(int pImageIndex) {
        ArrayList<ImageTypeSpecifier> lTypes = new ArrayList<ImageTypeSpecifier>();
        int lImageNo = 0;
        while (lImageNo < this.getNumImages(false)) {
            ImageTypeSpecifier lSpecifier = ImageTypeSpecifier.createInterleaved(ColorSpace.getInstance(1000), ONE, 0, false, false);
            lTypes.add(lSpecifier);
            ++lImageNo;
        }
        return lTypes.iterator();
    }

    @Override
    public int getNumImages(boolean pAllowSearch) {
        return this.getICOFile().getImageCount();
    }

    @Override
    public IIOMetadata getStreamMetadata() {
        return null;
    }

    @Override
    public int getWidth(int pImageIndex) {
        return this.getICOEntry(pImageIndex).getWidth();
    }

    @Override
    public BufferedImage read(int pImageIndex, ImageReadParam pParam) {
        return this.getICOEntry(pImageIndex).getBitmap().createImageRGB();
    }

    @Override
    public void setInput(Object pInput, boolean pSeekForwardOnly, boolean pIgnoreMetadata) {
        if (!(pInput instanceof ImageInputStream)) {
            throw new IllegalArgumentException("Only ImageInputStream supported as input source");
        }
        this.stream = (ImageInputStream)pInput;
    }

    private ICOFile getICOFile() {
        if (this.icoFile == null) {
            try {
                this.icoFile = new ICOFile(new ImageInputStreamAdapter(this.stream));
            }
            catch (IOException e) {
                System.err.println("Can't create ICOFile: " + e.getMessage());
            }
        }
        return this.icoFile;
    }

    private BitmapDescriptor getICOEntry(int pImageIndex) {
        return this.getICOFile().getDescriptors().get(pImageIndex);
    }
}

