/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.file.iconio;

import java.io.IOException;
import java.nio.ByteOrder;
import java.util.Locale;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import org.lateralgm.file.iconio.ICOReader;

public class ICOImageReaderSPI
extends ImageReaderSpi {
    public ICOImageReaderSPI() {
        super("Christian Treber, www.ctreber.com, ct@ctreber.com", "1.0 December 2003", new String[]{"ico", "ICO"}, new String[]{"ico"}, new String[]{"image/x-ico"}, "org.lateralgm.file.iconio.ICOReader", new Class[]{ImageInputStream.class}, null, false, null, null, null, null, false, null, null, null, null);
    }

    @Override
    public boolean canDecodeInput(Object pSource) {
        if (pSource instanceof ImageInputStream) {
            ImageInputStream in = (ImageInputStream)pSource;
            ByteOrder order = in.getByteOrder();
            in.setByteOrder(ByteOrder.LITTLE_ENDIAN);
            try {
                in.mark();
                short res = in.readShort();
                short type = in.readShort();
                in.reset();
                if (res == 0 && type == 1) {
                    return true;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            in.setByteOrder(order);
        }
        return false;
    }

    @Override
    public ImageReader createReaderInstance(Object pExtension) {
        return new ICOReader(this);
    }

    @Override
    public String getDescription(Locale pLocale) {
        return "Microsoft Icon Format (ICO)";
    }
}

