/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.file.iconio;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import org.lateralgm.file.StreamDecoder;
import org.lateralgm.file.StreamEncoder;
import org.lateralgm.file.iconio.AbstractBitmap;
import org.lateralgm.file.iconio.BitmapDescriptor;
import org.lateralgm.file.iconio.BitmapHeader;
import org.lateralgm.file.iconio.BitmapIndexed1BPP;
import org.lateralgm.file.iconio.BitmapIndexed4BPP;
import org.lateralgm.file.iconio.BitmapIndexed8BPP;
import org.lateralgm.file.iconio.BitmapPNG;
import org.lateralgm.file.iconio.BitmapRGB24BPP;
import org.lateralgm.file.iconio.BitmapRGB32BPP;
import org.lateralgm.file.iconio.TypeCompression;

public class ICOFile
implements Comparable<ICOFile> {
    private String fileName;
    private int reserved;
    private int type;
    private int imageCount;
    private StreamDecoder decoder;
    private final List<BitmapDescriptor> descriptors = new ArrayList<BitmapDescriptor>();
    private static final int HEADER_SIZE = 6;
    private static final int DESCRIPTOR_SIZE = 16;

    public ICOFile(String pFileName) throws IOException {
        this(pFileName, new StreamDecoder(pFileName));
        this.decoder.close();
    }

    public ICOFile(InputStream pInput) throws IOException {
        this("[from stream]", new StreamDecoder(pInput));
    }

    public ICOFile(URL pURL) throws IOException {
        this(pURL.toString(), new StreamDecoder(pURL.openStream()));
        this.decoder.close();
    }

    public ICOFile(byte[] pBuffer) throws IOException {
        this("[from buffer]", new StreamDecoder(new ByteArrayInputStream(pBuffer)));
        this.decoder.close();
    }

    public ICOFile(String pFileName, StreamDecoder pFileDecoder) throws IOException {
        this.fileName = pFileName;
        this.decoder = pFileDecoder;
        this.read(pFileDecoder);
    }

    @Override
    public int compareTo(ICOFile pOther) {
        return pOther.getFileName().compareTo(this.getFileName());
    }

    public String toString() {
        StringBuffer lSB = new StringBuffer(100);
        lSB.append(String.valueOf(this.fileName) + ", type: " + this.type + ", image count: " + this.getImageCount());
        return lSB.toString();
    }

    private void read(StreamDecoder pDec) throws IOException {
        this.readHeader(pDec);
        BitmapDescriptor[] lDescriptors = this.readDescriptors(pDec);
        this.fillDescriptors(pDec, lDescriptors);
    }

    private void readHeader(StreamDecoder pDec) throws IOException {
        this.reserved = pDec.read2();
        this.type = pDec.read2();
        this.imageCount = pDec.read2();
        if (this.type != 1) {
            throw new IllegalArgumentException("Unknown ICO type " + this.type);
        }
        if (this.imageCount == 0) {
            this.imageCount = 1;
        }
    }

    private void fillDescriptors(StreamDecoder pDec, BitmapDescriptor[] pDescriptors) throws IOException {
        BitmapDescriptor[] bitmapDescriptorArray = pDescriptors;
        int n = pDescriptors.length;
        int n2 = 0;
        while (n2 < n) {
            BitmapDescriptor lDescriptor = bitmapDescriptorArray[n2];
            this.fillDescriptor(pDec, lDescriptor);
            this.descriptors.add(lDescriptor);
            ++n2;
        }
    }

    private void fillDescriptor(StreamDecoder pDec, BitmapDescriptor pDescriptor) throws IOException {
        if (pDec.getPos() != pDescriptor.getOffset()) {
            pDec.seek(pDescriptor.getOffset());
        }
        pDescriptor.setHeader(new BitmapHeader(pDec));
        pDescriptor.setBitmap(ICOFile.readBitmap(pDec, pDescriptor));
        this.doSomeChecks(pDescriptor);
    }

    private BitmapDescriptor[] readDescriptors(StreamDecoder pDec) throws IOException {
        BitmapDescriptor[] lEntries = new BitmapDescriptor[this.imageCount];
        int lImageNo = 0;
        while (lImageNo < this.imageCount) {
            lEntries[lImageNo] = ICOFile.readDescriptor(pDec);
            ++lImageNo;
        }
        return lEntries;
    }

    private static BitmapDescriptor readDescriptor(StreamDecoder pDec) throws IOException {
        return new BitmapDescriptor(pDec);
    }

    private void doSomeChecks(BitmapDescriptor pDescriptor) {
        if (pDescriptor.getHeader().getWidth() * 2L != pDescriptor.getHeader().getHeight()) {
            System.out.println(this + ": In header, height is not twice the width");
        }
    }

    private static AbstractBitmap readBitmap(StreamDecoder pDec, BitmapDescriptor pDescriptor) throws IOException {
        int lBitsPerPixel = pDescriptor.getHeader().getBPP();
        AbstractBitmap lBitmap = null;
        if (pDescriptor.getHeader().getCompression() == TypeCompression.BI_PNG) {
            lBitmap = new BitmapPNG(pDescriptor);
        } else {
            switch (lBitsPerPixel) {
                case 1: {
                    lBitmap = new BitmapIndexed1BPP(pDescriptor);
                    break;
                }
                case 4: {
                    lBitmap = new BitmapIndexed4BPP(pDescriptor);
                    break;
                }
                case 8: {
                    lBitmap = new BitmapIndexed8BPP(pDescriptor);
                    break;
                }
                case 16: {
                    return null;
                }
                case 24: {
                    lBitmap = new BitmapRGB24BPP(pDescriptor);
                    break;
                }
                case 32: {
                    lBitmap = new BitmapRGB32BPP(pDescriptor);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported bit count " + lBitsPerPixel);
                }
            }
        }
        ((AbstractBitmap)lBitmap).read(pDec);
        return lBitmap;
    }

    public byte[] getDigest(String method) throws IOException, NoSuchAlgorithmException {
        byte[][] bitmaps = this.getBitmaps();
        MessageDigest md5 = MessageDigest.getInstance(method);
        byte[][] byArray = bitmaps;
        int n = bitmaps.length;
        int n2 = 0;
        while (n2 < n) {
            byte[] bitmap = byArray[n2];
            md5.update(bitmap);
            ++n2;
        }
        return md5.digest();
    }

    public List<BufferedImage> getImages() {
        ArrayList<BufferedImage> lImages = new ArrayList<BufferedImage>();
        for (BitmapDescriptor lDesc : this.getDescriptors()) {
            lImages.add(lDesc.getBitmap().createImageRGB());
        }
        return lImages;
    }

    public List<BitmapDescriptor> getDescriptors() {
        return this.descriptors;
    }

    public BitmapDescriptor getDescriptor(int pDescriptorNo) {
        return this.descriptors.get(pDescriptorNo);
    }

    public int getType() {
        return this.type;
    }

    public int getImageCount() {
        return this.descriptors == null ? this.imageCount : this.descriptors.size();
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getReserved() {
        return this.reserved;
    }

    public void write(OutputStream out) throws IOException {
        if (out instanceof StreamEncoder) {
            this.write((StreamEncoder)out);
        } else {
            StreamEncoder se = new StreamEncoder(out);
            this.write(se);
            se.flush();
        }
    }

    public void write(StreamEncoder out) throws IOException {
        this.writeHeader(out);
        byte[][] imageData = this.getBitmaps();
        int offset = 6 + 16 * this.descriptors.size();
        int i = 0;
        while (i < this.descriptors.size()) {
            BitmapDescriptor bmd = this.descriptors.get(i);
            bmd.setOffset(offset);
            bmd.setSize(imageData[i].length);
            offset += imageData[i].length;
            ++i;
        }
        this.writeDescriptors(out);
        byte[][] byArray = imageData;
        int n = imageData.length;
        int n2 = 0;
        while (n2 < n) {
            byte[] dat = byArray[n2];
            out.write(dat);
            ++n2;
        }
    }

    private void writeHeader(StreamEncoder out) throws IOException {
        out.write2(this.reserved);
        out.write2(this.type);
        out.write2(this.getImageCount());
    }

    private void writeDescriptors(StreamEncoder out) throws IOException {
        for (BitmapDescriptor bmd : this.descriptors) {
            bmd.write(out);
        }
    }

    private byte[][] getBitmaps() throws IOException {
        byte[][] res = new byte[this.descriptors.size()][];
        int i = 0;
        for (BitmapDescriptor bmd : this.descriptors) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            StreamEncoder o = new StreamEncoder(baos);
            if (bmd.getBitmap() instanceof BitmapPNG) {
                BitmapPNG png = (BitmapPNG)bmd.getBitmap();
                png.write(o);
            } else {
                bmd.getHeader().write(o);
                bmd.getBitmap().write(o);
            }
            o.flush();
            res[i] = baos.toByteArray();
            o.close();
            ++i;
        }
        return res;
    }

    public Image getDisplayImage() {
        BitmapDescriptor desc = this.descriptors.get(this.descriptors.size() - 1);
        if (desc != null) {
            return desc.getImageRGB();
        }
        return null;
    }
}

