/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.file.iconio;

import java.awt.image.BufferedImage;
import java.io.IOException;
import org.lateralgm.file.StreamDecoder;
import org.lateralgm.file.StreamEncoder;
import org.lateralgm.file.iconio.AbstractBitmapRGB;
import org.lateralgm.file.iconio.BitmapDescriptor;
import org.lateralgm.file.iconio.BitmapMask;

public class BitmapRGB32BPP
extends AbstractBitmapRGB {
    protected long readStreamLimit;

    public BitmapRGB32BPP(BitmapDescriptor pDescriptor) {
        super(pDescriptor);
        this.readStreamLimit = pDescriptor.getOffset() + pDescriptor.getSize();
    }

    @Override
    void readBitmap(StreamDecoder pDec) throws IOException {
        int lRowNo = 0;
        while (lRowNo < this.getHeight()) {
            byte[] lRow = new byte[this.getWidth() * 4];
            pDec.read(lRow);
            int lRowByte = 0;
            int lOutputPos = (this.getHeight() - lRowNo - 1) * this.getWidth();
            int lColNo = 0;
            while (lColNo < this.getWidth()) {
                this.samples[lOutputPos++] = lRow[lRowByte++] & 0xFF | ((lRow[lRowByte++] & 0xFF) << 8) + ((lRow[lRowByte++] & 0xFF) << 16) | (lRow[lRowByte++] & 0xFF) << 24;
                ++lColNo;
            }
            ++lRowNo;
        }
    }

    @Override
    protected void readMask(StreamDecoder pDec) throws IOException {
        if (this.readStreamLimit <= 0L || pDec.getPos() < this.readStreamLimit) {
            super.readMask(pDec);
        } else {
            this.transparencyMask = new BitmapMask(this.descriptor);
            this.transparencyMask.fakeRead();
        }
    }

    @Override
    public BufferedImage createImageRGB() {
        BufferedImage lImage = new BufferedImage(this.getWidth(), this.getHeight(), 2);
        lImage.setRGB(0, 0, this.getWidth(), this.getHeight(), this.samples, 0, this.getWidth());
        return lImage;
    }

    @Override
    void writeBitmap(StreamEncoder out) throws IOException {
        int width = this.getWidth();
        int padding = BitmapRGB32BPP.getPaddingPerScanLine(width, 32);
        int row = this.getHeight() - 1;
        while (row >= 0) {
            int offset = row * width;
            int x = 0;
            while (x < width) {
                int sample = this.samples[offset + x];
                out.write(sample & 0xFF);
                out.write(sample >> 8 & 0xFF);
                out.write(sample >> 16 & 0xFF);
                out.write(sample >> 24 & 0xFF);
                ++x;
            }
            int i = padding;
            while (i-- > 0) {
                out.write(0);
            }
            --row;
        }
    }
}

