/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.file.iconio;

import java.awt.image.BufferedImage;
import java.io.IOException;
import org.lateralgm.file.StreamDecoder;
import org.lateralgm.file.StreamEncoder;
import org.lateralgm.file.iconio.AbstractBitmapRGB;
import org.lateralgm.file.iconio.BitmapDescriptor;

public class BitmapRGB24BPP
extends AbstractBitmapRGB {
    public BitmapRGB24BPP(BitmapDescriptor pDescriptor) {
        super(pDescriptor);
    }

    @Override
    void readBitmap(StreamDecoder pDec) throws IOException {
        int lRowNo = 0;
        while (lRowNo < this.getHeight()) {
            byte[] lRow = new byte[this.getWidth() * 3];
            pDec.read(lRow);
            int lRowByte = 0;
            int lOutputPos = (this.getHeight() - lRowNo - 1) * this.getWidth();
            int lColNo = 0;
            while (lColNo < this.getWidth()) {
                this.samples[lOutputPos++] = (lRow[lRowByte++] & 0xFF) + ((lRow[lRowByte++] & 0xFF) << 8) + ((lRow[lRowByte++] & 0xFF) << 16);
                ++lColNo;
            }
            ++lRowNo;
        }
    }

    @Override
    public BufferedImage createImageRGB() {
        BufferedImage lImage = new BufferedImage(this.getWidth(), this.getHeight(), 2);
        lImage.setRGB(0, 0, this.getWidth(), this.getHeight(), this.samples, 0, this.getWidth());
        int width = this.getWidth();
        int height = this.getHeight();
        int x = 0;
        while (x < width) {
            int y = 0;
            while (y < height) {
                int p = lImage.getRGB(x, y);
                int mask = this.transparencyMask.mask.pixels[y * width + x];
                p = (mask == 0 ? -16777216 : 0) | p & 0xFFFFFF;
                lImage.setRGB(x, y, p);
                ++y;
            }
            ++x;
        }
        return lImage;
    }

    @Override
    void writeBitmap(StreamEncoder out) throws IOException {
        int width = this.getWidth();
        int padding = BitmapRGB24BPP.getPaddingPerScanLine(width, 24);
        int row = this.getHeight() - 1;
        while (row >= 0) {
            int offset = row * width;
            int x = 0;
            while (x < width) {
                int sample = this.samples[offset + x];
                out.write(sample & 0xFF);
                out.write(sample >> 8 & 0xFF);
                out.write(sample >> 16 & 0xFF);
                ++x;
            }
            int i = padding;
            while (i-- > 0) {
                out.write(0);
            }
            --row;
        }
    }
}

