/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.file.iconio;

import java.io.IOException;
import org.lateralgm.file.StreamDecoder;
import org.lateralgm.file.StreamEncoder;
import org.lateralgm.file.iconio.AbstractBitmapIndexed;
import org.lateralgm.file.iconio.BitmapDescriptor;

public class BitmapIndexed8BPP
extends AbstractBitmapIndexed {
    public BitmapIndexed8BPP(BitmapDescriptor pDescriptor) {
        super(pDescriptor);
    }

    @Override
    void readBitmap(StreamDecoder pDec) throws IOException {
        int lWt = BitmapIndexed8BPP.getBytesPerScanLine(this.getWidth(), 8);
        int lRowNo = 0;
        while (lRowNo < this.getHeight()) {
            byte[] lRow = new byte[lWt];
            pDec.read(lRow);
            int lRowByte = 0;
            int lOutputPos = (this.getHeight() - lRowNo - 1) * this.getWidth();
            int lColNo = 0;
            while (lColNo < this.getWidth()) {
                this.pixels[lOutputPos++] = lRow[lRowByte++] & 0xFF;
                ++lColNo;
            }
            ++lRowNo;
        }
    }

    @Override
    void writeBitmap(StreamEncoder out) throws IOException {
        int width = this.getWidth();
        int padding = BitmapIndexed8BPP.getPaddingPerScanLine(width, 8);
        int row = this.getHeight() - 1;
        while (row >= 0) {
            int offset = row * width;
            int x = 0;
            while (x < width) {
                out.write(this.pixels[offset + x]);
                ++x;
            }
            int i = padding;
            while (i-- > 0) {
                out.write(0);
            }
            --row;
        }
    }
}

