/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.file.iconio;

import java.io.IOException;
import org.lateralgm.file.StreamDecoder;
import org.lateralgm.file.StreamEncoder;
import org.lateralgm.file.iconio.AbstractBitmapIndexed;
import org.lateralgm.file.iconio.BitmapDescriptor;

public class BitmapIndexed4BPP
extends AbstractBitmapIndexed {
    public BitmapIndexed4BPP(BitmapDescriptor pDescriptor) {
        super(pDescriptor);
    }

    @Override
    void readBitmap(StreamDecoder pDec) throws IOException {
        int lWt = BitmapIndexed4BPP.getBytesPerScanLine(this.getWidth(), 4);
        int lRowNo = 0;
        while (lRowNo < this.getHeight()) {
            byte[] lRow = new byte[lWt];
            pDec.read(lRow);
            int lRowByte = 0;
            boolean lUpperNibbleP = true;
            int lOutputPos = (this.getHeight() - lRowNo - 1) * this.getWidth();
            int lColNo = 0;
            while (lColNo < this.getWidth()) {
                int lValue;
                if (lUpperNibbleP) {
                    lValue = (lRow[lRowByte] & 0xF0) >> 4;
                } else {
                    lValue = lRow[lRowByte] & 0xF;
                    ++lRowByte;
                }
                this.pixels[lOutputPos++] = lValue & 0xFF;
                lUpperNibbleP = !lUpperNibbleP;
                ++lColNo;
            }
            ++lRowNo;
        }
    }

    private void writeNibs(StreamEncoder out, int offset, int count) throws IOException {
        if (count == 2) {
            out.write(this.pixels[offset] << 4 | this.pixels[offset + 1]);
        } else if (count == 1) {
            out.write(this.pixels[offset] << 4);
        } else {
            throw new IllegalArgumentException("Can't write anything other than 1 or 2 nibbles");
        }
    }

    @Override
    void writeBitmap(StreamEncoder out) throws IOException {
        int width = this.getWidth();
        int padding = BitmapIndexed4BPP.getPaddingPerScanLine(width, 4);
        int row = this.getHeight() - 1;
        while (row >= 0) {
            int offset = row * width;
            int x = 0;
            while (x < width) {
                this.writeNibs(out, offset + x, Math.min(width - x, 2));
                x += 2;
            }
            int i = padding;
            while (i-- > 0) {
                out.write(0);
            }
            --row;
        }
    }
}

