/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.file.iconio;

import java.io.IOException;
import org.lateralgm.file.StreamDecoder;
import org.lateralgm.file.StreamEncoder;
import org.lateralgm.file.iconio.AbstractBitmapIndexed;
import org.lateralgm.file.iconio.BitmapDescriptor;

public class BitmapIndexed1BPP
extends AbstractBitmapIndexed {
    public BitmapIndexed1BPP(BitmapDescriptor pDescriptor) {
        super(pDescriptor);
    }

    @Override
    void readBitmap(StreamDecoder pDec) throws IOException {
        int lBytesPerScanLine = BitmapIndexed1BPP.getBytesPerScanLine(this.getWidth(), 1);
        int lRowNo = 0;
        while (lRowNo < this.getHeight()) {
            byte[] lBitmapBytes = new byte[lBytesPerScanLine];
            pDec.read(lBitmapBytes);
            int lBitmapByteNo = 0;
            int lTestBitMask = 128;
            int lPixelNo = (this.getHeight() - 1 - lRowNo) * this.getWidth();
            int lColNo = 0;
            while (lColNo < this.getWidth()) {
                this.pixels[lPixelNo++] = (lBitmapBytes[lBitmapByteNo] & lTestBitMask) / lTestBitMask & 0xFF;
                if (lTestBitMask == 1) {
                    lTestBitMask = 128;
                    ++lBitmapByteNo;
                } else {
                    lTestBitMask >>= 1;
                }
                ++lColNo;
            }
            ++lRowNo;
        }
    }

    void fakeReadBitmap() {
        int lPixelNo = 0;
        int lRowNo = 0;
        while (lRowNo < this.getHeight()) {
            int lColNo = 0;
            while (lColNo < this.getWidth()) {
                this.pixels[lPixelNo++] = 1;
                ++lColNo;
            }
            ++lRowNo;
        }
    }

    private void writeBits(StreamEncoder out, int offset, int count) throws IOException {
        int b = 0;
        int i = count - 1;
        while (i >= 0) {
            b |= this.pixels[offset + i] << 7 - i;
            --i;
        }
        out.write(b);
    }

    @Override
    void writeBitmap(StreamEncoder out) throws IOException {
        int width = this.getWidth();
        int padding = BitmapIndexed1BPP.getPaddingPerScanLine(width, 1);
        int row = this.getHeight() - 1;
        while (row >= 0) {
            int offset = row * width;
            int x = 0;
            while (x < width) {
                this.writeBits(out, offset + x, Math.min(width - x, 8));
                x += 8;
            }
            int i = padding;
            while (i-- > 0) {
                out.write(0);
            }
            --row;
        }
    }
}

