/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.file.iconio;

import java.io.IOException;
import org.lateralgm.file.StreamDecoder;
import org.lateralgm.file.StreamEncoder;
import org.lateralgm.file.iconio.TypeCompression;

public class BitmapHeader {
    private long headerSize;
    private long width;
    private long height;
    private int planes;
    private int bpp;
    private TypeCompression compression;
    private long imageSize;
    private long xPixelsPerM;
    private long yPixelsPerM;
    private long colorsUsed;
    private long colorsImportant;

    public BitmapHeader(StreamDecoder pDec) throws IOException {
        pDec.mark(4);
        this.headerSize = pDec.read4();
        if (this.headerSize == 1196314761L) {
            this.headerSize = -1L;
            this.compression = TypeCompression.BI_PNG;
            pDec.reset();
        } else {
            this.width = pDec.read4();
            this.height = pDec.read4();
            this.planes = pDec.read2();
            this.bpp = pDec.read2();
            this.compression = TypeCompression.getType(pDec.read4());
            this.imageSize = pDec.read4();
            this.xPixelsPerM = pDec.read4();
            this.yPixelsPerM = pDec.read4();
            this.colorsUsed = pDec.read4();
            this.colorsImportant = pDec.read4();
        }
    }

    public String toString() {
        return "size: " + this.headerSize + ", width: " + this.width + ", height: " + this.height + ", planes: " + this.planes + ", BPP: " + this.bpp + ", imageSize: " + this.imageSize + ", XPixelsPerM: " + this.xPixelsPerM + ", YPixelsPerM: " + this.yPixelsPerM + ", colorsUsed: " + this.colorsUsed + ", colorsImportant: " + this.colorsImportant + (this.colorsImportant == 0L ? " (all)" : "");
    }

    public int getBPP() {
        return this.bpp;
    }

    public long getColorsImportant() {
        return this.colorsImportant;
    }

    public long getColorsUsed() {
        return this.colorsUsed;
    }

    public TypeCompression getCompression() {
        return this.compression;
    }

    public long getHeight() {
        return this.height;
    }

    public long getBitmapSize() {
        return this.imageSize;
    }

    public int getPlanes() {
        return this.planes;
    }

    public long getHeaderSize() {
        return this.headerSize;
    }

    public long getWidth() {
        return this.width;
    }

    public long getXPixelsPerM() {
        return this.xPixelsPerM;
    }

    public long getYPixelsPerM() {
        return this.yPixelsPerM;
    }

    public int getColorCount() {
        return 1 << this.bpp;
    }

    void write(StreamEncoder out) throws IOException {
        out.write4((int)this.headerSize);
        out.write4((int)this.width);
        out.write4((int)this.height);
        out.write2(this.planes);
        out.write2(this.bpp);
        out.write4(TypeCompression.BI_RGB.getValue());
        out.write4((int)this.imageSize);
        out.write4((int)this.xPixelsPerM);
        out.write4((int)this.yPixelsPerM);
        out.write4((int)this.colorsUsed);
        out.write4((int)this.colorsImportant);
    }
}

