/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.file.iconio;

import java.awt.Image;
import java.io.IOException;
import org.lateralgm.file.StreamDecoder;
import org.lateralgm.file.StreamEncoder;
import org.lateralgm.file.iconio.AbstractBitmap;
import org.lateralgm.file.iconio.AbstractBitmapIndexed;
import org.lateralgm.file.iconio.BitmapHeader;

public class BitmapDescriptor {
    private int colorCount;
    private int reserved;
    private int planes;
    private int bpp;
    private long size;
    private long offset;
    private BitmapHeader header;
    private AbstractBitmap bitmap;

    public BitmapDescriptor(StreamDecoder pDec) throws IOException {
        pDec.read();
        pDec.read();
        this.colorCount = pDec.read();
        this.reserved = pDec.read();
        this.planes = pDec.read2();
        this.bpp = pDec.read2();
        this.size = pDec.read4();
        this.offset = pDec.read4();
    }

    public String toString() {
        return "width: " + this.getWidth() + ", height: " + this.getHeight() + ", colorCount: " + this.colorCount + " (" + this.getColorCount() + ")" + ", planes: " + this.planes + ", BPP: " + this.bpp + ", size: " + this.size + ", offset: " + this.offset;
    }

    public Image getImageIndexed() {
        if (!(this.bitmap instanceof AbstractBitmapIndexed)) {
            return null;
        }
        return ((AbstractBitmapIndexed)this.bitmap).createImageIndexed();
    }

    public int getBPP() {
        if (this.bpp != 0) {
            return this.bpp;
        }
        return this.header.getBPP();
    }

    public int getBPPRaw() {
        return this.bpp;
    }

    public Image getImageRGB() {
        return this.bitmap.createImageRGB();
    }

    public int getColorCountRaw() {
        return this.colorCount;
    }

    public int getColorCount() {
        return this.colorCount == 0 ? 256 : this.colorCount;
    }

    public int getHeight() {
        return this.header == null || this.header.getHeight() > Integer.MAX_VALUE ? 0 : (int)this.header.getHeight();
    }

    public long getOffset() {
        return this.offset;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public int getPlanes() {
        return this.planes;
    }

    public int getReserved() {
        return this.reserved;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public int getWidth() {
        return this.header == null || this.header.getWidth() > Integer.MAX_VALUE ? 0 : (int)this.header.getWidth();
    }

    public BitmapHeader getHeader() {
        return this.header;
    }

    void setHeader(BitmapHeader pHeader) {
        this.header = pHeader;
    }

    public AbstractBitmap getBitmap() {
        return this.bitmap;
    }

    void setBitmap(AbstractBitmap pBitmap) {
        this.bitmap = pBitmap;
    }

    void write(StreamEncoder out) throws IOException {
        out.write(this.getWidth());
        out.write(this.getHeight());
        out.write(this.colorCount);
        out.write(this.reserved);
        out.write2(this.planes);
        out.write2(this.bpp);
        out.write4((int)this.size);
        out.write4((int)this.offset);
    }
}

