/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.file.iconio;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.io.IOException;
import org.lateralgm.file.StreamDecoder;
import org.lateralgm.file.StreamEncoder;
import org.lateralgm.file.iconio.AbstractBitmap;
import org.lateralgm.file.iconio.BitmapDescriptor;

public abstract class AbstractBitmapIndexed
extends AbstractBitmap {
    private static final int OPAQUE = 255;
    private Color[] colorPalette;
    protected int[] pixels = new int[this.getWidth() * this.getHeight()];

    public AbstractBitmapIndexed(BitmapDescriptor pDescriptor) {
        super(pDescriptor);
    }

    @Override
    void read(StreamDecoder in) throws IOException {
        this.readColorPalette(in);
        this.readBitmap(in);
        this.readMask(in);
    }

    abstract void readBitmap(StreamDecoder var1) throws IOException;

    private void readColorPalette(StreamDecoder in) throws IOException {
        int lColorCount = this.getVerifiedColorCount();
        this.colorPalette = new Color[lColorCount];
        int lColorNo = 0;
        while (lColorNo < lColorCount) {
            this.setColor(lColorNo, AbstractBitmapIndexed.readColor(in));
            ++lColorNo;
        }
    }

    private static Color readColor(StreamDecoder in) throws IOException {
        int lBlue = in.read();
        int lGreen = in.read();
        int lRed = in.read();
        in.read();
        return new Color(lRed, lGreen, lBlue);
    }

    private int getVerifiedColorCount() {
        int lColorCount2;
        int lColorCount = this.getColorCount();
        if (lColorCount < (lColorCount2 = 1 << this.descriptor.getBPP())) {
            lColorCount = lColorCount2;
        }
        return lColorCount;
    }

    public BufferedImage createImageIndexed() {
        IndexColorModel lModel = this.createColorModel();
        BufferedImage lImage = new BufferedImage(this.getWidth(), this.getHeight(), 13, lModel);
        lImage.getRaster().setSamples(0, 0, this.getWidth(), this.getHeight(), 0, this.pixels);
        return lImage;
    }

    private IndexColorModel createColorModel() {
        int lColorCount = this.getVerifiedColorCount();
        byte[] lRed = new byte[lColorCount];
        byte[] lGreen = new byte[lColorCount];
        byte[] lBlue = new byte[lColorCount];
        byte[] lAlpha = new byte[lColorCount];
        int lColorNo = 0;
        while (lColorNo < lColorCount) {
            Color lColor = this.getColor(lColorNo);
            lRed[lColorNo] = (byte)lColor.getRed();
            lGreen[lColorNo] = (byte)lColor.getGreen();
            lBlue[lColorNo] = (byte)lColor.getBlue();
            lAlpha[lColorNo] = -1;
            ++lColorNo;
        }
        IndexColorModel lModel = new IndexColorModel(8, lColorCount, lRed, lGreen, lBlue, lAlpha);
        return lModel;
    }

    @Override
    public BufferedImage createImageRGB() {
        BufferedImage lImage = new BufferedImage(this.getWidth(), this.getHeight(), 2);
        int lYPos = 0;
        while (lYPos < this.getHeight()) {
            int lXPos = 0;
            while (lXPos < this.getWidth()) {
                int lRGB = this.getColor(lXPos, lYPos).getRGB();
                lRGB = this.transparencyMask.isOpaque(lXPos, lYPos) ? (lRGB |= 0xFF000000) : (lRGB &= 0xFFFFFF);
                lImage.setRGB(lXPos, lYPos, lRGB);
                ++lXPos;
            }
            ++lYPos;
        }
        return lImage;
    }

    public Color getColor(int pXPos, int pYPos) {
        return this.getColor(this.getPaletteIndex(pXPos, pYPos));
    }

    public int getPaletteIndex(int pXPos, int pYPos) {
        return this.pixels[pYPos * this.getWidth() + pXPos];
    }

    public Color getColor(int pIndex) {
        if (pIndex >= this.getVerifiedColorCount()) {
            throw new IllegalArgumentException("Color index out of range: is " + pIndex + ", max. " + this.getVerifiedColorCount());
        }
        return this.colorPalette[pIndex];
    }

    private void setColor(int pIndex, Color pColor) {
        this.colorPalette[pIndex] = pColor;
    }

    @Override
    void write(StreamEncoder out) throws IOException {
        this.writeColorPalette(out);
        this.writeBitmap(out);
        this.writeMask(out);
    }

    private void writeColorPalette(StreamEncoder out) throws IOException {
        Color[] colorArray = this.colorPalette;
        int n = this.colorPalette.length;
        int n2 = 0;
        while (n2 < n) {
            Color c = colorArray[n2];
            out.write(c.getBlue());
            out.write(c.getGreen());
            out.write(c.getRed());
            out.write(0);
            ++n2;
        }
    }

    abstract void writeBitmap(StreamEncoder var1) throws IOException;
}

