/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.file.iconio;

import java.awt.image.BufferedImage;
import java.io.IOException;
import org.lateralgm.file.StreamDecoder;
import org.lateralgm.file.StreamEncoder;
import org.lateralgm.file.iconio.BitmapDescriptor;
import org.lateralgm.file.iconio.BitmapMask;

public abstract class AbstractBitmap {
    protected BitmapDescriptor descriptor;
    protected BitmapMask transparencyMask;

    public AbstractBitmap(BitmapDescriptor pDescriptor) {
        this.descriptor = pDescriptor;
    }

    public abstract BufferedImage createImageRGB();

    abstract void read(StreamDecoder var1) throws IOException;

    protected int getHeight() {
        if (this.descriptor.getWidth() == this.descriptor.getHeight() / 2) {
            return this.descriptor.getWidth();
        }
        return this.descriptor.getHeight();
    }

    protected int getWidth() {
        return this.descriptor.getWidth();
    }

    protected int getColorCount() {
        return this.descriptor.getHeader().getColorCount();
    }

    public BitmapDescriptor getDescriptor() {
        return this.descriptor;
    }

    void setDescriptor(BitmapDescriptor pDescriptor) {
        this.descriptor = pDescriptor;
    }

    public String toString() {
        return this.getClass().toString();
    }

    protected static int getBytesPerScanLine(int pWidth, int pBPP) {
        double lBytesPerPixels = (double)pBPP / 8.0;
        int lBytesPerScanLine = (int)Math.ceil((double)pWidth * lBytesPerPixels);
        if ((lBytesPerScanLine & 3) != 0) {
            lBytesPerScanLine = (lBytesPerScanLine & 0xFFFFFFFC) + 4;
        }
        return lBytesPerScanLine;
    }

    protected static int getPaddingPerScanLine(int pWidth, int pBPP) {
        int bytesPerScanLine;
        double bytesPerPixels = (double)pBPP / 8.0;
        int totalBytesPerScanLine = bytesPerScanLine = (int)Math.ceil((double)pWidth * bytesPerPixels);
        if ((bytesPerScanLine & 3) != 0) {
            totalBytesPerScanLine = (bytesPerScanLine & 0xFFFFFFFC) + 4;
        }
        return totalBytesPerScanLine - bytesPerScanLine;
    }

    protected void readMask(StreamDecoder pDec) throws IOException {
        this.transparencyMask = new BitmapMask(this.descriptor);
        this.transparencyMask.read(pDec);
    }

    abstract void write(StreamEncoder var1) throws IOException;

    protected void writeMask(StreamEncoder out) throws IOException {
        this.transparencyMask.mask.writeBitmap(out);
    }
}

