/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.file;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class StreamEncoder
extends OutputStream {
    protected OutputStream out;
    protected int pos = 0;

    protected StreamEncoder() {
    }

    public StreamEncoder(OutputStream o) {
        this.out = o instanceof BufferedOutputStream ? o : new BufferedOutputStream(o);
    }

    public StreamEncoder(File f) throws FileNotFoundException {
        this.out = new BufferedOutputStream(new FileOutputStream(f));
    }

    public StreamEncoder(String filePath) throws FileNotFoundException {
        this.out = new BufferedOutputStream(new FileOutputStream(filePath));
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.out.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        this.pos += len;
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
        ++this.pos;
    }

    public void write2(int val) throws IOException {
        short i = (short)val;
        this.write(i & 0xFF);
        this.write(i >>> 8 & 0xFF);
    }

    public void write3(int val) throws IOException {
        this.write(val & 0xFF);
        this.write(val >>> 8 & 0xFF);
        this.write(val >>> 16 & 0xFF);
    }

    public void write4(int val) throws IOException {
        this.write(val & 0xFF);
        this.write(val >>> 8 & 0xFF);
        this.write(val >>> 16 & 0xFF);
        this.write(val >>> 24 & 0xFF);
    }

    public void writeD(double val) throws IOException {
        long num = Double.doubleToLongBits(val);
        byte[] b = new byte[8];
        b[0] = (byte)(num & 0xFFL);
        int i = 1;
        while (i < 8) {
            b[i] = (byte)(num >>> 8 * i & 0xFFL);
            ++i;
        }
        this.write(b);
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    public void fill(int count) throws IOException {
        int i = 0;
        while (i < count) {
            this.write4(0);
            ++i;
        }
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }
}

