/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.file;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.lateralgm.messages.Messages;

public class StreamDecoder
extends InputStream {
    protected InputStream in;
    protected int pos = 0;
    protected int markPos = 0;

    protected StreamDecoder() {
    }

    public StreamDecoder(InputStream in) {
        this.in = in instanceof BufferedInputStream ? in : new BufferedInputStream(in);
    }

    public StreamDecoder(String path) throws FileNotFoundException {
        this.in = new BufferedInputStream(new FileInputStream(path));
    }

    public StreamDecoder(File f) throws FileNotFoundException {
        this.in = new BufferedInputStream(new FileInputStream(f));
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int read = this.in.read(b, off, len);
        if (read != len) {
            String error = Messages.format("StreamDecoder.UNEXPECTED_EOF", this.getPosString());
            throw new IOException(error);
        }
        this.pos += len;
        return read;
    }

    @Override
    public int read() throws IOException {
        int t = this.in.read();
        if (t == -1) {
            String error = Messages.format("StreamDecoder.UNEXPECTED_EOF", this.getPosString());
            throw new IOException(error);
        }
        ++this.pos;
        return t;
    }

    public int read2() throws IOException {
        int a = this.read();
        int b = this.read();
        return a | b << 8;
    }

    public int read3() throws IOException {
        int a = this.read();
        int b = this.read();
        int c = this.read();
        return a | b << 8 | c << 16;
    }

    public int read4() throws IOException {
        int a = this.read();
        int b = this.read();
        int c = this.read();
        int d = this.read();
        return a | b << 8 | c << 16 | d << 24;
    }

    public double readD() throws IOException {
        byte[] b = new byte[8];
        this.read(b);
        long r = b[0] & 0xFF;
        int i = 1;
        while (i < 8) {
            r |= ((long)b[i] & 0xFFL) << 8 * i;
            ++i;
        }
        return Double.longBitsToDouble(r);
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public long skip(long length) throws IOException {
        long total = this.in.skip(length);
        while (total < length) {
            total += this.in.skip(length - total);
        }
        this.pos += (int)length;
        return total;
    }

    public InputStream getInputStream() {
        return this.in;
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.in.mark(readlimit);
        this.markPos = this.pos;
    }

    @Override
    public synchronized void reset() throws IOException {
        this.in.reset();
        this.pos = this.markPos;
    }

    public long getPos() {
        return this.pos;
    }

    public void seek(long pBytes) throws IOException {
        long toSkip = pBytes - this.getPos();
        if (toSkip >= 0L) {
            long lBytesSkipped = this.skip(toSkip);
            if (lBytesSkipped != toSkip) {
                throw new IOException(Messages.format("StreamDecoder.SEEK_SHORT", toSkip, lBytesSkipped));
            }
        } else {
            throw new IllegalArgumentException(Messages.format("StreamDecoder.SEEK_PASSED", pBytes, this.getPosString(), toSkip));
        }
    }

    protected String getPosString() {
        return Integer.toString(this.pos);
    }
}

