/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.file;

import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.TreeSet;
import org.lateralgm.file.ProjectFile;
import org.lateralgm.main.UpdateSource;
import org.lateralgm.resources.InstantiableResource;
import org.lateralgm.resources.Resource;
import org.lateralgm.resources.ResourceReference;

public class ResourceList<R extends InstantiableResource<R, ?>>
extends TreeSet<R>
implements UpdateSource.UpdateListener,
ProjectFile.ResourceHolder<R> {
    private static final long serialVersionUID = 1L;
    private static final IdComparator COMPARATOR = new IdComparator();
    private final Class<R> type;
    private final HashMap<ResourceReference<R>, WeakReference<R>> refMap;
    private final UpdateSource.UpdateTrigger updateTrigger = new UpdateSource.UpdateTrigger();
    public final UpdateSource updateSource = new UpdateSource(this, this.updateTrigger);
    public int lastId = -1;

    ResourceList(Class<R> type) {
        super(COMPARATOR);
        this.type = type;
        this.refMap = new HashMap();
    }

    private boolean doAdd(R res) {
        InstantiableResource r0;
        WeakReference<R> wr = this.refMap.get(((InstantiableResource)res).reference);
        InstantiableResource instantiableResource = r0 = wr == null ? null : (InstantiableResource)wr.get();
        if (r0 != null) {
            if (r0 == res) {
                return false;
            }
            super.remove(r0);
        }
        ((InstantiableResource)res).reference.updateSource.addListener(this);
        this.refMap.put(((InstantiableResource)res).reference, new WeakReference<R>(res));
        return super.add(res);
    }

    @Override
    public boolean add(R res) {
        if (((InstantiableResource)res).getId() == -1) {
            ((InstantiableResource)res).setId(++this.lastId);
        }
        if (this.doAdd(res)) {
            this.updateTrigger.fire();
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends R> c) {
        boolean r = false;
        for (InstantiableResource res : c) {
            res.setId(++this.lastId);
            r |= this.doAdd(res);
        }
        if (r) {
            this.updateTrigger.fire();
        }
        return r;
    }

    public R add() {
        InstantiableResource res = null;
        try {
            res = (InstantiableResource)this.type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (res != null) {
            res.setName(String.valueOf(res.getName()) + (this.lastId + 1));
            this.add((R)res);
        }
        return (R)res;
    }

    @Override
    public R getResource() {
        return this.add();
    }

    public R duplicate(Resource<?, ?> src) {
        if (!this.contains(src)) {
            return null;
        }
        R dest = this.add();
        ((InstantiableResource)src).copy(dest);
        return dest;
    }

    public R getUnsafe(int id) {
        for (InstantiableResource res : this) {
            int ri = res.getId();
            if (ri == id) {
                return (R)res;
            }
            if (ri > id) break;
        }
        return null;
    }

    public R get(String name) {
        for (InstantiableResource res : this) {
            if (!res.getName().equals(name)) continue;
            return (R)res;
        }
        return null;
    }

    private boolean doRemove(Resource<?, ?> res) {
        if (super.remove(res)) {
            res.reference.updateSource.removeListener(this);
            this.refMap.remove(res.reference);
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Object o) {
        if (this.doRemove((Resource)o)) {
            this.updateTrigger.fire();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean r = false;
        for (Object o : c) {
            r |= this.doRemove((Resource)o);
        }
        if (r) {
            this.updateTrigger.fire();
        }
        return r;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean r = false;
        for (InstantiableResource res : this) {
            if (c.contains(res)) continue;
            r |= this.doRemove(res);
        }
        if (r) {
            this.updateTrigger.fire();
        }
        return r;
    }

    @Override
    public void clear() {
        if (this.size() == 0) {
            return;
        }
        for (InstantiableResource r : this) {
            r.reference.updateSource.removeListener(this);
        }
        this.refMap.clear();
        super.clear();
        this.updateTrigger.fire();
    }

    public void defragIds() {
        int i = 0;
        for (InstantiableResource res : this) {
            res.setId(i++);
        }
        this.lastId = i - 1;
    }

    @Override
    public void updated(UpdateSource.UpdateEvent e) {
        assert (this.size() == this.refMap.size());
        this.updateTrigger.fire(e);
        Object o = e.source.owner;
        if (o instanceof ResourceReference) {
            InstantiableResource r0;
            ResourceReference ref = (ResourceReference)o;
            WeakReference<R> wr = this.refMap.get(ref);
            InstantiableResource instantiableResource = r0 = wr == null ? null : (InstantiableResource)wr.get();
            if (r0 != null) {
                Object r = ref.get();
                if (r0 != r) {
                    this.remove(r0);
                    if (r != null) {
                        this.add((R)((InstantiableResource)this.type.cast(r)));
                    }
                } else {
                    boolean changed = false;
                    try {
                        Comparator c = this.comparator();
                        InstantiableResource h = this.higher(r0);
                        if (h != null && c.compare(r0, h) >= 0) {
                            changed = true;
                        } else {
                            InstantiableResource l = this.lower(r0);
                            if (l != null && c.compare(r0, l) <= 0) {
                                changed = true;
                            }
                        }
                    }
                    catch (NoSuchMethodError nsme) {
                        changed = true;
                    }
                    if (changed) {
                        this.remove(r0);
                        this.add((R)r0);
                    }
                }
            }
        }
    }

    private static class IdComparator
    implements Comparator<InstantiableResource<?, ?>> {
        private IdComparator() {
        }

        @Override
        public int compare(InstantiableResource<?, ?> o1, InstantiableResource<?, ?> o2) {
            int i2;
            if (o1.reference == o2.reference) {
                return 0;
            }
            int i1 = o1.getId();
            if (i1 == (i2 = o2.getId())) {
                return Integer.signum(o1.hashCode() - o2.hashCode());
            }
            return i1 < i2 ? -1 : 1;
        }
    }
}

