/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.file;

import java.io.File;
import java.net.URI;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;
import org.lateralgm.file.ResourceList;
import org.lateralgm.main.UpdateSource;
import org.lateralgm.resources.Background;
import org.lateralgm.resources.Constants;
import org.lateralgm.resources.ExtensionPackages;
import org.lateralgm.resources.Font;
import org.lateralgm.resources.GameInformation;
import org.lateralgm.resources.GameSettings;
import org.lateralgm.resources.GmObject;
import org.lateralgm.resources.Include;
import org.lateralgm.resources.InstantiableResource;
import org.lateralgm.resources.Path;
import org.lateralgm.resources.Resource;
import org.lateralgm.resources.Room;
import org.lateralgm.resources.Script;
import org.lateralgm.resources.Shader;
import org.lateralgm.resources.Sound;
import org.lateralgm.resources.Sprite;
import org.lateralgm.resources.Timeline;
import org.lateralgm.resources.sub.Constant;
import org.lateralgm.resources.sub.Instance;
import org.lateralgm.resources.sub.Tile;
import org.lateralgm.resources.sub.Trigger;

public class ProjectFile
implements UpdateSource.UpdateListener {
    public static final GameSettings.ColorDepth[] GS_DEPTHS = new GameSettings.ColorDepth[]{GameSettings.ColorDepth.NO_CHANGE, GameSettings.ColorDepth.BIT_16, GameSettings.ColorDepth.BIT_32};
    public static final Map<GameSettings.ColorDepth, Integer> GS_DEPTH_CODE = ProjectFile.enumCodeMap((Enum[])GS_DEPTHS, GameSettings.ColorDepth.class);
    public static final GameSettings.Resolution[] GS5_RESOLS = new GameSettings.Resolution[]{GameSettings.Resolution.RES_640X480, GameSettings.Resolution.RES_800X600, GameSettings.Resolution.RES_1024X768, GameSettings.Resolution.RES_1280X1024, GameSettings.Resolution.NO_CHANGE, GameSettings.Resolution.RES_320X240, GameSettings.Resolution.RES_1600X1200};
    public static final GameSettings.Resolution[] GS_RESOLS = new GameSettings.Resolution[]{GameSettings.Resolution.NO_CHANGE, GameSettings.Resolution.RES_320X240, GameSettings.Resolution.RES_640X480, GameSettings.Resolution.RES_800X600, GameSettings.Resolution.RES_1024X768, GameSettings.Resolution.RES_1280X1024, GameSettings.Resolution.RES_1600X1200};
    public static final Map<GameSettings.Resolution, Integer> GS_RESOL_CODE = ProjectFile.enumCodeMap((Enum[])GS_RESOLS, GameSettings.Resolution.class);
    public static final GameSettings.Frequency[] GS_FREQS = new GameSettings.Frequency[]{GameSettings.Frequency.NO_CHANGE, GameSettings.Frequency.FREQ_60, GameSettings.Frequency.FREQ_70, GameSettings.Frequency.FREQ_85, GameSettings.Frequency.FREQ_100, GameSettings.Frequency.FREQ_120};
    public static final Map<GameSettings.Frequency, Integer> GS_FREQ_CODE = ProjectFile.enumCodeMap((Enum[])GS_FREQS, GameSettings.Frequency.class);
    public static final GameSettings.Priority[] GS_PRIORITIES = new GameSettings.Priority[]{GameSettings.Priority.NORMAL, GameSettings.Priority.HIGH, GameSettings.Priority.HIGHEST};
    public static final Map<GameSettings.Priority, Integer> GS_PRIORITY_CODE = ProjectFile.enumCodeMap((Enum[])GS_PRIORITIES, GameSettings.Priority.class);
    public static final GameSettings.ProgressBar[] GS_PROGBARS = new GameSettings.ProgressBar[]{GameSettings.ProgressBar.NONE, GameSettings.ProgressBar.DEFAULT, GameSettings.ProgressBar.CUSTOM};
    public static final Map<GameSettings.ProgressBar, Integer> GS_PROGBAR_CODE = ProjectFile.enumCodeMap((Enum[])GS_PROGBARS, GameSettings.ProgressBar.class);
    public static final GameSettings.IncludeFolder[] GS_INCFOLDERS = new GameSettings.IncludeFolder[]{GameSettings.IncludeFolder.MAIN, GameSettings.IncludeFolder.TEMP};
    public static final Map<GameSettings.IncludeFolder, Integer> GS_INCFOLDER_CODE = ProjectFile.enumCodeMap((Enum[])GS_INCFOLDERS, GameSettings.IncludeFolder.class);
    public static final Class<?>[] RESOURCE_KIND;
    public static final Map<Class<?>, Integer> RESOURCE_CODE;
    public static final Sound.PSound[] SOUND_FX_FLAGS;
    public static final Sound.SoundKind[] SOUND_KIND;
    public static final Map<Sound.SoundKind, Integer> SOUND_KIND_CODE;
    public static final Sound.SoundType[] SOUND_TYPE;
    public static final Map<Sound.SoundType, Integer> SOUND_TYPE_CODE;
    public static final GmObject.PhysicsShape[] PHYSICS_SHAPE;
    public static final Map<GmObject.PhysicsShape, Integer> SHAPE_CODE;
    public static final Sprite.BBMode[] SPRITE_BB_MODE;
    public static final Map<Sprite.BBMode, Integer> SPRITE_BB_CODE;
    public static final Sprite.MaskShape[] SPRITE_MASK_SHAPE;
    public static final Map<Sprite.MaskShape, Integer> SPRITE_MASK_CODE;
    public static final Include.ExportAction[] INCLUDE_EXPORT_ACTION;
    public static final Map<Include.ExportAction, Integer> INCLUDE_EXPORT_CODE;
    public FormatFlavor format;
    public URI uri;
    public final ResourceMap resMap;
    public SortedMap<Integer, Trigger> triggers = new TreeMap<Integer, Trigger>();
    public List<String> packages = new ArrayList<String>();
    public Constants defaultConstants = new Constants();
    public GameInformation gameInfo = new GameInformation();
    public Vector<GameSettings> gameSettings = new Vector();
    public ExtensionPackages extPackages = new ExtensionPackages();
    public int lastInstanceId = 100000;
    public int lastTileId = 10000000;
    private final UpdateSource.UpdateTrigger updateTrigger = new UpdateSource.UpdateTrigger();
    public final UpdateSource updateSource = new UpdateSource(this, this.updateTrigger);
    public static InterfaceProvider interfaceProvider;

    static {
        Class[] classArray = new Class[15];
        classArray[1] = GmObject.class;
        classArray[2] = Sprite.class;
        classArray[3] = Sound.class;
        classArray[4] = Room.class;
        classArray[6] = Background.class;
        classArray[7] = Script.class;
        classArray[8] = Path.class;
        classArray[9] = Font.class;
        classArray[10] = GameInformation.class;
        classArray[11] = GameSettings.class;
        classArray[12] = Timeline.class;
        classArray[13] = ExtensionPackages.class;
        classArray[14] = Shader.class;
        RESOURCE_KIND = classArray;
        RESOURCE_CODE = ProjectFile.codeMap(RESOURCE_KIND, new HashMap());
        SOUND_FX_FLAGS = new Sound.PSound[]{Sound.PSound.CHORUS, Sound.PSound.ECHO, Sound.PSound.FLANGER, Sound.PSound.GARGLE, Sound.PSound.REVERB};
        SOUND_KIND = new Sound.SoundKind[]{Sound.SoundKind.NORMAL, Sound.SoundKind.BACKGROUND, Sound.SoundKind.SPATIAL, Sound.SoundKind.MULTIMEDIA};
        SOUND_KIND_CODE = ProjectFile.enumCodeMap((Enum[])SOUND_KIND, Sound.SoundKind.class);
        SOUND_TYPE = new Sound.SoundType[]{Sound.SoundType.MONO, Sound.SoundType.STEREO, Sound.SoundType.THREED};
        SOUND_TYPE_CODE = ProjectFile.enumCodeMap((Enum[])SOUND_TYPE, Sound.SoundType.class);
        PHYSICS_SHAPE = new GmObject.PhysicsShape[]{GmObject.PhysicsShape.CIRCLE, GmObject.PhysicsShape.BOX, GmObject.PhysicsShape.SHAPE};
        SHAPE_CODE = ProjectFile.enumCodeMap((Enum[])PHYSICS_SHAPE, GmObject.PhysicsShape.class);
        SPRITE_BB_MODE = new Sprite.BBMode[]{Sprite.BBMode.AUTO, Sprite.BBMode.FULL, Sprite.BBMode.MANUAL};
        SPRITE_BB_CODE = ProjectFile.enumCodeMap((Enum[])SPRITE_BB_MODE, Sprite.BBMode.class);
        SPRITE_MASK_SHAPE = new Sprite.MaskShape[]{Sprite.MaskShape.PRECISE, Sprite.MaskShape.RECTANGLE, Sprite.MaskShape.DISK, Sprite.MaskShape.DIAMOND, Sprite.MaskShape.POLYGON};
        SPRITE_MASK_CODE = ProjectFile.enumCodeMap((Enum[])SPRITE_MASK_SHAPE, Sprite.MaskShape.class);
        INCLUDE_EXPORT_ACTION = new Include.ExportAction[]{Include.ExportAction.DONT_EXPORT, Include.ExportAction.TEMP_DIRECTORY, Include.ExportAction.SAME_FOLDER, Include.ExportAction.CUSTOM_FOLDER};
        INCLUDE_EXPORT_CODE = ProjectFile.enumCodeMap((Enum[])INCLUDE_EXPORT_ACTION, Include.ExportAction.class);
        interfaceProvider = new DefaultInterfaceProvider();
    }

    private static final <T> Map<T, Integer> codeMap(T[] keys, Map<T, Integer> m) {
        int i = 0;
        while (i < keys.length) {
            if (keys[i] != null) {
                m.put(keys[i], i);
            }
            ++i;
        }
        return Collections.unmodifiableMap(m);
    }

    private static final <T extends Enum<T>> Map<T, Integer> enumCodeMap(T[] keys, Class<T> enumClass) {
        return ProjectFile.codeMap(keys, new EnumMap(enumClass));
    }

    public String getPath() {
        return this.uri.getPath().replace("\\", "/");
    }

    public String getDirectory() {
        File f;
        String path = "";
        if (this.uri != null) {
            path = this.uri.getPath().replace("\\", "/");
        }
        if ((f = new File(path)).exists()) {
            return f.getParent();
        }
        return path;
    }

    public ProjectFile() {
        this.resMap = new ResourceMap();
        for (Class<? extends Resource<?, ?>> clazz : Resource.kinds) {
            if (!InstantiableResource.class.isAssignableFrom(clazz)) continue;
            this.resMap.addList(clazz);
        }
        GameSettings gameSettings = ProjectFile.createDefaultConfig();
        gameSettings.setName("Default");
        this.gameSettings.add(gameSettings);
        this.resMap.put(Constants.class, new SingletonResourceHolder<Constants>(this.defaultConstants));
        this.resMap.put(GameInformation.class, new SingletonResourceHolder<GameInformation>(this.gameInfo));
        this.resMap.put(ExtensionPackages.class, new SingletonResourceHolder<ExtensionPackages>(this.extPackages));
        for (ResourceHolder rl : this.resMap.values()) {
            if (!(rl instanceof ResourceList)) continue;
            ((ResourceList)rl).updateSource.addListener(this);
        }
    }

    public static GameSettings createDefaultConfig() {
        GameSettings gs = new GameSettings();
        Random random = new Random();
        gs.put(GameSettings.PGameSettings.GAME_ID, (Object)random.nextInt(100000001));
        random.nextBytes((byte[])gs.get(GameSettings.PGameSettings.GAME_GUID));
        return gs;
    }

    public static Calendar gmBaseTime() {
        Calendar res = Calendar.getInstance();
        res.set(1899, 11, 29, 23, 59, 59);
        return res;
    }

    public static double longTimeToGmTime(long time) {
        return (double)(time - ProjectFile.gmBaseTime().getTimeInMillis()) / 8.64E7;
    }

    public static String gmTimeToString(double time) {
        Calendar base = ProjectFile.gmBaseTime();
        base.setTimeInMillis(base.getTimeInMillis() + (long)(time * 8.64E7));
        return DateFormat.getDateTimeInstance().format(base.getTime());
    }

    public boolean checkIds() {
        for (ResourceHolder rh : this.resMap.values()) {
            if (!(rh instanceof ResourceList)) continue;
            HashSet<Integer> set = new HashSet<Integer>();
            ResourceList rl = (ResourceList)rh;
            for (Object o : rl) {
                if (!(o instanceof InstantiableResource)) continue;
                InstantiableResource r = (InstantiableResource)o;
                if (set.contains(r.getId())) {
                    return true;
                }
                set.add(r.getId());
            }
        }
        HashSet<Integer> instancesSet = new HashSet<Integer>();
        HashSet<Integer> tilesSet = new HashSet<Integer>();
        for (Room r : this.resMap.getList(Room.class)) {
            for (Instance instance : r.instances) {
                if (instancesSet.contains(instance.getID())) {
                    return true;
                }
                instancesSet.add(instance.getID());
            }
            for (Tile tile : r.tiles) {
                if (tilesSet.contains(tile.getID())) {
                    return true;
                }
                tilesSet.add(tile.getID());
            }
        }
        return false;
    }

    public void defragIds() {
        for (ResourceHolder rh : this.resMap.values()) {
            if (!(rh instanceof ResourceList)) continue;
            ((ResourceList)rh).defragIds();
        }
        this.lastInstanceId = 100000;
        this.lastTileId = 10000000;
        for (Room r : this.resMap.getList(Room.class)) {
            for (Instance instance : r.instances) {
                instance.properties.put(Instance.PInstance.ID, (Object)(++this.lastInstanceId));
            }
            for (Tile tile : r.tiles) {
                tile.properties.put(Tile.PTile.ID, (Object)(++this.lastTileId));
            }
        }
    }

    public static List<Constant> copyConstants(List<Constant> source) {
        ArrayList<Constant> dest = new ArrayList<Constant>(source.size());
        for (Constant c : source) {
            dest.add(c.copy());
        }
        return dest;
    }

    @Override
    public void updated(UpdateSource.UpdateEvent e) {
        this.updateTrigger.fire(e);
    }

    public static class DefaultInterfaceProvider
    implements InterfaceProvider {
        @Override
        public void start() {
        }

        @Override
        public void done() {
        }

        @Override
        public void init(int max, String titleKey) {
        }

        @Override
        public void setProgress(int percent, String messageKey) {
        }

        @Override
        public String translate(String key) {
            return key;
        }

        @Override
        public String format(String key, Object ... arguments) {
            return key;
        }

        @Override
        public void handleException(Exception e) {
            Thread t = Thread.currentThread();
            t.getUncaughtExceptionHandler().uncaughtException(t, e);
        }
    }

    public static class FormatFlavor {
        public static final String GM_OWNER = "GM";
        public static final String GMX_OWNER = "GMX";
        public static final FormatFlavor GM_530 = new FormatFlavor("GM", 530);
        public static final FormatFlavor GM_600 = new FormatFlavor("GM", 600);
        public static final FormatFlavor GM_701 = new FormatFlavor("GM", 701);
        public static final FormatFlavor GM_800 = new FormatFlavor("GM", 800);
        public static final FormatFlavor GM_810 = new FormatFlavor("GM", 810);
        public static final FormatFlavor GMX = new FormatFlavor("GMX", 1);
        protected Object owner;
        protected int version;

        public FormatFlavor(Object owner, int version) {
            this.owner = owner;
            this.version = version;
        }

        public static FormatFlavor getVersionFlavor(int ver) {
            switch (ver) {
                case 530: {
                    return GM_530;
                }
                case 600: {
                    return GM_600;
                }
                case 701: {
                    return GM_701;
                }
                case 800: {
                    return GM_800;
                }
                case 810: {
                    return GM_810;
                }
            }
            return null;
        }

        public Object getOwner() {
            return this.owner;
        }

        public int getVersion() {
            return this.version;
        }
    }

    public static interface InterfaceProvider {
        public void start();

        public void done();

        public void init(int var1, String var2);

        public void setProgress(int var1, String var2);

        public String translate(String var1);

        public String format(String var1, Object ... var2);

        public void handleException(Exception var1);
    }

    public static interface ResourceHolder<T extends Resource<T, ?>> {
        public T getResource();
    }

    public class ResourceMap
    extends HashMap<Class<?>, ResourceHolder<?>> {
        private static final long serialVersionUID = 1L;

        @Override
        public <R extends Resource<R, ?>> ResourceHolder<R> put(Class<R> key, ResourceHolder<R> value) {
            return super.put(key, value);
        }

        public <R extends Resource<R, ?>> ResourceHolder<R> get(Class<R> key) {
            return (ResourceHolder)super.get(key);
        }

        public <R extends InstantiableResource<R, ?>> ResourceList<R> getList(Class<R> key) {
            return (ResourceList)super.get(key);
        }

        public void addList(Class<?> kind) {
            this.put(kind, new ResourceList(kind));
        }
    }

    public static class SingletonResourceHolder<T extends Resource<T, ?>>
    implements ResourceHolder<T> {
        T r;

        public SingletonResourceHolder(T r) {
            this.r = r;
        }

        @Override
        public T getResource() {
            return this.r;
        }
    }
}

