/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.file;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public class LimitedInflaterInputStream
extends InflaterInputStream {
    protected long limit;
    private boolean closed = false;

    public LimitedInflaterInputStream(InputStream in, long limit) {
        super(in, new Inflater(), 512);
        this.limit = limit;
    }

    @Override
    public int available() throws IOException {
        this.ensureOpen();
        if (super.available() == 0) {
            return 0;
        }
        return (int)Math.min(this.limit, Integer.MAX_VALUE);
    }

    private void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
    }

    public void finish() throws IOException {
        if (!this.closed) {
            while (this.limit > 0L && this.in.available() > 0) {
                this.limit -= this.in.skip(this.limit);
            }
            this.inf.end();
            this.closed = true;
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.inf.end();
            this.in.close();
            this.closed = true;
        }
    }

    @Override
    protected void fill() throws IOException {
        this.ensureOpen();
        int len = this.in.read(this.buf, 0, (int)Math.min(this.limit, (long)this.buf.length));
        if (len == -1) {
            throw new EOFException("Unexpected end of ZLIB input stream");
        }
        this.limit -= (long)len;
        this.inf.setInput(this.buf, 0, len);
    }

    public long getLimit() {
        return this.limit;
    }
}

