/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.file;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.zip.Deflater;
import javax.imageio.ImageIO;
import org.lateralgm.file.StreamEncoder;
import org.lateralgm.main.Util;
import org.lateralgm.resources.InstantiableResource;
import org.lateralgm.resources.Resource;
import org.lateralgm.resources.ResourceReference;
import org.lateralgm.util.PropertyMap;

public class GmStreamEncoder
extends StreamEncoder {
    protected int originalPos = -1;
    protected OutputStream originalStream;
    private int[] table = null;
    private Charset charset = Charset.forName("ISO-8859-1");

    public GmStreamEncoder(OutputStream o) {
        super(o);
    }

    public GmStreamEncoder(File f) throws FileNotFoundException {
        super(f);
    }

    public GmStreamEncoder(String filePath) throws FileNotFoundException {
        super(filePath);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.table != null) {
            int i = 0;
            while (i < len) {
                int t = b[off + i] & 0xFF;
                int x = this.table[t + this.pos + i & 0xFF];
                b[off + i] = (byte)x;
                ++i;
            }
        }
        super.write(b, off, len);
    }

    @Override
    public void write(int b) throws IOException {
        if (this.table != null) {
            b = this.table[b + this.pos & 0xFF];
        }
        super.write(b);
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public void writeStr(String str) throws IOException {
        byte[] encoded = str.getBytes(this.charset);
        this.write4(encoded.length);
        this.write(encoded);
    }

    public void writeStr1(String str) throws IOException {
        byte[] encoded = str.getBytes(this.charset);
        int writeSize = Math.min(encoded.length, 255);
        this.write(writeSize);
        this.write(encoded, 0, writeSize);
    }

    public void writeBool(boolean val) throws IOException {
        this.write4(val ? 1 : 0);
    }

    @SafeVarargs
    public final <P extends Enum<P>> void write4(PropertyMap<P> map, P ... keys) throws IOException {
        P[] PArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            P key = PArray[n2];
            this.write4((Integer)map.get(key));
            ++n2;
        }
    }

    @SafeVarargs
    public final <P extends Enum<P>> void writeStr(PropertyMap<P> map, P ... keys) throws IOException {
        P[] PArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            P key = PArray[n2];
            this.writeStr((String)map.get(key));
            ++n2;
        }
    }

    @SafeVarargs
    public final <P extends Enum<P>> void writeBool(PropertyMap<P> map, P ... keys) throws IOException {
        P[] PArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            P key = PArray[n2];
            this.writeBool((Boolean)map.get(key));
            ++n2;
        }
    }

    @SafeVarargs
    public final <P extends Enum<P>> void writeD(PropertyMap<P> map, P ... keys) throws IOException {
        P[] PArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            P key = PArray[n2];
            this.writeD((Double)map.get(key));
            ++n2;
        }
    }

    public <R extends Resource<R, ?>> void writeId(ResourceReference<R> id) throws IOException {
        this.writeId(id, -1);
    }

    public <R extends Resource<R, ?>> void writeId(ResourceReference<R> id, int noneval) throws IOException {
        R r = Util.deRef(id);
        if (r != null && r instanceof InstantiableResource) {
            this.write4(((InstantiableResource)r).getId());
        } else {
            this.write4(noneval);
        }
    }

    public void compress(byte[] data) throws IOException {
        Deflater compresser = new Deflater();
        compresser.setInput(data);
        compresser.finish();
        byte[] buffer = new byte[131072];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while (!compresser.finished()) {
            int len = compresser.deflate(buffer);
            baos.write(buffer, 0, len);
        }
        this.write4(baos.size());
        this.write(baos.toByteArray());
    }

    public void beginDeflate() {
        this.originalStream = this.out;
        this.out = new ByteArrayOutputStream();
        this.originalPos = this.pos;
        this.pos = 0;
    }

    public void endDeflate() throws IOException {
        if (this.originalStream != null) {
            this.flush();
            ByteArrayOutputStream baos = (ByteArrayOutputStream)this.out;
            this.pos = this.originalPos;
            this.originalPos = -1;
            this.out = this.originalStream;
            this.originalStream = null;
            this.compress(baos.toByteArray());
        }
    }

    public void writeZlibImage(BufferedImage image) throws IOException {
        int[] pixels = image.getRGB(0, 0, image.getWidth(), image.getHeight(), null, 0, image.getWidth());
        DirectColorModel cm = new DirectColorModel(24, 0xFF0000, 65280, 255);
        WritableRaster raster = cm.createCompatibleWritableRaster(image.getWidth(), image.getHeight());
        int[] data = ((DataBufferInt)raster.getDataBuffer()).getData();
        int transparentReplacement = 16029345;
        int threshold = Integer.MIN_VALUE;
        int i = 0;
        while (i < pixels.length) {
            data[i] = pixels[i] < Integer.MIN_VALUE ? 16029345 : pixels[i] & 0xFFFFFF;
            ++i;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)new BufferedImage(cm, raster, false, null), "bmp", out);
        this.compress(out.toByteArray());
    }

    public void writeBGRAImage(BufferedImage image, boolean useTransp) throws IOException {
        int width = image.getWidth();
        int height = image.getHeight();
        int[] pixels = image.getRGB(0, 0, width, height, null, 0, width);
        this.write4(pixels.length * 4);
        int trans = image.getRGB(0, height - 1) & 0xFFFFFF;
        int p = 0;
        while (p < pixels.length) {
            this.write(pixels[p] & 0xFF);
            this.write(pixels[p] >>> 8 & 0xFF);
            this.write(pixels[p] >>> 16 & 0xFF);
            if (useTransp && (pixels[p] & 0xFFFFFF) == trans) {
                this.write(0);
            } else {
                this.write(pixels[p] >>> 24);
            }
            ++p;
        }
    }

    public void setSeed(int s) {
        this.table = (int[])(s >= 0 ? GmStreamEncoder.makeEncodeTable(s) : null);
    }

    protected static int[] makeEncodeTable(int seed) {
        int[] table = new int[256];
        int a = 6 + seed % 250;
        int b = seed / 250;
        int i = 0;
        while (i < 256) {
            table[i] = i;
            ++i;
        }
        i = 1;
        while (i < 10001) {
            int j = 1 + (i * a + b) % 254;
            int t = table[j];
            table[j] = table[j + 1];
            table[j + 1] = t;
            ++i;
        }
        return table;
    }
}

