/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.file;

import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import javax.imageio.ImageIO;
import org.lateralgm.file.GmStreamEncoder;
import org.lateralgm.file.LimitedInflaterInputStream;
import org.lateralgm.file.StreamDecoder;
import org.lateralgm.messages.Messages;
import org.lateralgm.util.PropertyMap;

public class GmStreamDecoder
extends StreamDecoder {
    protected int originalPos = -1;
    protected InputStream originalStream;
    private int[] table = null;
    private Charset charset = Charset.forName("ISO-8859-1");

    public GmStreamDecoder(InputStream in) {
        super(in);
    }

    public GmStreamDecoder(String path) throws FileNotFoundException {
        super(path);
    }

    public GmStreamDecoder(File f) throws FileNotFoundException {
        super(f);
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int n;
        int total = 0;
        do {
            if ((n = this.in.read(b, off + total, len - total)) > 0) continue;
            if (total != 0) break;
            total = n;
            break;
        } while ((total += n) != len);
        if (total != len) {
            String error = Messages.format("StreamDecoder.UNEXPECTED_EOF", this.getPosString());
            throw new IOException(error);
        }
        if (this.table != null) {
            int i = 0;
            while (i < len) {
                int t = b[off + i] & 0xFF;
                int x = this.table[t] - this.pos - i & 0xFF;
                b[off + i] = (byte)x;
                ++i;
            }
        }
        this.pos += len;
        return total;
    }

    @Override
    public int read() throws IOException {
        int t = this.in.read();
        if (t == -1) {
            String error = Messages.format("StreamDecoder.UNEXPECTED_EOF", this.getPosString());
            throw new IOException(error);
        }
        if (this.table != null) {
            t = this.table[t] - this.pos & 0xFF;
        }
        ++this.pos;
        return t;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public String readStr() throws IOException {
        byte[] data = new byte[this.read4()];
        this.read(data);
        return new String(data, this.charset);
    }

    public String readStr1() throws IOException {
        byte[] data = new byte[this.read()];
        this.read(data);
        return new String(data, this.charset);
    }

    public boolean readBool() throws IOException {
        int val = this.read4();
        if (val != 0 && val != 1) {
            String error = Messages.format("GmStreamDecoder.INVALID_BOOLEAN", val, this.getPosString());
            throw new IOException(error);
        }
        return val != 0;
    }

    @SafeVarargs
    public final <P extends Enum<P>> void read4(PropertyMap<P> map, P ... keys) throws IOException {
        P[] PArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            P key = PArray[n2];
            map.put(key, (Object)this.read4());
            ++n2;
        }
    }

    @SafeVarargs
    public final <P extends Enum<P>> void readStr(PropertyMap<P> map, P ... keys) throws IOException {
        P[] PArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            P key = PArray[n2];
            map.put(key, (Object)this.readStr());
            ++n2;
        }
    }

    @SafeVarargs
    public final <P extends Enum<P>> void readBool(PropertyMap<P> map, P ... keys) throws IOException {
        P[] PArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            P key = PArray[n2];
            map.put(key, (Object)this.readBool());
            ++n2;
        }
    }

    @SafeVarargs
    public final <P extends Enum<P>> void readD(PropertyMap<P> map, P ... keys) throws IOException {
        P[] PArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            P key = PArray[n2];
            map.put(key, (Object)this.readD());
            ++n2;
        }
    }

    public byte[] decompress(int length) throws IOException, DataFormatException {
        return this.decompress(length, length);
    }

    public byte[] decompress(int length, int initialCapacity) throws IOException, DataFormatException {
        Inflater decompresser = new Inflater();
        byte[] compressedData = new byte[length];
        this.read(compressedData, 0, length);
        decompresser.setInput(compressedData);
        byte[] result = new byte[131072];
        ByteArrayOutputStream baos = new ByteArrayOutputStream(initialCapacity);
        while (!decompresser.finished()) {
            int len = decompresser.inflate(result);
            baos.write(result, 0, len);
        }
        decompresser.end();
        return baos.toByteArray();
    }

    public void beginInflate() throws IOException {
        int limit = this.read4();
        this.originalStream = this.in;
        this.in = new LimitedInflaterInputStream(this.originalStream, limit);
        this.originalPos = this.pos;
        this.pos = 0;
    }

    public void endInflate() throws IOException {
        if (this.originalStream != null) {
            LimitedInflaterInputStream inf = (LimitedInflaterInputStream)this.in;
            inf.finish();
            this.pos = this.originalPos + (int)inf.getLimit();
            this.originalPos = -1;
            this.in = this.originalStream;
            this.originalStream = null;
        }
    }

    public BufferedImage readZlibImage(int width, int height) throws IOException, DataFormatException {
        int length = this.read4();
        int estimate = height * width * 4 + 100;
        return ImageIO.read(new ByteArrayInputStream(this.decompress(length, estimate)));
    }

    public BufferedImage readZlibImage() throws IOException, DataFormatException {
        return this.readZlibImage(0, 0);
    }

    public BufferedImage readBGRAImage(int w, int h) throws IOException {
        boolean datatype = false;
        int trans = 3;
        int[] bitSizes = new int[]{8, 8, 8, 8};
        int[] nArray = new int[4];
        nArray[0] = 2;
        nArray[1] = 1;
        nArray[3] = 3;
        int[] bitOrder = nArray;
        ColorSpace cs = ColorSpace.getInstance(1000);
        ComponentColorModel cm = new ComponentColorModel(cs, bitSizes, true, false, 3, 0);
        WritableRaster raster = Raster.createInterleavedRaster(0, w, h, w * 4, 4, bitOrder, null);
        byte[] data = ((DataBufferByte)raster.getDataBuffer()).getData();
        int s = this.read4();
        if (s != data.length) {
            throw new IOException(Messages.format("GmStreamDecoder.IMAGE_SIZE_MISMATCH", s, data.length, this.getPosString()));
        }
        this.read(data);
        return new BufferedImage(cm, raster, false, null);
    }

    public static boolean mask(int bits, int bit) {
        return (bits & bit) == bit;
    }

    public void setSeed(int s) {
        this.table = (int[])(s >= 0 ? GmStreamDecoder.makeDecodeTable(s) : null);
    }

    protected static int[] makeDecodeTable(int seed) {
        int[] encTable = GmStreamEncoder.makeEncodeTable(seed);
        return GmStreamDecoder.makeDecodeTable(encTable);
    }

    protected static int[] makeDecodeTable(int[] encTable) {
        int[] table = new int[256];
        int i = 1;
        while (i < 256) {
            table[encTable[i]] = i;
            ++i;
        }
        return table;
    }

    @Override
    protected String getPosString() {
        if (this.originalPos != -1) {
            return String.valueOf(this.originalPos) + "[" + this.pos + "]";
        }
        return Integer.toString(this.pos);
    }
}

