/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.file;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.TreeNode;
import org.lateralgm.components.impl.ResNode;
import org.lateralgm.file.GmStreamEncoder;
import org.lateralgm.file.ProjectFile;
import org.lateralgm.file.ResourceList;
import org.lateralgm.file.iconio.ICOFile;
import org.lateralgm.main.Util;
import org.lateralgm.resources.Background;
import org.lateralgm.resources.Constants;
import org.lateralgm.resources.Extension;
import org.lateralgm.resources.Font;
import org.lateralgm.resources.GameInformation;
import org.lateralgm.resources.GameSettings;
import org.lateralgm.resources.GmObject;
import org.lateralgm.resources.Include;
import org.lateralgm.resources.InstantiableResource;
import org.lateralgm.resources.Path;
import org.lateralgm.resources.Resource;
import org.lateralgm.resources.ResourceReference;
import org.lateralgm.resources.Room;
import org.lateralgm.resources.Script;
import org.lateralgm.resources.Shader;
import org.lateralgm.resources.Sound;
import org.lateralgm.resources.Sprite;
import org.lateralgm.resources.Timeline;
import org.lateralgm.resources.library.LibAction;
import org.lateralgm.resources.sub.Action;
import org.lateralgm.resources.sub.ActionContainer;
import org.lateralgm.resources.sub.Argument;
import org.lateralgm.resources.sub.BackgroundDef;
import org.lateralgm.resources.sub.CharacterRange;
import org.lateralgm.resources.sub.Constant;
import org.lateralgm.resources.sub.Event;
import org.lateralgm.resources.sub.Instance;
import org.lateralgm.resources.sub.MainEvent;
import org.lateralgm.resources.sub.Moment;
import org.lateralgm.resources.sub.PathPoint;
import org.lateralgm.resources.sub.Tile;
import org.lateralgm.resources.sub.Trigger;
import org.lateralgm.resources.sub.View;
import org.lateralgm.util.PropertyMap;

public final class GmFileWriter {
    private GmFileWriter() {
    }

    public static void writeProjectFile(OutputStream os, ProjectFile f, ResNode root, int ver) throws IOException {
        ProjectFile.interfaceProvider.init(200, "ProgressDialog.GMK_SAVING");
        f.format = ProjectFile.FormatFlavor.getVersionFlavor(ver);
        long savetime = System.currentTimeMillis();
        GmStreamEncoder out = new GmStreamEncoder(os);
        GameSettings gs = f.gameSettings.get(0);
        ProjectFile.interfaceProvider.setProgress(0, "ProgressDialog.SETTINGS");
        if (ver >= 810) {
            out.setCharset(Charset.forName("UTF-8"));
        } else {
            out.setCharset(Charset.defaultCharset());
        }
        out.write4(1234321);
        out.write4(ver);
        if (ver == 530) {
            out.write4(0);
        }
        int gameId = (Integer)gs.get(GameSettings.PGameSettings.GAME_ID);
        if (ver == 701) {
            out.write4(0);
            out.write4(0);
            out.write4(248);
            out.write(gameId & 0xFF);
            out.setSeed(248);
            out.write3(gameId >>> 8);
        } else {
            out.write4(gameId);
        }
        out.write((byte[])gs.get(GameSettings.PGameSettings.GAME_GUID));
        GmFileWriter.writeSettings(f, out, ver, savetime, gs);
        if (ver >= 800) {
            ProjectFile.interfaceProvider.setProgress(10, "ProgressDialog.TRIGGERS");
            GmFileWriter.writeTriggers(f, out, ver, gs);
            ProjectFile.interfaceProvider.setProgress(20, "ProgressDialog.CONSTANTS");
            GmFileWriter.writeConstants(f, out, ver, gs);
        }
        ProjectFile.interfaceProvider.setProgress(30, "ProgressDialog.SOUNDS");
        GmFileWriter.writeSounds(f, out, ver, gs);
        ProjectFile.interfaceProvider.setProgress(40, "ProgressDialog.SPRITES");
        GmFileWriter.writeSprites(f, out, ver, gs);
        ProjectFile.interfaceProvider.setProgress(50, "ProgressDialog.BACKGROUNDS");
        GmFileWriter.writeBackgrounds(f, out, ver, gs);
        ProjectFile.interfaceProvider.setProgress(60, "ProgressDialog.PATHS");
        GmFileWriter.writePaths(f, out, ver, gs);
        ProjectFile.interfaceProvider.setProgress(70, "ProgressDialog.SCRIPTS");
        GmFileWriter.writeScripts(f, out, ver, gs);
        ProjectFile.interfaceProvider.setProgress(80, "ProgressDialog.FONTS");
        GmFileWriter.writeFonts(f, out, ver, gs);
        ProjectFile.interfaceProvider.setProgress(90, "ProgressDialog.TIMELINES");
        GmFileWriter.writeTimelines(f, out, ver, gs);
        ProjectFile.interfaceProvider.setProgress(100, "ProgressDialog.OBJECTS");
        GmFileWriter.writeGmObjects(f, out, ver, gs);
        ProjectFile.interfaceProvider.setProgress(110, "ProgressDialog.ROOMS");
        GmFileWriter.writeRooms(f, out, ver, gs);
        out.write4(f.lastInstanceId);
        out.write4(f.lastTileId);
        if (ver >= 700) {
            ProjectFile.interfaceProvider.setProgress(120, "ProgressDialog.INCLUDEFILES");
            GmFileWriter.writeIncludedFiles(f, out, ver, gs);
            ProjectFile.interfaceProvider.setProgress(130, "ProgressDialog.PACKAGES");
            GmFileWriter.writePackages(f, out, ver);
        }
        ProjectFile.interfaceProvider.setProgress(140, "ProgressDialog.GAMEINFORMATION");
        GmFileWriter.writeGameInformation(f, out, ver, gs);
        ProjectFile.interfaceProvider.setProgress(150, "ProgressDialog.LIBRARYCREATION");
        out.write4(500);
        out.write4(0);
        ProjectFile.interfaceProvider.setProgress(160, "ProgressDialog.ROOMEXECUTION");
        out.write4(ver >= 700 ? 700 : 540);
        out.write4(0);
        ProjectFile.interfaceProvider.setProgress(170, "ProgressDialog.FILETREE");
        GmFileWriter.writeTree(out, root);
        out.close();
        ProjectFile.interfaceProvider.setProgress(200, "ProgressDialog.FINISHED");
    }

    public static void writeSettings(ProjectFile f, GmStreamEncoder out, int ver, long savetime, GameSettings g) throws IOException {
        int sync;
        ver = ver >= 810 ? 810 : (ver >= 800 ? 800 : (ver >= 701 ? 702 : ver));
        out.write4(ver >= 800 ? 800 : ver);
        if (ver >= 800) {
            out.beginDeflate();
        }
        PropertyMap p = g.properties;
        out.writeBool(p, new GameSettings.PGameSettings[]{GameSettings.PGameSettings.START_FULLSCREEN});
        if (ver >= 600) {
            out.writeBool(p, new GameSettings.PGameSettings[]{GameSettings.PGameSettings.INTERPOLATE});
        }
        out.writeBool(p, new GameSettings.PGameSettings[]{GameSettings.PGameSettings.DONT_DRAW_BORDER, GameSettings.PGameSettings.DISPLAY_CURSOR});
        out.write4(p, new GameSettings.PGameSettings[]{GameSettings.PGameSettings.SCALING});
        out.writeBool(p, new GameSettings.PGameSettings[]{GameSettings.PGameSettings.ALLOW_WINDOW_RESIZE, GameSettings.PGameSettings.ALWAYS_ON_TOP});
        out.write4(Util.getGmColor((Color)p.get(GameSettings.PGameSettings.COLOR_OUTSIDE_ROOM)));
        out.writeBool(p, new GameSettings.PGameSettings[]{GameSettings.PGameSettings.SET_RESOLUTION});
        out.write4(ProjectFile.GS_DEPTH_CODE.get(p.get(GameSettings.PGameSettings.COLOR_DEPTH)));
        out.write4(ProjectFile.GS_RESOL_CODE.get(p.get(GameSettings.PGameSettings.RESOLUTION)));
        out.write4(ProjectFile.GS_FREQ_CODE.get(p.get(GameSettings.PGameSettings.FREQUENCY)));
        out.writeBool(p, new GameSettings.PGameSettings[]{GameSettings.PGameSettings.DONT_SHOW_BUTTONS});
        int n = sync = (Boolean)p.get(GameSettings.PGameSettings.USE_SYNCHRONIZATION) != false ? 1 : 0;
        if (((Boolean)p.get(GameSettings.PGameSettings.FORCE_SOFTWARE_VERTEX_PROCESSING)).booleanValue()) {
            sync |= Integer.MIN_VALUE;
        }
        out.write4(sync);
        if (ver >= 800) {
            out.writeBool(p, new GameSettings.PGameSettings[]{GameSettings.PGameSettings.DISABLE_SCREENSAVERS});
        }
        out.writeBool(p, new GameSettings.PGameSettings[]{GameSettings.PGameSettings.LET_F4_SWITCH_FULLSCREEN, GameSettings.PGameSettings.LET_F1_SHOW_GAME_INFO, GameSettings.PGameSettings.LET_ESC_END_GAME, GameSettings.PGameSettings.LET_F5_SAVE_F6_LOAD});
        if (ver >= 702) {
            out.writeBool(p, new GameSettings.PGameSettings[]{GameSettings.PGameSettings.LET_F9_SCREENSHOT, GameSettings.PGameSettings.TREAT_CLOSE_AS_ESCAPE});
        }
        out.write4(ProjectFile.GS_PRIORITY_CODE.get(p.get(GameSettings.PGameSettings.GAME_PRIORITY)));
        out.writeBool(p, new GameSettings.PGameSettings[]{GameSettings.PGameSettings.FREEZE_ON_LOSE_FOCUS});
        out.write4(ProjectFile.GS_PROGBAR_CODE.get(p.get(GameSettings.PGameSettings.LOAD_BAR_MODE)));
        if (p.get(GameSettings.PGameSettings.LOAD_BAR_MODE) == GameSettings.ProgressBar.CUSTOM) {
            if (p.get(GameSettings.PGameSettings.BACK_LOAD_BAR) != null) {
                out.write4(ver < 800 ? 10 : 1);
                out.writeZlibImage((BufferedImage)p.get(GameSettings.PGameSettings.BACK_LOAD_BAR));
            } else {
                out.write4(ver < 800 ? -1 : 0);
            }
            if (p.get(GameSettings.PGameSettings.FRONT_LOAD_BAR) != null) {
                out.write4(ver < 800 ? 10 : 1);
                out.writeZlibImage((BufferedImage)p.get(GameSettings.PGameSettings.FRONT_LOAD_BAR));
            } else {
                out.write4(ver < 800 ? -1 : 0);
            }
        }
        out.writeBool(p, new GameSettings.PGameSettings[]{GameSettings.PGameSettings.SHOW_CUSTOM_LOAD_IMAGE});
        if (((Boolean)p.get(GameSettings.PGameSettings.SHOW_CUSTOM_LOAD_IMAGE)).booleanValue()) {
            if (p.get(GameSettings.PGameSettings.LOADING_IMAGE) != null) {
                out.write4(ver < 800 ? 10 : 1);
                out.writeZlibImage((BufferedImage)p.get(GameSettings.PGameSettings.LOADING_IMAGE));
            } else {
                out.write4(ver < 800 ? -1 : 0);
            }
        }
        out.writeBool(p, new GameSettings.PGameSettings[]{GameSettings.PGameSettings.IMAGE_PARTIALLY_TRANSPARENTY});
        out.write4(p, new GameSettings.PGameSettings[]{GameSettings.PGameSettings.LOAD_IMAGE_ALPHA});
        out.writeBool(p, new GameSettings.PGameSettings[]{GameSettings.PGameSettings.SCALE_PROGRESS_BAR});
        Util.fixIcon((ICOFile)g.get(GameSettings.PGameSettings.GAME_ICON), ver);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ((ICOFile)g.get(GameSettings.PGameSettings.GAME_ICON)).write(baos);
        out.write4(baos.size());
        baos.writeTo(out);
        out.writeBool(p, new GameSettings.PGameSettings[]{GameSettings.PGameSettings.DISPLAY_ERRORS, GameSettings.PGameSettings.WRITE_TO_LOG, GameSettings.PGameSettings.ABORT_ON_ERROR});
        out.write4(((Boolean)p.get(GameSettings.PGameSettings.TREAT_UNINIT_AS_0) != false ? 1 : 0) | ((Boolean)p.get(GameSettings.PGameSettings.ERROR_ON_ARGS) != false && ver >= 810 ? 2 : 0));
        out.writeStr(p, new GameSettings.PGameSettings[]{GameSettings.PGameSettings.AUTHOR});
        if (ver <= 600) {
            try {
                out.write4(Integer.parseInt((String)p.get(GameSettings.PGameSettings.VERSION)));
            }
            catch (NumberFormatException e) {
                out.write4(100);
            }
        } else {
            out.writeStr(p, new GameSettings.PGameSettings[]{GameSettings.PGameSettings.VERSION});
        }
        p.put(GameSettings.PGameSettings.LAST_CHANGED, (Object)ProjectFile.longTimeToGmTime(savetime));
        out.writeD(p, new GameSettings.PGameSettings[]{GameSettings.PGameSettings.LAST_CHANGED});
        out.writeStr(p, new GameSettings.PGameSettings[]{GameSettings.PGameSettings.INFORMATION});
        if (ver < 800) {
            out.write4(g.constants.constants.size());
            for (Constant con : g.constants.constants) {
                out.writeStr(con.name);
                out.writeStr(con.value);
            }
            if (ver == 542 || ver == 600) {
                ResourceList<Include> includes = f.resMap.getList(Include.class);
                out.write4(includes.size());
                for (Include inc : includes) {
                    out.writeStr(inc.properties, new Include.PInclude[]{Include.PInclude.FILEPATH});
                }
                out.write4(ProjectFile.GS_INCFOLDER_CODE.get(p.get(GameSettings.PGameSettings.INCLUDE_FOLDER)));
                out.writeBool(p, new GameSettings.PGameSettings[]{GameSettings.PGameSettings.OVERWRITE_EXISTING, GameSettings.PGameSettings.REMOVE_AT_GAME_END});
            }
        }
        if (ver >= 702) {
            out.write4(p, new GameSettings.PGameSettings[]{GameSettings.PGameSettings.VERSION_MAJOR, GameSettings.PGameSettings.VERSION_MINOR, GameSettings.PGameSettings.VERSION_RELEASE, GameSettings.PGameSettings.VERSION_BUILD});
            out.writeStr(p, new GameSettings.PGameSettings[]{GameSettings.PGameSettings.COMPANY, GameSettings.PGameSettings.PRODUCT, GameSettings.PGameSettings.COPYRIGHT, GameSettings.PGameSettings.DESCRIPTION});
            if (ver >= 800) {
                out.writeD(g.getLastChanged());
            }
        }
        out.endDeflate();
    }

    public static void writeTriggers(ProjectFile f, GmStreamEncoder out, int ver, GameSettings gs) throws IOException {
        if (ver < 800) {
            return;
        }
        out.write4(800);
        int no = f.triggers.isEmpty() ? 0 : f.triggers.lastKey() + 1;
        out.write4(no);
        Integer i = 0;
        while (i < no) {
            out.beginDeflate();
            Trigger t = (Trigger)f.triggers.get(i);
            if (t == null) {
                out.writeBool(false);
            } else {
                out.writeBool(true);
                out.write4(800);
                out.writeStr(t.name);
                out.writeStr(t.condition);
                out.write4(t.checkStep);
                out.writeStr(t.constant);
            }
            out.endDeflate();
            i = i + 1;
        }
        out.writeD(gs.getLastChanged());
    }

    public static void writeConstants(ProjectFile f, GmStreamEncoder out, int ver, GameSettings gs) throws IOException {
        if (ver < 800) {
            return;
        }
        out.write4(800);
        out.write4(gs.constants.constants.size());
        for (Constant c : gs.constants.constants) {
            out.writeStr(c.name);
            out.writeStr(c.value);
        }
        out.writeD(gs.getLastChanged());
    }

    public static void writeSounds(ProjectFile f, GmStreamEncoder out, int ver, GameSettings gs) throws IOException {
        ver = ver >= 800 ? 800 : (ver >= 600 ? 600 : 440);
        out.write4(ver == 800 ? 800 : 400);
        out.write4(f.resMap.getList(Sound.class).lastId + 1);
        int i = 0;
        while (i <= f.resMap.getList(Sound.class).lastId) {
            Sound snd;
            if (ver == 800) {
                out.beginDeflate();
            }
            out.writeBool((snd = f.resMap.getList(Sound.class).getUnsafe(i)) != null);
            if (snd != null) {
                out.writeStr(snd.getName());
                if (ver == 800) {
                    out.writeD(gs.getLastChanged());
                }
                out.write4(ver);
                out.write4(ProjectFile.SOUND_KIND_CODE.get(snd.get(Sound.PSound.KIND)));
                out.writeStr(snd.properties, new Sound.PSound[]{Sound.PSound.FILE_TYPE, Sound.PSound.FILE_NAME});
                if (snd.data != null) {
                    out.writeBool(true);
                    if (ver == 800) {
                        out.write4(snd.data.length);
                        out.write(snd.data);
                    } else {
                        out.compress(snd.data);
                    }
                } else {
                    out.writeBool(false);
                }
                out.write4(snd.getEffects());
                out.writeD(snd.properties, new Sound.PSound[]{Sound.PSound.VOLUME, Sound.PSound.PAN});
                out.writeBool(snd.properties, new Sound.PSound[]{Sound.PSound.PRELOAD});
            }
            out.endDeflate();
            ++i;
        }
    }

    public static void writeSprites(ProjectFile f, GmStreamEncoder out, int ver, GameSettings gs) throws IOException {
        ver = ver >= 800 ? 800 : (ver >= 542 ? 542 : 400);
        out.write4(ver == 800 ? 800 : 400);
        out.write4(f.resMap.getList(Sprite.class).lastId + 1);
        int i = 0;
        while (i <= f.resMap.getList(Sprite.class).lastId) {
            Sprite spr;
            if (ver == 800) {
                out.beginDeflate();
            }
            out.writeBool((spr = f.resMap.getList(Sprite.class).getUnsafe(i)) != null);
            if (spr != null) {
                out.writeStr(spr.getName());
                if (ver == 800) {
                    out.writeD(gs.getLastChanged());
                }
                out.write4(ver);
                if (ver < 800) {
                    out.write4(spr.subImages.getWidth());
                    out.write4(spr.subImages.getHeight());
                    out.write4(spr.properties, new Sprite.PSprite[]{Sprite.PSprite.BB_LEFT, Sprite.PSprite.BB_RIGHT, Sprite.PSprite.BB_BOTTOM, Sprite.PSprite.BB_TOP});
                    out.writeBool(spr.properties, new Sprite.PSprite[]{Sprite.PSprite.TRANSPARENT, Sprite.PSprite.SMOOTH_EDGES, Sprite.PSprite.PRELOAD});
                    out.write4(ProjectFile.SPRITE_BB_CODE.get(spr.get(Sprite.PSprite.BB_MODE)));
                    out.writeBool(spr.get(Sprite.PSprite.SHAPE) == Sprite.MaskShape.PRECISE);
                }
                out.write4(spr.properties, new Sprite.PSprite[]{Sprite.PSprite.ORIGIN_X, Sprite.PSprite.ORIGIN_Y});
                out.write4(spr.subImages.size());
                int j = 0;
                while (j < spr.subImages.size()) {
                    BufferedImage sub = (BufferedImage)spr.subImages.get(j);
                    if (ver == 800) {
                        out.write4(800);
                        int w = sub.getWidth();
                        int h = sub.getHeight();
                        out.write4(w);
                        out.write4(h);
                        if (w != 0 && h != 0) {
                            out.writeBGRAImage(sub, (Boolean)spr.get(Sprite.PSprite.TRANSPARENT));
                        }
                    } else {
                        out.write4(10);
                        out.writeZlibImage(sub);
                    }
                    ++j;
                }
                if (ver >= 800) {
                    out.write4(ProjectFile.SPRITE_MASK_CODE.get(spr.get(Sprite.PSprite.SHAPE)));
                    out.write4(spr.properties, new Sprite.PSprite[]{Sprite.PSprite.ALPHA_TOLERANCE});
                    out.writeBool(spr.properties, new Sprite.PSprite[]{Sprite.PSprite.SEPARATE_MASK});
                    out.write4(ProjectFile.SPRITE_BB_CODE.get(spr.get(Sprite.PSprite.BB_MODE)));
                    out.write4(spr.properties, new Sprite.PSprite[]{Sprite.PSprite.BB_LEFT, Sprite.PSprite.BB_RIGHT, Sprite.PSprite.BB_BOTTOM, Sprite.PSprite.BB_TOP});
                }
            }
            out.endDeflate();
            ++i;
        }
    }

    public static void writeBackgrounds(ProjectFile f, GmStreamEncoder out, int ver, GameSettings gs) throws IOException {
        ver = ver >= 710 ? 710 : (ver >= 543 ? 543 : 400);
        out.write4(ver == 710 ? 800 : 400);
        out.write4(f.resMap.getList(Background.class).lastId + 1);
        int i = 0;
        while (i <= f.resMap.getList(Background.class).lastId) {
            Background back;
            if (ver == 710) {
                out.beginDeflate();
            }
            out.writeBool((back = f.resMap.getList(Background.class).getUnsafe(i)) != null);
            if (back != null) {
                out.writeStr(back.getName());
                if (ver == 710) {
                    out.writeD(gs.getLastChanged());
                }
                out.write4(ver);
                if (ver < 710) {
                    out.write4(back.getWidth());
                    out.write4(back.getHeight());
                    out.writeBool(back.properties, new Background.PBackground[]{Background.PBackground.TRANSPARENT, Background.PBackground.SMOOTH_EDGES, Background.PBackground.PRELOAD, Background.PBackground.USE_AS_TILESET});
                } else {
                    out.writeBool(back.properties, new Background.PBackground[]{Background.PBackground.USE_AS_TILESET});
                }
                out.write4(back.properties, new Background.PBackground[]{Background.PBackground.TILE_WIDTH, Background.PBackground.TILE_HEIGHT, Background.PBackground.H_OFFSET, Background.PBackground.V_OFFSET, Background.PBackground.H_SEP, Background.PBackground.V_SEP});
                BufferedImage bi = back.getBackgroundImage();
                if (ver < 710) {
                    if (bi != null) {
                        out.writeBool(true);
                        out.write4(10);
                        out.writeZlibImage(bi);
                    } else {
                        out.writeBool(false);
                    }
                } else {
                    out.write4(800);
                    int w = bi == null ? 0 : bi.getWidth();
                    int h = bi == null ? 0 : bi.getHeight();
                    out.write4(w);
                    out.write4(h);
                    if (w != 0 && h != 0) {
                        out.writeBGRAImage(bi, (Boolean)back.get(Background.PBackground.TRANSPARENT));
                    }
                }
            }
            out.endDeflate();
            ++i;
        }
    }

    public static void writePaths(ProjectFile f, GmStreamEncoder out, int ver, GameSettings gs) throws IOException {
        if (ver > 800) {
            ver = 800;
        }
        out.write4(ver == 800 ? 800 : 420);
        out.write4(f.resMap.getList(Path.class).lastId + 1);
        int i = 0;
        while (i <= f.resMap.getList(Path.class).lastId) {
            Path path;
            if (ver == 800) {
                out.beginDeflate();
            }
            out.writeBool((path = f.resMap.getList(Path.class).getUnsafe(i)) != null);
            if (path != null) {
                out.writeStr(path.getName());
                if (ver == 800) {
                    out.writeD(gs.getLastChanged());
                }
                out.write4(530);
                out.writeBool(path.properties, new Path.PPath[]{Path.PPath.SMOOTH, Path.PPath.CLOSED});
                out.write4(path.properties, new Path.PPath[]{Path.PPath.PRECISION});
                out.writeId((ResourceReference)path.get(Path.PPath.BACKGROUND_ROOM));
                out.write4(path.properties, new Path.PPath[]{Path.PPath.SNAP_X, Path.PPath.SNAP_Y});
                out.write4(path.points.size());
                for (PathPoint p : path.points) {
                    out.writeD(p.getX());
                    out.writeD(p.getY());
                    out.writeD(p.getSpeed());
                }
            }
            out.endDeflate();
            ++i;
        }
    }

    public static void writeScripts(ProjectFile f, GmStreamEncoder out, int ver, GameSettings gs) throws IOException {
        ver = ver >= 800 ? 800 : 400;
        out.write4(ver);
        out.write4(f.resMap.getList(Script.class).lastId + 1);
        int i = 0;
        while (i <= f.resMap.getList(Script.class).lastId) {
            Script scr;
            if (ver == 800) {
                out.beginDeflate();
            }
            out.writeBool((scr = f.resMap.getList(Script.class).getUnsafe(i)) != null);
            if (scr != null) {
                out.writeStr(scr.getName());
                if (ver == 800) {
                    out.writeD(gs.getLastChanged());
                }
                out.write4(ver);
                out.writeStr(scr.properties, new Script.PScript[]{Script.PScript.CODE});
            }
            out.endDeflate();
            ++i;
        }
    }

    public static void writeFonts(ProjectFile f, GmStreamEncoder out, int ver, GameSettings gs) throws IOException {
        out.write4(ver >= 800 ? 800 : 540);
        out.write4(f.resMap.getList(Font.class).lastId + 1);
        int i = 0;
        while (i <= f.resMap.getList(Font.class).lastId) {
            Font font;
            if (ver >= 800) {
                out.beginDeflate();
            }
            out.writeBool((font = f.resMap.getList(Font.class).getUnsafe(i)) != null);
            if (font != null) {
                CharacterRange cr;
                out.writeStr(font.getName());
                if (ver >= 800) {
                    out.writeD(gs.getLastChanged());
                }
                out.write4(ver >= 800 ? 800 : 540);
                out.writeStr(font.properties, new Font.PFont[]{Font.PFont.FONT_NAME});
                out.write4(font.properties, new Font.PFont[]{Font.PFont.SIZE});
                out.writeBool(font.properties, new Font.PFont[]{Font.PFont.BOLD, Font.PFont.ITALIC});
                int rangemin = 0;
                int rangemax = 0;
                if (font.characterRanges.size() > 0 && (cr = (CharacterRange)font.characterRanges.get(0)) != null) {
                    rangemin = (Integer)cr.properties.get(CharacterRange.PCharacterRange.RANGE_MIN);
                    rangemax = (Integer)cr.properties.get(CharacterRange.PCharacterRange.RANGE_MAX);
                }
                if (ver >= 810) {
                    out.write2(rangemin);
                    out.write((Integer)font.get(Font.PFont.CHARSET));
                    out.write((Integer)font.get(Font.PFont.ANTIALIAS) + 1);
                } else {
                    out.write4(rangemin);
                }
                out.write4(rangemax);
            }
            out.endDeflate();
            ++i;
        }
    }

    public static void writeTimelines(ProjectFile f, GmStreamEncoder out, int ver, GameSettings gs) throws IOException {
        if (ver > 800) {
            ver = 800;
        }
        out.write4(ver == 800 ? 800 : 500);
        out.write4(f.resMap.getList(Timeline.class).lastId + 1);
        int i = 0;
        while (i <= f.resMap.getList(Timeline.class).lastId) {
            Timeline time;
            if (ver == 800) {
                out.beginDeflate();
            }
            out.writeBool((time = f.resMap.getList(Timeline.class).getUnsafe(i)) != null);
            if (time != null) {
                out.writeStr(time.getName());
                if (ver == 800) {
                    out.writeD(gs.getLastChanged());
                }
                out.write4(500);
                out.write4(time.moments.size());
                for (Moment mom : time.moments) {
                    out.write4(mom.stepNo);
                    GmFileWriter.writeActions(out, mom);
                }
            }
            out.endDeflate();
            ++i;
        }
    }

    public static void writeGmObjects(ProjectFile f, GmStreamEncoder out, int ver, GameSettings gs) throws IOException {
        if (ver > 800) {
            ver = 800;
        }
        out.write4(ver == 800 ? 800 : 400);
        out.write4(f.resMap.getList(GmObject.class).lastId + 1);
        int i = 0;
        while (i <= f.resMap.getList(GmObject.class).lastId) {
            GmObject obj;
            if (ver == 800) {
                out.beginDeflate();
            }
            out.writeBool((obj = f.resMap.getList(GmObject.class).getUnsafe(i)) != null);
            if (obj != null) {
                out.writeStr(obj.getName());
                if (ver == 800) {
                    out.writeD(gs.getLastChanged());
                }
                out.write4(430);
                out.writeId((ResourceReference)obj.get(GmObject.PGmObject.SPRITE));
                out.writeBool(obj.properties, new GmObject.PGmObject[]{GmObject.PGmObject.SOLID, GmObject.PGmObject.VISIBLE});
                out.write4(obj.properties, new GmObject.PGmObject[]{GmObject.PGmObject.DEPTH});
                out.writeBool(obj.properties, new GmObject.PGmObject[]{GmObject.PGmObject.PERSISTENT});
                out.writeId((ResourceReference)obj.get(GmObject.PGmObject.PARENT), -100);
                out.writeId((ResourceReference)obj.get(GmObject.PGmObject.MASK));
                int numMainEvents = ver == 800 ? 12 : 11;
                out.write4(numMainEvents - 1);
                int j = 0;
                while (j < numMainEvents) {
                    MainEvent me = obj.mainEvents.get(j);
                    int k = me.events.size();
                    while (k > 0) {
                        Event ev = me.events.get(k - 1);
                        if (j == 4) {
                            out.writeId(ev.other);
                        } else {
                            out.write4(ev.id);
                        }
                        GmFileWriter.writeActions(out, ev);
                        --k;
                    }
                    out.write4(-1);
                    ++j;
                }
            }
            out.endDeflate();
            ++i;
        }
    }

    public static void writeRooms(ProjectFile f, GmStreamEncoder out, int ver, GameSettings gs) throws IOException {
        if (ver > 800) {
            ver = 800;
        }
        out.write4(ver == 800 ? 800 : 420);
        out.write4(f.resMap.getList(Room.class).lastId + 1);
        int i = 0;
        while (i <= f.resMap.getList(Room.class).lastId) {
            Room rm;
            if (ver == 800) {
                out.beginDeflate();
            }
            out.writeBool((rm = f.resMap.getList(Room.class).getUnsafe(i)) != null);
            if (rm != null) {
                int viewBackgroundClear;
                out.writeStr(rm.getName());
                if (ver == 800) {
                    out.writeD(gs.getLastChanged());
                }
                out.write4(541);
                out.writeStr(rm.properties, new Room.PRoom[]{Room.PRoom.CAPTION});
                out.write4(rm.properties, new Room.PRoom[]{Room.PRoom.WIDTH, Room.PRoom.HEIGHT, Room.PRoom.SNAP_Y, Room.PRoom.SNAP_X});
                out.writeBool(rm.properties, new Room.PRoom[]{Room.PRoom.ISOMETRIC});
                out.write4(rm.properties, new Room.PRoom[]{Room.PRoom.SPEED});
                out.writeBool(rm.properties, new Room.PRoom[]{Room.PRoom.PERSISTENT});
                out.write4(Util.getGmColor((Color)rm.get(Room.PRoom.BACKGROUND_COLOR)));
                int n = viewBackgroundClear = (Boolean)rm.get(Room.PRoom.DRAW_BACKGROUND_COLOR) != false ? 1 : 0;
                if (!((Boolean)rm.get(Room.PRoom.VIEWS_CLEAR)).booleanValue()) {
                    viewBackgroundClear |= 2;
                }
                out.write4(viewBackgroundClear);
                out.writeStr(rm.properties, new Room.PRoom[]{Room.PRoom.CREATION_CODE});
                out.write4(rm.backgroundDefs.size());
                for (BackgroundDef back : rm.backgroundDefs) {
                    out.writeBool(back.properties, new BackgroundDef.PBackgroundDef[]{BackgroundDef.PBackgroundDef.VISIBLE, BackgroundDef.PBackgroundDef.FOREGROUND});
                    out.writeId((ResourceReference)back.properties.get(BackgroundDef.PBackgroundDef.BACKGROUND));
                    out.write4(back.properties, new BackgroundDef.PBackgroundDef[]{BackgroundDef.PBackgroundDef.X, BackgroundDef.PBackgroundDef.Y});
                    out.writeBool(back.properties, new BackgroundDef.PBackgroundDef[]{BackgroundDef.PBackgroundDef.TILE_HORIZ, BackgroundDef.PBackgroundDef.TILE_VERT});
                    out.write4(back.properties, new BackgroundDef.PBackgroundDef[]{BackgroundDef.PBackgroundDef.H_SPEED, BackgroundDef.PBackgroundDef.V_SPEED});
                    out.writeBool(back.properties, new BackgroundDef.PBackgroundDef[]{BackgroundDef.PBackgroundDef.STRETCH});
                }
                out.writeBool(rm.properties, new Room.PRoom[]{Room.PRoom.VIEWS_ENABLED});
                out.write4(rm.views.size());
                for (View view : rm.views) {
                    out.writeBool(view.properties, new View.PView[]{View.PView.VISIBLE});
                    out.write4(view.properties, new View.PView[]{View.PView.VIEW_X, View.PView.VIEW_Y, View.PView.VIEW_W, View.PView.VIEW_H, View.PView.PORT_X, View.PView.PORT_Y, View.PView.PORT_W, View.PView.PORT_H, View.PView.BORDER_H, View.PView.BORDER_V, View.PView.SPEED_H, View.PView.SPEED_V});
                    out.writeId((ResourceReference)view.properties.get(View.PView.OBJECT));
                }
                out.write4(rm.instances.size());
                for (Instance in : rm.instances) {
                    out.write4(in.getPosition().x);
                    out.write4(in.getPosition().y);
                    ResourceReference or = (ResourceReference)in.properties.get(Instance.PInstance.OBJECT);
                    out.writeId(or);
                    out.write4((Integer)in.properties.get(Instance.PInstance.ID));
                    out.writeStr(in.getCreationCode());
                    out.writeBool(in.isLocked());
                }
                out.write4(rm.tiles.size());
                for (Tile tile : rm.tiles) {
                    out.write4(tile.getPosition().x);
                    out.write4(tile.getPosition().y);
                    ResourceReference rb = (ResourceReference)tile.properties.get(Tile.PTile.BACKGROUND);
                    out.writeId(rb);
                    out.write4(tile.getBackgroundPosition().x);
                    out.write4(tile.getBackgroundPosition().y);
                    out.write4(tile.getSize().width);
                    out.write4(tile.getSize().height);
                    out.write4(tile.getDepth());
                    out.write4((Integer)tile.properties.get(Tile.PTile.ID));
                    out.writeBool(tile.isLocked());
                }
                out.writeBool(rm.properties, new Room.PRoom[]{Room.PRoom.REMEMBER_WINDOW_SIZE});
                out.write4(rm.properties, new Room.PRoom[]{Room.PRoom.EDITOR_WIDTH, Room.PRoom.EDITOR_HEIGHT});
                out.writeBool(rm.properties, new Room.PRoom[]{Room.PRoom.SHOW_GRID, Room.PRoom.SHOW_OBJECTS, Room.PRoom.SHOW_TILES, Room.PRoom.SHOW_BACKGROUNDS, Room.PRoom.SHOW_FOREGROUNDS, Room.PRoom.SHOW_VIEWS, Room.PRoom.DELETE_UNDERLYING_OBJECTS, Room.PRoom.DELETE_UNDERLYING_TILES});
                out.write4(rm.properties, new Room.PRoom[]{Room.PRoom.CURRENT_TAB, Room.PRoom.SCROLL_BAR_X, Room.PRoom.SCROLL_BAR_Y});
            }
            out.endDeflate();
            ++i;
        }
    }

    public static void writeIncludedFiles(ProjectFile f, GmStreamEncoder out, int ver, GameSettings gs) throws IOException {
        int n = ver >= 800 ? 800 : (ver = ver >= 620 ? 620 : 0);
        if (ver < 620) {
            return;
        }
        out.write4(ver);
        ResourceList<Include> includes = f.resMap.getList(Include.class);
        out.write4(includes.size());
        for (Include i : includes) {
            if (ver >= 800) {
                out.beginDeflate();
                out.writeD(gs.getLastChanged());
            }
            out.write4(ver);
            out.writeStr(i.properties, new Include.PInclude[]{Include.PInclude.FILENAME});
            out.writeStr(i.properties, new Include.PInclude[]{Include.PInclude.FILEPATH});
            out.writeBool(i.properties, new Include.PInclude[]{Include.PInclude.ORIGINAL});
            out.write4(i.properties, new Include.PInclude[]{Include.PInclude.SIZE});
            boolean store = (Boolean)i.get(Include.PInclude.STORE);
            out.writeBool(store);
            if (store) {
                out.write4(i.data.length);
                out.write(i.data);
            }
            out.write4(ProjectFile.INCLUDE_EXPORT_CODE.get(i.get(Include.PInclude.EXPORTACTION)));
            out.writeStr(i.properties, new Include.PInclude[]{Include.PInclude.EXPORTFOLDER});
            out.writeBool(i.properties, new Include.PInclude[]{Include.PInclude.OVERWRITE});
            out.writeBool(i.properties, new Include.PInclude[]{Include.PInclude.FREEMEMORY});
            out.writeBool(i.properties, new Include.PInclude[]{Include.PInclude.REMOVEATGAMEEND});
            out.endDeflate();
        }
    }

    public static void writePackages(ProjectFile f, GmStreamEncoder out, int ver) throws IOException {
        if (ver < 700) {
            return;
        }
        out.write4(700);
        out.write4(f.packages.size());
        for (String s : f.packages) {
            out.writeStr(s);
        }
    }

    public static void writeGameInformation(ProjectFile f, GmStreamEncoder out, int ver, GameSettings gs) throws IOException {
        ver = ver >= 800 ? 800 : (ver >= 600 ? 600 : 430);
        out.write4(ver);
        if (ver == 800) {
            out.beginDeflate();
        }
        GameInformation g = f.gameInfo;
        PropertyMap p = g.properties;
        out.write4(Util.getGmColor((Color)p.get(GameInformation.PGameInformation.BACKGROUND_COLOR)));
        if (ver < 800) {
            out.writeBool(p, new GameInformation.PGameInformation[]{GameInformation.PGameInformation.EMBED_GAME_WINDOW});
        } else {
            out.writeBool((Boolean)p.get(GameInformation.PGameInformation.EMBED_GAME_WINDOW) == false);
        }
        out.writeStr(p, new GameInformation.PGameInformation[]{GameInformation.PGameInformation.FORM_CAPTION});
        out.write4(p, new GameInformation.PGameInformation[]{GameInformation.PGameInformation.LEFT, GameInformation.PGameInformation.TOP, GameInformation.PGameInformation.WIDTH, GameInformation.PGameInformation.HEIGHT});
        out.writeBool(p, new GameInformation.PGameInformation[]{GameInformation.PGameInformation.SHOW_BORDER, GameInformation.PGameInformation.ALLOW_RESIZE, GameInformation.PGameInformation.STAY_ON_TOP, GameInformation.PGameInformation.PAUSE_GAME});
        if (ver >= 800) {
            out.writeD(gs.getLastChanged());
        }
        out.writeStr(p, new GameInformation.PGameInformation[]{GameInformation.PGameInformation.TEXT});
        out.endDeflate();
    }

    public static void writeTree(GmStreamEncoder out, ResNode root) throws IOException {
        Enumeration<TreeNode> e = root.preorderEnumeration();
        e.nextElement();
        while (e.hasMoreElements()) {
            ResNode node = (ResNode)e.nextElement();
            if (node.kind == Shader.class || node.kind == Include.class || node.kind == Extension.class || node.kind == Constants.class) continue;
            out.write4(node.status);
            if (ProjectFile.RESOURCE_CODE.containsKey(node.kind)) {
                out.write4(ProjectFile.RESOURCE_CODE.get(node.kind));
            } else {
                out.write4(0);
            }
            Resource<?, ?> res = Util.deRef(node.getRes());
            if (res != null && res instanceof InstantiableResource) {
                out.write4(((InstantiableResource)res).getId());
            } else {
                out.write4(0);
            }
            out.writeStr((String)node.getUserObject());
            out.write4(node.getChildCount());
        }
    }

    public static void writeActions(GmStreamEncoder out, ActionContainer container) throws IOException {
        out.write4(400);
        out.write4(container.actions.size());
        for (Action act : container.actions) {
            LibAction la = act.getLibAction();
            out.write4(440);
            out.write4(la.parent != null ? la.parent.id : la.parentId);
            out.write4(la.id);
            out.write4(la.actionKind);
            out.writeBool(la.allowRelative);
            out.writeBool(la.question);
            out.writeBool(la.canApplyTo);
            out.write4(la.execType);
            if (la.execType == 1) {
                out.writeStr(la.execInfo);
            } else {
                out.write4(0);
            }
            if (la.execType == 2) {
                out.writeStr(la.execInfo);
            } else {
                out.write4(0);
            }
            List<Argument> args = act.getArguments();
            out.write4(args.size());
            out.write4(args.size());
            for (Argument arg : args) {
                out.write4(arg.kind);
            }
            ResourceReference<GmObject> at = act.getAppliesTo();
            if (at != null) {
                if (at == GmObject.OBJECT_OTHER) {
                    out.write4(-2);
                } else if (at == GmObject.OBJECT_SELF) {
                    out.write4(-1);
                } else {
                    out.writeId(at, -100);
                }
            } else {
                out.write4(-100);
            }
            out.writeBool(act.isRelative());
            out.write4(args.size());
            for (Argument arg : args) {
                Class<? extends Resource<?, ?>> kind = Argument.getResourceKind(arg.kind);
                if (kind != null && InstantiableResource.class.isAssignableFrom(kind)) {
                    Resource<?, ?> r = Util.deRef(arg.getRes());
                    if (r != null && r instanceof InstantiableResource) {
                        out.writeStr(Integer.toString(((InstantiableResource)r).getId()));
                        continue;
                    }
                    out.writeStr("-1");
                    continue;
                }
                out.writeStr(arg.getVal());
            }
            out.writeBool(act.isNot());
        }
    }
}

