/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.file;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Stack;
import java.util.zip.DataFormatException;
import org.lateralgm.components.impl.ResNode;
import org.lateralgm.file.GmFormatException;
import org.lateralgm.file.GmStreamDecoder;
import org.lateralgm.file.ProjectFile;
import org.lateralgm.file.RefList;
import org.lateralgm.file.ResourceList;
import org.lateralgm.file.iconio.ICOFile;
import org.lateralgm.main.Util;
import org.lateralgm.resources.Background;
import org.lateralgm.resources.Constants;
import org.lateralgm.resources.Extension;
import org.lateralgm.resources.ExtensionPackages;
import org.lateralgm.resources.Font;
import org.lateralgm.resources.GameInformation;
import org.lateralgm.resources.GameSettings;
import org.lateralgm.resources.GmObject;
import org.lateralgm.resources.Include;
import org.lateralgm.resources.InstantiableResource;
import org.lateralgm.resources.Path;
import org.lateralgm.resources.Resource;
import org.lateralgm.resources.ResourceReference;
import org.lateralgm.resources.Room;
import org.lateralgm.resources.Script;
import org.lateralgm.resources.Shader;
import org.lateralgm.resources.Sound;
import org.lateralgm.resources.Sprite;
import org.lateralgm.resources.Timeline;
import org.lateralgm.resources.library.LibAction;
import org.lateralgm.resources.library.LibArgument;
import org.lateralgm.resources.library.LibManager;
import org.lateralgm.resources.sub.Action;
import org.lateralgm.resources.sub.ActionContainer;
import org.lateralgm.resources.sub.Argument;
import org.lateralgm.resources.sub.BackgroundDef;
import org.lateralgm.resources.sub.Constant;
import org.lateralgm.resources.sub.Event;
import org.lateralgm.resources.sub.Instance;
import org.lateralgm.resources.sub.MainEvent;
import org.lateralgm.resources.sub.Moment;
import org.lateralgm.resources.sub.PathPoint;
import org.lateralgm.resources.sub.ShapePoint;
import org.lateralgm.resources.sub.Tile;
import org.lateralgm.resources.sub.Trigger;
import org.lateralgm.resources.sub.View;
import org.lateralgm.util.PropertyMap;

public final class GmFileReader {
    private static Queue<PostponedRef> postpone = new LinkedList<PostponedRef>();

    private GmFileReader() {
    }

    private static GmFormatException versionError(ProjectFile f, String error, String res, int ver) {
        return GmFileReader.versionError(f, error, res, 0, ver);
    }

    private static GmFormatException versionError(ProjectFile f, String error, String res, int i, int ver) {
        ProjectFile.InterfaceProvider ip = ProjectFile.interfaceProvider;
        return new GmFormatException(f, ip.format("ProjectFileReader.ERROR_UNSUPPORTED", ip.format("ProjectFileReader." + error, ip.translate("LGM." + res), i), ver));
    }

    public static void readProjectFile(InputStream stream, ProjectFile file, URI uri, ResNode root) throws GmFormatException {
        GmFileReader.readProjectFile(stream, file, uri, root, null);
    }

    /*
     * WARNING - void declaration
     */
    public static void readProjectFile(InputStream stream, ProjectFile file, URI uri, ResNode root, Charset forceCharset) throws GmFormatException {
        ProjectFile.interfaceProvider.init(200, "ProgressDialog.GMK_LOADING");
        GmStreamDecoder in = null;
        RefList<Timeline> timeids = new RefList<Timeline>(Timeline.class);
        RefList<GmObject> objids = new RefList<GmObject>(GmObject.class);
        RefList<Room> rmids = new RefList<Room>(Room.class);
        try {
            try {
                void var17_25;
                in = new GmStreamDecoder(stream);
                ProjectFileContext c = new ProjectFileContext(file, in, timeids, objids, rmids);
                int identifier = in.read4();
                if (identifier != 1234321) {
                    throw new GmFormatException(file, ProjectFile.interfaceProvider.format("ProjectFileReader.ERROR_INVALID", uri, identifier));
                }
                int ver = in.read4();
                file.format = ProjectFile.FormatFlavor.getVersionFlavor(ver);
                if (ver != 530 && ver != 600 && ver != 701 && ver != 800 && ver != 810) {
                    String msg = ProjectFile.interfaceProvider.format("ProjectFileReader.ERROR_UNSUPPORTED", uri, ver);
                    throw new GmFormatException(file, msg);
                }
                if (forceCharset == null) {
                    if (ver >= 810) {
                        in.setCharset(Charset.forName("UTF-8"));
                    } else {
                        in.setCharset(Charset.defaultCharset());
                    }
                } else {
                    in.setCharset(forceCharset);
                }
                GameSettings gs = c.f.gameSettings.get(0);
                ProjectFile.interfaceProvider.setProgress(0, "ProgressDialog.SETTINGS");
                if (ver == 530) {
                    in.skip(4L);
                }
                if (ver == 701) {
                    int s1 = in.read4();
                    int s2 = in.read4();
                    in.skip(s1 * 4);
                    int seed = in.read4();
                    in.skip(s2 * 4);
                    int b1 = in.read();
                    in.setSeed(seed);
                    gs.put(GameSettings.PGameSettings.GAME_ID, (Object)(b1 | in.read3() << 8));
                } else {
                    gs.put(GameSettings.PGameSettings.GAME_ID, (Object)in.read4());
                }
                in.read((byte[])gs.get(GameSettings.PGameSettings.GAME_GUID));
                GmFileReader.readSettings(c, gs);
                if (ver >= 800) {
                    ProjectFile.interfaceProvider.setProgress(10, "ProgressDialog.TRIGGERS");
                    GmFileReader.readTriggers(c);
                    ProjectFile.interfaceProvider.setProgress(20, "ProgressDialog.CONSTANTS");
                    GmFileReader.readConstants(c, gs);
                }
                ProjectFile.interfaceProvider.setProgress(30, "ProgressDialog.SOUNDS");
                GmFileReader.readSounds(c);
                ProjectFile.interfaceProvider.setProgress(40, "ProgressDialog.SPRITES");
                GmFileReader.readSprites(c);
                ProjectFile.interfaceProvider.setProgress(50, "ProgressDialog.BACKGROUNDS");
                int bgVer = GmFileReader.readBackgrounds(c);
                ProjectFile.interfaceProvider.setProgress(60, "ProgressDialog.PATHS");
                GmFileReader.readPaths(c);
                ProjectFile.interfaceProvider.setProgress(70, "ProgressDialog.SCRIPTS");
                GmFileReader.readScripts(c);
                ProjectFile.interfaceProvider.setProgress(80, "ProgressDialog.SHADERS");
                ProjectFile.interfaceProvider.setProgress(90, "ProgressDialog.FONTS");
                int rver = in.read4();
                GmFileReader.readFonts(c, rver);
                ProjectFile.interfaceProvider.setProgress(100, "ProgressDialog.TIMELINES");
                GmFileReader.readTimelines(c);
                ProjectFile.interfaceProvider.setProgress(110, "ProgressDialog.OBJECTS");
                GmFileReader.readGmObjects(c);
                ProjectFile.interfaceProvider.setProgress(120, "ProgressDialog.ROOMS");
                GmFileReader.readRooms(c);
                if (bgVer <= 400) {
                    for (Room rm : file.resMap.getList(Room.class)) {
                        for (Tile tile : rm.tiles) {
                            ResourceReference bkg = (ResourceReference)tile.properties.get(Tile.PTile.BACKGROUND);
                            if (bkg == null || bkg.get() == null) continue;
                            ((Background)bkg.get()).properties.put(Background.PBackground.USE_AS_TILESET, (Object)true);
                        }
                    }
                }
                file.lastInstanceId = in.read4();
                file.lastTileId = in.read4();
                if (ver >= 700) {
                    ProjectFile.interfaceProvider.setProgress(130, "ProgressDialog.INCLUDEFILES");
                    GmFileReader.readIncludedFiles(c);
                    ProjectFile.interfaceProvider.setProgress(140, "ProgressDialog.PACKAGES");
                    GmFileReader.readPackages(c);
                }
                ProjectFile.interfaceProvider.setProgress(150, "ProgressDialog.GAMEINFORMATION");
                GmFileReader.readGameInformation(c);
                ProjectFile.interfaceProvider.setProgress(160, "ProgressDialog.POSTPONED");
                int percent = 0;
                for (PostponedRef i : postpone) {
                    i.invoke();
                    ProjectFile.interfaceProvider.setProgress(160 + ++percent / postpone.size(), "ProgressDialog.POSTPONED");
                }
                postpone.clear();
                ProjectFile.interfaceProvider.setProgress(170, "ProgressDialog.LIBRARYCREATION");
                ver = in.read4();
                if (ver != 500) {
                    throw new GmFormatException(file, ProjectFile.interfaceProvider.format("ProjectFileReader.ERROR_UNSUPPORTED", ProjectFile.interfaceProvider.translate("ProjectFileReader.AFTERINFO"), ver));
                }
                int no = in.read4();
                boolean bl = false;
                while (var17_25 < no) {
                    in.skip(in.read4());
                    ++var17_25;
                }
                ProjectFile.interfaceProvider.setProgress(180, "ProgressDialog.ROOMEXECUTION");
                ver = in.read4();
                if (ver != 500 && ver != 540 && ver != 700) {
                    throw new GmFormatException(file, ProjectFile.interfaceProvider.format("ProjectFileReader.ERROR_UNSUPPORTED", ProjectFile.interfaceProvider.translate("ProjectFileReader.AFTERINFO2"), ver));
                }
                in.skip(in.read4() * 4);
                ProjectFile.interfaceProvider.setProgress(190, "ProgressDialog.FILETREE");
                GmFileReader.readTree(c, root, ver);
                ProjectFile.interfaceProvider.setProgress(200, "ProgressDialog.FINISHED");
            }
            catch (Exception e) {
                if (e instanceof GmFormatException) {
                    throw (GmFormatException)e;
                }
                throw new GmFormatException(file, e);
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                    in = null;
                }
            }
            catch (IOException ex) {
                String key = ProjectFile.interfaceProvider.translate("GmFileReader.ERROR_CLOSEFAILED");
                throw new GmFormatException(file, key);
            }
        }
    }

    private static void readSettings(ProjectFileContext c, GameSettings g) throws IOException, GmFormatException, DataFormatException {
        byte frequency;
        GmStreamDecoder in = c.in;
        PropertyMap p = g.properties;
        int ver = in.read4();
        if (ver != 530 && ver != 542 && ver != 600 && ver != 702 && ver != 800 && ver != 810) {
            String msg = ProjectFile.interfaceProvider.format("ProjectFileReader.ERROR_UNSUPPORTED", "", ver);
            throw new GmFormatException(c.f, msg);
        }
        if (ver >= 800) {
            in.beginInflate();
        }
        in.readBool(p, new GameSettings.PGameSettings[]{GameSettings.PGameSettings.START_FULLSCREEN});
        if (ver >= 600) {
            in.readBool(p, new GameSettings.PGameSettings[]{GameSettings.PGameSettings.INTERPOLATE});
        }
        in.readBool(p, new GameSettings.PGameSettings[]{GameSettings.PGameSettings.DONT_DRAW_BORDER, GameSettings.PGameSettings.DISPLAY_CURSOR});
        in.read4(p, new GameSettings.PGameSettings[]{GameSettings.PGameSettings.SCALING});
        if (ver == 530) {
            in.skip(8L);
        } else {
            in.readBool(p, new GameSettings.PGameSettings[]{GameSettings.PGameSettings.ALLOW_WINDOW_RESIZE, GameSettings.PGameSettings.ALWAYS_ON_TOP});
            p.put(GameSettings.PGameSettings.COLOR_OUTSIDE_ROOM, (Object)Util.convertGmColor(in.read4()));
        }
        in.readBool(p, new GameSettings.PGameSettings[]{GameSettings.PGameSettings.SET_RESOLUTION});
        byte colorDepth = 0;
        if (ver == 530) {
            in.skip(8L);
            p.put(GameSettings.PGameSettings.RESOLUTION, (Object)ProjectFile.GS5_RESOLS[in.read4()]);
            byte b = (byte)in.read4();
            frequency = b == 4 ? (byte)0 : (byte)(b + 1);
            in.skip(8L);
        } else {
            colorDepth = (byte)in.read4();
            p.put(GameSettings.PGameSettings.RESOLUTION, (Object)ProjectFile.GS_RESOLS[in.read4()]);
            frequency = (byte)in.read4();
        }
        p.put(GameSettings.PGameSettings.COLOR_DEPTH, (Object)ProjectFile.GS_DEPTHS[colorDepth]);
        p.put(GameSettings.PGameSettings.FREQUENCY, (Object)ProjectFile.GS_FREQS[frequency]);
        in.readBool(p, new GameSettings.PGameSettings[]{GameSettings.PGameSettings.DONT_SHOW_BUTTONS});
        if (ver > 530) {
            int sync = in.read4();
            p.put(GameSettings.PGameSettings.USE_SYNCHRONIZATION, (Object)((sync & 1) != 0 ? 1 : 0));
            p.put(GameSettings.PGameSettings.FORCE_SOFTWARE_VERTEX_PROCESSING, (Object)((sync & Integer.MIN_VALUE) != 0 ? 1 : 0));
        }
        if (ver >= 800) {
            in.readBool(p, new GameSettings.PGameSettings[]{GameSettings.PGameSettings.DISABLE_SCREENSAVERS});
        }
        in.readBool(p, new GameSettings.PGameSettings[]{GameSettings.PGameSettings.LET_F4_SWITCH_FULLSCREEN, GameSettings.PGameSettings.LET_F1_SHOW_GAME_INFO, GameSettings.PGameSettings.LET_ESC_END_GAME, GameSettings.PGameSettings.LET_F5_SAVE_F6_LOAD});
        if (ver == 530) {
            in.skip(8L);
        }
        if (ver > 600) {
            in.readBool(p, new GameSettings.PGameSettings[]{GameSettings.PGameSettings.LET_F9_SCREENSHOT, GameSettings.PGameSettings.TREAT_CLOSE_AS_ESCAPE});
        }
        p.put(GameSettings.PGameSettings.GAME_PRIORITY, (Object)ProjectFile.GS_PRIORITIES[in.read4()]);
        in.readBool(p, new GameSettings.PGameSettings[]{GameSettings.PGameSettings.FREEZE_ON_LOSE_FOCUS});
        p.put(GameSettings.PGameSettings.LOAD_BAR_MODE, (Object)ProjectFile.GS_PROGBARS[in.read4()]);
        if (p.get(GameSettings.PGameSettings.LOAD_BAR_MODE) == GameSettings.ProgressBar.CUSTOM) {
            if (ver < 800) {
                if (in.read4() != -1) {
                    p.put(GameSettings.PGameSettings.BACK_LOAD_BAR, (Object)in.readZlibImage());
                }
                if (in.read4() != -1) {
                    p.put(GameSettings.PGameSettings.FRONT_LOAD_BAR, (Object)in.readZlibImage());
                }
            } else {
                if (in.readBool()) {
                    p.put(GameSettings.PGameSettings.BACK_LOAD_BAR, (Object)in.readZlibImage());
                }
                if (in.readBool()) {
                    p.put(GameSettings.PGameSettings.FRONT_LOAD_BAR, (Object)in.readZlibImage());
                }
            }
        }
        in.readBool(p, new GameSettings.PGameSettings[]{GameSettings.PGameSettings.SHOW_CUSTOM_LOAD_IMAGE});
        if (((Boolean)p.get(GameSettings.PGameSettings.SHOW_CUSTOM_LOAD_IMAGE)).booleanValue()) {
            if (ver < 800) {
                if (in.read4() != -1) {
                    p.put(GameSettings.PGameSettings.LOADING_IMAGE, (Object)in.readZlibImage());
                }
            } else if (in.readBool()) {
                p.put(GameSettings.PGameSettings.LOADING_IMAGE, (Object)in.readZlibImage());
            }
        }
        in.readBool(p, new GameSettings.PGameSettings[]{GameSettings.PGameSettings.IMAGE_PARTIALLY_TRANSPARENTY});
        in.read4(p, new GameSettings.PGameSettings[]{GameSettings.PGameSettings.LOAD_IMAGE_ALPHA});
        in.readBool(p, new GameSettings.PGameSettings[]{GameSettings.PGameSettings.SCALE_PROGRESS_BAR});
        int length = in.read4();
        byte[] data = new byte[length];
        in.read(data, 0, length);
        g.put(GameSettings.PGameSettings.GAME_ICON, (Object)new ICOFile(data));
        in.readBool(p, new GameSettings.PGameSettings[]{GameSettings.PGameSettings.DISPLAY_ERRORS, GameSettings.PGameSettings.WRITE_TO_LOG, GameSettings.PGameSettings.ABORT_ON_ERROR});
        int errors = in.read4();
        p.put(GameSettings.PGameSettings.TREAT_UNINIT_AS_0, (Object)((errors & 1) != 0 ? 1 : 0));
        p.put(GameSettings.PGameSettings.ERROR_ON_ARGS, (Object)((errors & 2) != 0 ? 1 : 0));
        in.readStr(p, new GameSettings.PGameSettings[]{GameSettings.PGameSettings.AUTHOR});
        if (ver > 600) {
            in.readStr(p, new GameSettings.PGameSettings[]{GameSettings.PGameSettings.VERSION});
        } else {
            p.put(GameSettings.PGameSettings.VERSION, (Object)Integer.toString(in.read4()));
        }
        in.readD(p, new GameSettings.PGameSettings[]{GameSettings.PGameSettings.LAST_CHANGED});
        in.readStr(p, new GameSettings.PGameSettings[]{GameSettings.PGameSettings.INFORMATION});
        if (ver < 800) {
            int no = in.read4();
            int i = 0;
            while (i < no) {
                Constant con = new Constant();
                g.constants.constants.add(con);
                con.name = in.readStr();
                con.value = in.readStr();
                ++i;
            }
        }
        if (ver > 600) {
            in.read4(p, new GameSettings.PGameSettings[]{GameSettings.PGameSettings.VERSION_MAJOR, GameSettings.PGameSettings.VERSION_MINOR, GameSettings.PGameSettings.VERSION_RELEASE, GameSettings.PGameSettings.VERSION_BUILD});
            in.readStr(p, new GameSettings.PGameSettings[]{GameSettings.PGameSettings.COMPANY, GameSettings.PGameSettings.PRODUCT, GameSettings.PGameSettings.COPYRIGHT, GameSettings.PGameSettings.DESCRIPTION});
            if (ver >= 800) {
                in.skip(8L);
            }
        } else if (ver > 530) {
            GmFileReader.readSettingsIncludes(c.f, in, g);
        }
        in.endInflate();
    }

    private static void readSettingsIncludes(ProjectFile f, GmStreamDecoder in, GameSettings gs) throws IOException {
        int no = in.read4();
        int i = 0;
        while (i < no) {
            Include inc = f.resMap.getList(Include.class).add();
            String filepath = in.readStr();
            String filename = new File(filepath).getName();
            inc.put(Include.PInclude.FILEPATH, filepath);
            inc.put(Include.PInclude.FILENAME, filename);
            ++i;
        }
        gs.put(GameSettings.PGameSettings.INCLUDE_FOLDER, (Object)ProjectFile.GS_INCFOLDERS[in.read4()]);
        in.readBool(gs.properties, new GameSettings.PGameSettings[]{GameSettings.PGameSettings.OVERWRITE_EXISTING, GameSettings.PGameSettings.REMOVE_AT_GAME_END});
        Include.ExportAction exportAction = gs.get(GameSettings.PGameSettings.INCLUDE_FOLDER) == GameSettings.IncludeFolder.TEMP ? Include.ExportAction.TEMP_DIRECTORY : Include.ExportAction.SAME_FOLDER;
        for (Include inc : f.resMap.getList(Include.class)) {
            inc.put(Include.PInclude.EXPORTACTION, (Object)exportAction);
            inc.put(Include.PInclude.OVERWRITE, gs.get(GameSettings.PGameSettings.OVERWRITE_EXISTING));
            inc.put(Include.PInclude.REMOVEATGAMEEND, gs.get(GameSettings.PGameSettings.REMOVE_AT_GAME_END));
        }
    }

    private static void readTriggers(ProjectFileContext c) throws IOException, GmFormatException {
        ProjectFile f = c.f;
        GmStreamDecoder in = c.in;
        int ver = in.read4();
        if (ver != 800) {
            throw GmFileReader.versionError(f, "BEFORE", "SND", ver);
        }
        int no = in.read4();
        int i = 0;
        while (i < no) {
            in.beginInflate();
            if (!in.readBool()) {
                in.endInflate();
            } else {
                ver = in.read4();
                if (ver != 800) {
                    throw GmFileReader.versionError(f, "BEFORE", "SND", ver);
                }
                Trigger trig = new Trigger();
                f.triggers.put(i, trig);
                trig.name = in.readStr();
                trig.condition = in.readStr();
                trig.checkStep = in.read4();
                trig.constant = in.readStr();
                in.endInflate();
            }
            ++i;
        }
        in.skip(8L);
    }

    private static void readConstants(ProjectFileContext c, GameSettings gs) throws IOException, GmFormatException {
        ProjectFile f = c.f;
        GmStreamDecoder in = c.in;
        int ver = in.read4();
        if (ver != 800) {
            throw GmFileReader.versionError(f, "BEFORE", "SND", ver);
        }
        int no = in.read4();
        int i = 0;
        while (i < no) {
            Constant con = new Constant();
            gs.constants.constants.add(con);
            con.name = in.readStr();
            con.value = in.readStr();
            ++i;
        }
        in.skip(8L);
    }

    private static void readSounds(ProjectFileContext c) throws IOException, GmFormatException, DataFormatException {
        ProjectFile f = c.f;
        GmStreamDecoder in = c.in;
        int ver = in.read4();
        if (ver != 400 && ver != 800) {
            throw GmFileReader.versionError(f, "BEFORE", "SND", ver);
        }
        int noSounds = in.read4();
        int i = 0;
        while (i < noSounds) {
            if (ver == 800) {
                in.beginInflate();
            }
            if (!in.readBool()) {
                ++f.resMap.getList(Sound.class).lastId;
                in.endInflate();
            } else {
                Sound snd = f.resMap.getList(Sound.class).add();
                snd.setName(in.readStr());
                if (ver == 800) {
                    in.skip(8L);
                }
                if ((ver = in.read4()) != 440 && ver != 600 && ver != 800) {
                    throw GmFileReader.versionError(f, "IN", "SND", i, ver);
                }
                int kind53 = -1;
                if (ver == 440) {
                    kind53 = in.read4();
                } else {
                    snd.put(Sound.PSound.KIND, (Object)ProjectFile.SOUND_KIND[in.read4()]);
                }
                in.readStr(snd.properties, new Sound.PSound[]{Sound.PSound.FILE_TYPE});
                if (ver == 440) {
                    if (kind53 != -1) {
                        snd.data = in.decompress(in.read4());
                    }
                    in.skip(8L);
                    snd.put(Sound.PSound.PRELOAD, !in.readBool());
                } else {
                    snd.put(Sound.PSound.FILE_NAME, in.readStr());
                    if (in.readBool()) {
                        if (ver == 600) {
                            snd.data = in.decompress(in.read4());
                        } else {
                            int s = in.read4();
                            snd.data = new byte[s];
                            in.read(snd.data);
                        }
                    }
                    snd.setEffects(in.read4());
                    in.readD(snd.properties, new Sound.PSound[]{Sound.PSound.VOLUME, Sound.PSound.PAN});
                    snd.put(Sound.PSound.PRELOAD, in.readBool());
                }
                in.endInflate();
            }
            ++i;
        }
    }

    private static void readSprites(ProjectFileContext c) throws IOException, GmFormatException, DataFormatException {
        ProjectFile f = c.f;
        GmStreamDecoder in = c.in;
        int ver = in.read4();
        if (ver != 400 && ver != 800 && ver != 810) {
            throw GmFileReader.versionError(f, "BEFORE", "SPR", ver);
        }
        int noSprites = in.read4();
        int i = 0;
        while (i < noSprites) {
            if (ver == 800) {
                in.beginInflate();
            }
            if (!in.readBool()) {
                ++f.resMap.getList(Sprite.class).lastId;
                in.endInflate();
            } else {
                Sprite spr = f.resMap.getList(Sprite.class).add();
                spr.put(Sprite.PSprite.BB_MODE, (Object)Sprite.BBMode.MANUAL);
                Sprite.BBMode actualBBMode = null;
                spr.setName(in.readStr());
                if (ver == 800) {
                    in.skip(8L);
                }
                if ((ver = in.read4()) != 400 && ver != 542 && ver != 800 && ver != 810) {
                    throw GmFileReader.versionError(f, "IN", "SPR", i, ver);
                }
                int w = 0;
                int h = 0;
                if (ver < 800) {
                    w = in.read4();
                    h = in.read4();
                    in.read4(spr.properties, new Sprite.PSprite[]{Sprite.PSprite.BB_LEFT, Sprite.PSprite.BB_RIGHT, Sprite.PSprite.BB_BOTTOM, Sprite.PSprite.BB_TOP});
                    spr.put(Sprite.PSprite.TRANSPARENT, in.readBool());
                    if (ver > 400) {
                        in.readBool(spr.properties, new Sprite.PSprite[]{Sprite.PSprite.SMOOTH_EDGES, Sprite.PSprite.PRELOAD});
                    }
                    actualBBMode = ProjectFile.SPRITE_BB_MODE[in.read4()];
                    boolean precise = in.readBool();
                    spr.put(Sprite.PSprite.SHAPE, (Object)(precise ? Sprite.MaskShape.PRECISE : Sprite.MaskShape.RECTANGLE));
                    if (ver == 400) {
                        in.skip(4L);
                        spr.put(Sprite.PSprite.PRELOAD, !in.readBool());
                    }
                } else {
                    spr.put(Sprite.PSprite.TRANSPARENT, false);
                }
                in.read4(spr.properties, new Sprite.PSprite[]{Sprite.PSprite.ORIGIN_X, Sprite.PSprite.ORIGIN_Y});
                int nosub = in.read4();
                int j = 0;
                while (j < nosub) {
                    if (ver >= 800) {
                        int subver = in.read4();
                        if (subver != 800 && subver != 810) {
                            throw GmFileReader.versionError(f, "IN", "SPR", i, subver);
                        }
                        w = in.read4();
                        h = in.read4();
                        if (w != 0 && h != 0) {
                            spr.subImages.add(in.readBGRAImage(w, h));
                        }
                    } else if (in.read4() != -1) {
                        spr.subImages.add(in.readZlibImage(w, h));
                    }
                    ++j;
                }
                if (ver >= 800) {
                    spr.put(Sprite.PSprite.SHAPE, (Object)ProjectFile.SPRITE_MASK_SHAPE[in.read4()]);
                    spr.put(Sprite.PSprite.ALPHA_TOLERANCE, in.read4());
                    spr.put(Sprite.PSprite.SEPARATE_MASK, in.readBool());
                    actualBBMode = ProjectFile.SPRITE_BB_MODE[in.read4()];
                    in.read4(spr.properties, new Sprite.PSprite[]{Sprite.PSprite.BB_LEFT, Sprite.PSprite.BB_RIGHT, Sprite.PSprite.BB_BOTTOM, Sprite.PSprite.BB_TOP});
                }
                spr.put(Sprite.PSprite.BB_MODE, (Object)actualBBMode);
                in.endInflate();
            }
            ++i;
        }
    }

    private static int readBackgrounds(ProjectFileContext c) throws IOException, GmFormatException, DataFormatException {
        ProjectFile f = c.f;
        GmStreamDecoder in = c.in;
        int ver = in.read4();
        if (ver != 400 && ver != 800) {
            throw GmFileReader.versionError(f, "BEFORE", "BKG", ver);
        }
        int noBackgrounds = in.read4();
        int i = 0;
        while (i < noBackgrounds) {
            block10: {
                block12: {
                    int h;
                    int w;
                    Background back;
                    block11: {
                        block9: {
                            if (ver == 800) {
                                in.beginInflate();
                            }
                            if (in.readBool()) break block9;
                            ++f.resMap.getList(Background.class).lastId;
                            in.endInflate();
                            break block10;
                        }
                        back = f.resMap.getList(Background.class).add();
                        back.setName(in.readStr());
                        if (ver == 800) {
                            in.skip(8L);
                        }
                        if ((ver = in.read4()) != 400 && ver != 543 && ver != 710) {
                            throw GmFileReader.versionError(f, "IN", "BKG", i, ver);
                        }
                        if (ver >= 710) break block11;
                        w = in.read4();
                        h = in.read4();
                        back.put(Background.PBackground.TRANSPARENT, in.readBool());
                        if (ver > 400) {
                            in.readBool(back.properties, new Background.PBackground[]{Background.PBackground.SMOOTH_EDGES, Background.PBackground.PRELOAD, Background.PBackground.USE_AS_TILESET});
                            in.read4(back.properties, new Background.PBackground[]{Background.PBackground.TILE_WIDTH, Background.PBackground.TILE_HEIGHT, Background.PBackground.H_OFFSET, Background.PBackground.V_OFFSET, Background.PBackground.H_SEP, Background.PBackground.V_SEP});
                        } else {
                            in.skip(4L);
                            back.put(Background.PBackground.PRELOAD, !in.readBool());
                        }
                        if (!in.readBool()) break block12;
                        if (in.read4() == -1) break block10;
                        back.setBackgroundImage(in.readZlibImage(w, h));
                        break block12;
                    }
                    back.put(Background.PBackground.USE_AS_TILESET, in.readBool());
                    in.read4(back.properties, new Background.PBackground[]{Background.PBackground.TILE_WIDTH, Background.PBackground.TILE_HEIGHT, Background.PBackground.H_OFFSET, Background.PBackground.V_OFFSET, Background.PBackground.H_SEP, Background.PBackground.V_SEP});
                    ver = in.read4();
                    if (ver != 800) {
                        throw GmFileReader.versionError(f, "IN", "BKG", i, ver);
                    }
                    w = in.read4();
                    h = in.read4();
                    if (w != 0 && h != 0) {
                        back.setBackgroundImage(in.readBGRAImage(w, h));
                    }
                }
                in.endInflate();
            }
            ++i;
        }
        return ver;
    }

    private static void readPaths(ProjectFileContext c) throws IOException, GmFormatException {
        ProjectFile f = c.f;
        GmStreamDecoder in = c.in;
        int ver = in.read4();
        if (ver != 420 && ver != 800) {
            throw GmFileReader.versionError(f, "BEFORE", "PTH", ver);
        }
        int noPaths = in.read4();
        int i = 0;
        while (i < noPaths) {
            if (ver == 800) {
                in.beginInflate();
            }
            if (!in.readBool()) {
                ++f.resMap.getList(Path.class).lastId;
                in.endInflate();
            } else {
                int ver2;
                Path path = f.resMap.getList(Path.class).add();
                path.setName(in.readStr());
                if (ver == 800) {
                    in.skip(8L);
                }
                if ((ver2 = in.read4()) != 530) {
                    throw GmFileReader.versionError(f, "IN", "PTH", i, ver2);
                }
                in.readBool(path.properties, new Path.PPath[]{Path.PPath.SMOOTH, Path.PPath.CLOSED});
                path.put(Path.PPath.PRECISION, in.read4());
                path.put(Path.PPath.BACKGROUND_ROOM, c.rmids.get(in.read4()));
                in.read4(path.properties, new Path.PPath[]{Path.PPath.SNAP_X, Path.PPath.SNAP_Y});
                int nopoints = in.read4();
                int j = 0;
                while (j < nopoints) {
                    path.points.add(new PathPoint((int)in.readD(), (int)in.readD(), (int)in.readD()));
                    ++j;
                }
                in.endInflate();
            }
            ++i;
        }
    }

    private static void readScripts(ProjectFileContext c) throws IOException, GmFormatException {
        ProjectFile f = c.f;
        GmStreamDecoder in = c.in;
        int ver = in.read4();
        if (ver != 400 && ver != 800 && ver != 810) {
            throw GmFileReader.versionError(f, "BEFORE", "SCR", ver);
        }
        int noScripts = in.read4();
        int i = 0;
        while (i < noScripts) {
            if (ver >= 800) {
                in.beginInflate();
            }
            if (!in.readBool()) {
                ++f.resMap.getList(Script.class).lastId;
                in.endInflate();
            } else {
                Script scr = f.resMap.getList(Script.class).add();
                scr.setName(in.readStr());
                if (ver >= 800) {
                    in.skip(8L);
                }
                if ((ver = in.read4()) != 400 && ver != 800 && ver != 810) {
                    throw GmFileReader.versionError(f, "IN", "SCR", i, ver);
                }
                String code = in.readStr();
                scr.put(Script.PScript.CODE, code);
                in.endInflate();
            }
            ++i;
        }
    }

    private static void readFonts(ProjectFileContext c, int ver) throws IOException, GmFormatException, DataFormatException {
        ProjectFile f = c.f;
        GmStreamDecoder in = c.in;
        if (ver != 440 && ver != 540 && ver != 800) {
            throw GmFileReader.versionError(f, "BEFORE", "FNT", (int)in.getPos());
        }
        if (ver == 440) {
            int noDataFiles = in.read4();
            int i = 0;
            while (i < noDataFiles) {
                if (in.readBool()) {
                    in.skip(in.read4());
                    if (in.read4() != 440) {
                        ProjectFile.InterfaceProvider ip = ProjectFile.interfaceProvider;
                        throw new GmFormatException(f, ip.format("ProjectFileReader.ERROR_UNSUPPORTED", ip.translate("ProjectFileReader.INDATAFILES"), ver));
                    }
                    Include inc = f.resMap.getList(Include.class).add();
                    String filepath = in.readStr();
                    String filename = new File(filepath).getName();
                    inc.put(Include.PInclude.FILEPATH, filepath);
                    inc.put(Include.PInclude.FILENAME, filename);
                    if (in.readBool()) {
                        inc.data = in.decompress(in.read4());
                        if (inc.data != null) {
                            inc.put(Include.PInclude.SIZE, inc.data.length);
                        }
                    }
                    inc.put(Include.PInclude.EXPORTACTION, (Object)ProjectFile.INCLUDE_EXPORT_ACTION[in.read4()]);
                    inc.put(Include.PInclude.OVERWRITE, in.readBool());
                    inc.put(Include.PInclude.FREEMEMORY, in.readBool());
                    inc.put(Include.PInclude.REMOVEATGAMEEND, in.readBool());
                }
                ++i;
            }
            return;
        }
        int noFonts = in.read4();
        int i = 0;
        while (i < noFonts) {
            if (ver == 800) {
                in.beginInflate();
            }
            if (!in.readBool()) {
                ++f.resMap.getList(Font.class).lastId;
                in.endInflate();
            } else {
                Font font = f.resMap.getList(Font.class).add();
                font.setName(in.readStr());
                if (ver == 800) {
                    in.skip(8L);
                }
                if ((ver = in.read4()) != 540 && ver != 800) {
                    throw GmFileReader.versionError(f, "IN", "FNT", i, ver);
                }
                font.put(Font.PFont.FONT_NAME, in.readStr());
                font.put(Font.PFont.SIZE, in.read4());
                in.readBool(font.properties, new Font.PFont[]{Font.PFont.BOLD, Font.PFont.ITALIC});
                int rangemin = in.read2();
                font.put(Font.PFont.CHARSET, in.read());
                int aa = in.read();
                aa = aa == 0 && f.format != ProjectFile.FormatFlavor.GM_810 ? 3 : --aa;
                font.put(Font.PFont.ANTIALIAS, aa);
                font.addRange(rangemin, in.read4());
                in.endInflate();
            }
            ++i;
        }
    }

    private static void readTimelines(ProjectFileContext c) throws IOException, GmFormatException {
        ProjectFile f = c.f;
        GmStreamDecoder in = c.in;
        int ver = in.read4();
        if (ver != 500 && ver != 800) {
            throw GmFileReader.versionError(f, "BEFORE", "TML", ver);
        }
        int noTimelines = in.read4();
        int i = 0;
        while (i < noTimelines) {
            if (ver == 800) {
                in.beginInflate();
            }
            if (!in.readBool()) {
                in.endInflate();
            } else {
                int ver2;
                ResourceReference<Timeline> r = c.timeids.get(i);
                Timeline time = r.get();
                f.resMap.getList(Timeline.class).add(time);
                time.setName(in.readStr());
                if (ver == 800) {
                    in.skip(8L);
                }
                if ((ver2 = in.read4()) != 500) {
                    throw GmFileReader.versionError(f, "IN", "TML", i, ver2);
                }
                int nomoms = in.read4();
                int j = 0;
                while (j < nomoms) {
                    Moment mom = time.addMoment();
                    mom.stepNo = in.read4();
                    ProjectFileContext fc = c.copy();
                    fc.in = in;
                    GmFileReader.readActions(fc, mom, "INTIMELINEACTION", i, mom.stepNo);
                    ++j;
                }
                in.endInflate();
            }
            ++i;
        }
        f.resMap.getList(Timeline.class).lastId = noTimelines - 1;
    }

    private static void readGmObjects(ProjectFileContext c) throws IOException, GmFormatException {
        ProjectFile f = c.f;
        GmStreamDecoder in = c.in;
        int ver = in.read4();
        if (ver != 400 && ver != 800) {
            throw GmFileReader.versionError(f, "BEFORE", "OBJ", ver);
        }
        int noGmObjects = in.read4();
        int i = 0;
        while (i < noGmObjects) {
            if (ver == 800) {
                in.beginInflate();
            }
            if (!in.readBool()) {
                in.endInflate();
            } else {
                int ver2;
                ResourceReference<GmObject> r = c.objids.get(i);
                GmObject obj = r.get();
                f.resMap.getList(GmObject.class).add(obj);
                obj.setName(in.readStr());
                if (ver == 800) {
                    in.skip(8L);
                }
                if ((ver2 = in.read4()) != 430 && ver2 != 820) {
                    throw GmFileReader.versionError(f, "IN", "OBJ", i, ver2);
                }
                Sprite temp = f.resMap.getList(Sprite.class).getUnsafe(in.read4());
                if (temp != null) {
                    obj.put(GmObject.PGmObject.SPRITE, temp.reference);
                }
                in.readBool(obj.properties, new GmObject.PGmObject[]{GmObject.PGmObject.SOLID, GmObject.PGmObject.VISIBLE});
                obj.put(GmObject.PGmObject.DEPTH, in.read4());
                obj.put(GmObject.PGmObject.PERSISTENT, in.readBool());
                obj.put(GmObject.PGmObject.PARENT, c.objids.get(in.read4()));
                temp = f.resMap.getList(Sprite.class).getUnsafe(in.read4());
                if (temp != null) {
                    obj.put(GmObject.PGmObject.MASK, temp.reference);
                }
                int noEvents = in.read4() + 1;
                int j = 0;
                while (j < noEvents) {
                    MainEvent me = obj.mainEvents.get(j);
                    boolean done = false;
                    while (!done) {
                        int first = in.read4();
                        if (first != -1) {
                            Event ev = new Event();
                            me.events.add(0, ev);
                            if (j == 4) {
                                ev.other = c.objids.get(first);
                            } else {
                                ev.id = first;
                            }
                            ev.mainId = j;
                            ProjectFileContext fc = c.copy();
                            fc.in = in;
                            GmFileReader.readActions(fc, ev, "INOBJECTACTION", i, j * 1000 + ev.id);
                            continue;
                        }
                        done = true;
                    }
                    ++j;
                }
                if (ver2 >= 820) {
                    in.readBool(obj.properties, new GmObject.PGmObject[]{GmObject.PGmObject.PHYSICS_OBJECT, GmObject.PGmObject.PHYSICS_SENSOR});
                    in.read4(obj.properties, new GmObject.PGmObject[]{GmObject.PGmObject.PHYSICS_SHAPE});
                    in.readD(obj.properties, new GmObject.PGmObject[]{GmObject.PGmObject.PHYSICS_DENSITY, GmObject.PGmObject.PHYSICS_RESTITUTION});
                    in.read4(obj.properties, new GmObject.PGmObject[]{GmObject.PGmObject.PHYSICS_GROUP});
                    in.readD(obj.properties, new GmObject.PGmObject[]{GmObject.PGmObject.PHYSICS_DAMPING_LINEAR, GmObject.PGmObject.PHYSICS_DAMPING_ANGULAR});
                    int ptc = in.read4();
                    if (ver2 >= 821) {
                        in.readD(obj.properties, new GmObject.PGmObject[]{GmObject.PGmObject.PHYSICS_FRICTION});
                        in.readBool(obj.properties, new GmObject.PGmObject[]{GmObject.PGmObject.PHYSICS_AWAKE, GmObject.PGmObject.PHYSICS_KINEMATIC});
                    }
                    int j2 = 0;
                    while (j2 < ptc) {
                        obj.shapePoints.add(new ShapePoint(in.readD(), in.readD()));
                        ++j2;
                    }
                }
                in.endInflate();
            }
            ++i;
        }
        f.resMap.getList(GmObject.class).lastId = noGmObjects - 1;
    }

    private static void readRooms(ProjectFileContext c) throws IOException, GmFormatException {
        ProjectFile f = c.f;
        GmStreamDecoder in = c.in;
        int ver = in.read4();
        if (ver != 420 && ver != 800) {
            throw GmFileReader.versionError(f, "BEFORE", "RMM", ver);
        }
        int noRooms = in.read4();
        int i = 0;
        while (i < noRooms) {
            if (ver == 800) {
                in.beginInflate();
            }
            if (!in.readBool()) {
                in.endInflate();
            } else {
                int ver2;
                ResourceReference<Room> r = c.rmids.get(i);
                Room rm = r.get();
                f.resMap.getList(Room.class).add(rm);
                rm.setName(in.readStr());
                if (ver == 800) {
                    in.skip(8L);
                }
                if ((ver2 = in.read4()) != 520 && ver2 != 541 && ver2 != 810 && ver2 != 811 && ver2 != 820) {
                    throw GmFileReader.versionError(f, "IN", "RMM", i, ver2);
                }
                rm.put(Room.PRoom.CAPTION, in.readStr());
                in.read4(rm.properties, new Room.PRoom[]{Room.PRoom.WIDTH, Room.PRoom.HEIGHT, Room.PRoom.SNAP_Y, Room.PRoom.SNAP_X});
                rm.put(Room.PRoom.ISOMETRIC, in.readBool());
                rm.put(Room.PRoom.SPEED, in.read4());
                rm.put(Room.PRoom.PERSISTENT, in.readBool());
                rm.put(Room.PRoom.BACKGROUND_COLOR, Util.convertGmColor(in.read4()));
                int backgroundViewClear = in.read4();
                rm.put(Room.PRoom.DRAW_BACKGROUND_COLOR, (backgroundViewClear & 1) != 0);
                rm.put(Room.PRoom.VIEWS_CLEAR, (backgroundViewClear & 2) == 0);
                rm.put(Room.PRoom.CREATION_CODE, in.readStr());
                int nobackgrounds = in.read4();
                int j = 0;
                while (j < nobackgrounds) {
                    BackgroundDef bk = rm.backgroundDefs.get(j);
                    in.readBool(bk.properties, new BackgroundDef.PBackgroundDef[]{BackgroundDef.PBackgroundDef.VISIBLE, BackgroundDef.PBackgroundDef.FOREGROUND});
                    Background temp = f.resMap.getList(Background.class).getUnsafe(in.read4());
                    if (temp != null) {
                        bk.properties.put(BackgroundDef.PBackgroundDef.BACKGROUND, (Object)temp.reference);
                    }
                    in.read4(bk.properties, new BackgroundDef.PBackgroundDef[]{BackgroundDef.PBackgroundDef.X, BackgroundDef.PBackgroundDef.Y});
                    in.readBool(bk.properties, new BackgroundDef.PBackgroundDef[]{BackgroundDef.PBackgroundDef.TILE_HORIZ, BackgroundDef.PBackgroundDef.TILE_VERT});
                    in.read4(bk.properties, new BackgroundDef.PBackgroundDef[]{BackgroundDef.PBackgroundDef.H_SPEED, BackgroundDef.PBackgroundDef.V_SPEED});
                    bk.properties.put(BackgroundDef.PBackgroundDef.STRETCH, (Object)in.readBool());
                    ++j;
                }
                rm.put(Room.PRoom.VIEWS_ENABLED, in.readBool());
                int noviews = in.read4();
                int j2 = 0;
                while (j2 < noviews) {
                    View vw = rm.views.get(j2);
                    in.readBool(vw.properties, new View.PView[]{View.PView.VISIBLE});
                    in.read4(vw.properties, new View.PView[]{View.PView.VIEW_X, View.PView.VIEW_Y, View.PView.VIEW_W, View.PView.VIEW_H, View.PView.PORT_X, View.PView.PORT_Y});
                    if (ver2 > 520) {
                        in.read4(vw.properties, new View.PView[]{View.PView.PORT_W, View.PView.PORT_H});
                    } else {
                        vw.properties.put(View.PView.PORT_W, vw.properties.get(View.PView.VIEW_W));
                        vw.properties.put(View.PView.PORT_H, vw.properties.get(View.PView.VIEW_H));
                    }
                    in.read4(vw.properties, new View.PView[]{View.PView.BORDER_H, View.PView.BORDER_V, View.PView.SPEED_H, View.PView.SPEED_V});
                    GmObject temp = f.resMap.getList(GmObject.class).getUnsafe(in.read4());
                    if (temp != null) {
                        vw.properties.put(View.PView.OBJECT, (Object)temp.reference);
                    }
                    ++j2;
                }
                int noinstances = in.read4();
                int j3 = 0;
                while (j3 < noinstances) {
                    Instance inst = rm.addInstance();
                    inst.setPosition(new Point(in.read4(), in.read4()));
                    GmObject temp = f.resMap.getList(GmObject.class).getUnsafe(in.read4());
                    if (temp != null) {
                        inst.properties.put(Instance.PInstance.OBJECT, (Object)temp.reference);
                    }
                    inst.properties.put(Instance.PInstance.ID, (Object)in.read4());
                    inst.setCreationCode(in.readStr());
                    if (ver2 >= 810) {
                        in.readD(inst.properties, new Instance.PInstance[]{Instance.PInstance.SCALE_X, Instance.PInstance.SCALE_Y});
                        Color color = Util.convertGmColorWithAlpha(in.read4());
                        inst.setColor(color);
                        inst.setAlpha(color.getAlpha());
                    }
                    if (ver2 >= 811) {
                        inst.properties.put(Instance.PInstance.ROTATION, (Object)in.readD());
                    }
                    inst.setLocked(in.readBool());
                    ++j3;
                }
                int notiles = in.read4();
                int j4 = 0;
                while (j4 < notiles) {
                    Tile t = new Tile(rm);
                    t.setPosition(new Point(in.read4(), in.read4()));
                    Background temp = f.resMap.getList(Background.class).getUnsafe(in.read4());
                    ResourceReference bkg = null;
                    if (temp != null) {
                        bkg = temp.reference;
                    }
                    t.properties.put(Tile.PTile.BACKGROUND, (Object)bkg);
                    t.setBackgroundPosition(new Point(in.read4(), in.read4()));
                    t.setSize(new Dimension(in.read4(), in.read4()));
                    t.setDepth(in.read4());
                    t.properties.put(Tile.PTile.ID, (Object)in.read4());
                    if (ver2 >= 810) {
                        in.readD(t.properties, new Tile.PTile[]{Tile.PTile.SCALE_X, Tile.PTile.SCALE_Y});
                        Color color = Util.convertGmColorWithAlpha(in.read4());
                        t.setColor(color);
                        t.setAlpha(color.getAlpha());
                    }
                    t.setLocked(in.readBool());
                    rm.tiles.add(t);
                    ++j4;
                }
                if (ver2 >= 820) {
                    rm.put(Room.PRoom.PHYSICS_WORLD, in.readBool());
                    in.read4(rm.properties, new Room.PRoom[]{Room.PRoom.PHYSICS_TOP, Room.PRoom.PHYSICS_LEFT, Room.PRoom.PHYSICS_RIGHT, Room.PRoom.PHYSICS_BOTTOM});
                    in.readD(rm.properties, new Room.PRoom[]{Room.PRoom.PHYSICS_GRAVITY_X, Room.PRoom.PHYSICS_GRAVITY_Y, Room.PRoom.PHYSICS_PIXTOMETERS});
                }
                rm.put(Room.PRoom.REMEMBER_WINDOW_SIZE, in.readBool());
                in.read4(rm.properties, new Room.PRoom[]{Room.PRoom.EDITOR_WIDTH, Room.PRoom.EDITOR_HEIGHT});
                in.readBool(rm.properties, new Room.PRoom[]{Room.PRoom.SHOW_GRID, Room.PRoom.SHOW_OBJECTS, Room.PRoom.SHOW_TILES, Room.PRoom.SHOW_BACKGROUNDS, Room.PRoom.SHOW_FOREGROUNDS, Room.PRoom.SHOW_VIEWS, Room.PRoom.DELETE_UNDERLYING_OBJECTS, Room.PRoom.DELETE_UNDERLYING_TILES});
                if (ver2 == 520) {
                    in.skip(24L);
                }
                in.read4(rm.properties, new Room.PRoom[]{Room.PRoom.CURRENT_TAB, Room.PRoom.SCROLL_BAR_X, Room.PRoom.SCROLL_BAR_Y});
                in.endInflate();
            }
            ++i;
        }
        f.resMap.getList(Room.class).lastId = noRooms - 1;
    }

    private static void readIncludedFiles(ProjectFileContext c) throws IOException, GmFormatException {
        ProjectFile f = c.f;
        GmStreamDecoder in = c.in;
        int ver = in.read4();
        if (ver != 430 && ver != 600 && ver != 620 && ver != 800 && ver != 810) {
            throw GmFileReader.versionError(f, "BEFORE", "GMI", ver);
        }
        int noIncludes = in.read4();
        int i = 0;
        while (i < noIncludes) {
            if (ver >= 800) {
                in.beginInflate();
                in.skip(8L);
            }
            if ((ver = in.read4()) != 620 && ver != 800 && ver != 810) {
                ProjectFile.InterfaceProvider ip = ProjectFile.interfaceProvider;
                throw new GmFormatException(f, ip.format("ProjectFileReader.ERROR_UNSUPPORTED", ip.translate("ProjectFileReader.ININCLUDEDFILES"), ver));
            }
            Include inc = f.resMap.getList(Include.class).add();
            inc.put(Include.PInclude.FILENAME, in.readStr());
            inc.put(Include.PInclude.FILEPATH, in.readStr());
            inc.put(Include.PInclude.ORIGINAL, in.readBool());
            int size = in.read4();
            inc.put(Include.PInclude.SIZE, size);
            boolean store = in.readBool();
            inc.put(Include.PInclude.STORE, store);
            if (store) {
                int s = in.read4();
                inc.data = new byte[s];
                in.read(inc.data, 0, s);
            }
            inc.put(Include.PInclude.EXPORTACTION, (Object)ProjectFile.INCLUDE_EXPORT_ACTION[in.read4()]);
            inc.put(Include.PInclude.EXPORTFOLDER, in.readStr());
            inc.put(Include.PInclude.OVERWRITE, in.readBool());
            inc.put(Include.PInclude.FREEMEMORY, in.readBool());
            inc.put(Include.PInclude.REMOVEATGAMEEND, in.readBool());
            in.endInflate();
            ++i;
        }
    }

    private static void readPackages(ProjectFileContext c) throws IOException, GmFormatException {
        ProjectFile f = c.f;
        GmStreamDecoder in = c.in;
        int ver = in.read4();
        if (ver != 700) {
            throw GmFileReader.versionError(f, "BEFORE", "EXT", ver);
        }
        int noPackages = in.read4();
        int i = 0;
        while (i < noPackages) {
            f.packages.add(in.readStr());
            ++i;
        }
    }

    private static void readGameInformation(ProjectFileContext c) throws IOException, GmFormatException {
        int bc;
        GmStreamDecoder in = c.in;
        GameInformation gameInfo = c.f.gameInfo;
        PropertyMap p = gameInfo.properties;
        int ver = in.read4();
        if (ver != 430 && ver != 600 && ver != 620 && ver != 800 && ver != 810) {
            throw GmFileReader.versionError(c.f, "BEFORE", "GMI", ver);
        }
        if (ver >= 800) {
            in.beginInflate();
        }
        if ((bc = in.read4()) >= 0) {
            p.put(GameInformation.PGameInformation.BACKGROUND_COLOR, (Object)Util.convertGmColor(bc));
        }
        if (ver < 800) {
            in.readBool(p, new GameInformation.PGameInformation[]{GameInformation.PGameInformation.EMBED_GAME_WINDOW});
        } else {
            p.put(GameInformation.PGameInformation.EMBED_GAME_WINDOW, (Object)(!in.readBool() ? 1 : 0));
        }
        if (ver > 430) {
            in.readStr(p, new GameInformation.PGameInformation[]{GameInformation.PGameInformation.FORM_CAPTION});
            in.read4(p, new GameInformation.PGameInformation[]{GameInformation.PGameInformation.LEFT, GameInformation.PGameInformation.TOP, GameInformation.PGameInformation.WIDTH, GameInformation.PGameInformation.HEIGHT});
            in.readBool(p, new GameInformation.PGameInformation[]{GameInformation.PGameInformation.SHOW_BORDER, GameInformation.PGameInformation.ALLOW_RESIZE, GameInformation.PGameInformation.STAY_ON_TOP, GameInformation.PGameInformation.PAUSE_GAME});
        }
        if (ver >= 800) {
            in.skip(8L);
        }
        in.readStr(p, new GameInformation.PGameInformation[]{GameInformation.PGameInformation.TEXT});
        in.endInflate();
    }

    private static void readTree(ProjectFileContext c, ResNode root, int ver) throws IOException {
        ProjectFile f = c.f;
        GmStreamDecoder in = c.in;
        Stack<ResNode> path = new Stack<ResNode>();
        Stack<Integer> left = new Stack<Integer>();
        path.push(root);
        int rootnodes = ver > 540 ? 12 : 11;
        while (rootnodes-- > 0) {
            byte status = (byte)in.read4();
            Class<Object> type = ProjectFile.RESOURCE_KIND[in.read4()];
            if (ver == 500 && type == Font.class) {
                type = Include.class;
            }
            int ind = in.read4();
            String name = in.readStr();
            boolean hasRef = false;
            if (status == 3) {
                hasRef = type == Font.class ? ver != 500 : (type == null ? false : InstantiableResource.class.isAssignableFrom(type));
            }
            ResourceList rl = hasRef ? (ResourceList)f.resMap.get(type) : null;
            ResNode node = new ResNode(name, status, type, hasRef ? ((InstantiableResource)rl.getUnsafe((int)ind)).reference : null);
            if (ver == 500 && type == Include.class) {
                if (hasRef) {
                    ((Resource)rl.getUnsafe(ind)).setName(name);
                }
                if (status == 1) {
                    ((ResNode)path.peek()).addChild(ProjectFile.interfaceProvider.translate("LGM.FNT"), status, Font.class);
                }
            }
            ((ResNode)path.peek()).add(node);
            int contents = in.read4();
            if (contents > 0) {
                left.push(rootnodes);
                rootnodes = contents;
                path.push(node);
            }
            while (rootnodes == 0 && !left.isEmpty()) {
                rootnodes = (Integer)left.pop();
                path.pop();
            }
        }
        ResNode incRoot = null;
        if (ver == 500) {
            ResNode dataFileNode = (ResNode)root.getChildAt(6);
            if (dataFileNode instanceof ResNode) {
                incRoot = dataFileNode;
                incRoot.setUserObject("Includes");
                root.remove(incRoot);
            }
        } else {
            incRoot = new ResNode("Includes", 1, Include.class);
            for (Include inc : f.resMap.getList(Include.class)) {
                String filename = inc.get(Include.PInclude.FILENAME).toString();
                if (!filename.isEmpty()) {
                    inc.setName(Util.fileNameWithoutExtension(filename));
                }
                incRoot.add(new ResNode(inc.getName(), 3, Include.class, inc.reference));
            }
        }
        root.insert(incRoot, 9);
        if (ver <= 540) {
            root.addChild("Extension Packages", (byte)3, ExtensionPackages.class);
        }
        ResNode node = new ResNode("Shaders", 1, Shader.class);
        root.insert(node, 5);
        node = new ResNode("Extensions", 1, Extension.class);
        root.insert(node, 11);
        node = new ResNode("Constants", 3, Constants.class);
        root.insert(node, 12);
    }

    private static void readActions(ProjectFileContext c, ActionContainer container, String errorKey, int format1, int format2) throws IOException, GmFormatException {
        final ProjectFile f = c.f;
        GmStreamDecoder in = c.in;
        int ver = in.read4();
        if (ver != 400) {
            ProjectFile.InterfaceProvider ip = ProjectFile.interfaceProvider;
            throw new GmFormatException(f, ip.format("ProjectFileReader.ERROR_UNSUPPORTED", ip.format("ProjectFileReader." + errorKey, format1, format2), ver));
        }
        int noacts = in.read4();
        int k = 0;
        while (k < noacts) {
            boolean unknownLib;
            in.skip(4L);
            int libid = in.read4();
            int actid = in.read4();
            LibAction la = LibManager.getLibAction(libid, actid);
            boolean bl = unknownLib = la == null;
            if (unknownLib) {
                la = new LibAction();
                la.id = actid;
                la.parentId = libid;
                la.actionKind = (byte)in.read4();
                if (la.actionKind == 7) {
                    la = LibManager.codeAction;
                    in.skip(16L);
                    in.skip(in.read4());
                    in.skip(in.read4());
                } else {
                    la.allowRelative = in.readBool();
                    la.question = in.readBool();
                    la.canApplyTo = in.readBool();
                    la.execType = (byte)in.read4();
                    if (la.execType == 1) {
                        la.execInfo = in.readStr();
                    } else {
                        in.skip(in.read4());
                    }
                    if (la.execType == 2) {
                        la.execInfo = in.readStr();
                    } else {
                        in.skip(in.read4());
                    }
                }
            } else {
                in.skip(20L);
                in.skip(in.read4());
                in.skip(in.read4());
            }
            Argument[] args = new Argument[in.read4()];
            byte[] argkinds = new byte[in.read4()];
            int x = 0;
            while (x < argkinds.length) {
                argkinds[x] = (byte)in.read4();
                ++x;
            }
            if (unknownLib) {
                la.libArguments = new LibArgument[argkinds.length];
                x = 0;
                while (x < argkinds.length) {
                    la.libArguments[x] = new LibArgument();
                    la.libArguments[x].kind = argkinds[x];
                    ++x;
                }
            }
            Action act = container.addAction(la);
            int appliesTo = in.read4();
            switch (appliesTo) {
                case -1: {
                    act.setAppliesTo(GmObject.OBJECT_SELF);
                    break;
                }
                case -2: {
                    act.setAppliesTo(GmObject.OBJECT_OTHER);
                    break;
                }
                default: {
                    act.setAppliesTo(c.objids.get(appliesTo));
                }
            }
            act.setRelative(in.readBool());
            int actualnoargs = in.read4();
            int l = 0;
            while (l < actualnoargs) {
                if (l >= args.length) {
                    in.skip(in.read4());
                } else {
                    args[l] = new Argument(argkinds[l]);
                    String strval = in.readStr();
                    args[l].setVal(strval);
                    Class<? extends Resource<?, ?>> kind = Argument.getResourceKind(argkinds[l]);
                    if (kind != null && Resource.class.isAssignableFrom(kind)) {
                        try {
                            final int id = Integer.parseInt(strval);
                            final Argument arg = args[l];
                            PostponedRef pr = new PostponedRef(){

                                @Override
                                public boolean invoke() {
                                    ProjectFile.ResourceHolder rh = (ProjectFile.ResourceHolder)f.resMap.get(Argument.getResourceKind(arg.kind));
                                    Object temp = null;
                                    temp = rh instanceof ResourceList ? ((ResourceList)rh).getUnsafe(id) : rh.getResource();
                                    if (temp != null) {
                                        arg.setRes(temp.reference);
                                    }
                                    return temp != null;
                                }
                            };
                            if (!pr.invoke()) {
                                postpone.add(pr);
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    act.setArguments(args);
                }
                ++l;
            }
            act.setNot(in.readBool());
            ++k;
        }
    }

    static interface PostponedRef {
        public boolean invoke();
    }

    private static class ProjectFileContext {
        ProjectFile f;
        GmStreamDecoder in;
        RefList<Timeline> timeids;
        RefList<GmObject> objids;
        RefList<Room> rmids;

        public ProjectFileContext(ProjectFile f, GmStreamDecoder in, RefList<Timeline> timeids, RefList<GmObject> objids, RefList<Room> rmids) {
            this.f = f;
            this.in = in;
            this.timeids = timeids;
            this.objids = objids;
            this.rmids = rmids;
        }

        public ProjectFileContext copy() {
            return new ProjectFileContext(this.f, this.in, this.timeids, this.objids, this.rmids);
        }
    }
}

