/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.file;

import com.sun.org.apache.xerces.internal.impl.dv.util.HexBin;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.lateralgm.components.impl.ResNode;
import org.lateralgm.file.GmFormatException;
import org.lateralgm.file.ProjectFile;
import org.lateralgm.file.ResourceList;
import org.lateralgm.file.iconio.ICOFile;
import org.lateralgm.main.Util;
import org.lateralgm.resources.Background;
import org.lateralgm.resources.Constants;
import org.lateralgm.resources.Font;
import org.lateralgm.resources.GameInformation;
import org.lateralgm.resources.GameSettings;
import org.lateralgm.resources.GmObject;
import org.lateralgm.resources.Include;
import org.lateralgm.resources.InstantiableResource;
import org.lateralgm.resources.Path;
import org.lateralgm.resources.Resource;
import org.lateralgm.resources.ResourceReference;
import org.lateralgm.resources.Room;
import org.lateralgm.resources.Script;
import org.lateralgm.resources.Shader;
import org.lateralgm.resources.Sound;
import org.lateralgm.resources.Sprite;
import org.lateralgm.resources.Timeline;
import org.lateralgm.resources.library.LibAction;
import org.lateralgm.resources.sub.Action;
import org.lateralgm.resources.sub.ActionContainer;
import org.lateralgm.resources.sub.Argument;
import org.lateralgm.resources.sub.BackgroundDef;
import org.lateralgm.resources.sub.CharacterRange;
import org.lateralgm.resources.sub.Constant;
import org.lateralgm.resources.sub.Event;
import org.lateralgm.resources.sub.GlyphMetric;
import org.lateralgm.resources.sub.Instance;
import org.lateralgm.resources.sub.MainEvent;
import org.lateralgm.resources.sub.Moment;
import org.lateralgm.resources.sub.PathPoint;
import org.lateralgm.resources.sub.ShapePoint;
import org.lateralgm.resources.sub.Tile;
import org.lateralgm.resources.sub.View;
import org.lateralgm.util.PropertyMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class GMXFileWriter {
    private static DocumentBuilder documentBuilder;
    private static Transformer transformer;
    public static HashMap<Class<?>, String> tagNames;
    public static HashMap<Class<?>, String> rootNames;

    static {
        tagNames = new HashMap();
        rootNames = new HashMap();
        tagNames.put(Sprite.class, "sprites");
        tagNames.put(Sound.class, "sounds");
        tagNames.put(Background.class, "backgrounds");
        tagNames.put(Path.class, "paths");
        tagNames.put(Script.class, "scripts");
        tagNames.put(Shader.class, "shaders");
        tagNames.put(Font.class, "fonts");
        tagNames.put(Timeline.class, "timelines");
        tagNames.put(GmObject.class, "objects");
        tagNames.put(Room.class, "rooms");
        tagNames.put(Include.class, "datafiles");
        rootNames.put(Sprite.class, "sprites");
        rootNames.put(Sound.class, "sound");
        rootNames.put(Background.class, "background");
        rootNames.put(Path.class, "paths");
        rootNames.put(Script.class, "scripts");
        rootNames.put(Shader.class, "shaders");
        rootNames.put(Font.class, "fonts");
        rootNames.put(Timeline.class, "timelines");
        rootNames.put(GmObject.class, "objects");
        rootNames.put(Room.class, "rooms");
        rootNames.put(Include.class, "datafiles");
    }

    private GMXFileWriter() {
    }

    public static void writeProjectFile(OutputStream os, ProjectFile f, ResNode rootRes) throws IOException, GmFormatException {
        ProjectFile.interfaceProvider.init(160, "ProgressDialog.GMX_SAVING");
        f.format = ProjectFile.FormatFlavor.GMX;
        long savetime = System.currentTimeMillis();
        if (documentBuilder == null) {
            try {
                documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            }
            catch (ParserConfigurationException pce) {
                throw new GmFormatException(f, pce);
            }
        }
        if (transformer == null) {
            try {
                transformer = TransformerFactory.newInstance().newTransformer();
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("method", "xml");
                transformer.setOutputProperty("encoding", "UTF-8");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            }
            catch (TransformerConfigurationException e) {
                throw new GmFormatException(f, e);
            }
            catch (TransformerFactoryConfigurationError e) {
                throw e;
            }
        }
        Document dom = documentBuilder.newDocument();
        ProjectFileContext c = new ProjectFileContext(f, dom);
        Element root = dom.createElement("assets");
        ProjectFile.interfaceProvider.setProgress(0, "ProgressDialog.SETTINGS");
        GMXFileWriter.writeConfigurations(c, root, savetime);
        ProjectFile.interfaceProvider.setProgress(10, "ProgressDialog.SPRITES");
        GMXFileWriter.writeGroup(c, root, Sprite.class);
        ProjectFile.interfaceProvider.setProgress(20, "ProgressDialog.SOUNDS");
        GMXFileWriter.writeGroup(c, root, Sound.class);
        ProjectFile.interfaceProvider.setProgress(30, "ProgressDialog.BACKGROUNDS");
        GMXFileWriter.writeGroup(c, root, Background.class);
        ProjectFile.interfaceProvider.setProgress(40, "ProgressDialog.PATHS");
        GMXFileWriter.writeGroup(c, root, Path.class);
        ProjectFile.interfaceProvider.setProgress(50, "ProgressDialog.SCRIPTS");
        GMXFileWriter.writeGroup(c, root, Script.class);
        ProjectFile.interfaceProvider.setProgress(60, "ProgressDialog.SHADERS");
        GMXFileWriter.writeGroup(c, root, Shader.class);
        ProjectFile.interfaceProvider.setProgress(70, "ProgressDialog.FONTS");
        GMXFileWriter.writeGroup(c, root, Font.class);
        ProjectFile.interfaceProvider.setProgress(80, "ProgressDialog.TIMELINES");
        GMXFileWriter.writeGroup(c, root, Timeline.class);
        ProjectFile.interfaceProvider.setProgress(90, "ProgressDialog.OBJECTS");
        GMXFileWriter.writeGroup(c, root, GmObject.class);
        ProjectFile.interfaceProvider.setProgress(100, "ProgressDialog.ROOMS");
        GMXFileWriter.writeGroup(c, root, Room.class);
        ProjectFile.interfaceProvider.setProgress(110, "ProgressDialog.INCLUDEFILES");
        GMXFileWriter.writeGroup(c, root, Include.class);
        ProjectFile.interfaceProvider.setProgress(120, "ProgressDialog.PACKAGES");
        ProjectFile.interfaceProvider.setProgress(130, "ProgressDialog.CONSTANTS");
        GMXFileWriter.writeDefaultConstants(c, root);
        ProjectFile.interfaceProvider.setProgress(140, "ProgressDialog.EXTENSIONS");
        ProjectFile.interfaceProvider.setProgress(150, "ProgressDialog.GAMEINFORMATION");
        GMXFileWriter.writeGameInformation(c, root);
        dom.appendChild(root);
        ProjectFile.interfaceProvider.setProgress(150, "ProgressDialog.DOCUMENT");
        try {
            try {
                transformer.transform(new DOMSource(dom), new StreamResult(os));
            }
            catch (TransformerException te) {
                throw new GmFormatException(f, te);
            }
        }
        finally {
            os.close();
        }
        ProjectFile.interfaceProvider.setProgress(160, "ProgressDialog.FINISHED");
    }

    private static Element createElement(Document dom, String name, String value) {
        Element ret = dom.createElement(name);
        ret.setTextContent(value);
        return ret;
    }

    private static void transformDocumentWrapped(ProjectFile f, Document document, File file) throws GmFormatException {
        file.getParentFile().mkdirs();
        try {
            transformer.transform(new DOMSource(document), new StreamResult(file));
        }
        catch (TransformerException e) {
            throw new GmFormatException(f, "failed to transform: " + file.getAbsolutePath(), e);
        }
    }

    private static void transformDocumentUnchecked(ProjectFile f, Document document, File file) {
        try {
            GMXFileWriter.transformDocumentWrapped(f, document, file);
        }
        catch (GmFormatException e) {
            ProjectFile.interfaceProvider.handleException(e);
        }
    }

    private static ResNode getPrimaryNode(ResNode first) {
        while (first.status != 1) {
            first = (ResNode)first.getParent();
        }
        return first;
    }

    private static String boolToString(Boolean bool) {
        return bool != false ? "-1" : "0";
    }

    public static <R extends Resource<R, ?>> String getName(ResourceReference<R> ref) {
        return GMXFileWriter.getName(ref, "<undefined>");
    }

    public static <R extends Resource<R, ?>> String getName(ResourceReference<R> ref, String noneval) {
        R res = Util.deRef(ref);
        if (res != null && res instanceof InstantiableResource) {
            return ((InstantiableResource)res).getName();
        }
        return noneval;
    }

    public static <R extends Resource<R, ?>> int getId(ResourceReference<R> ref) {
        return GMXFileWriter.getId(ref, -1);
    }

    public static <R extends Resource<R, ?>> int getId(ResourceReference<R> ref, int noneval) {
        R res = Util.deRef(ref);
        if (res != null && res instanceof InstantiableResource) {
            return ((InstantiableResource)res).getId();
        }
        return noneval;
    }

    public static <R extends InstantiableResource<R, ?>> void writeGroup(ProjectFileContext c, Element root, Class<R> kind) throws IOException {
        ResourceList<R> list = c.f.resMap.getList(kind);
        if (list.isEmpty()) {
            return;
        }
        GMXFileWriter.writeTree(c, GMXFileWriter.getPrimaryNode(((InstantiableResource)list.first()).getNode()), root);
    }

    private static void writeTree(ProjectFileContext c, ResNode root, Element domRoot) throws IOException {
        Document dom = c.dom;
        String name = root.getUserObject().toString();
        if (root.status == 1) {
            name = rootNames.get(root.kind);
        }
        Element pnode = dom.createElement(tagNames.get(root.kind));
        pnode.setAttribute("name", name);
        domRoot.appendChild(pnode);
        domRoot = pnode;
        Vector<ResNode> children = root.getChildren();
        if (children == null) {
            return;
        }
        for (ResNode obj : children) {
            if (!(obj instanceof ResNode)) continue;
            ResNode resNode = obj;
            Class<?> kind = resNode.kind;
            switch (resNode.status) {
                case 1: 
                case 2: {
                    GMXFileWriter.writeTree(c, resNode, domRoot);
                    break;
                }
                case 3: {
                    if (kind == Sprite.class) {
                        GMXFileWriter.writeSprite(c, resNode, domRoot);
                        break;
                    }
                    if (kind == Sound.class) {
                        GMXFileWriter.writeSound(c, resNode, domRoot);
                        break;
                    }
                    if (kind == Background.class) {
                        GMXFileWriter.writeBackground(c, resNode, domRoot);
                        break;
                    }
                    if (kind == Path.class) {
                        GMXFileWriter.writePath(c, resNode, domRoot);
                        break;
                    }
                    if (kind == Script.class) {
                        GMXFileWriter.writeScript(c, resNode, domRoot);
                        break;
                    }
                    if (kind == Shader.class) {
                        GMXFileWriter.writeShader(c, resNode, domRoot);
                        break;
                    }
                    if (kind == Font.class) {
                        GMXFileWriter.writeFont(c, resNode, domRoot);
                        break;
                    }
                    if (kind == Timeline.class) {
                        GMXFileWriter.writeTimeline(c, resNode, domRoot);
                        break;
                    }
                    if (kind == GmObject.class) {
                        GMXFileWriter.writeGmObject(c, resNode, domRoot);
                        break;
                    }
                    if (kind == Room.class) {
                        GMXFileWriter.writeRoom(c, resNode, domRoot);
                        break;
                    }
                    if (kind != Include.class) break;
                    GMXFileWriter.writeInclude(c, resNode, domRoot);
                }
            }
        }
    }

    public static void writeConfigurations(ProjectFileContext c, Element root, long savetime) throws IOException {
        Document dom = c.dom;
        ProjectFile f = c.f;
        Element conNode = dom.createElement("Configs");
        conNode.setAttribute("name", "configs");
        root.appendChild(conNode);
        for (GameSettings gs : f.gameSettings) {
            Element setNode = dom.createElement("Config");
            String configDir = "Configs\\" + gs.getName();
            setNode.setTextContent(configDir);
            conNode.appendChild(setNode);
            Document doc = documentBuilder.newDocument();
            Element nconNode = doc.createElement("Config");
            doc.appendChild(nconNode);
            Element optNode = doc.createElement("Options");
            nconNode.appendChild(optNode);
            long syncvertex = 0L;
            if (((Boolean)gs.get(GameSettings.PGameSettings.USE_SYNCHRONIZATION)).booleanValue()) {
                ++syncvertex;
            }
            if (((Boolean)gs.get(GameSettings.PGameSettings.FORCE_SOFTWARE_VERTEX_PROCESSING)).booleanValue()) {
                syncvertex += 0x80000000L;
            }
            optNode.appendChild(GMXFileWriter.createElement(doc, "option_sync_vertex", Long.toString(syncvertex)));
            optNode.appendChild(GMXFileWriter.createElement(doc, "option_use_new_audio", gs.get(GameSettings.PGameSettings.USE_NEW_AUDIO).toString()));
            optNode.appendChild(GMXFileWriter.createElement(doc, "option_shortcircuit", gs.get(GameSettings.PGameSettings.SHORT_CIRCUIT_EVAL).toString()));
            optNode.appendChild(GMXFileWriter.createElement(doc, "option_use_fast_collision", gs.get(GameSettings.PGameSettings.USE_FAST_COLLISION).toString()));
            optNode.appendChild(GMXFileWriter.createElement(doc, "option_fast_collision_compatibility", gs.get(GameSettings.PGameSettings.FAST_COLLISION_COMPAT).toString()));
            optNode.appendChild(GMXFileWriter.createElement(doc, "option_fullscreen", gs.get(GameSettings.PGameSettings.START_FULLSCREEN).toString()));
            optNode.appendChild(GMXFileWriter.createElement(doc, "option_sizeable", gs.get(GameSettings.PGameSettings.ALLOW_WINDOW_RESIZE).toString()));
            optNode.appendChild(GMXFileWriter.createElement(doc, "option_stayontop", gs.get(GameSettings.PGameSettings.ALWAYS_ON_TOP).toString()));
            optNode.appendChild(GMXFileWriter.createElement(doc, "option_aborterrors", gs.get(GameSettings.PGameSettings.ABORT_ON_ERROR).toString()));
            optNode.appendChild(GMXFileWriter.createElement(doc, "option_noscreensaver", gs.get(GameSettings.PGameSettings.DISABLE_SCREENSAVERS).toString()));
            optNode.appendChild(GMXFileWriter.createElement(doc, "option_showcursor", gs.get(GameSettings.PGameSettings.DISPLAY_CURSOR).toString()));
            optNode.appendChild(GMXFileWriter.createElement(doc, "option_displayerrors", gs.get(GameSettings.PGameSettings.DISPLAY_ERRORS).toString()));
            optNode.appendChild(GMXFileWriter.createElement(doc, "option_noborder", gs.get(GameSettings.PGameSettings.DONT_DRAW_BORDER).toString()));
            optNode.appendChild(GMXFileWriter.createElement(doc, "option_nobuttons", gs.get(GameSettings.PGameSettings.DONT_SHOW_BUTTONS).toString()));
            optNode.appendChild(GMXFileWriter.createElement(doc, "option_argumenterrors", gs.get(GameSettings.PGameSettings.ERROR_ON_ARGS).toString()));
            optNode.appendChild(GMXFileWriter.createElement(doc, "option_freeze", gs.get(GameSettings.PGameSettings.FREEZE_ON_LOSE_FOCUS).toString()));
            optNode.appendChild(GMXFileWriter.createElement(doc, "option_colordepth", ProjectFile.GS_DEPTH_CODE.get(gs.get(GameSettings.PGameSettings.COLOR_DEPTH)).toString()));
            optNode.appendChild(GMXFileWriter.createElement(doc, "option_frequency", ProjectFile.GS_FREQ_CODE.get(gs.get(GameSettings.PGameSettings.FREQUENCY)).toString()));
            optNode.appendChild(GMXFileWriter.createElement(doc, "option_resolution", ProjectFile.GS_RESOL_CODE.get(gs.get(GameSettings.PGameSettings.RESOLUTION)).toString()));
            optNode.appendChild(GMXFileWriter.createElement(doc, "option_changeresolution", gs.get(GameSettings.PGameSettings.SET_RESOLUTION).toString()));
            optNode.appendChild(GMXFileWriter.createElement(doc, "option_priority", ProjectFile.GS_PRIORITY_CODE.get(gs.get(GameSettings.PGameSettings.GAME_PRIORITY)).toString()));
            optNode.appendChild(GMXFileWriter.createElement(doc, "option_closeesc", gs.get(GameSettings.PGameSettings.LET_ESC_END_GAME).toString()));
            optNode.appendChild(GMXFileWriter.createElement(doc, "option_interpolate", gs.get(GameSettings.PGameSettings.INTERPOLATE).toString()));
            optNode.appendChild(GMXFileWriter.createElement(doc, "option_scale", gs.get(GameSettings.PGameSettings.SCALING).toString()));
            optNode.appendChild(GMXFileWriter.createElement(doc, "option_closeesc", gs.get(GameSettings.PGameSettings.TREAT_CLOSE_AS_ESCAPE).toString()));
            gs.put(GameSettings.PGameSettings.LAST_CHANGED, (Object)ProjectFile.longTimeToGmTime(savetime));
            optNode.appendChild(GMXFileWriter.createElement(doc, "option_lastchanged", gs.get(GameSettings.PGameSettings.LAST_CHANGED).toString()));
            optNode.appendChild(GMXFileWriter.createElement(doc, "option_gameid", gs.get(GameSettings.PGameSettings.GAME_ID).toString()));
            String guid = HexBin.encode((byte[])gs.get(GameSettings.PGameSettings.GAME_GUID));
            optNode.appendChild(GMXFileWriter.createElement(doc, "option_gameguid", String.valueOf('{') + guid.substring(0, 8) + '-' + guid.substring(8, 12) + '-' + guid.substring(12, 16) + '-' + guid.substring(16, 20) + '-' + guid.substring(20, 32) + '}'));
            optNode.appendChild(GMXFileWriter.createElement(doc, "option_author", (String)gs.get(GameSettings.PGameSettings.AUTHOR)));
            optNode.appendChild(GMXFileWriter.createElement(doc, "option_version_company", (String)gs.get(GameSettings.PGameSettings.COMPANY)));
            optNode.appendChild(GMXFileWriter.createElement(doc, "option_version_copyright", (String)gs.get(GameSettings.PGameSettings.COPYRIGHT)));
            optNode.appendChild(GMXFileWriter.createElement(doc, "option_version_description", (String)gs.get(GameSettings.PGameSettings.DESCRIPTION)));
            optNode.appendChild(GMXFileWriter.createElement(doc, "option_version_product", (String)gs.get(GameSettings.PGameSettings.PRODUCT)));
            optNode.appendChild(GMXFileWriter.createElement(doc, "option_information", (String)gs.get(GameSettings.PGameSettings.INFORMATION)));
            optNode.appendChild(GMXFileWriter.createElement(doc, "option_version", gs.get(GameSettings.PGameSettings.VERSION).toString()));
            optNode.appendChild(GMXFileWriter.createElement(doc, "option_version_build", gs.get(GameSettings.PGameSettings.VERSION_BUILD).toString()));
            optNode.appendChild(GMXFileWriter.createElement(doc, "option_version_major", gs.get(GameSettings.PGameSettings.VERSION_MAJOR).toString()));
            optNode.appendChild(GMXFileWriter.createElement(doc, "option_version_minor", gs.get(GameSettings.PGameSettings.VERSION_MINOR).toString()));
            optNode.appendChild(GMXFileWriter.createElement(doc, "option_version_release", gs.get(GameSettings.PGameSettings.VERSION_RELEASE).toString()));
            optNode.appendChild(GMXFileWriter.createElement(doc, "option_windows_steam_app_id", gs.get(GameSettings.PGameSettings.WINDOWS_STEAM_ID).toString()));
            optNode.appendChild(GMXFileWriter.createElement(doc, "option_mac_steam_app_id", gs.get(GameSettings.PGameSettings.MAC_STEAM_ID).toString()));
            optNode.appendChild(GMXFileWriter.createElement(doc, "option_linux_steam_app_id", gs.get(GameSettings.PGameSettings.LINUX_STEAM_ID).toString()));
            optNode.appendChild(GMXFileWriter.createElement(doc, "option_windows_enable_steam", gs.get(GameSettings.PGameSettings.WINDOWS_STEAM_ENABLE).toString()));
            optNode.appendChild(GMXFileWriter.createElement(doc, "option_mac_enable_steam", gs.get(GameSettings.PGameSettings.MAC_STEAM_ENABLE).toString()));
            optNode.appendChild(GMXFileWriter.createElement(doc, "option_linux_enable_steam", gs.get(GameSettings.PGameSettings.LINUX_STEAM_ENABLE).toString()));
            Element cce = doc.createElement("ConfigConstants");
            GMXFileWriter.writeConstants(gs.constants, doc, cce);
            nconNode.appendChild(cce);
            String icoPath = String.valueOf(configDir) + "\\windows\\runner_icon.ico";
            optNode.appendChild(GMXFileWriter.createElement(doc, "option_windows_game_icon", icoPath));
            icoPath = String.valueOf(f.getDirectory()) + '\\' + icoPath;
            File icoFile = new File(Util.getPOSIXPath(icoPath)).getParentFile();
            icoFile.mkdirs();
            FileOutputStream fos = new FileOutputStream(Util.getPOSIXPath(icoPath));
            ((ICOFile)gs.get(GameSettings.PGameSettings.GAME_ICON)).write(fos);
            fos.close();
            File file = new File(Util.getPOSIXPath(String.valueOf(f.getDirectory()) + "/Configs/" + gs.getName() + ".config.gmx"));
            GMXFileWriter.transformDocumentUnchecked(f, doc, file);
        }
    }

    public static void writeConstants(Constants cnsts, Document dom, Element node) throws IOException {
        Element base = dom.createElement("constants");
        base.setAttribute("number", Integer.toString(cnsts.constants.size()));
        for (Constant cnst : cnsts.constants) {
            Element celement = dom.createElement("constant");
            celement.setAttribute("name", cnst.name);
            celement.setTextContent(cnst.value);
            base.appendChild(celement);
        }
        node.appendChild(base);
    }

    public static void writeDefaultConstants(ProjectFileContext c, Element root) throws IOException {
        GMXFileWriter.writeConstants(c.f.defaultConstants, c.dom, root);
    }

    private static void writeSprite(ProjectFileContext c, ResNode resNode, Element domRoot) throws IOException {
        Document dom = c.dom;
        ProjectFile f = c.f;
        Sprite spr = (Sprite)resNode.getRes().get();
        Element res = dom.createElement("sprite");
        String fname = String.valueOf(f.getDirectory()) + "\\sprites\\";
        res.setTextContent("sprites\\" + spr.getName());
        File imagesFile = new File(Util.getPOSIXPath(String.valueOf(fname) + "\\images"));
        imagesFile.mkdirs();
        Document doc = documentBuilder.newDocument();
        Element sprroot = doc.createElement("sprite");
        doc.appendChild(sprroot);
        sprroot.appendChild(GMXFileWriter.createElement(doc, "xorig", spr.get(Sprite.PSprite.ORIGIN_X).toString()));
        sprroot.appendChild(GMXFileWriter.createElement(doc, "yorigin", spr.get(Sprite.PSprite.ORIGIN_Y).toString()));
        sprroot.appendChild(GMXFileWriter.createElement(doc, "colkind", ProjectFile.SPRITE_MASK_CODE.get(spr.get(Sprite.PSprite.SHAPE)).toString()));
        sprroot.appendChild(GMXFileWriter.createElement(doc, "sepmasks", GMXFileWriter.boolToString((Boolean)spr.get(Sprite.PSprite.SEPARATE_MASK))));
        sprroot.appendChild(GMXFileWriter.createElement(doc, "bbox_left", spr.get(Sprite.PSprite.BB_LEFT).toString()));
        sprroot.appendChild(GMXFileWriter.createElement(doc, "bbox_right", spr.get(Sprite.PSprite.BB_RIGHT).toString()));
        sprroot.appendChild(GMXFileWriter.createElement(doc, "bbox_top", spr.get(Sprite.PSprite.BB_TOP).toString()));
        sprroot.appendChild(GMXFileWriter.createElement(doc, "bbox_bottom", spr.get(Sprite.PSprite.BB_BOTTOM).toString()));
        sprroot.appendChild(GMXFileWriter.createElement(doc, "bboxmode", ProjectFile.SPRITE_BB_CODE.get(spr.get(Sprite.PSprite.BB_MODE)).toString()));
        sprroot.appendChild(GMXFileWriter.createElement(doc, "coltolerance", spr.get(Sprite.PSprite.ALPHA_TOLERANCE).toString()));
        sprroot.appendChild(GMXFileWriter.createElement(doc, "HTile", GMXFileWriter.boolToString((Boolean)spr.get(Sprite.PSprite.TILE_HORIZONTALLY))));
        sprroot.appendChild(GMXFileWriter.createElement(doc, "VTile", GMXFileWriter.boolToString((Boolean)spr.get(Sprite.PSprite.TILE_VERTICALLY))));
        sprroot.appendChild(GMXFileWriter.createElement(doc, "For3D", GMXFileWriter.boolToString((Boolean)spr.get(Sprite.PSprite.FOR3D))));
        int width = spr.getWidth();
        int height = spr.getHeight();
        sprroot.appendChild(GMXFileWriter.createElement(doc, "width", Integer.toString(width)));
        sprroot.appendChild(GMXFileWriter.createElement(doc, "height", Integer.toString(height)));
        Element frameroot = doc.createElement("frames");
        int j = 0;
        while (j < spr.subImages.size()) {
            String framefname = "images\\" + spr.getName() + '_' + j + ".png";
            File outputfile = new File(Util.getPOSIXPath(String.valueOf(fname) + framefname));
            Element frameNode = GMXFileWriter.createElement(doc, "frame", framefname);
            frameNode.setAttribute("index", Integer.toString(j));
            frameroot.appendChild(frameNode);
            BufferedImage sub = (BufferedImage)spr.subImages.get(j);
            ImageIO.write((RenderedImage)((Boolean)spr.get(Sprite.PSprite.TRANSPARENT) != false ? Util.getTransparentImage(sub) : sub), "png", outputfile);
            ++j;
        }
        sprroot.appendChild(frameroot);
        File file = new File(Util.getPOSIXPath(String.valueOf(fname) + spr.getName() + ".sprite.gmx"));
        GMXFileWriter.transformDocumentUnchecked(f, doc, file);
        domRoot.appendChild(res);
    }

    private static void writeSound(ProjectFileContext c, ResNode resNode, Element domRoot) throws IOException {
        ProjectFile f = c.f;
        Document dom = c.dom;
        Sound snd = (Sound)resNode.getRes().get();
        Element res = dom.createElement("sound");
        String fname = String.valueOf(f.getDirectory()) + "\\sound\\";
        res.setTextContent("sound\\" + snd.getName());
        File audioFile = new File(Util.getPOSIXPath(String.valueOf(fname) + "\\audio"));
        audioFile.mkdirs();
        Document doc = documentBuilder.newDocument();
        Element sndroot = doc.createElement("sound");
        doc.appendChild(sndroot);
        String fileType = snd.get(Sound.PSound.FILE_TYPE).toString();
        String fileName = String.valueOf(snd.getName()) + fileType;
        sndroot.appendChild(GMXFileWriter.createElement(doc, "extension", fileType));
        sndroot.appendChild(GMXFileWriter.createElement(doc, "origname", "sound\\audio\\" + fileName));
        sndroot.appendChild(GMXFileWriter.createElement(doc, "kind", ProjectFile.SOUND_KIND_CODE.get(snd.get(Sound.PSound.KIND)).toString()));
        Element volumeRoot = doc.createElement("volume");
        volumeRoot.appendChild(GMXFileWriter.createElement(doc, "volume", snd.get(Sound.PSound.VOLUME).toString()));
        sndroot.appendChild(volumeRoot);
        Element bitRateRoot = doc.createElement("bitRates");
        bitRateRoot.appendChild(GMXFileWriter.createElement(doc, "bitRate", snd.get(Sound.PSound.BIT_RATE).toString()));
        sndroot.appendChild(bitRateRoot);
        Element sampleRateRoot = doc.createElement("sampleRates");
        sampleRateRoot.appendChild(GMXFileWriter.createElement(doc, "sampleRate", snd.get(Sound.PSound.SAMPLE_RATE).toString()));
        sndroot.appendChild(sampleRateRoot);
        Element typesRoot = doc.createElement("types");
        typesRoot.appendChild(GMXFileWriter.createElement(doc, "type", ProjectFile.SOUND_TYPE_CODE.get(snd.get(Sound.PSound.TYPE)).toString()));
        sndroot.appendChild(typesRoot);
        Element bitDepthRoot = doc.createElement("bitDepths");
        bitDepthRoot.appendChild(GMXFileWriter.createElement(doc, "bitDepth", snd.get(Sound.PSound.BIT_DEPTH).toString()));
        sndroot.appendChild(bitDepthRoot);
        sndroot.appendChild(GMXFileWriter.createElement(doc, "pan", snd.get(Sound.PSound.PAN).toString()));
        sndroot.appendChild(GMXFileWriter.createElement(doc, "preload", GMXFileWriter.boolToString((Boolean)snd.get(Sound.PSound.PRELOAD))));
        sndroot.appendChild(GMXFileWriter.createElement(doc, "compressed", GMXFileWriter.boolToString((Boolean)snd.get(Sound.PSound.COMPRESSED))));
        sndroot.appendChild(GMXFileWriter.createElement(doc, "streamed", GMXFileWriter.boolToString((Boolean)snd.get(Sound.PSound.STREAMED))));
        sndroot.appendChild(GMXFileWriter.createElement(doc, "uncompressOnLoad", GMXFileWriter.boolToString((Boolean)snd.get(Sound.PSound.DECOMPRESS_ON_LOAD))));
        sndroot.appendChild(GMXFileWriter.createElement(doc, "effects", Integer.toString(snd.getEffects())));
        sndroot.appendChild(GMXFileWriter.createElement(doc, "data", fileName));
        Util.writeFully(Util.getPOSIXPath(String.valueOf(fname) + "audio/" + fileName), snd.data);
        File file = new File(Util.getPOSIXPath(String.valueOf(fname) + resNode.getUserObject().toString() + ".sound.gmx"));
        GMXFileWriter.transformDocumentUnchecked(f, doc, file);
        domRoot.appendChild(res);
    }

    private static void writeBackground(ProjectFileContext c, ResNode resNode, Element domRoot) throws IOException {
        ProjectFile f = c.f;
        Document dom = c.dom;
        Background bkg = (Background)resNode.getRes().get();
        Element res = dom.createElement("background");
        String fname = String.valueOf(f.getDirectory()) + "\\background\\";
        res.setTextContent("background\\" + bkg.getName());
        File imagesFile = new File(Util.getPOSIXPath(String.valueOf(fname) + "\\images"));
        imagesFile.mkdirs();
        Document doc = documentBuilder.newDocument();
        Element bkgroot = doc.createElement("background");
        doc.appendChild(bkgroot);
        bkgroot.appendChild(GMXFileWriter.createElement(doc, "istileset", GMXFileWriter.boolToString((Boolean)bkg.get(Background.PBackground.USE_AS_TILESET))));
        bkgroot.appendChild(GMXFileWriter.createElement(doc, "tilewidth", bkg.get(Background.PBackground.TILE_WIDTH).toString()));
        bkgroot.appendChild(GMXFileWriter.createElement(doc, "tileheight", bkg.get(Background.PBackground.TILE_HEIGHT).toString()));
        bkgroot.appendChild(GMXFileWriter.createElement(doc, "tilexoff", bkg.get(Background.PBackground.H_OFFSET).toString()));
        bkgroot.appendChild(GMXFileWriter.createElement(doc, "tileyoff", bkg.get(Background.PBackground.V_OFFSET).toString()));
        bkgroot.appendChild(GMXFileWriter.createElement(doc, "tilehsep", bkg.get(Background.PBackground.H_SEP).toString()));
        bkgroot.appendChild(GMXFileWriter.createElement(doc, "tilevsep", bkg.get(Background.PBackground.V_SEP).toString()));
        bkgroot.appendChild(GMXFileWriter.createElement(doc, "HTile", GMXFileWriter.boolToString((Boolean)bkg.get(Background.PBackground.TILE_HORIZONTALLY))));
        bkgroot.appendChild(GMXFileWriter.createElement(doc, "VTile", GMXFileWriter.boolToString((Boolean)bkg.get(Background.PBackground.TILE_VERTICALLY))));
        bkgroot.appendChild(GMXFileWriter.createElement(doc, "For3D", GMXFileWriter.boolToString((Boolean)bkg.get(Background.PBackground.FOR3D))));
        int width = bkg.getWidth();
        int height = bkg.getHeight();
        bkgroot.appendChild(GMXFileWriter.createElement(doc, "width", Integer.toString(width)));
        bkgroot.appendChild(GMXFileWriter.createElement(doc, "height", Integer.toString(height)));
        bkgroot.appendChild(GMXFileWriter.createElement(doc, "data", "images\\" + bkg.getName() + ".png"));
        if (width > 0 && height > 0) {
            File outputfile = new File(Util.getPOSIXPath(String.valueOf(fname) + "images\\" + bkg.getName() + ".png"));
            ImageIO.write((RenderedImage)bkg.getBackgroundImage(), "png", outputfile);
        }
        File file = new File(Util.getPOSIXPath(String.valueOf(fname) + resNode.getUserObject().toString() + ".background.gmx"));
        GMXFileWriter.transformDocumentUnchecked(f, doc, file);
        domRoot.appendChild(res);
    }

    private static void writePath(ProjectFileContext c, ResNode resNode, Element domRoot) throws IOException {
        ProjectFile f = c.f;
        Document dom = c.dom;
        Path path = (Path)resNode.getRes().get();
        Element res = dom.createElement("path");
        String fname = String.valueOf(f.getDirectory()) + "\\paths\\";
        res.setTextContent("paths\\" + path.getName());
        File pathsFile = new File(Util.getPOSIXPath(String.valueOf(f.getDirectory()) + "/paths"));
        pathsFile.mkdir();
        Document doc = documentBuilder.newDocument();
        Element pathroot = doc.createElement("path");
        doc.appendChild(pathroot);
        int kind = (Boolean)path.get(Path.PPath.SMOOTH) != false ? 1 : 0;
        pathroot.appendChild(GMXFileWriter.createElement(doc, "kind", Integer.toString(kind)));
        int closed = (Boolean)path.get(Path.PPath.CLOSED) != false ? -1 : 0;
        pathroot.appendChild(GMXFileWriter.createElement(doc, "closed", Integer.toString(closed)));
        pathroot.appendChild(GMXFileWriter.createElement(doc, "precision", path.get(Path.PPath.PRECISION).toString()));
        pathroot.appendChild(GMXFileWriter.createElement(doc, "backroom", Integer.toString(GMXFileWriter.getId((ResourceReference)path.get(Path.PPath.BACKGROUND_ROOM)))));
        pathroot.appendChild(GMXFileWriter.createElement(doc, "hsnap", path.get(Path.PPath.SNAP_X).toString()));
        pathroot.appendChild(GMXFileWriter.createElement(doc, "vsnap", path.get(Path.PPath.SNAP_Y).toString()));
        Element rootpoint = doc.createElement("points");
        pathroot.appendChild(rootpoint);
        for (PathPoint p : path.points) {
            rootpoint.appendChild(GMXFileWriter.createElement(doc, "point", String.valueOf(p.getX()) + "," + p.getY() + ',' + p.getSpeed()));
        }
        File file = new File(Util.getPOSIXPath(String.valueOf(fname) + path.getName() + ".path.gmx"));
        GMXFileWriter.transformDocumentUnchecked(f, doc, file);
        domRoot.appendChild(res);
    }

    private static void writeScript(ProjectFileContext c, ResNode resNode, Element domRoot) throws IOException {
        ProjectFile f = c.f;
        Document dom = c.dom;
        Script scr = (Script)resNode.getRes().get();
        Element res = dom.createElement("script");
        String fname = "scripts\\" + scr.getName() + ".gml";
        res.setTextContent(fname);
        File file = new File(Util.getPOSIXPath(String.valueOf(f.getDirectory()) + "/scripts"));
        file.mkdir();
        try (Writer out = null;){
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(Util.getPOSIXPath(String.valueOf(f.getDirectory()) + '/' + Util.getPOSIXPath(fname))), "UTF-8"));
            out.write((String)scr.properties.get(Script.PScript.CODE));
        }
        domRoot.appendChild(res);
    }

    private static void writeShader(ProjectFileContext c, ResNode resNode, Element domRoot) throws IOException {
        ProjectFile f = c.f;
        Document dom = c.dom;
        Shader shr = (Shader)resNode.getRes().get();
        Element res = dom.createElement("shader");
        String fname = "shaders\\" + shr.getName() + ".shader";
        res.setTextContent(fname);
        res.setAttribute("type", shr.properties.get(Shader.PShader.TYPE).toString());
        File file = new File(Util.getPOSIXPath(String.valueOf(f.getDirectory()) + "/shaders"));
        file.mkdir();
        try (Writer out = null;){
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(Util.getPOSIXPath(String.valueOf(f.getDirectory()) + '/' + fname)), "UTF-8"));
            String code = shr.properties.get(Shader.PShader.VERTEX) + "\n//######################_==_YOYO_SHADER_MARKER_==_######################@~" + shr.properties.get(Shader.PShader.FRAGMENT);
            out.write(code);
        }
        domRoot.appendChild(res);
    }

    private static void writeFont(ProjectFileContext c, ResNode resNode, Element domRoot) throws IOException {
        ProjectFile f = c.f;
        Document dom = c.dom;
        Font fnt = (Font)resNode.getRes().get();
        Element res = dom.createElement("font");
        String fname = String.valueOf(f.getDirectory()) + "\\fonts\\";
        res.setTextContent("fonts\\" + fnt.getName());
        File fontsFile = new File(Util.getPOSIXPath(fname));
        fontsFile.mkdirs();
        Document doc = documentBuilder.newDocument();
        Element fntroot = doc.createElement("font");
        doc.appendChild(fntroot);
        fntroot.appendChild(GMXFileWriter.createElement(doc, "name", fnt.get(Font.PFont.FONT_NAME).toString()));
        fntroot.appendChild(GMXFileWriter.createElement(doc, "size", fnt.get(Font.PFont.SIZE).toString()));
        fntroot.appendChild(GMXFileWriter.createElement(doc, "bold", GMXFileWriter.boolToString((Boolean)fnt.get(Font.PFont.BOLD))));
        fntroot.appendChild(GMXFileWriter.createElement(doc, "italic", GMXFileWriter.boolToString((Boolean)fnt.get(Font.PFont.ITALIC))));
        fntroot.appendChild(GMXFileWriter.createElement(doc, "charset", fnt.get(Font.PFont.CHARSET).toString()));
        fntroot.appendChild(GMXFileWriter.createElement(doc, "aa", fnt.get(Font.PFont.ANTIALIAS).toString()));
        Element rangeroot = doc.createElement("ranges");
        fntroot.appendChild(rangeroot);
        for (CharacterRange cr : fnt.characterRanges) {
            rangeroot.appendChild(GMXFileWriter.createElement(doc, "range0", cr.properties.get(CharacterRange.PCharacterRange.RANGE_MIN) + "," + cr.properties.get(CharacterRange.PCharacterRange.RANGE_MAX)));
        }
        Element glyphroot = doc.createElement("glyphs");
        fntroot.appendChild(glyphroot);
        for (GlyphMetric gm : fnt.glyphMetrics) {
            Element gelement = doc.createElement("glyph");
            gelement.setAttribute("character", gm.properties.get(GlyphMetric.PGlyphMetric.CHARACTER).toString());
            gelement.setAttribute("x", gm.properties.get(GlyphMetric.PGlyphMetric.X).toString());
            gelement.setAttribute("y", gm.properties.get(GlyphMetric.PGlyphMetric.Y).toString());
            gelement.setAttribute("w", gm.properties.get(GlyphMetric.PGlyphMetric.W).toString());
            gelement.setAttribute("h", gm.properties.get(GlyphMetric.PGlyphMetric.H).toString());
            gelement.setAttribute("shift", gm.properties.get(GlyphMetric.PGlyphMetric.SHIFT).toString());
            gelement.setAttribute("offset", gm.properties.get(GlyphMetric.PGlyphMetric.OFFSET).toString());
            glyphroot.appendChild(gelement);
        }
        fntroot.appendChild(GMXFileWriter.createElement(doc, "image", String.valueOf(fnt.getName()) + ".png"));
        File file = new File(Util.getPOSIXPath(String.valueOf(fname) + fnt.getName() + ".font.gmx"));
        GMXFileWriter.transformDocumentUnchecked(f, doc, file);
        domRoot.appendChild(res);
    }

    private static void writeTimeline(ProjectFileContext c, ResNode resNode, Element domRoot) throws IOException {
        ProjectFile f = c.f;
        Document dom = c.dom;
        Timeline timeline = (Timeline)resNode.getRes().get();
        Element res = dom.createElement("timeline");
        String fname = String.valueOf(f.getDirectory()) + "\\timelines\\";
        res.setTextContent("timelines\\" + timeline.getName());
        File timelinesFile = new File(Util.getPOSIXPath(String.valueOf(f.getDirectory()) + "/timelines"));
        timelinesFile.mkdir();
        Document doc = documentBuilder.newDocument();
        Element tmlroot = doc.createElement("timeline");
        doc.appendChild(tmlroot);
        for (Moment mom : timeline.moments) {
            Element entroot = doc.createElement("entry");
            tmlroot.appendChild(entroot);
            entroot.appendChild(GMXFileWriter.createElement(doc, "step", Integer.toString(mom.stepNo)));
            Element evtroot = doc.createElement("event");
            entroot.appendChild(evtroot);
            GMXFileWriter.writeActions(doc, evtroot, mom);
        }
        File file = new File(Util.getPOSIXPath(String.valueOf(fname) + timeline.getName() + ".timeline.gmx"));
        GMXFileWriter.transformDocumentUnchecked(f, doc, file);
        domRoot.appendChild(res);
    }

    private static void writeGmObject(ProjectFileContext c, ResNode resNode, Element domRoot) throws IOException {
        ProjectFile f = c.f;
        Document dom = c.dom;
        GmObject object = (GmObject)resNode.getRes().get();
        Element res = dom.createElement("object");
        String fname = String.valueOf(f.getDirectory()) + "\\objects\\";
        res.setTextContent("objects\\" + object.getName());
        File objectsFile = new File(Util.getPOSIXPath(String.valueOf(f.getDirectory()) + "/objects"));
        objectsFile.mkdir();
        Document doc = documentBuilder.newDocument();
        Element objroot = doc.createElement("object");
        doc.appendChild(objroot);
        objroot.appendChild(GMXFileWriter.createElement(doc, "spriteName", GMXFileWriter.getName((ResourceReference)object.get(GmObject.PGmObject.SPRITE))));
        objroot.appendChild(GMXFileWriter.createElement(doc, "solid", GMXFileWriter.boolToString((Boolean)object.get(GmObject.PGmObject.SOLID))));
        objroot.appendChild(GMXFileWriter.createElement(doc, "visible", GMXFileWriter.boolToString((Boolean)object.get(GmObject.PGmObject.VISIBLE))));
        objroot.appendChild(GMXFileWriter.createElement(doc, "depth", object.get(GmObject.PGmObject.DEPTH).toString()));
        objroot.appendChild(GMXFileWriter.createElement(doc, "persistent", GMXFileWriter.boolToString((Boolean)object.get(GmObject.PGmObject.PERSISTENT))));
        objroot.appendChild(GMXFileWriter.createElement(doc, "maskName", GMXFileWriter.getName((ResourceReference)object.get(GmObject.PGmObject.MASK))));
        objroot.appendChild(GMXFileWriter.createElement(doc, "parentName", GMXFileWriter.getName((ResourceReference)object.get(GmObject.PGmObject.PARENT))));
        Element evtroot = doc.createElement("events");
        int i = 0;
        while (i < object.mainEvents.size()) {
            MainEvent me = object.mainEvents.get(i);
            int k = me.events.size();
            while (k > 0) {
                Event ev = me.events.get(k - 1);
                Element evtelement = doc.createElement("event");
                evtelement.setAttribute("eventtype", Integer.toString(ev.mainId));
                if (ev.mainId == 4) {
                    evtelement.setAttribute("ename", GMXFileWriter.getName(ev.other));
                } else {
                    evtelement.setAttribute("enumb", Integer.toString(ev.id));
                }
                evtroot.appendChild(evtelement);
                GMXFileWriter.writeActions(doc, evtelement, ev);
                --k;
            }
            ++i;
        }
        objroot.appendChild(evtroot);
        objroot.appendChild(GMXFileWriter.createElement(doc, "PhysicsObject", GMXFileWriter.boolToString((Boolean)object.get(GmObject.PGmObject.PHYSICS_OBJECT))));
        objroot.appendChild(GMXFileWriter.createElement(doc, "PhysicsObjectSensor", GMXFileWriter.boolToString((Boolean)object.get(GmObject.PGmObject.PHYSICS_SENSOR))));
        objroot.appendChild(GMXFileWriter.createElement(doc, "PhysicsObjectShape", ProjectFile.SHAPE_CODE.get(object.get(GmObject.PGmObject.PHYSICS_SHAPE)).toString()));
        objroot.appendChild(GMXFileWriter.createElement(doc, "PhysicsObjectDensity", Double.toString((Double)object.get(GmObject.PGmObject.PHYSICS_DENSITY))));
        objroot.appendChild(GMXFileWriter.createElement(doc, "PhysicsObjectRestitution", Double.toString((Double)object.get(GmObject.PGmObject.PHYSICS_RESTITUTION))));
        objroot.appendChild(GMXFileWriter.createElement(doc, "PhysicsObjectGroup", Integer.toString((Integer)object.get(GmObject.PGmObject.PHYSICS_GROUP))));
        objroot.appendChild(GMXFileWriter.createElement(doc, "PhysicsObjectLinearDamping", Double.toString((Double)object.get(GmObject.PGmObject.PHYSICS_DAMPING_LINEAR))));
        objroot.appendChild(GMXFileWriter.createElement(doc, "PhysicsObjectAngularDamping", Double.toString((Double)object.get(GmObject.PGmObject.PHYSICS_DAMPING_ANGULAR))));
        objroot.appendChild(GMXFileWriter.createElement(doc, "PhysicsObjectFriction", Double.toString((Double)object.get(GmObject.PGmObject.PHYSICS_FRICTION))));
        objroot.appendChild(GMXFileWriter.createElement(doc, "PhysicsObjectAwake", GMXFileWriter.boolToString((Boolean)object.get(GmObject.PGmObject.PHYSICS_AWAKE))));
        objroot.appendChild(GMXFileWriter.createElement(doc, "PhysicsObjectKinematic", GMXFileWriter.boolToString((Boolean)object.get(GmObject.PGmObject.PHYSICS_KINEMATIC))));
        Element pointsroot = doc.createElement("PhysicsShapePoints");
        for (ShapePoint point : object.shapePoints) {
            pointsroot.appendChild(GMXFileWriter.createElement(doc, "point", String.valueOf(point.getX()) + "," + point.getY()));
        }
        objroot.appendChild(pointsroot);
        File file = new File(Util.getPOSIXPath(String.valueOf(fname) + object.getName() + ".object.gmx"));
        GMXFileWriter.transformDocumentUnchecked(f, doc, file);
        domRoot.appendChild(res);
    }

    private static void writeRoom(ProjectFileContext c, ResNode resNode, Element domRoot) throws IOException {
        ProjectFile f = c.f;
        Document dom = c.dom;
        Room room = (Room)resNode.getRes().get();
        Element res = dom.createElement("room");
        String fname = String.valueOf(f.getDirectory()) + "\\rooms\\";
        res.setTextContent("rooms\\" + room.getName());
        File roomsFile = new File(Util.getPOSIXPath(String.valueOf(f.getDirectory()) + "/rooms"));
        roomsFile.mkdir();
        Document doc = documentBuilder.newDocument();
        Element roomroot = doc.createElement("room");
        doc.appendChild(roomroot);
        roomroot.appendChild(GMXFileWriter.createElement(doc, "caption", room.get(Room.PRoom.CAPTION).toString()));
        roomroot.appendChild(GMXFileWriter.createElement(doc, "width", room.get(Room.PRoom.WIDTH).toString()));
        roomroot.appendChild(GMXFileWriter.createElement(doc, "height", room.get(Room.PRoom.HEIGHT).toString()));
        roomroot.appendChild(GMXFileWriter.createElement(doc, "hsnap", room.get(Room.PRoom.SNAP_X).toString()));
        roomroot.appendChild(GMXFileWriter.createElement(doc, "vsnap", room.get(Room.PRoom.SNAP_Y).toString()));
        roomroot.appendChild(GMXFileWriter.createElement(doc, "isometric", GMXFileWriter.boolToString((Boolean)room.get(Room.PRoom.ISOMETRIC))));
        roomroot.appendChild(GMXFileWriter.createElement(doc, "speed", room.get(Room.PRoom.SPEED).toString()));
        roomroot.appendChild(GMXFileWriter.createElement(doc, "persistent", GMXFileWriter.boolToString((Boolean)room.get(Room.PRoom.PERSISTENT))));
        roomroot.appendChild(GMXFileWriter.createElement(doc, "colour", Integer.toString(Util.getGmColor((Color)room.get(Room.PRoom.BACKGROUND_COLOR)))));
        roomroot.appendChild(GMXFileWriter.createElement(doc, "showcolour", GMXFileWriter.boolToString((Boolean)room.get(Room.PRoom.DRAW_BACKGROUND_COLOR))));
        roomroot.appendChild(GMXFileWriter.createElement(doc, "code", room.get(Room.PRoom.CREATION_CODE).toString()));
        roomroot.appendChild(GMXFileWriter.createElement(doc, "enableViews", GMXFileWriter.boolToString((Boolean)room.get(Room.PRoom.VIEWS_ENABLED))));
        roomroot.appendChild(GMXFileWriter.createElement(doc, "clearViewBackground", GMXFileWriter.boolToString((Boolean)room.get(Room.PRoom.VIEWS_CLEAR))));
        Element mkeroot = doc.createElement("makerSettings");
        mkeroot.appendChild(GMXFileWriter.createElement(doc, "isSet", GMXFileWriter.boolToString((Boolean)room.get(Room.PRoom.REMEMBER_WINDOW_SIZE))));
        mkeroot.appendChild(GMXFileWriter.createElement(doc, "w", room.get(Room.PRoom.EDITOR_WIDTH).toString()));
        mkeroot.appendChild(GMXFileWriter.createElement(doc, "h", room.get(Room.PRoom.EDITOR_HEIGHT).toString()));
        mkeroot.appendChild(GMXFileWriter.createElement(doc, "showGrid", GMXFileWriter.boolToString((Boolean)room.get(Room.PRoom.SHOW_GRID))));
        mkeroot.appendChild(GMXFileWriter.createElement(doc, "showObjects", GMXFileWriter.boolToString((Boolean)room.get(Room.PRoom.SHOW_OBJECTS))));
        mkeroot.appendChild(GMXFileWriter.createElement(doc, "showTiles", GMXFileWriter.boolToString((Boolean)room.get(Room.PRoom.SHOW_TILES))));
        mkeroot.appendChild(GMXFileWriter.createElement(doc, "showBackgrounds", GMXFileWriter.boolToString((Boolean)room.get(Room.PRoom.SHOW_BACKGROUNDS))));
        mkeroot.appendChild(GMXFileWriter.createElement(doc, "showForegrounds", GMXFileWriter.boolToString((Boolean)room.get(Room.PRoom.SHOW_FOREGROUNDS))));
        mkeroot.appendChild(GMXFileWriter.createElement(doc, "showViews", GMXFileWriter.boolToString((Boolean)room.get(Room.PRoom.SHOW_VIEWS))));
        mkeroot.appendChild(GMXFileWriter.createElement(doc, "deleteUnderlyingObj", GMXFileWriter.boolToString((Boolean)room.get(Room.PRoom.DELETE_UNDERLYING_OBJECTS))));
        mkeroot.appendChild(GMXFileWriter.createElement(doc, "deleteUnderlyingTiles", GMXFileWriter.boolToString((Boolean)room.get(Room.PRoom.DELETE_UNDERLYING_TILES))));
        mkeroot.appendChild(GMXFileWriter.createElement(doc, "page", room.get(Room.PRoom.CURRENT_TAB).toString()));
        mkeroot.appendChild(GMXFileWriter.createElement(doc, "xoffset", room.get(Room.PRoom.SCROLL_BAR_X).toString()));
        mkeroot.appendChild(GMXFileWriter.createElement(doc, "yoffset", room.get(Room.PRoom.SCROLL_BAR_Y).toString()));
        roomroot.appendChild(mkeroot);
        Element backroot = doc.createElement("backgrounds");
        roomroot.appendChild(backroot);
        for (BackgroundDef back : room.backgroundDefs) {
            PropertyMap<BackgroundDef.PBackgroundDef> props = back.properties;
            Element bckelement = doc.createElement("background");
            backroot.appendChild(bckelement);
            bckelement.setAttribute("visible", GMXFileWriter.boolToString((Boolean)props.get(BackgroundDef.PBackgroundDef.VISIBLE)));
            bckelement.setAttribute("foreground", GMXFileWriter.boolToString((Boolean)props.get(BackgroundDef.PBackgroundDef.FOREGROUND)));
            bckelement.setAttribute("name", GMXFileWriter.getName((ResourceReference)props.get(BackgroundDef.PBackgroundDef.BACKGROUND), ""));
            bckelement.setAttribute("x", Integer.toString((Integer)props.get(BackgroundDef.PBackgroundDef.X)));
            bckelement.setAttribute("y", Integer.toString((Integer)props.get(BackgroundDef.PBackgroundDef.Y)));
            bckelement.setAttribute("htiled", GMXFileWriter.boolToString((Boolean)props.get(BackgroundDef.PBackgroundDef.TILE_HORIZ)));
            bckelement.setAttribute("vtiled", GMXFileWriter.boolToString((Boolean)props.get(BackgroundDef.PBackgroundDef.TILE_VERT)));
            bckelement.setAttribute("hspeed", Integer.toString((Integer)props.get(BackgroundDef.PBackgroundDef.H_SPEED)));
            bckelement.setAttribute("vspeed", Integer.toString((Integer)props.get(BackgroundDef.PBackgroundDef.V_SPEED)));
            bckelement.setAttribute("stretch", GMXFileWriter.boolToString((Boolean)props.get(BackgroundDef.PBackgroundDef.STRETCH)));
        }
        Element viewroot = doc.createElement("views");
        roomroot.appendChild(viewroot);
        for (View view : room.views) {
            PropertyMap<View.PView> props = view.properties;
            Element vwelement = doc.createElement("view");
            viewroot.appendChild(vwelement);
            vwelement.setAttribute("visible", GMXFileWriter.boolToString((Boolean)props.get(View.PView.VISIBLE)));
            vwelement.setAttribute("objName", GMXFileWriter.getName((ResourceReference)props.get(View.PView.OBJECT)));
            vwelement.setAttribute("xview", Integer.toString((Integer)props.get(View.PView.VIEW_X)));
            vwelement.setAttribute("yview", Integer.toString((Integer)props.get(View.PView.VIEW_Y)));
            vwelement.setAttribute("wview", Integer.toString((Integer)props.get(View.PView.VIEW_W)));
            vwelement.setAttribute("hview", Integer.toString((Integer)props.get(View.PView.VIEW_H)));
            vwelement.setAttribute("xport", Integer.toString((Integer)props.get(View.PView.PORT_X)));
            vwelement.setAttribute("yport", Integer.toString((Integer)props.get(View.PView.PORT_Y)));
            vwelement.setAttribute("wport", Integer.toString((Integer)props.get(View.PView.PORT_W)));
            vwelement.setAttribute("hport", Integer.toString((Integer)props.get(View.PView.PORT_H)));
            vwelement.setAttribute("hborder", Integer.toString((Integer)props.get(View.PView.BORDER_H)));
            vwelement.setAttribute("vborder", Integer.toString((Integer)props.get(View.PView.BORDER_V)));
            vwelement.setAttribute("hspeed", Integer.toString((Integer)props.get(View.PView.SPEED_H)));
            vwelement.setAttribute("vspeed", Integer.toString((Integer)props.get(View.PView.SPEED_V)));
        }
        Element insroot = doc.createElement("instances");
        roomroot.appendChild(insroot);
        for (Instance in : room.instances) {
            Element inselement = doc.createElement("instance");
            insroot.appendChild(inselement);
            inselement.setAttribute("objName", GMXFileWriter.getName((ResourceReference)in.properties.get(Instance.PInstance.OBJECT)));
            inselement.setAttribute("x", Integer.toString(in.getPosition().x));
            inselement.setAttribute("y", Integer.toString(in.getPosition().y));
            inselement.setAttribute("name", in.getName());
            inselement.setAttribute("id", Integer.toString(in.getID()));
            inselement.setAttribute("locked", GMXFileWriter.boolToString(in.isLocked()));
            inselement.setAttribute("code", in.getCreationCode());
            inselement.setAttribute("scaleX", Double.toString(in.getScale().getX()));
            inselement.setAttribute("scaleY", Double.toString(in.getScale().getY()));
            String color = Long.toString(Util.getInstanceColorWithAlpha(in.getColor(), in.getAlpha()));
            inselement.setAttribute("colour", color);
            inselement.setAttribute("rotation", Double.toString(in.getRotation()));
        }
        Element tileroot = doc.createElement("tiles");
        roomroot.appendChild(tileroot);
        for (Tile tile : room.tiles) {
            PropertyMap<Tile.PTile> props = tile.properties;
            Element tileelement = doc.createElement("tile");
            tileroot.appendChild(tileelement);
            tileelement.setAttribute("bgName", GMXFileWriter.getName((ResourceReference)props.get(Tile.PTile.BACKGROUND), ""));
            tileelement.setAttribute("x", Integer.toString((Integer)props.get(Tile.PTile.ROOM_X)));
            tileelement.setAttribute("y", Integer.toString((Integer)props.get(Tile.PTile.ROOM_Y)));
            tileelement.setAttribute("w", Integer.toString((Integer)props.get(Tile.PTile.WIDTH)));
            tileelement.setAttribute("h", Integer.toString((Integer)props.get(Tile.PTile.HEIGHT)));
            tileelement.setAttribute("xo", Integer.toString((Integer)props.get(Tile.PTile.BG_X)));
            tileelement.setAttribute("yo", Integer.toString((Integer)props.get(Tile.PTile.BG_Y)));
            tileelement.setAttribute("id", Integer.toString((Integer)props.get(Tile.PTile.ID)));
            tileelement.setAttribute("name", (String)props.get(Tile.PTile.NAME));
            tileelement.setAttribute("depth", Integer.toString(tile.getDepth()));
            tileelement.setAttribute("locked", GMXFileWriter.boolToString(tile.isLocked()));
            Point2D scale = tile.getScale();
            tileelement.setAttribute("scaleX", Double.toString(scale.getX()));
            tileelement.setAttribute("scaleY", Double.toString(scale.getY()));
            tileelement.setAttribute("colour", Long.toString(tile.getColor()));
        }
        roomroot.appendChild(GMXFileWriter.createElement(doc, "PhysicsWorld", GMXFileWriter.boolToString((Boolean)room.get(Room.PRoom.PHYSICS_WORLD))));
        roomroot.appendChild(GMXFileWriter.createElement(doc, "PhysicsWorldTop", Integer.toString((Integer)room.get(Room.PRoom.PHYSICS_TOP))));
        roomroot.appendChild(GMXFileWriter.createElement(doc, "PhysicsWorldLeft", Integer.toString((Integer)room.get(Room.PRoom.PHYSICS_LEFT))));
        roomroot.appendChild(GMXFileWriter.createElement(doc, "PhysicsWorldRight", Integer.toString((Integer)room.get(Room.PRoom.PHYSICS_RIGHT))));
        roomroot.appendChild(GMXFileWriter.createElement(doc, "PhysicsWorldBottom", Integer.toString((Integer)room.get(Room.PRoom.PHYSICS_BOTTOM))));
        roomroot.appendChild(GMXFileWriter.createElement(doc, "PhysicsWorldGravityX", Double.toString((Double)room.get(Room.PRoom.PHYSICS_GRAVITY_X))));
        roomroot.appendChild(GMXFileWriter.createElement(doc, "PhysicsWorldGravityY", Double.toString((Double)room.get(Room.PRoom.PHYSICS_GRAVITY_Y))));
        roomroot.appendChild(GMXFileWriter.createElement(doc, "PhysicsWorldPixToMeters", Double.toString((Double)room.get(Room.PRoom.PHYSICS_PIXTOMETERS))));
        File file = new File(Util.getPOSIXPath(String.valueOf(fname) + room.getName() + ".room.gmx"));
        GMXFileWriter.transformDocumentUnchecked(f, doc, file);
        domRoot.appendChild(res);
    }

    private static void writeInclude(ProjectFileContext c, ResNode resNode, Element domRoot) throws IOException {
        ProjectFile f = c.f;
        Document dom = c.dom;
        Include include = (Include)resNode.getRes().get();
        Element incRoot = dom.createElement("datafile");
        incRoot.appendChild(GMXFileWriter.createElement(dom, "name", include.getName()));
        incRoot.appendChild(GMXFileWriter.createElement(dom, "filename", include.get(Include.PInclude.FILENAME).toString()));
        incRoot.appendChild(GMXFileWriter.createElement(dom, "size", include.get(Include.PInclude.SIZE).toString()));
        incRoot.appendChild(GMXFileWriter.createElement(dom, "exportDir", include.get(Include.PInclude.EXPORTFOLDER).toString()));
        int exportCode = ProjectFile.INCLUDE_EXPORT_CODE.get(include.get(Include.PInclude.EXPORTACTION));
        incRoot.appendChild(GMXFileWriter.createElement(dom, "exportAction", Integer.toString(exportCode)));
        incRoot.appendChild(GMXFileWriter.createElement(dom, "overwrite", GMXFileWriter.boolToString((Boolean)include.get(Include.PInclude.OVERWRITE))));
        incRoot.appendChild(GMXFileWriter.createElement(dom, "store", GMXFileWriter.boolToString((Boolean)include.get(Include.PInclude.STORE))));
        incRoot.appendChild(GMXFileWriter.createElement(dom, "freeData", GMXFileWriter.boolToString((Boolean)include.get(Include.PInclude.FREEMEMORY))));
        incRoot.appendChild(GMXFileWriter.createElement(dom, "removeEnd", GMXFileWriter.boolToString((Boolean)include.get(Include.PInclude.REMOVEATGAMEEND))));
        domRoot.appendChild(incRoot);
        String filePath = include.get(Include.PInclude.FILENAME).toString();
        ResNode parent = (ResNode)resNode.getParent();
        while (parent != null && parent.status == 2) {
            filePath = String.valueOf(parent.toString()) + '/' + filePath;
            parent = (ResNode)parent.getParent();
        }
        filePath = String.valueOf(f.getDirectory()) + "/datafiles/" + filePath;
        File dataFile = new File(filePath);
        dataFile.getParentFile().mkdirs();
        Files.write(dataFile.toPath(), include.data, new OpenOption[0]);
    }

    public static void writePackages(ProjectFileContext c, Element root) throws IOException {
    }

    public static void writeGameInformation(ProjectFileContext c, Element root) throws FileNotFoundException {
        Document dom = c.dom;
        ProjectFile f = c.f;
        Element helpNode = dom.createElement("help");
        Element rtfNode = dom.createElement("rtf");
        rtfNode.setTextContent("help.rtf");
        helpNode.appendChild(rtfNode);
        try (PrintWriter out = null;){
            out = new PrintWriter(Util.getPOSIXPath(String.valueOf(f.getDirectory()) + "/help.rtf"));
            out.println(f.gameInfo.properties.get(GameInformation.PGameInformation.TEXT));
        }
        root.appendChild(helpNode);
    }

    public static void writeActions(Document doc, Element root, ActionContainer container) {
        for (Action act : container.actions) {
            Element actelement = doc.createElement("action");
            root.appendChild(actelement);
            LibAction la = act.getLibAction();
            actelement.appendChild(GMXFileWriter.createElement(doc, "libid", Integer.toString(la.parent != null ? la.parent.id : la.parentId)));
            actelement.appendChild(GMXFileWriter.createElement(doc, "id", Integer.toString(la.id)));
            actelement.appendChild(GMXFileWriter.createElement(doc, "kind", Integer.toString(la.actionKind)));
            actelement.appendChild(GMXFileWriter.createElement(doc, "userelative", GMXFileWriter.boolToString(la.allowRelative)));
            actelement.appendChild(GMXFileWriter.createElement(doc, "useapplyto", GMXFileWriter.boolToString(la.canApplyTo)));
            actelement.appendChild(GMXFileWriter.createElement(doc, "isquestion", GMXFileWriter.boolToString(la.question)));
            actelement.appendChild(GMXFileWriter.createElement(doc, "exetype", Integer.toString(la.execType)));
            String execinfo = "";
            if (la.execType == 1) {
                execinfo = la.execInfo;
            }
            actelement.appendChild(GMXFileWriter.createElement(doc, "functionname", execinfo));
            execinfo = "";
            if (la.execType == 2) {
                execinfo = la.execInfo;
            }
            actelement.appendChild(GMXFileWriter.createElement(doc, "codestring", execinfo));
            ResourceReference<GmObject> at = act.getAppliesTo();
            if (at != null) {
                if (at == GmObject.OBJECT_OTHER) {
                    actelement.appendChild(GMXFileWriter.createElement(doc, "whoName", "other"));
                } else if (at == GmObject.OBJECT_SELF) {
                    actelement.appendChild(GMXFileWriter.createElement(doc, "whoName", "self"));
                } else {
                    actelement.appendChild(GMXFileWriter.createElement(doc, "whoName", GMXFileWriter.getName(at)));
                }
            } else {
                actelement.appendChild(GMXFileWriter.createElement(doc, "whoName", "self"));
            }
            actelement.appendChild(GMXFileWriter.createElement(doc, "relative", GMXFileWriter.boolToString(act.isRelative())));
            actelement.appendChild(GMXFileWriter.createElement(doc, "isnot", GMXFileWriter.boolToString(act.isNot())));
            Element argsroot = doc.createElement("arguments");
            actelement.appendChild(argsroot);
            List<Argument> args = act.getArguments();
            for (Argument arg : args) {
                Element argelement = doc.createElement("argument");
                argsroot.appendChild(argelement);
                argelement.appendChild(GMXFileWriter.createElement(doc, "kind", Integer.toString(arg.kind)));
                Class<? extends Resource<?, ?>> kind = Argument.getResourceKind(arg.kind);
                if (kind != null && InstantiableResource.class.isAssignableFrom(kind)) {
                    argelement.appendChild(GMXFileWriter.createElement(doc, Resource.kindNames.get(kind).toLowerCase(), GMXFileWriter.getName(arg.getRes())));
                    continue;
                }
                argelement.appendChild(GMXFileWriter.createElement(doc, "string", arg.getVal()));
            }
        }
    }

    private static class ProjectFileContext {
        ProjectFile f;
        Document dom;

        public ProjectFileContext(ProjectFile f, Document d) {
            this.f = f;
            this.dom = d;
        }

        public ProjectFileContext copy() {
            return new ProjectFileContext(this.f, this.dom);
        }
    }
}

