/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.file;

import com.sun.org.apache.xerces.internal.impl.dv.util.HexBin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Queue;
import javax.imageio.ImageIO;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.lateralgm.components.impl.ResNode;
import org.lateralgm.file.GMXFileWriter;
import org.lateralgm.file.GmFormatException;
import org.lateralgm.file.ProjectFile;
import org.lateralgm.file.RefList;
import org.lateralgm.file.ResourceList;
import org.lateralgm.file.iconio.ICOFile;
import org.lateralgm.main.Util;
import org.lateralgm.resources.Background;
import org.lateralgm.resources.Constants;
import org.lateralgm.resources.Extension;
import org.lateralgm.resources.ExtensionPackages;
import org.lateralgm.resources.Font;
import org.lateralgm.resources.GameInformation;
import org.lateralgm.resources.GameSettings;
import org.lateralgm.resources.GmObject;
import org.lateralgm.resources.Include;
import org.lateralgm.resources.Path;
import org.lateralgm.resources.Resource;
import org.lateralgm.resources.Room;
import org.lateralgm.resources.Script;
import org.lateralgm.resources.Shader;
import org.lateralgm.resources.Sound;
import org.lateralgm.resources.Sprite;
import org.lateralgm.resources.Timeline;
import org.lateralgm.resources.library.LibAction;
import org.lateralgm.resources.library.LibArgument;
import org.lateralgm.resources.library.LibManager;
import org.lateralgm.resources.sub.Action;
import org.lateralgm.resources.sub.ActionContainer;
import org.lateralgm.resources.sub.Argument;
import org.lateralgm.resources.sub.BackgroundDef;
import org.lateralgm.resources.sub.Constant;
import org.lateralgm.resources.sub.Event;
import org.lateralgm.resources.sub.GlyphMetric;
import org.lateralgm.resources.sub.Instance;
import org.lateralgm.resources.sub.MainEvent;
import org.lateralgm.resources.sub.Moment;
import org.lateralgm.resources.sub.PathPoint;
import org.lateralgm.resources.sub.ShapePoint;
import org.lateralgm.resources.sub.Tile;
import org.lateralgm.resources.sub.View;
import org.lateralgm.util.PropertyMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class GMXFileReader {
    public static final String STUPID_SHADER_MARKER = "//######################_==_YOYO_SHADER_MARKER_==_######################@~";
    private static DocumentBuilderFactory documentBuilderFactory;
    private static DocumentBuilder documentBuilder;
    private static Queue<PostponedRef> postpone;

    static {
        postpone = new LinkedList<PostponedRef>();
    }

    private GMXFileReader() {
    }

    private static Document parseDocumentUnchecked(ProjectFile f, String path) throws GmFormatException {
        Document doc = null;
        try {
            doc = documentBuilder.parse(path);
        }
        catch (SAXException e) {
            throw new GmFormatException(f, "failed to parse: " + path, e);
        }
        catch (IOException e) {
            throw new GmFormatException(f, "failed to read: " + path, e);
        }
        return doc;
    }

    private static Document parseDocumentChecked(ProjectFile f, String path) {
        Document doc = null;
        try {
            doc = GMXFileReader.parseDocumentUnchecked(f, path);
        }
        catch (GmFormatException e) {
            ProjectFile.interfaceProvider.handleException(e);
        }
        return doc;
    }

    private static GmFormatException versionError(ProjectFile f, String error, String res, int ver) {
        return GMXFileReader.versionError(f, error, res, 0, ver);
    }

    private static GmFormatException versionError(ProjectFile f, String error, String res, int i, int ver) {
        ProjectFile.InterfaceProvider ip = ProjectFile.interfaceProvider;
        return new GmFormatException(f, ip.format("ProjectFileReader.ERROR_UNSUPPORTED", ip.format("ProjectFileReader." + error, ip.translate("LGM." + res), i), ver));
    }

    public static void readProjectFile(InputStream stream, ProjectFile file, URI uri, ResNode root) throws GmFormatException {
        GMXFileReader.readProjectFile(stream, file, uri, root, null);
    }

    public static void readProjectFile(InputStream stream, ProjectFile file, URI uri, ResNode root, Charset forceCharset) throws GmFormatException {
        ProjectFile.interfaceProvider.init(160, "ProgressDialog.GMX_LOADING");
        file.format = ProjectFile.FormatFlavor.GMX;
        if (documentBuilderFactory == null) {
            documentBuilderFactory = DocumentBuilderFactory.newInstance();
        }
        if (documentBuilder == null) {
            try {
                documentBuilder = documentBuilderFactory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e1) {
                throw new GmFormatException(file, e1);
            }
        }
        RefList<Timeline> timeids = new RefList<Timeline>(Timeline.class);
        RefList<GmObject> objids = new RefList<GmObject>(GmObject.class);
        RefList<Room> rmids = new RefList<Room>(Room.class);
        try {
            try {
                Document document = GMXFileReader.parseDocumentUnchecked(file, uri.toString());
                ProjectFileContext c = new ProjectFileContext(file, document, timeids, objids, rmids);
                ProjectFile.interfaceProvider.setProgress(0, "ProgressDialog.SPRITES");
                GMXFileReader.readGroup(c, root, Sprite.class);
                ProjectFile.interfaceProvider.setProgress(10, "ProgressDialog.SOUNDS");
                GMXFileReader.readGroup(c, root, Sound.class);
                ProjectFile.interfaceProvider.setProgress(20, "ProgressDialog.BACKGROUNDS");
                GMXFileReader.readGroup(c, root, Background.class);
                ProjectFile.interfaceProvider.setProgress(30, "ProgressDialog.PATHS");
                GMXFileReader.readGroup(c, root, Path.class);
                ProjectFile.interfaceProvider.setProgress(40, "ProgressDialog.SCRIPTS");
                GMXFileReader.readGroup(c, root, Script.class);
                ProjectFile.interfaceProvider.setProgress(50, "ProgressDialog.SHADERS");
                GMXFileReader.readGroup(c, root, Shader.class);
                ProjectFile.interfaceProvider.setProgress(60, "ProgressDialog.FONTS");
                GMXFileReader.readGroup(c, root, Font.class);
                ProjectFile.interfaceProvider.setProgress(70, "ProgressDialog.TIMELINES");
                GMXFileReader.readGroup(c, root, Timeline.class);
                ProjectFile.interfaceProvider.setProgress(80, "ProgressDialog.OBJECTS");
                GMXFileReader.readGroup(c, root, GmObject.class);
                ProjectFile.interfaceProvider.setProgress(90, "ProgressDialog.ROOMS");
                GMXFileReader.readGroup(c, root, Room.class);
                ProjectFile.interfaceProvider.setProgress(100, "ProgressDialog.INCLUDEFILES");
                GMXFileReader.readGroup(c, root, Include.class);
                ProjectFile.interfaceProvider.setProgress(110, "ProgressDialog.EXTENSIONS");
                GMXFileReader.readExtensions(c, root);
                ProjectFile.interfaceProvider.setProgress(120, "ProgressDialog.CONSTANTS");
                GMXFileReader.readDefaultConstants(c, root);
                ProjectFile.interfaceProvider.setProgress(130, "ProgressDialog.GAMEINFORMATION");
                GMXFileReader.readGameInformation(c, root);
                ProjectFile.interfaceProvider.setProgress(140, "ProgressDialog.SETTINGS");
                GMXFileReader.readConfigurations(c, root);
                ProjectFile.interfaceProvider.setProgress(150, "ProgressDialog.PACKAGES");
                GMXFileReader.readPackages(c, root);
                ProjectFile.interfaceProvider.setProgress(160, "ProgressDialog.POSTPONED");
                for (PostponedRef i : postpone) {
                    i.invoke();
                }
                postpone.clear();
                ProjectFile.interfaceProvider.setProgress(160, "ProgressDialog.FINISHED");
            }
            catch (Exception e) {
                if (e instanceof GmFormatException) {
                    throw (GmFormatException)e;
                }
                throw new GmFormatException(file, e);
            }
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                    stream = null;
                }
            }
            catch (IOException ex) {
                String key = ProjectFile.interfaceProvider.translate("GmFileReader.ERROR_CLOSEFAILED");
                throw new GmFormatException(file, key);
            }
        }
    }

    private static void readGroup(ProjectFileContext c, ResNode root, Class<?> kind) {
        Document in = c.in;
        ResNode node = new ResNode(Resource.kindNamesPlural.get(kind), 1, kind, null);
        root.add(node);
        String kindTagName = GMXFileWriter.tagNames.get(kind);
        if (kindTagName == null) {
            return;
        }
        NodeList list = in.getElementsByTagName(kindTagName);
        if (list == null || list.getLength() <= 0) {
            return;
        }
        list = list.item(0).getChildNodes();
        GMXFileReader.readTree(c, list, node, kind);
    }

    private static void readTree(ProjectFileContext c, NodeList list, ResNode node, Class<?> kind) {
        int i = 0;
        while (i < list.getLength()) {
            Node cNode = list.item(i);
            String tagName = cNode.getNodeName();
            if (!tagName.equals("#text")) {
                if (tagName.equals(GMXFileWriter.tagNames.get(kind))) {
                    String groupName = cNode.getAttributes().getNamedItem("name").getTextContent();
                    ResNode rnode = new ResNode(groupName, 2, kind, null);
                    node.add(rnode);
                    GMXFileReader.readTree(c, cNode.getChildNodes(), rnode, kind);
                } else if (tagName.equals("sprite")) {
                    GMXFileReader.readSprite(c, node, cNode);
                } else if (tagName.equals("sound")) {
                    GMXFileReader.readSound(c, node, cNode);
                } else if (tagName.equals("background")) {
                    GMXFileReader.readBackground(c, node, cNode);
                } else if (tagName.equals("path")) {
                    GMXFileReader.readPath(c, node, cNode);
                } else if (tagName.equals("script")) {
                    GMXFileReader.readScript(c, node, cNode);
                } else if (tagName.equals("shader")) {
                    GMXFileReader.readShader(c, node, cNode);
                } else if (tagName.equals("font")) {
                    GMXFileReader.readFont(c, node, cNode);
                } else if (tagName.equals("timeline")) {
                    GMXFileReader.readTimeline(c, node, cNode);
                } else if (tagName.equals("object")) {
                    GMXFileReader.readGmObject(c, node, cNode);
                } else if (tagName.equals("room")) {
                    GMXFileReader.readRoom(c, node, cNode);
                } else if (tagName.equals("datafile")) {
                    GMXFileReader.readInclude(c, node, cNode);
                }
            }
            ++i;
        }
    }

    private static void readConfigurations(ProjectFileContext c, ResNode root) {
        Document in = c.in;
        NodeList configNodes = in.getElementsByTagName("Configs").item(0).getChildNodes();
        c.f.gameSettings.clear();
        int i = 0;
        while (i < configNodes.getLength()) {
            Node cNode = configNodes.item(i);
            String cname = cNode.getNodeName();
            if (!cname.equals("#text") && !cname.toLowerCase().equals("configs") && cname.toLowerCase().equals("config")) {
                GameSettings gSet = new GameSettings();
                String fileName = new File(Util.getPOSIXPath(cNode.getTextContent())).getName();
                gSet.setName(fileName);
                c.f.gameSettings.add(gSet);
                PropertyMap pSet = gSet.properties;
                String path = String.valueOf(c.f.getDirectory()) + '/' + Util.getPOSIXPath(cNode.getTextContent());
                Document setdoc = GMXFileReader.parseDocumentChecked(c.f, String.valueOf(path) + ".config.gmx");
                if (setdoc != null) {
                    pSet.put(GameSettings.PGameSettings.USE_NEW_AUDIO, (Object)Boolean.parseBoolean(setdoc.getElementsByTagName("option_use_new_audio").item(0).getTextContent()));
                    pSet.put(GameSettings.PGameSettings.SHORT_CIRCUIT_EVAL, (Object)Boolean.parseBoolean(setdoc.getElementsByTagName("option_shortcircuit").item(0).getTextContent()));
                    pSet.put(GameSettings.PGameSettings.USE_FAST_COLLISION, (Object)Boolean.parseBoolean(setdoc.getElementsByTagName("option_use_fast_collision").item(0).getTextContent()));
                    pSet.put(GameSettings.PGameSettings.FAST_COLLISION_COMPAT, (Object)Boolean.parseBoolean(setdoc.getElementsByTagName("option_fast_collision_compatibility").item(0).getTextContent()));
                    pSet.put(GameSettings.PGameSettings.START_FULLSCREEN, (Object)Boolean.parseBoolean(setdoc.getElementsByTagName("option_fullscreen").item(0).getTextContent()));
                    pSet.put(GameSettings.PGameSettings.ALLOW_WINDOW_RESIZE, (Object)Boolean.parseBoolean(setdoc.getElementsByTagName("option_sizeable").item(0).getTextContent()));
                    pSet.put(GameSettings.PGameSettings.ALWAYS_ON_TOP, (Object)Boolean.parseBoolean(setdoc.getElementsByTagName("option_stayontop").item(0).getTextContent()));
                    pSet.put(GameSettings.PGameSettings.ABORT_ON_ERROR, (Object)Boolean.parseBoolean(setdoc.getElementsByTagName("option_aborterrors").item(0).getTextContent()));
                    pSet.put(GameSettings.PGameSettings.DISABLE_SCREENSAVERS, (Object)Boolean.parseBoolean(setdoc.getElementsByTagName("option_noscreensaver").item(0).getTextContent()));
                    pSet.put(GameSettings.PGameSettings.DISPLAY_CURSOR, (Object)Boolean.parseBoolean(setdoc.getElementsByTagName("option_showcursor").item(0).getTextContent()));
                    pSet.put(GameSettings.PGameSettings.DISPLAY_ERRORS, (Object)Boolean.parseBoolean(setdoc.getElementsByTagName("option_displayerrors").item(0).getTextContent()));
                    pSet.put(GameSettings.PGameSettings.DONT_DRAW_BORDER, (Object)Boolean.parseBoolean(setdoc.getElementsByTagName("option_noborder").item(0).getTextContent()));
                    pSet.put(GameSettings.PGameSettings.DONT_SHOW_BUTTONS, (Object)Boolean.parseBoolean(setdoc.getElementsByTagName("option_nobuttons").item(0).getTextContent()));
                    pSet.put(GameSettings.PGameSettings.ERROR_ON_ARGS, (Object)Boolean.parseBoolean(setdoc.getElementsByTagName("option_argumenterrors").item(0).getTextContent()));
                    pSet.put(GameSettings.PGameSettings.FREEZE_ON_LOSE_FOCUS, (Object)Boolean.parseBoolean(setdoc.getElementsByTagName("option_freeze").item(0).getTextContent()));
                    pSet.put(GameSettings.PGameSettings.COLOR_DEPTH, (Object)ProjectFile.GS_DEPTHS[Integer.parseInt(setdoc.getElementsByTagName("option_colordepth").item(0).getTextContent())]);
                    pSet.put(GameSettings.PGameSettings.FREQUENCY, (Object)ProjectFile.GS_FREQS[Integer.parseInt(setdoc.getElementsByTagName("option_frequency").item(0).getTextContent())]);
                    pSet.put(GameSettings.PGameSettings.RESOLUTION, (Object)ProjectFile.GS_RESOLS[Integer.parseInt(setdoc.getElementsByTagName("option_resolution").item(0).getTextContent())]);
                    pSet.put(GameSettings.PGameSettings.SET_RESOLUTION, (Object)Boolean.parseBoolean(setdoc.getElementsByTagName("option_changeresolution").item(0).getTextContent()));
                    pSet.put(GameSettings.PGameSettings.GAME_PRIORITY, (Object)ProjectFile.GS_PRIORITIES[Integer.parseInt(setdoc.getElementsByTagName("option_priority").item(0).getTextContent())]);
                    long syncvertex = Long.parseLong(setdoc.getElementsByTagName("option_sync_vertex").item(0).getTextContent());
                    gSet.put(GameSettings.PGameSettings.USE_SYNCHRONIZATION, (Object)(syncvertex == 0x80000001L || syncvertex == 1L ? 1 : 0));
                    pSet.put(GameSettings.PGameSettings.FORCE_SOFTWARE_VERTEX_PROCESSING, (Object)(syncvertex == 0x80000001L || syncvertex == 0x80000000L ? 1 : 0));
                    pSet.put(GameSettings.PGameSettings.LET_ESC_END_GAME, (Object)Boolean.parseBoolean(setdoc.getElementsByTagName("option_closeesc").item(0).getTextContent()));
                    pSet.put(GameSettings.PGameSettings.INTERPOLATE, (Object)Boolean.parseBoolean(setdoc.getElementsByTagName("option_interpolate").item(0).getTextContent()));
                    pSet.put(GameSettings.PGameSettings.SCALING, (Object)Integer.parseInt(setdoc.getElementsByTagName("option_scale").item(0).getTextContent()));
                    pSet.put(GameSettings.PGameSettings.TREAT_CLOSE_AS_ESCAPE, (Object)Boolean.parseBoolean(setdoc.getElementsByTagName("option_closeesc").item(0).getTextContent()));
                    String changed = setdoc.getElementsByTagName("option_lastchanged").item(0).getTextContent();
                    if (!changed.isEmpty()) {
                        pSet.put(GameSettings.PGameSettings.LAST_CHANGED, (Object)Double.parseDouble(changed));
                    }
                    String icopath = String.valueOf(c.f.getDirectory()) + '/' + setdoc.getElementsByTagName("option_windows_game_icon").item(0).getTextContent();
                    icopath = Util.getPOSIXPath(icopath);
                    try {
                        if (new File(icopath).exists()) {
                            pSet.put(GameSettings.PGameSettings.GAME_ICON, (Object)new ICOFile(icopath));
                        }
                    }
                    catch (IOException e) {
                        ProjectFile.interfaceProvider.handleException(new GmFormatException(c.f, "failed to read: " + icopath, e));
                    }
                    pSet.put(GameSettings.PGameSettings.GAME_ID, (Object)Integer.parseInt(setdoc.getElementsByTagName("option_gameid").item(0).getTextContent()));
                    pSet.put(GameSettings.PGameSettings.GAME_GUID, (Object)HexBin.decode(setdoc.getElementsByTagName("option_gameguid").item(0).getTextContent().replace("-", "").replace("{", "").replace("}", "")));
                    pSet.put(GameSettings.PGameSettings.AUTHOR, (Object)setdoc.getElementsByTagName("option_author").item(0).getTextContent());
                    pSet.put(GameSettings.PGameSettings.VERSION, (Object)setdoc.getElementsByTagName("option_version").item(0).getTextContent());
                    pSet.put(GameSettings.PGameSettings.INFORMATION, (Object)setdoc.getElementsByTagName("option_information").item(0).getTextContent());
                    pSet.put(GameSettings.PGameSettings.COMPANY, (Object)setdoc.getElementsByTagName("option_version_company").item(0).getTextContent());
                    pSet.put(GameSettings.PGameSettings.COPYRIGHT, (Object)setdoc.getElementsByTagName("option_version_copyright").item(0).getTextContent());
                    pSet.put(GameSettings.PGameSettings.DESCRIPTION, (Object)setdoc.getElementsByTagName("option_version_description").item(0).getTextContent());
                    pSet.put(GameSettings.PGameSettings.PRODUCT, (Object)setdoc.getElementsByTagName("option_version_product").item(0).getTextContent());
                    pSet.put(GameSettings.PGameSettings.VERSION_BUILD, (Object)Integer.parseInt(setdoc.getElementsByTagName("option_version_build").item(0).getTextContent()));
                    pSet.put(GameSettings.PGameSettings.VERSION_MAJOR, (Object)Integer.parseInt(setdoc.getElementsByTagName("option_version_major").item(0).getTextContent()));
                    pSet.put(GameSettings.PGameSettings.VERSION_MINOR, (Object)Integer.parseInt(setdoc.getElementsByTagName("option_version_minor").item(0).getTextContent()));
                    pSet.put(GameSettings.PGameSettings.VERSION_RELEASE, (Object)Integer.parseInt(setdoc.getElementsByTagName("option_version_release").item(0).getTextContent()));
                    pSet.put(GameSettings.PGameSettings.WINDOWS_STEAM_ID, (Object)Integer.parseInt(setdoc.getElementsByTagName("option_windows_steam_app_id").item(0).getTextContent()));
                    pSet.put(GameSettings.PGameSettings.MAC_STEAM_ID, (Object)Integer.parseInt(setdoc.getElementsByTagName("option_mac_steam_app_id").item(0).getTextContent()));
                    pSet.put(GameSettings.PGameSettings.LINUX_STEAM_ID, (Object)Integer.parseInt(setdoc.getElementsByTagName("option_linux_steam_app_id").item(0).getTextContent()));
                    pSet.put(GameSettings.PGameSettings.WINDOWS_STEAM_ENABLE, (Object)Boolean.parseBoolean(setdoc.getElementsByTagName("option_windows_enable_steam").item(0).getTextContent()));
                    pSet.put(GameSettings.PGameSettings.MAC_STEAM_ENABLE, (Object)Boolean.parseBoolean(setdoc.getElementsByTagName("option_mac_enable_steam").item(0).getTextContent()));
                    pSet.put(GameSettings.PGameSettings.LINUX_STEAM_ENABLE, (Object)Boolean.parseBoolean(setdoc.getElementsByTagName("option_linux_enable_steam").item(0).getTextContent()));
                    Node cnstNode = setdoc.getElementsByTagName("ConfigConstants").item(0);
                    if (cnstNode != null) {
                        NodeList cnstsList = cnstNode.getChildNodes();
                        boolean found = false;
                        int ic = 0;
                        while (ic < cnstsList.getLength()) {
                            cnstNode = cnstsList.item(ic);
                            String cnstName = cnstNode.getNodeName();
                            if (!cnstName.toLowerCase().equals("#text") && cnstName.toLowerCase().equals("constants")) {
                                found = true;
                                break;
                            }
                            ++ic;
                        }
                        if (found) {
                            GMXFileReader.readConstants(gSet.constants, cnstNode);
                        }
                    }
                }
            }
            ++i;
        }
        ResNode node = new ResNode("Game Settings", 3, GameSettings.class, null);
        root.add(node);
    }

    private static void readSprite(ProjectFileContext c, ResNode node, Node cNode) {
        ProjectFile f = c.f;
        Sprite spr = f.resMap.getList(Sprite.class).add();
        String fileName = new File(Util.getPOSIXPath(cNode.getTextContent())).getName();
        spr.setName(fileName);
        ResNode rnode = new ResNode(spr.getName(), 3, Sprite.class, spr.reference);
        node.add(rnode);
        String path = String.valueOf(f.getDirectory()) + '/' + Util.getPOSIXPath(cNode.getTextContent());
        Document sprdoc = GMXFileReader.parseDocumentChecked(f, String.valueOf(path) + ".sprite.gmx");
        if (sprdoc == null) {
            return;
        }
        spr.put(Sprite.PSprite.TRANSPARENT, false);
        spr.put(Sprite.PSprite.ORIGIN_X, Integer.parseInt(sprdoc.getElementsByTagName("xorig").item(0).getTextContent()));
        spr.put(Sprite.PSprite.ORIGIN_Y, Integer.parseInt(sprdoc.getElementsByTagName("yorigin").item(0).getTextContent()));
        spr.put(Sprite.PSprite.SHAPE, (Object)ProjectFile.SPRITE_MASK_SHAPE[Integer.parseInt(sprdoc.getElementsByTagName("colkind").item(0).getTextContent())]);
        spr.put(Sprite.PSprite.SEPARATE_MASK, Integer.parseInt(sprdoc.getElementsByTagName("sepmasks").item(0).getTextContent()) != 0);
        spr.put(Sprite.PSprite.BB_MODE, (Object)ProjectFile.SPRITE_BB_MODE[Integer.parseInt(sprdoc.getElementsByTagName("bboxmode").item(0).getTextContent())]);
        spr.put(Sprite.PSprite.BB_LEFT, Integer.parseInt(sprdoc.getElementsByTagName("bbox_left").item(0).getTextContent()));
        spr.put(Sprite.PSprite.BB_RIGHT, Integer.parseInt(sprdoc.getElementsByTagName("bbox_right").item(0).getTextContent()));
        spr.put(Sprite.PSprite.BB_TOP, Integer.parseInt(sprdoc.getElementsByTagName("bbox_top").item(0).getTextContent()));
        spr.put(Sprite.PSprite.BB_BOTTOM, Integer.parseInt(sprdoc.getElementsByTagName("bbox_bottom").item(0).getTextContent()));
        spr.put(Sprite.PSprite.ALPHA_TOLERANCE, Integer.parseInt(sprdoc.getElementsByTagName("coltolerance").item(0).getTextContent()));
        spr.put(Sprite.PSprite.TILE_HORIZONTALLY, Integer.parseInt(sprdoc.getElementsByTagName("HTile").item(0).getTextContent()) != 0);
        spr.put(Sprite.PSprite.TILE_VERTICALLY, Integer.parseInt(sprdoc.getElementsByTagName("VTile").item(0).getTextContent()) != 0);
        spr.put(Sprite.PSprite.FOR3D, Integer.parseInt(sprdoc.getElementsByTagName("For3D").item(0).getTextContent()) != 0);
        NodeList frList = sprdoc.getElementsByTagName("frame");
        path = String.valueOf(f.getDirectory()) + "/sprites/";
        int ii = 0;
        while (ii < frList.getLength()) {
            Node fnode = frList.item(ii);
            BufferedImage img = null;
            File imgfile = new File(String.valueOf(path) + Util.getPOSIXPath(fnode.getTextContent()));
            if (imgfile.exists()) {
                try {
                    img = ImageIO.read(imgfile);
                    spr.subImages.add(img);
                }
                catch (IOException e) {
                    ProjectFile.interfaceProvider.handleException(new GmFormatException(c.f, "failed to read: " + imgfile.getAbsolutePath(), e));
                }
            }
            ++ii;
        }
    }

    private static void readSound(ProjectFileContext c, ResNode node, Node cNode) {
        ProjectFile f = c.f;
        Sound snd = f.resMap.getList(Sound.class).add();
        String fileName = new File(Util.getPOSIXPath(cNode.getTextContent())).getName();
        snd.setName(fileName);
        ResNode rnode = new ResNode(snd.getName(), 3, Sound.class, snd.reference);
        node.add(rnode);
        snd.setNode(rnode);
        String path = String.valueOf(f.getDirectory()) + '/' + Util.getPOSIXPath(cNode.getTextContent());
        Document snddoc = GMXFileReader.parseDocumentChecked(f, String.valueOf(path) + ".sound.gmx");
        if (snddoc == null) {
            return;
        }
        snd.put(Sound.PSound.FILE_NAME, snddoc.getElementsByTagName("origname").item(0).getTextContent());
        NodeList nl = snddoc.getElementsByTagName("volume");
        snd.put(Sound.PSound.VOLUME, Double.parseDouble(nl.item(nl.getLength() - 1).getTextContent()));
        snd.put(Sound.PSound.PAN, Double.parseDouble(snddoc.getElementsByTagName("pan").item(0).getTextContent()));
        snd.put(Sound.PSound.BIT_RATE, Integer.parseInt(snddoc.getElementsByTagName("bitRate").item(0).getTextContent()));
        snd.put(Sound.PSound.SAMPLE_RATE, Integer.parseInt(snddoc.getElementsByTagName("sampleRate").item(0).getTextContent()));
        int sndtype = Integer.parseInt(snddoc.getElementsByTagName("type").item(0).getTextContent());
        snd.put(Sound.PSound.TYPE, (Object)ProjectFile.SOUND_TYPE[sndtype]);
        snd.put(Sound.PSound.BIT_DEPTH, Integer.parseInt(snddoc.getElementsByTagName("bitDepth").item(0).getTextContent()));
        snd.put(Sound.PSound.PRELOAD, Integer.parseInt(snddoc.getElementsByTagName("preload").item(0).getTextContent()) != 0);
        snd.put(Sound.PSound.COMPRESSED, Integer.parseInt(snddoc.getElementsByTagName("compressed").item(0).getTextContent()) != 0);
        snd.put(Sound.PSound.STREAMED, Integer.parseInt(snddoc.getElementsByTagName("streamed").item(0).getTextContent()) != 0);
        snd.put(Sound.PSound.DECOMPRESS_ON_LOAD, Integer.parseInt(snddoc.getElementsByTagName("uncompressOnLoad").item(0).getTextContent()) != 0);
        int sndkind = Integer.parseInt(snddoc.getElementsByTagName("kind").item(0).getTextContent());
        snd.put(Sound.PSound.KIND, (Object)ProjectFile.SOUND_KIND[sndkind]);
        snd.put(Sound.PSound.FILE_TYPE, snddoc.getElementsByTagName("extension").item(0).getTextContent());
        int effects = Integer.parseInt(snddoc.getElementsByTagName("effects").item(0).getTextContent());
        snd.setEffects(effects);
        NodeList data = snddoc.getElementsByTagName("data");
        if (data.item(0) != null) {
            String fname = data.item(0).getTextContent();
            fname = String.valueOf(f.getDirectory()) + "/sound/audio/" + fname;
            try {
                snd.data = Util.readFully(fname);
            }
            catch (IOException e) {
                ProjectFile.interfaceProvider.handleException(new GmFormatException(c.f, "failed to read: " + fname, e));
            }
        }
    }

    private static void readBackground(ProjectFileContext c, ResNode node, Node cNode) {
        ProjectFile f = c.f;
        Background bkg = f.resMap.getList(Background.class).add();
        String fileName = new File(Util.getPOSIXPath(cNode.getTextContent())).getName();
        bkg.setName(fileName);
        ResNode rnode = new ResNode(bkg.getName(), 3, Background.class, bkg.reference);
        node.add(rnode);
        String path = String.valueOf(f.getDirectory()) + '/' + Util.getPOSIXPath(cNode.getTextContent());
        Document bkgdoc = GMXFileReader.parseDocumentChecked(f, String.valueOf(path) + ".background.gmx");
        if (bkgdoc == null) {
            return;
        }
        bkg.put(Background.PBackground.USE_AS_TILESET, Integer.parseInt(bkgdoc.getElementsByTagName("istileset").item(0).getTextContent()) != 0);
        bkg.put(Background.PBackground.TILE_WIDTH, Integer.parseInt(bkgdoc.getElementsByTagName("tilewidth").item(0).getTextContent()));
        bkg.put(Background.PBackground.TILE_HEIGHT, Integer.parseInt(bkgdoc.getElementsByTagName("tileheight").item(0).getTextContent()));
        bkg.put(Background.PBackground.H_OFFSET, Integer.parseInt(bkgdoc.getElementsByTagName("tilexoff").item(0).getTextContent()));
        bkg.put(Background.PBackground.V_OFFSET, Integer.parseInt(bkgdoc.getElementsByTagName("tileyoff").item(0).getTextContent()));
        bkg.put(Background.PBackground.H_SEP, Integer.parseInt(bkgdoc.getElementsByTagName("tilehsep").item(0).getTextContent()));
        bkg.put(Background.PBackground.V_SEP, Integer.parseInt(bkgdoc.getElementsByTagName("tilevsep").item(0).getTextContent()));
        bkg.put(Background.PBackground.TILE_HORIZONTALLY, Integer.parseInt(bkgdoc.getElementsByTagName("HTile").item(0).getTextContent()) != 0);
        bkg.put(Background.PBackground.TILE_VERTICALLY, Integer.parseInt(bkgdoc.getElementsByTagName("VTile").item(0).getTextContent()) != 0);
        bkg.put(Background.PBackground.FOR3D, Integer.parseInt(bkgdoc.getElementsByTagName("For3D").item(0).getTextContent()) != 0);
        path = String.valueOf(f.getDirectory()) + "/background/";
        Node fnode = bkgdoc.getElementsByTagName("data").item(0);
        BufferedImage img = null;
        File imgfile = new File(String.valueOf(path) + Util.getPOSIXPath(fnode.getTextContent()));
        if (imgfile.exists()) {
            try {
                img = ImageIO.read(imgfile);
                bkg.setBackgroundImage(img);
            }
            catch (IOException e) {
                ProjectFile.interfaceProvider.handleException(new GmFormatException(c.f, "failed to read: " + imgfile.getAbsolutePath(), e));
            }
        }
    }

    private static void readPath(ProjectFileContext c, ResNode node, Node cNode) {
        final ProjectFile f = c.f;
        final Path pth = f.resMap.getList(Path.class).add();
        String fileName = new File(Util.getPOSIXPath(cNode.getTextContent())).getName();
        pth.setName(fileName);
        ResNode rnode = new ResNode(pth.getName(), 3, Path.class, pth.reference);
        node.add(rnode);
        String path = String.valueOf(f.getDirectory()) + '/' + Util.getPOSIXPath(cNode.getTextContent());
        Document pthdoc = GMXFileReader.parseDocumentChecked(f, String.valueOf(path) + ".path.gmx");
        if (pthdoc == null) {
            return;
        }
        pth.put(Path.PPath.SMOOTH, Integer.parseInt(pthdoc.getElementsByTagName("kind").item(0).getTextContent()) != 0);
        pth.put(Path.PPath.PRECISION, Integer.parseInt(pthdoc.getElementsByTagName("precision").item(0).getTextContent()));
        pth.put(Path.PPath.CLOSED, Integer.parseInt(pthdoc.getElementsByTagName("closed").item(0).getTextContent()) != 0);
        final int backroom = Integer.parseInt(pthdoc.getElementsByTagName("backroom").item(0).getTextContent());
        if (backroom >= 0) {
            PostponedRef pr = new PostponedRef(){

                @Override
                public boolean invoke() {
                    ResourceList<Room> list = f.resMap.getList(Room.class);
                    if (list == null) {
                        return false;
                    }
                    Room rmn = list.getUnsafe(backroom);
                    if (rmn == null) {
                        return false;
                    }
                    pth.put(Path.PPath.BACKGROUND_ROOM, rmn.reference);
                    return true;
                }
            };
            postpone.add(pr);
        }
        pth.put(Path.PPath.SNAP_X, Integer.parseInt(pthdoc.getElementsByTagName("hsnap").item(0).getTextContent()));
        pth.put(Path.PPath.SNAP_Y, Integer.parseInt(pthdoc.getElementsByTagName("vsnap").item(0).getTextContent()));
        NodeList frList = pthdoc.getElementsByTagName("point");
        int ii = 0;
        while (ii < frList.getLength()) {
            Node fnode = frList.item(ii);
            String[] coords = fnode.getTextContent().split(",");
            pth.points.add(new PathPoint(Integer.parseInt(coords[0]), Integer.parseInt(coords[1]), Integer.parseInt(coords[2])));
            ++ii;
        }
    }

    private static void readScript(ProjectFileContext c, ResNode node, Node cNode) {
        ProjectFile f = c.f;
        Script scr = f.resMap.getList(Script.class).add();
        String fileName = new File(Util.getPOSIXPath(cNode.getTextContent())).getName();
        scr.setName(fileName.substring(0, fileName.lastIndexOf(46)));
        ResNode rnode = new ResNode(scr.getName(), 3, Script.class, scr.reference);
        node.add(rnode);
        String path = String.valueOf(f.getDirectory()) + '/' + Util.getPOSIXPath(cNode.getTextContent());
        try {
            Throwable throwable = null;
            Object var9_12 = null;
            try (BufferedReader reader = new BufferedReader(new FileReader(path));){
                String code = "";
                String line = reader.readLine();
                if (line == null) {
                    return;
                }
                if (line.startsWith("#define") && (line = reader.readLine()) == null) {
                    return;
                }
                do {
                    if (line.startsWith("#define")) {
                        scr.put(Script.PScript.CODE, code);
                        code = "";
                        scr = f.resMap.getList(Script.class).add();
                        scr.setName(line.substring(8, line.length()));
                        rnode = new ResNode(scr.getName(), 3, Script.class, scr.reference);
                        node.add(rnode);
                        continue;
                    }
                    code = String.valueOf(code) + line + '\n';
                } while ((line = reader.readLine()) != null);
                scr.put(Script.PScript.CODE, code);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException e) {
            ProjectFile.interfaceProvider.handleException(new GmFormatException(c.f, "file not found: " + path, e));
        }
        catch (IOException e) {
            ProjectFile.interfaceProvider.handleException(new GmFormatException(c.f, "unable to read file: " + path, e));
        }
    }

    private static void readShader(ProjectFileContext c, ResNode node, Node cNode) {
        ProjectFile f = c.f;
        Shader shr = f.resMap.getList(Shader.class).add();
        String fileName = new File(Util.getPOSIXPath(cNode.getTextContent())).getName();
        shr.setName(fileName.substring(0, fileName.lastIndexOf(46)));
        ResNode rnode = new ResNode(shr.getName(), 3, Shader.class, shr.reference);
        node.add(rnode);
        shr.put(Shader.PShader.TYPE, cNode.getAttributes().item(0).getTextContent());
        String code = "";
        String path = String.valueOf(f.getDirectory()) + '/' + Util.getPOSIXPath(cNode.getTextContent());
        try {
            Throwable throwable = null;
            Object var10_13 = null;
            try (BufferedReader reader = new BufferedReader(new FileReader(path));){
                String line = "";
                while ((line = reader.readLine()) != null) {
                    code = String.valueOf(code) + line + '\n';
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException e) {
            ProjectFile.interfaceProvider.handleException(new GmFormatException(c.f, "file not found: " + path, e));
        }
        catch (IOException e) {
            ProjectFile.interfaceProvider.handleException(new GmFormatException(c.f, "unable to read file: " + path, e));
        }
        String[] splitcode = code.split(STUPID_SHADER_MARKER);
        shr.put(Shader.PShader.VERTEX, splitcode[0]);
        shr.put(Shader.PShader.FRAGMENT, splitcode[1]);
    }

    private static void readFont(ProjectFileContext c, ResNode node, Node cNode) {
        ProjectFile f = c.f;
        Font fnt = f.resMap.getList(Font.class).add();
        String fileName = new File(Util.getPOSIXPath(cNode.getTextContent())).getName();
        fnt.setName(fileName);
        ResNode rnode = new ResNode(fnt.getName(), 3, Font.class, fnt.reference);
        node.add(rnode);
        String path = String.valueOf(f.getDirectory()) + '/' + Util.getPOSIXPath(cNode.getTextContent());
        Document fntdoc = GMXFileReader.parseDocumentChecked(f, String.valueOf(path) + ".font.gmx");
        if (fntdoc == null) {
            return;
        }
        fnt.put(Font.PFont.FONT_NAME, fntdoc.getElementsByTagName("name").item(0).getTextContent());
        fnt.put(Font.PFont.SIZE, Integer.parseInt(fntdoc.getElementsByTagName("size").item(0).getTextContent()));
        fnt.put(Font.PFont.BOLD, Integer.parseInt(fntdoc.getElementsByTagName("bold").item(0).getTextContent()) != 0);
        fnt.put(Font.PFont.ITALIC, Integer.parseInt(fntdoc.getElementsByTagName("italic").item(0).getTextContent()) != 0);
        fnt.put(Font.PFont.CHARSET, Integer.parseInt(fntdoc.getElementsByTagName("charset").item(0).getTextContent()));
        fnt.put(Font.PFont.ANTIALIAS, Integer.parseInt(fntdoc.getElementsByTagName("aa").item(0).getTextContent()));
        NodeList ranges = fntdoc.getElementsByTagName("range0");
        int item = 0;
        while (item < ranges.getLength()) {
            String[] range = ranges.item(item).getTextContent().split(",");
            fnt.addRange(Integer.parseInt(range[0]), Integer.parseInt(range[1]));
            ++item;
        }
        NodeList glyphs = fntdoc.getElementsByTagName("glyph");
        int item2 = 0;
        while (item2 < glyphs.getLength()) {
            NamedNodeMap attribs = glyphs.item(item2).getAttributes();
            GlyphMetric gm = fnt.addGlyph();
            gm.properties.put(GlyphMetric.PGlyphMetric.CHARACTER, (Object)Integer.parseInt(attribs.getNamedItem("character").getTextContent()));
            gm.properties.put(GlyphMetric.PGlyphMetric.X, (Object)Integer.parseInt(attribs.getNamedItem("x").getTextContent()));
            gm.properties.put(GlyphMetric.PGlyphMetric.Y, (Object)Integer.parseInt(attribs.getNamedItem("y").getTextContent()));
            gm.properties.put(GlyphMetric.PGlyphMetric.W, (Object)Integer.parseInt(attribs.getNamedItem("w").getTextContent()));
            gm.properties.put(GlyphMetric.PGlyphMetric.H, (Object)Integer.parseInt(attribs.getNamedItem("h").getTextContent()));
            gm.properties.put(GlyphMetric.PGlyphMetric.SHIFT, (Object)Integer.parseInt(attribs.getNamedItem("shift").getTextContent()));
            gm.properties.put(GlyphMetric.PGlyphMetric.OFFSET, (Object)Integer.parseInt(attribs.getNamedItem("offset").getTextContent()));
            ++item2;
        }
    }

    private static void readTimeline(ProjectFileContext c, ResNode node, Node cNode) {
        ProjectFile f = c.f;
        Timeline tml = f.resMap.getList(Timeline.class).add();
        String fileName = new File(Util.getPOSIXPath(cNode.getTextContent())).getName();
        tml.setName(fileName);
        ResNode rnode = new ResNode(tml.getName(), 3, Timeline.class, tml.reference);
        node.add(rnode);
        String path = String.valueOf(f.getDirectory()) + '/' + Util.getPOSIXPath(cNode.getTextContent());
        Document tmldoc = GMXFileReader.parseDocumentChecked(f, String.valueOf(path) + ".timeline.gmx");
        if (tmldoc == null) {
            return;
        }
        NodeList frList = tmldoc.getElementsByTagName("entry");
        int ii = 0;
        while (ii < frList.getLength()) {
            Node fnode = frList.item(ii);
            Moment mom = tml.addMoment();
            NodeList children = fnode.getChildNodes();
            int x = 0;
            while (x < children.getLength()) {
                Node cnode = children.item(x);
                if (!cnode.getNodeName().equals("#text")) {
                    if (cnode.getNodeName().equals("step")) {
                        mom.stepNo = Integer.parseInt(cnode.getTextContent());
                    } else if (cnode.getNodeName().equals("event")) {
                        GMXFileReader.readActions(c, mom, "INTIMELINEACTION", tml.getId(), mom.stepNo, cnode.getChildNodes());
                    }
                }
                ++x;
            }
            ++ii;
        }
    }

    private static void readGmObject(ProjectFileContext c, ResNode node, Node cNode) {
        final ProjectFile f = c.f;
        GmObject obj = f.resMap.getList(GmObject.class).add();
        String fileName = new File(Util.getPOSIXPath(cNode.getTextContent())).getName();
        obj.setName(fileName);
        String path = String.valueOf(f.getDirectory()) + '/' + Util.getPOSIXPath(cNode.getTextContent());
        Document objdoc = GMXFileReader.parseDocumentChecked(f, String.valueOf(path) + ".object.gmx");
        if (objdoc == null) {
            return;
        }
        String sprname = objdoc.getElementsByTagName("spriteName").item(0).getTextContent();
        if (!sprname.equals("<undefined>")) {
            postpone.add(new DefaultPostponedRef<GmObject.PGmObject>(f.resMap.getList(Sprite.class), obj.properties, GmObject.PGmObject.SPRITE, sprname));
        } else {
            obj.put(GmObject.PGmObject.SPRITE, null);
        }
        String mskname = objdoc.getElementsByTagName("maskName").item(0).getTextContent();
        if (!mskname.equals("<undefined>")) {
            postpone.add(new DefaultPostponedRef<GmObject.PGmObject>(f.resMap.getList(Sprite.class), obj.properties, GmObject.PGmObject.MASK, mskname));
        } else {
            obj.put(GmObject.PGmObject.MASK, null);
        }
        String parname = objdoc.getElementsByTagName("parentName").item(0).getTextContent();
        if (!parname.equals("<undefined>") && !parname.equals("self")) {
            postpone.add(new DefaultPostponedRef<GmObject.PGmObject>(f.resMap.getList(GmObject.class), obj.properties, GmObject.PGmObject.PARENT, parname));
        } else {
            obj.put(GmObject.PGmObject.PARENT, null);
        }
        obj.put(GmObject.PGmObject.SOLID, Integer.parseInt(objdoc.getElementsByTagName("solid").item(0).getTextContent()) != 0);
        obj.put(GmObject.PGmObject.VISIBLE, Integer.parseInt(objdoc.getElementsByTagName("visible").item(0).getTextContent()) != 0);
        obj.put(GmObject.PGmObject.DEPTH, Integer.parseInt(objdoc.getElementsByTagName("depth").item(0).getTextContent()));
        obj.put(GmObject.PGmObject.PERSISTENT, Integer.parseInt(objdoc.getElementsByTagName("persistent").item(0).getTextContent()) != 0);
        NodeList frList = objdoc.getElementsByTagName("event");
        int ii = 0;
        while (ii < frList.getLength()) {
            Node fnode = frList.item(ii);
            final Event ev = new Event();
            ev.mainId = Integer.parseInt(fnode.getAttributes().getNamedItem("eventtype").getTextContent());
            MainEvent me = obj.mainEvents.get(ev.mainId);
            me.events.add(0, ev);
            if (ev.mainId == 4) {
                final String colname = fnode.getAttributes().getNamedItem("ename").getTextContent();
                PostponedRef pr = new PostponedRef(){

                    @Override
                    public boolean invoke() {
                        ResourceList<GmObject> list = f.resMap.getList(GmObject.class);
                        if (list == null) {
                            return false;
                        }
                        GmObject col = list.get(colname);
                        if (col == null) {
                            return false;
                        }
                        ev.other = col.reference;
                        return true;
                    }
                };
                postpone.add(pr);
            } else {
                ev.id = Integer.parseInt(fnode.getAttributes().getNamedItem("enumb").getTextContent());
            }
            GMXFileReader.readActions(c, ev, "INOBJECTACTION", obj.getId(), ii * 1000 + ev.id, fnode.getChildNodes());
            ++ii;
        }
        obj.put(GmObject.PGmObject.PHYSICS_OBJECT, Integer.parseInt(objdoc.getElementsByTagName("PhysicsObject").item(0).getTextContent()) != 0);
        obj.put(GmObject.PGmObject.PHYSICS_SENSOR, Integer.parseInt(objdoc.getElementsByTagName("PhysicsObjectSensor").item(0).getTextContent()) != 0);
        int shapekind = Integer.parseInt(objdoc.getElementsByTagName("PhysicsObjectShape").item(0).getTextContent());
        obj.put(GmObject.PGmObject.PHYSICS_SHAPE, (Object)ProjectFile.PHYSICS_SHAPE[shapekind]);
        obj.put(GmObject.PGmObject.PHYSICS_DENSITY, Double.parseDouble(objdoc.getElementsByTagName("PhysicsObjectDensity").item(0).getTextContent()));
        obj.put(GmObject.PGmObject.PHYSICS_RESTITUTION, Double.parseDouble(objdoc.getElementsByTagName("PhysicsObjectRestitution").item(0).getTextContent()));
        obj.put(GmObject.PGmObject.PHYSICS_GROUP, Integer.parseInt(objdoc.getElementsByTagName("PhysicsObjectGroup").item(0).getTextContent()));
        obj.put(GmObject.PGmObject.PHYSICS_DAMPING_LINEAR, Double.parseDouble(objdoc.getElementsByTagName("PhysicsObjectLinearDamping").item(0).getTextContent()));
        obj.put(GmObject.PGmObject.PHYSICS_DAMPING_ANGULAR, Double.parseDouble(objdoc.getElementsByTagName("PhysicsObjectAngularDamping").item(0).getTextContent()));
        Node fNode = objdoc.getElementsByTagName("PhysicsObjectFriction").item(0);
        if (fNode != null) {
            obj.put(GmObject.PGmObject.PHYSICS_FRICTION, Double.parseDouble(fNode.getTextContent()));
            obj.put(GmObject.PGmObject.PHYSICS_AWAKE, Integer.parseInt(objdoc.getElementsByTagName("PhysicsObjectAwake").item(0).getTextContent()) != 0);
            obj.put(GmObject.PGmObject.PHYSICS_KINEMATIC, Integer.parseInt(objdoc.getElementsByTagName("PhysicsObjectKinematic").item(0).getTextContent()) != 0);
        }
        NodeList pointNodes = objdoc.getElementsByTagName("point");
        int p = 0;
        while (p < pointNodes.getLength()) {
            String[] coords = pointNodes.item(p).getTextContent().split(",");
            obj.shapePoints.add(new ShapePoint(Double.parseDouble(coords[0]), Double.parseDouble(coords[1])));
            ++p;
        }
        ResNode rnode = new ResNode(obj.getName(), 3, GmObject.class, obj.reference);
        node.add(rnode);
    }

    private static void readRoom(ProjectFileContext c, ResNode node, Node cNode) {
        ProjectFile f = c.f;
        Room rmn = f.resMap.getList(Room.class).add();
        String fileName = new File(Util.getPOSIXPath(cNode.getTextContent())).getName();
        rmn.setName(fileName);
        ResNode rnode = new ResNode(rmn.getName(), 3, Room.class, rmn.reference);
        node.add(rnode);
        String path = String.valueOf(f.getDirectory()) + '/' + Util.getPOSIXPath(cNode.getTextContent());
        Document rmndoc = GMXFileReader.parseDocumentChecked(f, String.valueOf(path) + ".room.gmx");
        if (rmndoc == null) {
            return;
        }
        String caption = rmndoc.getElementsByTagName("caption").item(0).getTextContent();
        rmn.put(Room.PRoom.CAPTION, caption);
        NodeList cnodes = rmndoc.getElementsByTagName("room").item(0).getChildNodes();
        int x = 0;
        while (x < cnodes.getLength()) {
            Node pnode = cnodes.item(x);
            String pname = pnode.getNodeName();
            if (!pname.equals("#text")) {
                String bkgname;
                int y;
                if (pname.equals("caption")) {
                    rmn.put(Room.PRoom.CAPTION, pnode.getTextContent());
                } else if (pname.equals("width")) {
                    rmn.put(Room.PRoom.WIDTH, Integer.parseInt(pnode.getTextContent()));
                } else if (pname.equals("height")) {
                    rmn.put(Room.PRoom.HEIGHT, Integer.parseInt(pnode.getTextContent()));
                } else if (pname.equals("vsnap")) {
                    rmn.put(Room.PRoom.SNAP_Y, Integer.parseInt(pnode.getTextContent()));
                } else if (pname.equals("hsnap")) {
                    rmn.put(Room.PRoom.SNAP_X, Integer.parseInt(pnode.getTextContent()));
                } else if (pname.equals("isometric")) {
                    rmn.put(Room.PRoom.ISOMETRIC, Integer.parseInt(pnode.getTextContent()) != 0);
                } else if (pname.equals("speed")) {
                    rmn.put(Room.PRoom.SPEED, Integer.parseInt(pnode.getTextContent()));
                } else if (pname.equals("persistent")) {
                    rmn.put(Room.PRoom.PERSISTENT, Integer.parseInt(pnode.getTextContent()) != 0);
                } else if (pname.equals("colour")) {
                    int col = Integer.parseInt(pnode.getTextContent());
                    rmn.put(Room.PRoom.BACKGROUND_COLOR, Util.convertGmColor(col));
                } else if (pname.equals("showcolour")) {
                    rmn.put(Room.PRoom.DRAW_BACKGROUND_COLOR, Integer.parseInt(pnode.getTextContent()) != 0);
                } else if (pname.equals("code")) {
                    rmn.put(Room.PRoom.CREATION_CODE, pnode.getTextContent());
                } else if (pname.equals("enableViews")) {
                    rmn.put(Room.PRoom.VIEWS_ENABLED, Integer.parseInt(pnode.getTextContent()) != 0);
                } else if (pname.equals("clearViewBackground")) {
                    rmn.put(Room.PRoom.VIEWS_CLEAR, Integer.parseInt(pnode.getTextContent()) != 0);
                } else if (pname.equals("makerSettings")) {
                    NodeList msnodes = pnode.getChildNodes();
                    y = 0;
                    while (y < msnodes.getLength()) {
                        Node mnode = msnodes.item(y);
                        String mname = mnode.getNodeName();
                        if (!mname.equals("#text")) {
                            if (mname.equals("isSet")) {
                                rmn.put(Room.PRoom.REMEMBER_WINDOW_SIZE, Integer.parseInt(mnode.getTextContent()) != 0);
                            } else if (mname.equals("w")) {
                                rmn.put(Room.PRoom.EDITOR_WIDTH, Integer.parseInt(mnode.getTextContent()));
                            } else if (mname.equals("h")) {
                                rmn.put(Room.PRoom.EDITOR_HEIGHT, Integer.parseInt(mnode.getTextContent()));
                            } else if (mname.equals("showGrid")) {
                                rmn.put(Room.PRoom.SHOW_GRID, Integer.parseInt(mnode.getTextContent()) != 0);
                            } else if (mname.equals("showObjects")) {
                                rmn.put(Room.PRoom.SHOW_OBJECTS, Integer.parseInt(mnode.getTextContent()) != 0);
                            } else if (mname.equals("showTiles")) {
                                rmn.put(Room.PRoom.SHOW_TILES, Integer.parseInt(mnode.getTextContent()) != 0);
                            } else if (mname.equals("showBackgrounds")) {
                                rmn.put(Room.PRoom.SHOW_BACKGROUNDS, Integer.parseInt(mnode.getTextContent()) != 0);
                            } else if (mname.equals("showForegrounds")) {
                                rmn.put(Room.PRoom.SHOW_FOREGROUNDS, Integer.parseInt(mnode.getTextContent()) != 0);
                            } else if (mname.equals("showViews")) {
                                rmn.put(Room.PRoom.SHOW_VIEWS, Integer.parseInt(mnode.getTextContent()) != 0);
                            } else if (mname.equals("deleteUnderlyingObj")) {
                                rmn.put(Room.PRoom.DELETE_UNDERLYING_OBJECTS, Integer.parseInt(mnode.getTextContent()) != 0);
                            } else if (mname.equals("deleteUnderlyingTiles")) {
                                rmn.put(Room.PRoom.DELETE_UNDERLYING_TILES, Integer.parseInt(mnode.getTextContent()) != 0);
                            } else if (mname.equals("page")) {
                                rmn.put(Room.PRoom.CURRENT_TAB, Integer.parseInt(mnode.getTextContent()));
                            } else if (mname.equals("xoffset")) {
                                rmn.put(Room.PRoom.SCROLL_BAR_X, Integer.parseInt(mnode.getTextContent()));
                            } else if (mname.equals("yoffset")) {
                                rmn.put(Room.PRoom.SCROLL_BAR_Y, Integer.parseInt(mnode.getTextContent()));
                            }
                        }
                        ++y;
                    }
                } else if (pname.equals("backgrounds")) {
                    NodeList bgnodes = pnode.getChildNodes();
                    int bkgnum = 0;
                    int y2 = 0;
                    while (y2 < bgnodes.getLength()) {
                        Node bnode = bgnodes.item(y2);
                        String bname = bnode.getNodeName();
                        if (!bname.equals("#text")) {
                            BackgroundDef bkg = rmn.backgroundDefs.get(bkgnum);
                            ++bkgnum;
                            bkg.properties.put(BackgroundDef.PBackgroundDef.VISIBLE, (Object)(Integer.parseInt(bnode.getAttributes().getNamedItem("visible").getTextContent()) != 0 ? 1 : 0));
                            bkgname = bnode.getAttributes().getNamedItem("name").getTextContent();
                            postpone.add(new DefaultPostponedRef<BackgroundDef.PBackgroundDef>(f.resMap.getList(Background.class), bkg.properties, BackgroundDef.PBackgroundDef.BACKGROUND, bkgname));
                            bkg.properties.put(BackgroundDef.PBackgroundDef.FOREGROUND, (Object)(Integer.parseInt(bnode.getAttributes().getNamedItem("foreground").getTextContent()) != 0 ? 1 : 0));
                            bkg.properties.put(BackgroundDef.PBackgroundDef.TILE_HORIZ, (Object)(Integer.parseInt(bnode.getAttributes().getNamedItem("htiled").getTextContent()) != 0 ? 1 : 0));
                            bkg.properties.put(BackgroundDef.PBackgroundDef.TILE_VERT, (Object)(Integer.parseInt(bnode.getAttributes().getNamedItem("vtiled").getTextContent()) != 0 ? 1 : 0));
                            bkg.properties.put(BackgroundDef.PBackgroundDef.STRETCH, (Object)(Integer.parseInt(bnode.getAttributes().getNamedItem("stretch").getTextContent()) != 0 ? 1 : 0));
                            bkg.properties.put(BackgroundDef.PBackgroundDef.H_SPEED, (Object)Integer.parseInt(bnode.getAttributes().getNamedItem("hspeed").getTextContent()));
                            bkg.properties.put(BackgroundDef.PBackgroundDef.V_SPEED, (Object)Integer.parseInt(bnode.getAttributes().getNamedItem("vspeed").getTextContent()));
                            bkg.properties.put(BackgroundDef.PBackgroundDef.X, (Object)Integer.parseInt(bnode.getAttributes().getNamedItem("x").getTextContent()));
                            bkg.properties.put(BackgroundDef.PBackgroundDef.Y, (Object)Integer.parseInt(bnode.getAttributes().getNamedItem("y").getTextContent()));
                        }
                        ++y2;
                    }
                } else if (pname.equals("views")) {
                    NodeList vinodes = pnode.getChildNodes();
                    int viewnum = 0;
                    int y3 = 0;
                    while (y3 < vinodes.getLength()) {
                        Node vnode = vinodes.item(y3);
                        String vname = vnode.getNodeName();
                        if (!vname.equals("#text")) {
                            View vw = rmn.views.get(viewnum);
                            ++viewnum;
                            vw.properties.put(View.PView.VISIBLE, (Object)(Integer.parseInt(vnode.getAttributes().getNamedItem("visible").getTextContent()) != 0 ? 1 : 0));
                            String objname = vnode.getAttributes().getNamedItem("objName").getTextContent();
                            postpone.add(new DefaultPostponedRef<View.PView>(f.resMap.getList(GmObject.class), vw.properties, View.PView.OBJECT, objname));
                            vw.properties.put(View.PView.SPEED_H, (Object)Integer.parseInt(vnode.getAttributes().getNamedItem("hspeed").getTextContent()));
                            vw.properties.put(View.PView.SPEED_V, (Object)Integer.parseInt(vnode.getAttributes().getNamedItem("vspeed").getTextContent()));
                            vw.properties.put(View.PView.BORDER_H, (Object)Integer.parseInt(vnode.getAttributes().getNamedItem("hborder").getTextContent()));
                            vw.properties.put(View.PView.BORDER_V, (Object)Integer.parseInt(vnode.getAttributes().getNamedItem("vborder").getTextContent()));
                            vw.properties.put(View.PView.PORT_H, (Object)Integer.parseInt(vnode.getAttributes().getNamedItem("hport").getTextContent()));
                            vw.properties.put(View.PView.PORT_W, (Object)Integer.parseInt(vnode.getAttributes().getNamedItem("wport").getTextContent()));
                            vw.properties.put(View.PView.PORT_X, (Object)Integer.parseInt(vnode.getAttributes().getNamedItem("xport").getTextContent()));
                            vw.properties.put(View.PView.PORT_Y, (Object)Integer.parseInt(vnode.getAttributes().getNamedItem("yport").getTextContent()));
                            vw.properties.put(View.PView.VIEW_H, (Object)Integer.parseInt(vnode.getAttributes().getNamedItem("hview").getTextContent()));
                            vw.properties.put(View.PView.VIEW_W, (Object)Integer.parseInt(vnode.getAttributes().getNamedItem("wview").getTextContent()));
                            vw.properties.put(View.PView.VIEW_X, (Object)Integer.parseInt(vnode.getAttributes().getNamedItem("xview").getTextContent()));
                            vw.properties.put(View.PView.VIEW_Y, (Object)Integer.parseInt(vnode.getAttributes().getNamedItem("yview").getTextContent()));
                        }
                        ++y3;
                    }
                } else if (pname.equals("instances")) {
                    NodeList insnodes = pnode.getChildNodes();
                    y = 0;
                    while (y < insnodes.getLength()) {
                        Node inode = insnodes.item(y);
                        String iname = inode.getNodeName();
                        if (!iname.equals("#text") && iname.equals("instance") && inode.getAttributes().getLength() > 0) {
                            int instid;
                            Instance inst = rmn.addInstance();
                            String objname = inode.getAttributes().getNamedItem("objName").getTextContent();
                            GmObject temp = f.resMap.getList(GmObject.class).get(objname);
                            if (temp != null) {
                                inst.properties.put(Instance.PInstance.OBJECT, (Object)temp.reference);
                            }
                            NamedNodeMap attribs = inode.getAttributes();
                            int xx = Integer.parseInt(attribs.getNamedItem("x").getNodeValue());
                            int yy = Integer.parseInt(attribs.getNamedItem("y").getNodeValue());
                            double sx = Double.parseDouble(attribs.getNamedItem("scaleX").getNodeValue());
                            double sy = Double.parseDouble(attribs.getNamedItem("scaleY").getNodeValue());
                            if (attribs.getNamedItem("colour") != null) {
                                long col = Long.parseLong(attribs.getNamedItem("colour").getNodeValue());
                                Color color = Util.convertInstanceColorWithAlpha((int)col);
                                inst.setColor(color);
                                inst.setAlpha(color.getAlpha());
                            }
                            double rot = Double.parseDouble(attribs.getNamedItem("rotation").getNodeValue());
                            inst.properties.put(Instance.PInstance.NAME, (Object)inode.getAttributes().getNamedItem("name").getNodeValue());
                            Node idNode = inode.getAttributes().getNamedItem("id");
                            if (idNode != null) {
                                instid = Integer.parseInt(idNode.getNodeValue());
                                if (instid > f.lastInstanceId) {
                                    f.lastInstanceId = instid;
                                }
                            } else {
                                instid = ++f.lastInstanceId;
                            }
                            inst.properties.put(Instance.PInstance.ID, (Object)instid);
                            inst.setPosition(new Point(xx, yy));
                            inst.setScale(new Point2D.Double(sx, sy));
                            inst.setRotation(rot);
                            inst.setCreationCode(inode.getAttributes().getNamedItem("code").getNodeValue());
                            inst.setLocked(Integer.parseInt(inode.getAttributes().getNamedItem("locked").getNodeValue()) != 0);
                        }
                        ++y;
                    }
                } else if (pname.equals("tiles")) {
                    NodeList tinodes = pnode.getChildNodes();
                    int p = 0;
                    while (p < tinodes.getLength()) {
                        Node tnode = tinodes.item(p);
                        String tname = tnode.getNodeName();
                        if (!tname.equals("#text")) {
                            Tile tile = new Tile(rmn);
                            NamedNodeMap attribs = tnode.getAttributes();
                            tile.setPosition(new Point(Integer.parseInt(attribs.getNamedItem("x").getTextContent()), Integer.parseInt(attribs.getNamedItem("y").getTextContent())));
                            bkgname = tnode.getAttributes().getNamedItem("bgName").getTextContent();
                            postpone.add(new DefaultPostponedRef<Tile.PTile>(f.resMap.getList(Background.class), tile.properties, Tile.PTile.BACKGROUND, bkgname));
                            tile.properties.put(Tile.PTile.NAME, (Object)attribs.getNamedItem("name").getNodeValue());
                            int tileid = Integer.parseInt(attribs.getNamedItem("id").getTextContent());
                            if (tileid > f.lastTileId) {
                                f.lastTileId = tileid;
                            }
                            tile.properties.put(Tile.PTile.ID, (Object)tileid);
                            tile.setBackgroundPosition(new Point(Integer.parseInt(attribs.getNamedItem("xo").getTextContent()), Integer.parseInt(attribs.getNamedItem("yo").getTextContent())));
                            tile.setSize(new Dimension(Integer.parseInt(attribs.getNamedItem("w").getTextContent()), Integer.parseInt(attribs.getNamedItem("h").getTextContent())));
                            tile.setDepth(Integer.parseInt(attribs.getNamedItem("depth").getTextContent()));
                            tile.setLocked(Integer.parseInt(attribs.getNamedItem("locked").getTextContent()) != 0);
                            double sx = Double.parseDouble(attribs.getNamedItem("scaleX").getNodeValue());
                            double sy = Double.parseDouble(attribs.getNamedItem("scaleY").getNodeValue());
                            tile.setScale(new Point2D.Double(sx, sy));
                            tile.setColor(Long.parseLong(attribs.getNamedItem("colour").getNodeValue()));
                            rmn.tiles.add(tile);
                        }
                        ++p;
                    }
                } else if (pname.equals("PhysicsWorld")) {
                    rmn.put(Room.PRoom.PHYSICS_WORLD, Integer.parseInt(pnode.getTextContent()) != 0);
                } else if (pname.equals("PhysicsWorldTop")) {
                    rmn.put(Room.PRoom.PHYSICS_TOP, Integer.parseInt(pnode.getTextContent()));
                } else if (pname.equals("PhysicsWorldLeft")) {
                    rmn.put(Room.PRoom.PHYSICS_LEFT, Integer.parseInt(pnode.getTextContent()));
                } else if (pname.equals("PhysicsWorldRight")) {
                    rmn.put(Room.PRoom.PHYSICS_RIGHT, Integer.parseInt(pnode.getTextContent()));
                } else if (pname.equals("PhysicsWorldBottom")) {
                    rmn.put(Room.PRoom.PHYSICS_BOTTOM, Integer.parseInt(pnode.getTextContent()));
                } else if (pname.equals("PhysicsWorldGravityX")) {
                    rmn.put(Room.PRoom.PHYSICS_GRAVITY_X, Double.parseDouble(pnode.getTextContent()));
                } else if (pname.equals("PhysicsWorldGravityY")) {
                    rmn.put(Room.PRoom.PHYSICS_GRAVITY_Y, Double.parseDouble(pnode.getTextContent()));
                } else if (pname.equals("PhysicsWorldPixToMeters")) {
                    rmn.put(Room.PRoom.PHYSICS_PIXTOMETERS, Double.parseDouble(pnode.getTextContent()));
                }
            }
            ++x;
        }
    }

    private static void readInclude(ProjectFileContext c, ResNode node, Node cNode) {
        if (!(cNode instanceof Element)) {
            return;
        }
        Element el = (Element)cNode;
        ProjectFile f = c.f;
        Include inc = f.resMap.getList(Include.class).add();
        String name = el.getElementsByTagName("name").item(0).getTextContent();
        inc.setName(Util.fileNameWithoutExtension(name));
        ResNode rnode = new ResNode(inc.getName(), 3, Include.class, inc.reference);
        node.add(rnode);
        boolean overwrite = Integer.parseInt(el.getElementsByTagName("overwrite").item(0).getTextContent()) != 0;
        inc.put(Include.PInclude.OVERWRITE, overwrite);
        boolean freeMemory = Integer.parseInt(el.getElementsByTagName("freeData").item(0).getTextContent()) != 0;
        inc.put(Include.PInclude.FREEMEMORY, freeMemory);
        boolean removeEnd = Integer.parseInt(el.getElementsByTagName("removeEnd").item(0).getTextContent()) != 0;
        inc.put(Include.PInclude.REMOVEATGAMEEND, removeEnd);
        boolean store = Integer.parseInt(el.getElementsByTagName("store").item(0).getTextContent()) != 0;
        inc.put(Include.PInclude.STORE, store);
        int size = Integer.parseInt(el.getElementsByTagName("size").item(0).getTextContent());
        inc.put(Include.PInclude.SIZE, size);
        String exportFolder = el.getElementsByTagName("exportDir").item(0).getTextContent();
        inc.put(Include.PInclude.EXPORTFOLDER, exportFolder);
        int exportAction = Integer.parseInt(el.getElementsByTagName("exportAction").item(0).getTextContent());
        inc.put(Include.PInclude.EXPORTACTION, (Object)ProjectFile.INCLUDE_EXPORT_ACTION[exportAction]);
        String filename = el.getElementsByTagName("filename").item(0).getTextContent();
        inc.put(Include.PInclude.FILENAME, filename);
        String filePath = filename;
        ResNode parent = node;
        while (parent != null && parent.status == 2) {
            filePath = String.valueOf(parent.toString()) + File.separatorChar + filePath;
            parent = (ResNode)parent.getParent();
        }
        filePath = String.valueOf(f.getDirectory()) + File.separatorChar + "datafiles" + File.separatorChar + filePath;
        inc.put(Include.PInclude.FILEPATH, filePath);
        File dataFile = new File(filePath);
        try {
            inc.data = Files.readAllBytes(dataFile.toPath());
        }
        catch (IOException e) {
            ProjectFile.interfaceProvider.handleException(new GmFormatException(c.f, "failed to read: " + dataFile.getAbsolutePath(), e));
        }
    }

    private static void readPackages(ProjectFileContext c, ResNode root) {
        ExtensionPackages extpkgs = c.f.extPackages;
        ResNode node = new ResNode(Resource.kindNamesPlural.get(ExtensionPackages.class), 3, ExtensionPackages.class, extpkgs.reference);
        root.add(node);
    }

    private static void readExtensions(ProjectFileContext c, ResNode root) {
        Document in = c.in;
        ResNode node = new ResNode(Resource.kindNamesPlural.get(Extension.class), 1, Extension.class, null);
        root.add(node);
        NodeList extList = in.getElementsByTagName("extensions");
        if (extList.getLength() <= 0) {
            return;
        }
        extList = extList.item(0).getChildNodes();
    }

    private static void readConstants(Constants cnsts, Node node) {
        if (node == null) {
            return;
        }
        int count = Integer.valueOf(node.getAttributes().getNamedItem("number").getNodeValue());
        ArrayList<Constant> newList = new ArrayList<Constant>(count);
        NodeList cnstNodes = node.getChildNodes();
        int i = 0;
        while (i < cnstNodes.getLength()) {
            Node cnstNode = cnstNodes.item(i);
            if (cnstNode.getNodeName().equals("constant")) {
                String name = cnstNode.getAttributes().getNamedItem("name").getTextContent();
                String value = cnstNode.getTextContent();
                newList.add(new Constant(name, value));
            }
            ++i;
        }
        cnsts.constants = newList;
    }

    private static void readDefaultConstants(ProjectFileContext c, ResNode root) {
        GMXFileReader.readConstants(c.f.defaultConstants, c.in.getElementsByTagName("constants").item(0));
        ResNode node = new ResNode("Constants", 3, Constants.class, null);
        root.add(node);
    }

    private static void readGameInformation(ProjectFileContext c, ResNode root) {
        Document in = c.in;
        GameInformation gameInfo = c.f.gameInfo;
        NodeList rtfNodes = in.getElementsByTagName("rtf");
        if (rtfNodes.getLength() == 0) {
            return;
        }
        Node rtfNode = rtfNodes.item(rtfNodes.getLength() - 1);
        String path = String.valueOf(c.f.getDirectory()) + '/' + Util.getPOSIXPath(rtfNode.getTextContent());
        String text = "";
        try {
            Throwable throwable = null;
            Object var9_12 = null;
            try (BufferedReader reader = new BufferedReader(new FileReader(path));){
                String line = "";
                while ((line = reader.readLine()) != null) {
                    text = String.valueOf(text) + line + '\n';
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException e) {
            ProjectFile.interfaceProvider.handleException(new GmFormatException(c.f, "file not found: " + path, e));
        }
        catch (IOException e) {
            ProjectFile.interfaceProvider.handleException(new GmFormatException(c.f, "unable to read file: " + path, e));
        }
        gameInfo.put(GameInformation.PGameInformation.TEXT, (Object)text);
        ResNode node = new ResNode(Resource.kindNamesPlural.get(GameInformation.class), 3, GameInformation.class, gameInfo.reference);
        root.add(node);
    }

    private static void readActions(ProjectFileContext c, ActionContainer container, String errorKey, int format1, int format2, NodeList actList) {
        final ProjectFile f = c.f;
        int i = 0;
        while (i < actList.getLength()) {
            Node actNode = actList.item(i);
            if (!actNode.getNodeName().equals("#text")) {
                boolean unknownLib;
                int libid = 0;
                int actid = 0;
                byte kind = 0;
                boolean userelative = false;
                boolean isquestion = false;
                boolean isquestiontrue = false;
                boolean isrelative = false;
                boolean useapplyto = false;
                byte exectype = 0;
                String appliesto = "";
                String functionname = "";
                String codestring = "";
                Argument[] args = null;
                LibAction la = null;
                NodeList propList = actNode.getChildNodes();
                int ii = 0;
                while (ii < propList.getLength()) {
                    Node prop = propList.item(ii);
                    if (!prop.getNodeName().equals("#text")) {
                        if (prop.getNodeName().equals("libid")) {
                            libid = Integer.parseInt(prop.getTextContent());
                        } else if (prop.getNodeName().equals("id")) {
                            actid = Integer.parseInt(prop.getTextContent());
                        } else if (prop.getNodeName().equals("kind")) {
                            kind = Byte.parseByte(prop.getTextContent());
                        } else if (prop.getNodeName().equals("userelative")) {
                            userelative = Integer.parseInt(prop.getTextContent()) != 0;
                        } else if (prop.getNodeName().equals("relative")) {
                            isrelative = Integer.parseInt(prop.getTextContent()) != 0;
                        } else if (prop.getNodeName().equals("isquestion")) {
                            isquestion = Integer.parseInt(prop.getTextContent()) != 0;
                        } else if (prop.getNodeName().equals("isnot")) {
                            isquestiontrue = Integer.parseInt(prop.getTextContent()) != 0;
                        } else if (prop.getNodeName().equals("useapplyto")) {
                            useapplyto = Integer.parseInt(prop.getTextContent()) != 0;
                        } else if (prop.getNodeName().equals("exetype")) {
                            exectype = Byte.parseByte(prop.getTextContent());
                        } else if (prop.getNodeName().equals("whoName")) {
                            appliesto = prop.getTextContent();
                        } else if (prop.getNodeName().equals("functionname")) {
                            functionname = prop.getTextContent();
                        } else if (prop.getNodeName().equals("codestring")) {
                            codestring = prop.getTextContent();
                        } else if (prop.getNodeName().equals("arguments")) {
                            Node arg;
                            NodeList targList = prop.getChildNodes();
                            ArrayList<Node> argList = new ArrayList<Node>();
                            int x = 0;
                            while (x < targList.getLength()) {
                                arg = targList.item(x);
                                if (!arg.getNodeName().equals("#text")) {
                                    argList.add(arg);
                                }
                                ++x;
                            }
                            args = new Argument[argList.size()];
                            x = 0;
                            while (x < argList.size()) {
                                arg = (Node)argList.get(x);
                                if (!arg.getNodeName().equals("#text")) {
                                    args[x] = new Argument(0);
                                    NodeList argproplist = arg.getChildNodes();
                                    int xx = 0;
                                    while (xx < argproplist.getLength()) {
                                        Node argprop = argproplist.item(xx);
                                        if (!prop.getNodeName().equals("#text")) {
                                            final String proptext = argprop.getTextContent();
                                            final Argument argument = args[x];
                                            if (argprop.getNodeName().equals("kind")) {
                                                argument.kind = Byte.parseByte(argprop.getTextContent());
                                            } else if (argprop.getNodeName().equals("string")) {
                                                argument.setVal(proptext);
                                            } else {
                                                Class<? extends Resource<?, ?>> kindc = Argument.getResourceKind(argument.kind);
                                                if (kindc != null && Resource.class.isAssignableFrom(kindc)) {
                                                    try {
                                                        PostponedRef pr = new PostponedRef(){

                                                            @Override
                                                            public boolean invoke() {
                                                                ProjectFile.ResourceHolder rh = (ProjectFile.ResourceHolder)f.resMap.get(Argument.getResourceKind(argument.kind));
                                                                if (rh == null) {
                                                                    return false;
                                                                }
                                                                Object temp = null;
                                                                temp = rh instanceof ResourceList ? ((ResourceList)rh).get(proptext) : rh.getResource();
                                                                if (temp != null) {
                                                                    argument.setRes(temp.reference);
                                                                }
                                                                argument.setVal(proptext);
                                                                return temp != null;
                                                            }
                                                        };
                                                        postpone.add(pr);
                                                    }
                                                    catch (NumberFormatException numberFormatException) {
                                                        // empty catch block
                                                    }
                                                }
                                            }
                                        }
                                        ++xx;
                                    }
                                }
                                ++x;
                            }
                        }
                    }
                    ++ii;
                }
                la = LibManager.getLibAction(libid, actid);
                boolean bl = unknownLib = la == null;
                if (unknownLib) {
                    la = new LibAction();
                    la.id = actid;
                    la.parentId = libid;
                    la.actionKind = kind;
                    if (la.actionKind == 7) {
                        la = LibManager.codeAction;
                    } else {
                        la.allowRelative = userelative;
                        la.question = isquestion;
                        la.canApplyTo = useapplyto;
                        la.execType = exectype;
                        if (la.execType == 1) {
                            la.execInfo = functionname;
                        }
                        if (la.execType == 2) {
                            la.execInfo = codestring;
                        }
                    }
                    if (args != null) {
                        la.libArguments = new LibArgument[args.length];
                        int b = 0;
                        while (b < args.length) {
                            LibArgument argument = new LibArgument();
                            argument.kind = args[b].kind;
                            la.libArguments[b] = argument;
                            ++b;
                        }
                    }
                }
                final Action act = container.addAction(la);
                if (appliesto.equals("self")) {
                    act.setAppliesTo(GmObject.OBJECT_SELF);
                } else if (appliesto.equals("other")) {
                    act.setAppliesTo(GmObject.OBJECT_OTHER);
                } else {
                    final String objname = appliesto;
                    PostponedRef pr = new PostponedRef(){

                        @Override
                        public boolean invoke() {
                            ResourceList<GmObject> list = f.resMap.getList(GmObject.class);
                            if (list == null) {
                                return false;
                            }
                            GmObject obj = list.get(objname);
                            if (obj == null) {
                                return false;
                            }
                            act.setAppliesTo(obj.reference);
                            return true;
                        }
                    };
                    postpone.add(pr);
                }
                act.setRelative(isrelative);
                if (args != null && args.length > 0) {
                    act.setArguments(args);
                }
                act.setNot(isquestiontrue);
            }
            ++i;
        }
    }

    static class DefaultPostponedRef<K extends Enum<K>>
    implements PostponedRef {
        ResourceList<?> list;
        String name;
        PropertyMap<K> p;
        K key;

        DefaultPostponedRef(ResourceList<?> list, PropertyMap<K> p, K key, String name) {
            this.list = list;
            this.p = p;
            this.key = key;
            this.name = name;
        }

        @Override
        public boolean invoke() {
            Object temp = this.list.get(this.name);
            if (temp != null) {
                this.p.put(this.key, (Object)((Resource)temp).reference);
            }
            return temp != null;
        }
    }

    static interface PostponedRef {
        public boolean invoke();
    }

    private static class ProjectFileContext {
        ProjectFile f;
        Document in;
        RefList<Timeline> timeids;
        RefList<GmObject> objids;
        RefList<Room> rmids;

        public ProjectFileContext(ProjectFile f, Document d, RefList<Timeline> timeids, RefList<GmObject> objids, RefList<Room> rmids) {
            this.f = f;
            this.in = d;
            this.timeids = timeids;
            this.objids = objids;
            this.rmids = rmids;
        }

        public ProjectFileContext copy() {
            return new ProjectFileContext(this.f, this.in, this.timeids, this.objids, this.rmids);
        }
    }
}

