/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.file;

import java.io.File;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.lateralgm.main.UpdateSource;

public class FileChangeMonitor
implements Runnable {
    private static final int POLL_INTERVAL = 1000;
    private static ScheduledExecutorService monitorService = Executors.newSingleThreadScheduledExecutor();
    public final File file;
    public final Executor executor;
    private final UpdateRunnable changedRunnable;
    private final UpdateRunnable deletedRunnable;
    private final ScheduledFuture<?> future;
    private final UpdateSource.UpdateTrigger trigger = new UpdateSource.UpdateTrigger();
    public final UpdateSource updateSource = new UpdateSource(this, this.trigger);
    private long lastModified;
    private long length;
    private boolean changed;

    public FileChangeMonitor(File f, Executor e) {
        if (!f.exists()) {
            throw new IllegalArgumentException();
        }
        this.file = f;
        this.executor = e;
        this.changedRunnable = new UpdateRunnable(new FileUpdateEvent(this.updateSource, Flag.CHANGED));
        this.deletedRunnable = new UpdateRunnable(new FileUpdateEvent(this.updateSource, Flag.DELETED));
        this.lastModified = this.file.lastModified();
        this.length = this.file.length();
        this.future = monitorService.scheduleWithFixedDelay(this, 1000L, 1000L, TimeUnit.MILLISECONDS);
    }

    public FileChangeMonitor(String f, Executor e) {
        this(new File(f), e);
    }

    public void stop() {
        this.future.cancel(false);
    }

    @Override
    public void run() {
        if (!this.file.exists()) {
            this.executor.execute(this.deletedRunnable);
            this.future.cancel(false);
            return;
        }
        long m = this.file.lastModified();
        long l = this.file.length();
        if (m != this.lastModified || l != this.length) {
            this.changed = true;
            this.lastModified = m;
            this.length = l;
        } else if (this.changed) {
            this.executor.execute(this.changedRunnable);
            this.changed = false;
        }
    }

    public class FileUpdateEvent
    extends UpdateSource.UpdateEvent {
        public final Flag flag;

        public FileUpdateEvent(UpdateSource s, Flag f) {
            super(s);
            this.flag = f;
        }
    }

    public static enum Flag {
        CHANGED,
        DELETED;

    }

    private class UpdateRunnable
    implements Runnable {
        public final FileUpdateEvent event;

        public UpdateRunnable(FileUpdateEvent e) {
            this.event = e;
        }

        @Override
        public void run() {
            FileChangeMonitor.this.trigger.fire(this.event);
        }
    }
}

