/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.file;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.zip.CRC32;
import javax.imageio.ImageIO;
import org.lateralgm.main.LGM;

public final class ApngIO {
    public static final byte[] PNG_SIGNATURE = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    public static final String IO_FMT = "png";

    private static byte bite(int i, int p) {
        return (byte)(i >> p & 0xFF);
    }

    private static byte[] i2b(int i) {
        return new byte[]{ApngIO.bite(i, 24), ApngIO.bite(i, 16), ApngIO.bite(i, 8), ApngIO.bite(i, 0)};
    }

    private static void readFully(InputStream in, byte[] buffer) throws IOException {
        ApngIO.readFully(in, buffer, 0, buffer.length);
    }

    private static void readFully(InputStream in, byte[] buffer, int off, int len) throws IOException {
        int n;
        int total = 0;
        do {
            if ((n = in.read(buffer, off + total, len - total)) > 0) continue;
            if (total != 0) break;
            total = n;
            break;
        } while ((total += n) != len);
    }

    private static void transferIDATs(InputStream dis, OutputStream os, int sn, boolean ignoreOthers) throws IOException {
        Generic_Chunk chunk = new Generic_Chunk();
        while (chunk.read(dis) && !chunk.isType(IEND.type)) {
            if (chunk.isType(IDAT.type)) {
                os.write((sn == -1 ? chunk : new fdAT(chunk, sn)).getBytes());
                continue;
            }
            if (ignoreOthers) continue;
            os.write(chunk.getBytes());
        }
    }

    public static void imagesToApng(ArrayList<BufferedImage> imgs, OutputStream fullFile) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)imgs.get(0), IO_FMT, baos);
        byte[] buf = baos.toByteArray();
        IHDR_Dummy myhdr = new IHDR_Dummy(buf);
        acTL myactl = new acTL(imgs.size(), 0);
        fcTL fctl = new fcTL(0, imgs.get(0).getWidth(), imgs.get(0).getHeight(), 0, 0, 1, 30, fcTL.Dispose.BACKGROUND, fcTL.Blend.OVER);
        fullFile.write(PNG_SIGNATURE);
        fullFile.write(myhdr.getBytes());
        fullFile.write(myactl.getBytes());
        fullFile.write(fctl.getBytes());
        ByteArrayInputStream bais = new ByteArrayInputStream(buf);
        bais.skip(8L);
        ApngIO.transferIDATs(bais, fullFile, -1, true);
        int indx = -1;
        for (BufferedImage bi : imgs) {
            if (indx++ == -1) continue;
            baos.reset();
            ImageIO.write((RenderedImage)bi, IO_FMT, baos);
            fctl = new fcTL(indx++, bi.getWidth(), bi.getHeight(), 0, 0, 1, 30, fcTL.Dispose.BACKGROUND, fcTL.Blend.OVER);
            fullFile.write(fctl.getBytes());
            buf = baos.toByteArray();
            bais = new ByteArrayInputStream(buf);
            bais.skip(8L);
            ApngIO.transferIDATs(bais, fullFile, indx, true);
        }
        fullFile.write(IEND.instance.getBytes());
    }

    public static ArrayList<BufferedImage> apngToBufferedImages(InputStream is) {
        Generic_Chunk genChunk = new Generic_Chunk();
        ByteArrayOutputStream png = new ByteArrayOutputStream();
        ArrayList<BufferedImage> ret = new ArrayList<BufferedImage>();
        byte[] imageHeader = null;
        try {
            png.write(PNG_SIGNATURE);
            byte[] pngBase = new byte[8];
            is.read(pngBase);
            if (!Arrays.equals(pngBase, PNG_SIGNATURE)) {
                throw new IOException("Not APNG");
            }
            boolean hasData = false;
            while (genChunk.read(is)) {
                ByteArrayInputStream bais;
                if (genChunk.isType(acTL.type)) continue;
                if (genChunk.isType(fcTL.type)) {
                    if (!hasData) continue;
                    png.write(IEND.instance.getBytes());
                    bais = new ByteArrayInputStream(png.toByteArray());
                    ret.add(ImageIO.read(bais));
                    png.reset();
                    png.write(pngBase);
                    png.write(imageHeader);
                    hasData = false;
                    bais.close();
                    continue;
                }
                if (genChunk.isType(IDAT.type)) {
                    png.write(genChunk.getBytes());
                    hasData = true;
                    continue;
                }
                if (genChunk.isType(fdAT.type)) {
                    byte[] a = new fdAT(genChunk).toIDAT().getBytes();
                    png.write(a);
                    hasData = true;
                    continue;
                }
                if (genChunk.isType(IEND.type)) {
                    png.write(genChunk.getBytes());
                    bais = new ByteArrayInputStream(png.toByteArray());
                    ret.add(ImageIO.read(bais));
                    bais.close();
                    break;
                }
                if (genChunk.isType(IHDR_Dummy.type)) {
                    imageHeader = genChunk.getBytes();
                    png.write(imageHeader);
                    continue;
                }
                png.write(genChunk.getBytes());
            }
        }
        catch (IOException e) {
            LGM.showDefaultExceptionHandler(e);
        }
        return ret;
    }

    private static class ChunkType {
        private int val;
        private byte[] data;

        public ChunkType(byte[] bytes) {
            this.data = bytes;
            this.val = ChunkType.bytesToInt(bytes);
        }

        public byte[] getBytes() {
            return this.data;
        }

        public static int bytesToInt(byte[] b) {
            if (b.length != 4) {
                throw new ArrayIndexOutOfBoundsException();
            }
            return b[0] << 24 | b[1] << 16 | b[2] << 8 | b[3];
        }

        public boolean equals(ChunkType other) {
            return this.val == other.val;
        }
    }

    private static class Generic_Chunk
    extends PNG_Chunk {
        public Generic_Chunk() {
            super(null);
        }

        @Override
        void repopulate() {
            System.err.println("Repopulate called on generic chunk.");
        }
    }

    private static class IDAT
    extends PNG_Chunk {
        public static final ChunkType type = new ChunkType(new byte[]{73, 68, 65, 84});

        public IDAT(byte[] dat) {
            super(type);
            this.data = dat;
            this.repopulate();
        }

        @Override
        public void repopulate() {
            this.updateCRC();
        }
    }

    private static class IEND
    extends PNG_Chunk {
        public static final ChunkType type = new ChunkType(new byte[]{73, 69, 78, 68});
        public static final IEND instance = new IEND();

        private IEND() {
            super(type);
            this.repopulate();
        }

        @Override
        public void repopulate() {
            this.data = new byte[0];
            this.updateCRC();
        }
    }

    private static class IHDR_Dummy
    extends PNG_Chunk {
        public static final ChunkType type = new ChunkType(new byte[]{73, 72, 68, 82});

        public IHDR_Dummy(byte[] png) {
            super(type);
            this.data = new byte[13];
            System.arraycopy(png, 16, this.data, 0, this.data.length);
            this.repopulate();
        }

        @Override
        void repopulate() {
            this.updateCRC();
        }
    }

    private static abstract class PNG_Chunk {
        protected int length = 0;
        protected ChunkType chunkType;
        protected byte[] data;
        protected byte[] crc;

        public PNG_Chunk(ChunkType type) {
            this.chunkType = type;
        }

        void updateCRC() {
            CRC32 crc32 = new CRC32();
            crc32.update(this.chunkType.getBytes());
            crc32.update(this.data);
            int tcrc = (int)crc32.getValue();
            this.length = this.data.length;
            this.crc = ApngIO.i2b(tcrc);
        }

        abstract void repopulate();

        byte[] getBytes() {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                baos.write(ApngIO.i2b(this.length));
                baos.write(this.chunkType.getBytes());
                baos.write(this.data);
                baos.write(this.crc);
            }
            catch (IOException e) {
                LGM.showDefaultExceptionHandler(e);
            }
            return baos.toByteArray();
        }

        boolean isType(ChunkType t) {
            return this.chunkType == null ? false : this.chunkType.equals(t);
        }

        boolean read(InputStream dis) throws IOException {
            int b1 = dis.read();
            if (b1 == -1) {
                return false;
            }
            this.length = b1 << 24 | dis.read() << 16 | dis.read() << 8 | dis.read();
            byte[] chunkTypeBytes = new byte[4];
            ApngIO.readFully(dis, chunkTypeBytes);
            this.chunkType = new ChunkType(chunkTypeBytes);
            this.data = new byte[this.length];
            ApngIO.readFully(dis, this.data);
            this.crc = new byte[4];
            ApngIO.readFully(dis, this.crc);
            return true;
        }
    }

    private static class acTL
    extends PNG_Chunk {
        public static final ChunkType type = new ChunkType(new byte[]{97, 99, 84, 76});
        int numFrames;
        int numPlays;

        public acTL(int nf, int np) {
            super(type);
            this.numFrames = nf;
            this.numPlays = np;
            this.repopulate();
        }

        @Override
        public void repopulate() {
            this.data = new byte[]{ApngIO.bite(this.numFrames, 24), ApngIO.bite(this.numFrames, 16), ApngIO.bite(this.numFrames, 8), ApngIO.bite(this.numFrames, 0), ApngIO.bite(this.numPlays, 24), ApngIO.bite(this.numPlays, 16), ApngIO.bite(this.numPlays, 8), ApngIO.bite(this.numPlays, 0)};
            this.updateCRC();
        }
    }

    private static class fcTL
    extends PNG_Chunk {
        public static final ChunkType type = new ChunkType(new byte[]{102, 99, 84, 76});
        protected int sequenceNumber;
        protected int width;
        protected int height;
        protected int xOffset;
        protected int yOffset;
        protected short delayNum;
        protected short delayDen;
        protected Dispose disposeOp;
        protected Blend blendOp;

        public fcTL(int sn, int w, int h, int xo, int yo, short dn, short dd, Dispose dop, Blend bop) {
            super(type);
            this.sequenceNumber = sn;
            this.width = w;
            this.height = h;
            this.xOffset = xo;
            this.yOffset = yo;
            this.delayNum = dn;
            this.delayDen = dd;
            this.disposeOp = dop;
            this.blendOp = bop;
            this.repopulate();
        }

        @Override
        void repopulate() {
            this.data = new byte[]{ApngIO.bite(this.sequenceNumber, 24), ApngIO.bite(this.sequenceNumber, 16), ApngIO.bite(this.sequenceNumber, 8), ApngIO.bite(this.sequenceNumber, 0), ApngIO.bite(this.width, 24), ApngIO.bite(this.width, 16), ApngIO.bite(this.width, 8), ApngIO.bite(this.width, 0), ApngIO.bite(this.height, 24), ApngIO.bite(this.height, 16), ApngIO.bite(this.height, 8), ApngIO.bite(this.height, 0), ApngIO.bite(this.xOffset, 24), ApngIO.bite(this.xOffset, 16), ApngIO.bite(this.xOffset, 8), ApngIO.bite(this.xOffset, 0), ApngIO.bite(this.yOffset, 24), ApngIO.bite(this.yOffset, 16), ApngIO.bite(this.yOffset, 8), ApngIO.bite(this.yOffset, 0), ApngIO.bite(this.delayNum, 8), ApngIO.bite(this.delayNum, 0), ApngIO.bite(this.delayDen, 8), ApngIO.bite(this.delayDen, 0), this.disposeOp.getValue(), this.blendOp.getValue()};
            this.updateCRC();
        }

        public static enum Blend {
            SOURCE(0),
            OVER(1);

            private byte value;

            private Blend(int v) {
                this.value = (byte)v;
            }

            public byte getValue() {
                return this.value;
            }
        }

        public static enum Dispose {
            NONE(0),
            BACKGROUND(1),
            PREVIOUS(2);

            private byte value;

            private Dispose(int v) {
                this.value = (byte)v;
            }

            public byte getValue() {
                return this.value;
            }
        }
    }

    private static class fdAT
    extends PNG_Chunk {
        public static final ChunkType type = new ChunkType(new byte[]{102, 100, 65, 84});
        protected int sequenceNumber;
        protected byte[] frameData;

        public fdAT(PNG_Chunk pc) {
            super(pc.chunkType);
            this.length = pc.length;
            this.sequenceNumber = pc.data[0] << 24 | pc.data[1] << 16 | pc.data[2] << 8 | pc.data[3];
            this.frameData = new byte[pc.data.length - 4];
            System.arraycopy(pc.data, 4, this.frameData, 0, this.frameData.length);
            this.crc = pc.crc;
        }

        public fdAT(PNG_Chunk src, int sn) {
            super(type);
            this.length = src.length;
            this.sequenceNumber = sn;
            this.frameData = src.data;
            this.repopulate();
        }

        @Override
        public void repopulate() {
            this.data = new byte[this.frameData.length + 4];
            System.arraycopy(ApngIO.i2b(this.sequenceNumber), 0, this.data, 0, 4);
            System.arraycopy(this.frameData, 0, this.data, 4, this.frameData.length);
            this.updateCRC();
        }

        public IDAT toIDAT() {
            return new IDAT(this.frameData);
        }
    }
}

