/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.components.visual;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.TreeMap;
import javax.swing.JPanel;
import org.lateralgm.main.Util;
import org.lateralgm.ui.swing.visuals.BoundedVisual;
import org.lateralgm.ui.swing.visuals.Visual;
import org.lateralgm.ui.swing.visuals.VisualContainer;

public class VisualPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final Point ORIGIN_MOUSE = new Point();
    private final TreeMap<Integer, Visual> visuals = new TreeMap();
    private final Rectangle overallBounds = new Rectangle();
    public final VisualContainer container = new PanelVisualContainer();
    private int zoom = 1;
    protected Point zoomOrigin;
    private boolean boundsLocked = false;
    private boolean boundsUpdated = false;

    public VisualPanel() {
        this.setBackground(Color.GRAY);
        this.setOpaque(true);
    }

    protected void componentToVisual(Point p) {
        this.componentToVisual(p, this.zoom);
    }

    protected void componentToVisual(Point p, int z) {
        p.x = VisualPanel.zoom(p.x - this.visualOffsetX(z), 2 - z) + this.overallBounds.x;
        p.y = VisualPanel.zoom(p.y - this.visualOffsetY(z), 2 - z) + this.overallBounds.y;
    }

    protected void componentToVisual(Rectangle r, int z) {
        Point p = r.getLocation();
        this.componentToVisual(p, z);
        r.setLocation(p);
        r.width = VisualPanel.zoom(r.width, 2 - z);
        r.height = VisualPanel.zoom(r.height, 2 - z);
    }

    public void visualToComponent(Point p) {
        this.visualToComponent(p, this.zoom);
    }

    public void visualToComponent(Point p, int z) {
        p.x = VisualPanel.zoom(p.x - this.overallBounds.x, z) + this.visualOffsetX(z);
        p.y = VisualPanel.zoom(p.y - this.overallBounds.y, z) + this.visualOffsetY(z);
    }

    protected void visualToComponent(Rectangle r, int z) {
        Point p = r.getLocation();
        this.visualToComponent(p, z);
        r.setLocation(p);
        r.width = VisualPanel.zoom(r.width, z);
        r.height = VisualPanel.zoom(r.height, z);
    }

    public Rectangle getOverallBounds() {
        return this.overallBounds;
    }

    protected static double zoom(double d, int z) {
        return z > 0 ? (double)z * d : d / (double)(2 - z);
    }

    protected static int zoom(int i, int z) {
        return z > 0 ? z * i : Util.negDiv(i, 2 - z);
    }

    protected static int zoomAlign(int i, int z, boolean ceil) {
        return z <= 0 ? (2 - z) * Util.negDiv(i + (ceil ? 1 - z : 0), 2 - z) : i;
    }

    protected static void zoomAlign(Rectangle r, int z, boolean out) {
        int x0 = VisualPanel.zoomAlign(r.x, z, !out);
        int y0 = VisualPanel.zoomAlign(r.y, z, !out);
        r.setBounds(x0, y0, VisualPanel.zoomAlign(r.width + r.x - x0, z, out), VisualPanel.zoomAlign(r.height + r.y - y0, z, out));
    }

    protected static void zoom(Rectangle r, int z) {
        r.x = VisualPanel.zoom(r.x, z);
        r.y = VisualPanel.zoom(r.y, z);
        r.width = VisualPanel.zoom(r.width, z);
        r.height = VisualPanel.zoom(r.height, z);
    }

    protected int visualOffsetX(int z) {
        return (this.getWidth() - VisualPanel.zoom(this.overallBounds.width, z)) / 2;
    }

    protected int visualOffsetY(int z) {
        return (this.getHeight() - VisualPanel.zoom(this.overallBounds.height, z)) / 2;
    }

    protected Rectangle getOverallBounds(Rectangle r) {
        if (r == null) {
            return new Rectangle(this.overallBounds);
        }
        r.setBounds(this.overallBounds);
        return r;
    }

    protected static void calculateOverallBounds(Rectangle b) {
        b.grow(128, 128);
        b.add(0, 0);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension s = this.overallBounds.getSize();
        s.width = VisualPanel.zoom(s.width, this.zoom);
        s.height = VisualPanel.zoom(s.height, this.zoom);
        return s;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics g2 = g.create();
        if (g2.getClip() == null) {
            g2.setClip(0, 0, this.getWidth(), this.getHeight());
        }
        g2.translate(this.visualOffsetX(this.zoom), this.visualOffsetY(this.zoom));
        if (this.zoom != 1) {
            double s = VisualPanel.zoom(1.0, this.zoom);
            Graphics2D g3 = (Graphics2D)g2;
            g3.scale(s, s);
            g3.setRenderingHint(RenderingHints.KEY_INTERPOLATION, this.zoom < 1 ? RenderingHints.VALUE_INTERPOLATION_BILINEAR : RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        }
        g2.translate(-this.overallBounds.x, -this.overallBounds.y);
        this.paintVisuals(g2);
        g2.dispose();
    }

    protected void paintVisuals(Graphics g) {
        for (Visual v : this.visuals.values()) {
            v.paint(g);
        }
    }

    public void put(int layer, Visual v) {
        Visual pv;
        Visual visual = pv = v == null ? this.visuals.remove(layer) : this.visuals.put(layer, v);
        if (pv == v) {
            return;
        }
        if (v instanceof BoundedVisual || pv instanceof BoundedVisual) {
            this.container.updateBounds();
        }
        this.repaint();
    }

    protected void lockBounds() {
        this.boundsLocked = true;
    }

    protected void unlockBounds() {
        this.boundsLocked = false;
        if (this.boundsUpdated) {
            this.container.updateBounds();
            this.boundsUpdated = false;
        }
    }

    public void setZoom(int z) {
        if (this.zoom == z) {
            return;
        }
        this.zoom = z;
        this.container.updateBounds();
    }

    private class PanelVisualContainer
    implements VisualContainer {
        private int oldZoom;

        private PanelVisualContainer() {
            this.oldZoom = VisualPanel.this.zoom;
        }

        @Override
        public void repaint(Rectangle r) {
            if (r == null) {
                VisualPanel.this.repaint();
            } else {
                Rectangle cr = r.getBounds();
                VisualPanel.zoomAlign(cr, VisualPanel.this.zoom, true);
                VisualPanel.this.visualToComponent(cr, VisualPanel.this.zoom);
                VisualPanel.this.repaint(cr);
            }
        }

        @Override
        public void updateBounds() {
            Point co;
            boolean uz;
            boolean uob;
            boolean bl = uob = !VisualPanel.this.boundsLocked;
            if (VisualPanel.this.boundsLocked) {
                VisualPanel.this.boundsUpdated = true;
            }
            boolean bl2 = uz = VisualPanel.this.zoom != this.oldZoom;
            if (!uob && !uz) {
                return;
            }
            Point o = VisualPanel.this.zoomOrigin;
            if (o == null || o == ORIGIN_MOUSE) {
                Point point = co = o == null ? null : VisualPanel.this.getMousePosition();
                if (co == null) {
                    Rectangle vr = VisualPanel.this.getVisibleRect();
                    co = new Point(vr.x + vr.width / 2, vr.y + vr.height / 2);
                }
                o = co.getLocation();
                VisualPanel.this.componentToVisual(o, this.oldZoom);
            } else {
                co = o.getLocation();
                VisualPanel.this.visualToComponent(co, this.oldZoom);
            }
            Rectangle oob = VisualPanel.this.overallBounds.getBounds();
            if (uob) {
                VisualPanel.this.overallBounds.setSize(-1, -1);
                for (Visual v : VisualPanel.this.visuals.values()) {
                    if (!(v instanceof BoundedVisual)) continue;
                    ((BoundedVisual)v).extendBounds(VisualPanel.this.overallBounds);
                }
                VisualPanel.calculateOverallBounds(VisualPanel.this.overallBounds);
            }
            VisualPanel.zoomAlign(VisualPanel.this.overallBounds, VisualPanel.this.zoom, true);
            if (oob.equals(VisualPanel.this.overallBounds) && !uz) {
                return;
            }
            Point p = VisualPanel.this.getLocation();
            VisualPanel.this.setBounds(p.x + co.x - VisualPanel.zoom(o.x - ((VisualPanel)VisualPanel.this).overallBounds.x, VisualPanel.this.zoom), p.y + co.y - VisualPanel.zoom(o.y - ((VisualPanel)VisualPanel.this).overallBounds.y, VisualPanel.this.zoom), Math.max(VisualPanel.this.getWidth(), VisualPanel.zoom(((VisualPanel)VisualPanel.this).overallBounds.width, VisualPanel.this.zoom)), Math.max(VisualPanel.this.getHeight(), VisualPanel.zoom(((VisualPanel)VisualPanel.this).overallBounds.height, VisualPanel.this.zoom)));
            this.oldZoom = VisualPanel.this.zoom;
            VisualPanel.this.revalidate();
        }
    }
}

