/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.components.visual;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import org.lateralgm.components.visual.AbstractImagePreview;
import org.lateralgm.main.UpdateSource;
import org.lateralgm.main.Util;
import org.lateralgm.resources.Sprite;
import org.lateralgm.util.PropertyMap;

public class SubimagePreview
extends AbstractImagePreview
implements UpdateSource.UpdateListener {
    private static final long serialVersionUID = 1L;
    private int subIndex = 0;
    private boolean showBbox = true;
    private boolean showOrigin = true;
    private final Sprite sprite;
    private final SpritePropertyListener spl = new SpritePropertyListener();
    private static final int ORIGIN_SIZE = 20;
    public boolean enableMouse = true;

    public SubimagePreview(Sprite s) {
        this.sprite = s;
        s.properties.updateSource.addListener(this.spl);
        s.reference.updateSource.addListener(this);
        this.enableEvents(501L);
        this.enableEvents(506L);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.getImage() == null) {
            return;
        }
        if (!this.showBbox && !this.showOrigin) {
            return;
        }
        g = g.create();
        this.reclipAndTranslate(g);
        int originX = (int)Math.floor((double)((Integer)this.sprite.get(Sprite.PSprite.ORIGIN_X)).intValue() * this.zoom);
        int originY = (int)Math.floor((double)((Integer)this.sprite.get(Sprite.PSprite.ORIGIN_Y)).intValue() * this.zoom);
        int left = (Integer)this.sprite.get(Sprite.PSprite.BB_LEFT);
        int right = (Integer)this.sprite.get(Sprite.PSprite.BB_RIGHT);
        int top = (Integer)this.sprite.get(Sprite.PSprite.BB_TOP);
        int bottom = (Integer)this.sprite.get(Sprite.PSprite.BB_BOTTOM);
        left = Math.min(left, right);
        right = Math.max(left, right);
        top = Math.min(top, bottom);
        bottom = Math.max(top, bottom);
        left = (int)Math.floor((double)left * this.zoom);
        top = (int)Math.floor((double)top * this.zoom);
        right = (int)Math.ceil((double)(right + 1) * this.zoom) - 1;
        bottom = (int)Math.ceil((double)(bottom + 1) * this.zoom) - 1;
        g.setXORMode(Color.BLACK);
        g.setColor(Color.WHITE);
        if (this.showBbox) {
            g.drawRect(left, top, right - left, bottom - top);
        }
        if (this.showOrigin) {
            g.drawLine(originX - 20, originY, originX + 20, originY);
            g.drawLine(originX, originY - 20, originX, originY + 20);
        }
        g.dispose();
    }

    private void setBoundedOrigin(int x, int y) {
        BufferedImage img = this.getImage();
        int w = 0;
        int h = 0;
        if (img != null) {
            w = img.getWidth();
            h = img.getHeight();
        }
        x = Math.max(0, Math.min(w, x));
        y = Math.max(0, Math.min(h, y));
        this.sprite.put(Sprite.PSprite.ORIGIN_X, x);
        this.sprite.put(Sprite.PSprite.ORIGIN_Y, y);
    }

    public void setIndex(int i) {
        this.subIndex = i;
        this.resizeAndRepaint();
    }

    public int getIndex() {
        return this.subIndex;
    }

    public void setShowBbox(boolean show) {
        if (show != this.showBbox) {
            this.repaint();
        }
        this.showBbox = show;
    }

    public void setShowOrigin(boolean show) {
        if (show != this.showOrigin) {
            this.repaint();
        }
        this.showOrigin = show;
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        if (this.enableMouse && e.getID() == 501 && e.getButton() == 1) {
            Point pnt = this.translatePoint(e.getPoint());
            this.setBoundedOrigin(pnt.x, pnt.y);
        }
        super.processMouseEvent(e);
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent e) {
        if (this.enableMouse && e.getID() == 506 && (e.getModifiersEx() & 0x400) != 0) {
            Point pnt = this.translatePoint(e.getPoint());
            this.setBoundedOrigin(pnt.x, pnt.y);
        }
        super.processMouseMotionEvent(e);
    }

    @Override
    protected BufferedImage getImage() {
        if (this.sprite == null) {
            return null;
        }
        int s = this.sprite.subImages.size();
        if (s == 0 || this.subIndex < 0) {
            return null;
        }
        BufferedImage bi = (BufferedImage)this.sprite.subImages.get(this.subIndex % s);
        if (!((Boolean)this.sprite.get(Sprite.PSprite.TRANSPARENT)).booleanValue()) {
            return bi;
        }
        return Util.getTransparentImage(bi);
    }

    @Override
    public void updated(UpdateSource.UpdateEvent e) {
        this.resizeAndRepaint();
    }

    private class SpritePropertyListener
    extends PropertyMap.PropertyUpdateListener<Sprite.PSprite> {
        private SpritePropertyListener() {
        }

        @Override
        public void updated(PropertyMap.PropertyUpdateEvent<Sprite.PSprite> e) {
            switch ((Sprite.PSprite)((Object)e.key)) {
                case TRANSPARENT: 
                case SHAPE: 
                case SMOOTH_EDGES: 
                case PRELOAD: {
                    return;
                }
            }
            SubimagePreview.this.repaint();
        }
    }
}

