/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.components.visual;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import org.lateralgm.components.NumberField;
import org.lateralgm.components.impl.SpriteStripDialog;
import org.lateralgm.components.visual.AbstractImagePreview;

public class SpriteStripPreview
extends AbstractImagePreview
implements NumberField.ValueChangeListener {
    private static final long serialVersionUID = 1L;
    private final SpriteStripDialog props;

    public SpriteStripPreview(SpriteStripDialog sd) {
        this.props = sd;
        this.enableEvents(501L);
        this.enableEvents(506L);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.getImage() == null) {
            return;
        }
        g = g.create();
        this.reclipAndTranslate(g);
        g.setXORMode(Color.BLACK);
        g.setColor(Color.WHITE);
        for (Rectangle r : this.props) {
            g.drawRect(r.x, r.y, r.width - 1, r.height - 1);
        }
        g.dispose();
    }

    private void setBoundedOrigin(int x, int y) {
        Dimension d = this.getPreferredSize();
        x = Math.max(0, Math.min(d.width - 1, x));
        y = Math.max(0, Math.min(d.height - 1, y));
        this.props.setOrigin(x, y);
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        if (e.getID() == 501 && e.getButton() == 1 && e.getX() < this.getPreferredSize().width && e.getY() < this.getPreferredSize().height) {
            Point pnt = this.translatePoint(e.getPoint());
            this.setBoundedOrigin(pnt.x, pnt.y);
        }
        super.processMouseEvent(e);
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent e) {
        if (e.getID() == 506 && (e.getModifiersEx() & 0x400) != 0) {
            Point pnt = this.translatePoint(e.getPoint());
            this.setBoundedOrigin(pnt.x, pnt.y);
        }
        super.processMouseMotionEvent(e);
    }

    @Override
    protected BufferedImage getImage() {
        return this.props == null ? null : this.props.img;
    }

    @Override
    public void valueChange(NumberField.ValueChangeEvent evt) {
        this.repaint();
    }
}

