/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.components.visual;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CompoundEdit;
import org.lateralgm.components.impl.AddPieceInstance;
import org.lateralgm.components.impl.ModifyPieceInstance;
import org.lateralgm.components.impl.RemovePieceInstance;
import org.lateralgm.components.visual.VisualPanel;
import org.lateralgm.main.LGM;
import org.lateralgm.main.Util;
import org.lateralgm.messages.Messages;
import org.lateralgm.resources.Background;
import org.lateralgm.resources.GmObject;
import org.lateralgm.resources.ResourceReference;
import org.lateralgm.resources.Room;
import org.lateralgm.resources.sub.Instance;
import org.lateralgm.resources.sub.Tile;
import org.lateralgm.resources.sub.View;
import org.lateralgm.subframes.CodeFrame;
import org.lateralgm.subframes.RoomFrame;
import org.lateralgm.ui.swing.visuals.RoomVisual;
import org.lateralgm.util.ActiveArrayList;
import org.lateralgm.util.PropertyMap;

public class RoomEditor
extends VisualPanel {
    private static final long serialVersionUID = 1L;
    public static final int ZOOM_MIN = -1;
    public static final int ZOOM_MAX = 2;
    private final Room room;
    protected final RoomFrame frame;
    private Room.Piece cursor;
    private Room.Piece selectedPiece;
    public final PropertyMap<PRoomEditor> properties;
    public final RoomVisual roomVisual;
    private final RoomPropertyListener rpl = new RoomPropertyListener();
    private final RoomEditorPropertyValidator repv = new RoomEditorPropertyValidator();
    private Point objectFirstPosition = null;
    private boolean editOtherLayers = false;
    public Rectangle selection = null;
    private Point selectionOrigin = null;
    private Point selectedPiecesOrigin = null;
    private List<Instance> selectedInstances = new ArrayList<Instance>();
    private List<Tile> selectedTiles = new ArrayList<Tile>();
    private boolean pasteMode = false;
    private boolean altKeyHasBeenPressed = false;
    private boolean ctrlKeyHasBeenPressed = false;
    private boolean shiftKeyHasBeenPressed = false;
    private static final EnumMap<PRoomEditor, Object> DEFS = PropertyMap.makeDefaultMap(PRoomEditor.class, true, true, true, true, true, false, true, true, 0, 0, 1, true, false, true, false, false);
    int offsetX = 0;
    int offsetY = 0;
    private boolean validating;

    public RoomEditor(Room r, RoomFrame frame) {
        int n;
        int n2;
        PRoomEditor[] pRoomEditorArray;
        if (((Boolean)r.get(Room.PRoom.REMEMBER_WINDOW_SIZE)).booleanValue()) {
            EnumMap<PRoomEditor, Object> m = new EnumMap<PRoomEditor, Object>(PRoomEditor.class);
            pRoomEditorArray = PRoomEditor.values();
            n2 = pRoomEditorArray.length;
            n = 0;
            while (n < n2) {
                PRoomEditor pre = pRoomEditorArray[n];
                try {
                    m.put(pre, r.get(Room.PRoom.valueOf(pre.toString())));
                }
                catch (IllegalArgumentException e) {
                    m.put(pre, DEFS.get((Object)pre));
                }
                ++n;
            }
            this.properties = new PropertyMap<PRoomEditor>(PRoomEditor.class, this.repv, m);
        } else {
            this.properties = new PropertyMap<PRoomEditor>(PRoomEditor.class, this.repv, DEFS);
        }
        this.room = r;
        this.frame = frame;
        this.setFocusable(true);
        this.zoomOrigin = ORIGIN_MOUSE;
        r.properties.updateSource.addListener(this.rpl);
        this.enableEvents(48L);
        EnumSet<RoomVisual.Show> s = EnumSet.noneOf(RoomVisual.Show.class);
        pRoomEditorArray = PRoomEditor.values();
        n2 = pRoomEditorArray.length;
        n = 0;
        while (n < n2) {
            PRoomEditor p = pRoomEditorArray[n];
            if (p.rvBinding != null && ((Boolean)this.properties.get(p)).booleanValue()) {
                s.add(p.rvBinding);
            }
            ++n;
        }
        this.lockBounds();
        this.roomVisual = new RoomVisual(this.container, r, s);
        this.unlockBounds();
        this.put(0, this.roomVisual);
        this.setOpaque(false);
        this.setZoom((Integer)this.properties.get(PRoomEditor.ZOOM));
        this.refresh();
    }

    public void editOtherLayers(boolean editOtherLayers) {
        this.editOtherLayers = editOtherLayers;
    }

    public Room getRoom() {
        return this.room;
    }

    public void refresh() {
        this.revalidate();
        this.repaint();
    }

    public Room.Piece getSelectedPiece() {
        return this.selectedPiece;
    }

    public void setSelectedPiece(Room.Piece selectedPiece) {
        this.selectedPiece = selectedPiece;
    }

    public void copySelectionTiles() {
        if (this.selection == null) {
            return;
        }
        this.selectedTiles.clear();
        this.selectedInstances.clear();
        Room currentRoom = this.getRoom();
        Integer depth = (Integer)this.frame.tileLayer.getSelectedItem();
        for (Tile tile : currentRoom.tiles) {
            Point tilePosition = tile.getPosition();
            if (tilePosition.x < this.selection.x || tilePosition.x >= this.selection.x + this.selection.width || tilePosition.y < this.selection.y || tilePosition.y >= this.selection.y + this.selection.height || !this.frame.tEditOtherLayers.isSelected() && tile.getDepth() != depth.intValue()) continue;
            this.selectedTiles.add(tile);
        }
        this.selectedPiecesOrigin = new Point(this.selection.x, this.selection.y);
        this.roomVisual.setSelectionImage(null, this.selectedTiles);
    }

    public void copySelectionInstances() {
        if (this.selection == null) {
            return;
        }
        this.selectedInstances.clear();
        this.selectedTiles.clear();
        Room currentRoom = this.getRoom();
        for (Instance instance : currentRoom.instances) {
            Point instancePosition = instance.getPosition();
            if (instancePosition.x < this.selection.x || instancePosition.x >= this.selection.x + this.selection.width || instancePosition.y < this.selection.y || instancePosition.y >= this.selection.y + this.selection.height) continue;
            this.selectedInstances.add(instance);
        }
        this.selectedPiecesOrigin = new Point(this.selection.x, this.selection.y);
        this.roomVisual.setSelectionImage(this.selectedInstances, null);
    }

    public void activateSelectObjectMode() {
        this.properties.put(PRoomEditor.SINGLE_SELECTION, (Object)true);
    }

    public void deactivateSelectObjectMode() {
        this.properties.put(PRoomEditor.SINGLE_SELECTION, (Object)false);
    }

    public void activateSelectRegionMode() {
        this.properties.put(PRoomEditor.MULTI_SELECTION, (Object)true);
    }

    public void deactivateSelectRegionMode() {
        this.properties.put(PRoomEditor.MULTI_SELECTION, (Object)false);
        this.roomVisual.setSelection(null);
        this.selection = null;
    }

    public void deactivatePasteMode() {
        this.pasteMode = false;
        this.roomVisual.deactivatePasteMode();
    }

    public void activatePasteMode() {
        this.pasteMode = true;
        this.roomVisual.activatePasteMode();
        this.properties.put(PRoomEditor.MULTI_SELECTION, (Object)false);
    }

    private void pasteInstances(Point mousePosition) {
        boolean deleteUnderlyingInstances = (Boolean)this.properties.get(PRoomEditor.DELETE_UNDERLYING_OBJECTS);
        CompoundEdit compoundEdit = new CompoundEdit();
        if (deleteUnderlyingInstances) {
            this.frame.deleteInstancesInSelection(new Rectangle(mousePosition.x, mousePosition.y, this.roomVisual.getSelectionImageWidth(), this.roomVisual.getSelectionImageHeight()), compoundEdit);
        }
        for (Instance instance : this.selectedInstances) {
            Point position = instance.getPosition();
            Point newPosition = new Point(position.x - this.selectedPiecesOrigin.x + mousePosition.x, position.y - this.selectedPiecesOrigin.y + mousePosition.y);
            Instance newInstance = this.room.addInstance();
            newInstance.properties.put(Instance.PInstance.OBJECT, instance.properties.get(Instance.PInstance.OBJECT));
            newInstance.setRotation(instance.getRotation());
            newInstance.setScale(instance.getScale());
            newInstance.setColor(instance.getColor());
            newInstance.setAlpha(instance.getAlpha());
            newInstance.setCode(instance.getCode());
            newInstance.setCreationCode(instance.getCreationCode());
            newInstance.setPosition(newPosition);
            AddPieceInstance edit = new AddPieceInstance(this.frame, newInstance, this.room.instances.size() - 1);
            compoundEdit.addEdit(edit);
        }
        compoundEdit.end();
        this.frame.undoSupport.postEdit(compoundEdit);
    }

    private void pasteTiles(Point mousePosition) {
        boolean deleteUnderlyingTiles = (Boolean)this.properties.get(PRoomEditor.DELETE_UNDERLYING_TILES);
        CompoundEdit compoundEdit = new CompoundEdit();
        if (deleteUnderlyingTiles) {
            this.frame.deleteTilesInSelection(new Rectangle(mousePosition.x, mousePosition.y, this.roomVisual.getSelectionImageWidth(), this.roomVisual.getSelectionImageHeight()), compoundEdit);
        }
        for (Tile tile : this.selectedTiles) {
            Point position = tile.getPosition();
            Point newPosition = new Point(position.x - this.selectedPiecesOrigin.x + mousePosition.x, position.y - this.selectedPiecesOrigin.y + mousePosition.y);
            Tile newTile = new Tile(this.room, LGM.currentFile);
            newTile.properties.put(Tile.PTile.BACKGROUND, tile.properties.get(Tile.PTile.BACKGROUND));
            newTile.setBackgroundPosition(tile.getBackgroundPosition());
            newTile.setPosition(newPosition);
            newTile.setSize(tile.getSize());
            newTile.setDepth(tile.getDepth());
            this.room.tiles.add(newTile);
            AddPieceInstance edit = new AddPieceInstance(this.frame, newTile, this.room.tiles.size() - 1);
            compoundEdit.addEdit(edit);
        }
        compoundEdit.end();
        this.frame.undoSupport.postEdit(compoundEdit);
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        super.processMouseEvent(e);
        this.mouseEdit(e);
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent e) {
        super.processMouseMotionEvent(e);
        this.mouseEdit(e);
    }

    public void releaseCursor(Point lastPosition) {
        CompoundEdit compoundEdit = new CompoundEdit();
        AbstractUndoableEdit edit = null;
        edit = this.objectFirstPosition != null ? new ModifyPieceInstance(this.frame, this.cursor, ModifyPieceInstance.Type.POSITION, this.objectFirstPosition, new Point(lastPosition)) : (this.cursor instanceof Instance ? new AddPieceInstance(this.frame, this.cursor, this.room.instances.size() - 1) : new AddPieceInstance(this.frame, this.cursor, this.room.tiles.size() - 1));
        compoundEdit.addEdit(edit);
        this.objectFirstPosition = null;
        boolean deleteUnderlyingObjects = (Boolean)this.properties.get(PRoomEditor.DELETE_UNDERLYING_OBJECTS);
        boolean deleteUnderlyingTiles = (Boolean)this.properties.get(PRoomEditor.DELETE_UNDERLYING_TILES);
        if (deleteUnderlyingObjects && this.cursor instanceof Instance) {
            this.deleteUnderlying(this.roomVisual.intersectInstances(new Rectangle(lastPosition.x, lastPosition.y, 1, 1)), this.room.instances, compoundEdit);
        } else if (deleteUnderlyingTiles && this.cursor instanceof Tile) {
            this.deleteUnderlying(this.roomVisual.intersectTiles(new Rectangle(lastPosition.x, lastPosition.y, 1, 1), this.getTileDepth()), this.room.tiles, compoundEdit);
        }
        compoundEdit.end();
        this.frame.undoSupport.postEdit(compoundEdit);
        this.unlockBounds();
        this.cursor = null;
    }

    private <T> void deleteUnderlying(Iterator<T> i, ActiveArrayList<T> l, CompoundEdit compoundEdit) {
        HashSet<T> s = new HashSet<T>();
        while (i.hasNext()) {
            T t = i.next();
            if (t == this.cursor) continue;
            RemovePieceInstance edit = this.cursor instanceof Instance ? new RemovePieceInstance(this.frame, (Room.Piece)t, this.room.instances.indexOf(t)) : new RemovePieceInstance(this.frame, (Room.Piece)t, this.room.tiles.indexOf(t));
            compoundEdit.addEdit(edit);
            s.add(t);
        }
        l.removeAll(s);
    }

    public void setCursor(Room.Piece ds) {
        boolean addMultipleMode = (Boolean)this.properties.get(PRoomEditor.ADD_MULTIPLE);
        if (this.selectedPiece != null) {
            this.selectedPiece.setSelected(false);
        }
        if (ds != null) {
            this.selectedPiece = ds;
        }
        this.cursor = ds;
        if (!addMultipleMode) {
            this.cursor.setSelected(true);
        }
        if (ds instanceof Instance) {
            this.frame.oList.setSelectedValue(ds, true);
            this.frame.fireObjUpdate();
        } else if (ds instanceof Tile) {
            this.frame.tList.setSelectedValue(ds, true);
            this.frame.fireTileUpdate();
        }
        this.lockBounds();
    }

    private void processLeftButton(int modifiers, boolean pressed, Room.Piece pieceUnderCursor, Point position) {
        if (this.frame.selectedPiece != null) {
            this.frame.processFocusLost();
            this.requestFocusInWindow();
        }
        boolean addMultipleMode = (Boolean)this.properties.get(PRoomEditor.ADD_MULTIPLE);
        boolean addOnTopMode = (Boolean)this.properties.get(PRoomEditor.ADD_ON_TOP);
        if (!addMultipleMode && !addOnTopMode) {
            if (pressed && pieceUnderCursor != null && !pieceUnderCursor.isLocked()) {
                this.objectFirstPosition = pieceUnderCursor.getPosition();
                this.offsetX = position.x - pieceUnderCursor.getPosition().x;
                this.offsetY = position.y - pieceUnderCursor.getPosition().y;
                this.setCursor(pieceUnderCursor);
            }
            if (pressed && pieceUnderCursor == null) {
                this.offsetX = 0;
                this.offsetY = 0;
                this.addNewPieceInstance(position);
                addMultipleMode = true;
            }
        } else {
            this.offsetX = 0;
            this.offsetY = 0;
            if (addMultipleMode && this.cursor != null && !this.roomVisual.intersects(new Rectangle(position.x, position.y, 1, 1), this.cursor)) {
                this.releaseCursor(position);
                pressed = true;
            }
            if (pressed && this.cursor == null) {
                this.addNewPieceInstance(position);
                addMultipleMode = true;
            }
        }
        if (this.cursor != null && !addMultipleMode) {
            this.cursor.setPosition(new Point(position.x - this.offsetX, position.y - this.offsetY));
        }
    }

    private void addNewPieceInstance(Point position) {
        if (this.frame.tabs.getSelectedIndex() == 2) {
            ResourceReference<Background> bkg = this.frame.taSource.getSelected();
            if (bkg == null) {
                return;
            }
            Background b = bkg.get();
            Tile t = new Tile(this.room, LGM.currentFile);
            t.properties.put(Tile.PTile.BACKGROUND, (Object)bkg);
            t.setBackgroundPosition(new Point(this.frame.tSelect.tx, this.frame.tSelect.ty));
            t.setPosition(position);
            if (!((Boolean)b.get(Background.PBackground.USE_AS_TILESET)).booleanValue()) {
                t.setSize(new Dimension(b.getWidth(), b.getHeight()));
            } else {
                t.setSize(new Dimension((Integer)b.get(Background.PBackground.TILE_WIDTH), (Integer)b.get(Background.PBackground.TILE_HEIGHT)));
            }
            t.setDepth((Integer)this.frame.tileLayer.getSelectedItem());
            this.room.tiles.add(t);
            this.setCursor(t);
        } else if (this.frame.tabs.getSelectedIndex() == 0) {
            ResourceReference<GmObject> obj = this.frame.oNew.getSelected();
            if (obj == null) {
                return;
            }
            Instance instance = this.room.addInstance();
            instance.properties.put(Instance.PInstance.OBJECT, (Object)obj);
            instance.setPosition(position);
            this.setCursor(instance);
        }
    }

    private void processRightButton(int modifiers, boolean pressed, final Room.Piece mc, Point p) {
        boolean addOnTopMode;
        if (this.frame.selectedPiece != null) {
            this.frame.processFocusLost();
            this.requestFocusInWindow();
        }
        if (this.selectedPiece != null) {
            this.selectedPiece.setSelected(false);
        }
        if (addOnTopMode = ((Boolean)this.properties.get(PRoomEditor.ADD_ON_TOP)).booleanValue()) {
            if (!pressed) {
                return;
            }
            JPopupMenu jp = new JPopupMenu();
            JCheckBoxMenuItem cb = new JCheckBoxMenuItem(Messages.getString("RoomEditor.LOCKED"), mc.isLocked());
            cb.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    mc.setLocked(((JCheckBoxMenuItem)e.getSource()).isSelected());
                }
            });
            jp.add(cb);
            if (mc instanceof Instance) {
                final Instance i = (Instance)mc;
                JMenuItem mi = new JMenuItem(Messages.getString("RoomEditor.CREATION_CODE"));
                mi.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        RoomEditor.this.frame.openInstanceCodeFrame(i);
                    }
                });
                jp.add(mi);
            }
            Point cp = p.getLocation();
            this.visualToComponent(cp);
            jp.show(this, cp.x, cp.y);
        } else if (!mc.isLocked()) {
            ActiveArrayList<PropertyMap.PropertyValidator<Instance.PInstance>> alist = null;
            int pieceIndex = -1;
            JList<PropertyMap.PropertyValidator<Instance.PInstance>> jlist = null;
            if (mc instanceof Instance) {
                pieceIndex = this.room.instances.indexOf(mc);
                if (pieceIndex == -1) {
                    return;
                }
                alist = this.room.instances;
                jlist = this.frame.oList;
                CodeFrame fr = this.frame.codeFrames.get((Instance)mc);
                if (fr != null) {
                    fr.dispose();
                }
            } else if (mc instanceof Tile) {
                pieceIndex = this.room.tiles.indexOf(mc);
                if (pieceIndex == -1) {
                    return;
                }
                alist = this.room.tiles;
                jlist = this.frame.tList;
            } else {
                return;
            }
            RemovePieceInstance edit = new RemovePieceInstance(this.frame, mc, pieceIndex);
            this.frame.undoSupport.postEdit(edit);
            int i2 = jlist.getSelectedIndex();
            ((ArrayList)alist).remove(pieceIndex);
            jlist.setSelectedIndex(Math.min(alist.size() - 1, i2));
        }
    }

    public void altKeyPressed() {
        boolean snapToGridMode = (Boolean)this.properties.get(PRoomEditor.SNAP_TO_GRID);
        if (snapToGridMode) {
            this.altKeyHasBeenPressed = true;
            this.properties.put(PRoomEditor.SNAP_TO_GRID, (Object)false);
        }
    }

    public void altKeyReleased() {
        if (this.altKeyHasBeenPressed) {
            this.altKeyHasBeenPressed = false;
            this.properties.put(PRoomEditor.SNAP_TO_GRID, (Object)true);
        }
    }

    public void ctrlKeyPressed() {
        boolean addOnTopMode = (Boolean)this.properties.get(PRoomEditor.ADD_ON_TOP);
        if (!addOnTopMode) {
            this.ctrlKeyHasBeenPressed = true;
            this.properties.put(PRoomEditor.ADD_ON_TOP, (Object)true);
        }
    }

    public void ctrlKeyReleased() {
        if (this.ctrlKeyHasBeenPressed) {
            this.ctrlKeyHasBeenPressed = false;
            this.properties.put(PRoomEditor.ADD_ON_TOP, (Object)false);
        }
    }

    public void shiftKeyPressed() {
        boolean addMultipleMode = (Boolean)this.properties.get(PRoomEditor.ADD_MULTIPLE);
        if (!addMultipleMode) {
            this.shiftKeyHasBeenPressed = true;
            this.properties.put(PRoomEditor.ADD_MULTIPLE, (Object)true);
        }
    }

    public void shiftKeyReleased() {
        if (this.shiftKeyHasBeenPressed) {
            this.shiftKeyHasBeenPressed = false;
            this.properties.put(PRoomEditor.ADD_MULTIPLE, (Object)false);
        }
    }

    protected void mouseEdit(MouseEvent e) {
        int modifiers = e.getModifiersEx();
        int type = e.getID();
        Point currentPosition = e.getPoint().getLocation();
        this.componentToVisual(currentPosition);
        int x = currentPosition.x;
        int y = currentPosition.y;
        boolean leftButtonPressed = (modifiers & 0x400) != 0;
        boolean rightButtonPressed = (modifiers & 0x1000) != 0;
        boolean selectionMode = (Boolean)this.properties.get(PRoomEditor.MULTI_SELECTION);
        boolean snapToGridMode = (Boolean)this.properties.get(PRoomEditor.SNAP_TO_GRID);
        if (snapToGridMode) {
            int sx = (Integer)this.room.get(Room.PRoom.SNAP_X);
            int sy = (Integer)this.room.get(Room.PRoom.SNAP_Y);
            int ox = (Integer)this.properties.get(PRoomEditor.GRID_OFFSET_X);
            int oy = (Integer)this.properties.get(PRoomEditor.GRID_OFFSET_Y);
            if (((Boolean)this.room.get(Room.PRoom.ISOMETRIC)).booleanValue()) {
                boolean d;
                int gx = ox + Util.negDiv(x - ox, sx) * sx;
                int gy = oy + Util.negDiv(y - oy, sy) * sy;
                boolean bl = d = Math.abs(x - gx - sx / 2) * sy + Math.abs(y - gy - sy / 2) * sx < sx * sy / 2;
                x = gx + (d ? sx / 2 : (x > gx + sx / 2 ? sx : 0));
                y = gy + (d ? sy / 2 : (y > gy + sy / 2 ? sy : 0));
            } else {
                x = ox + Util.negDiv(x - ox, sx) * sx;
                y = oy + Util.negDiv(y - oy, sy) * sy;
            }
        }
        if (selectionMode) {
            if (leftButtonPressed) {
                if (x < 0) {
                    x = 0;
                }
                if (y < 0) {
                    y = 0;
                }
                if (x > this.room.getWidth()) {
                    x = this.room.getWidth();
                }
                if (y > this.room.getHeight()) {
                    y = this.room.getHeight();
                }
                if (this.selectionOrigin == null) {
                    if (this.selectedPiece != null) {
                        this.selectedPiece.setSelected(false);
                    }
                    this.selectionOrigin = new Point(x, y);
                    return;
                }
                int newSelectionOriginX = Math.min(this.selectionOrigin.x, x);
                int newSelectionOriginY = Math.min(this.selectionOrigin.y, y);
                int width = Math.abs(x - this.selectionOrigin.x);
                int height = Math.abs(y - this.selectionOrigin.y);
                this.selection = new Rectangle(newSelectionOriginX, newSelectionOriginY, width, height);
                this.roomVisual.setSelection(this.selection);
                return;
            }
            if (this.selectionOrigin != null) {
                this.selectionOrigin = null;
                return;
            }
        }
        this.frame.statX.setText(String.valueOf(Messages.getString("RoomFrame.STAT_X")) + x);
        this.frame.statY.setText(String.valueOf(Messages.getString("RoomFrame.STAT_Y")) + y);
        this.frame.statId.setText("");
        this.frame.statSrc.setText("");
        this.roomVisual.setMousePosition(new Point(x, y));
        if (this.pasteMode && leftButtonPressed) {
            if (this.selectedInstances.size() > 0) {
                this.pasteInstances(new Point(x, y));
            }
            if (this.selectedTiles.size() > 0) {
                this.pasteTiles(new Point(x, y));
            }
            return;
        }
        if (this.pasteMode && rightButtonPressed) {
            this.deactivatePasteMode();
        }
        if (selectionMode && rightButtonPressed) {
            return;
        }
        PropertyMap.PropertyValidator<Instance.PInstance> mc = null;
        if (this.frame.tabs.getSelectedIndex() == 2) {
            Tile tile = this.getTopPiece(currentPosition, Tile.class, this.getTileDepth());
            if (tile == null && this.editOtherLayers) {
                tile = this.getTopPiece(currentPosition, Tile.class);
            }
            if ((mc = tile) != null) {
                String idt = String.valueOf(Messages.getString("RoomFrame.STAT_ID")) + tile.properties.get(Tile.PTile.ID);
                if (mc.isLocked()) {
                    idt = String.valueOf(idt) + " X";
                }
                this.frame.statId.setText(idt);
                ResourceReference rb = (ResourceReference)tile.properties.get(Tile.PTile.BACKGROUND);
                Background b = (Background)Util.deRef(rb);
                String name = b == null ? Messages.getString("RoomFrame.NO_BACKGROUND") : b.getName();
                idt = String.valueOf(Messages.getString("RoomFrame.STAT_TILESET")) + name;
                this.frame.statSrc.setText(idt);
            }
        } else {
            Instance instance = this.getTopPiece(currentPosition, Instance.class);
            mc = instance;
            if (instance != null) {
                String idt = String.valueOf(Messages.getString("RoomFrame.STAT_ID")) + instance.properties.get(Instance.PInstance.ID);
                if (mc.isLocked()) {
                    idt = String.valueOf(idt) + " X";
                }
                this.frame.statId.setText(idt);
                ResourceReference or = (ResourceReference)instance.properties.get(Instance.PInstance.OBJECT);
                GmObject o = (GmObject)Util.deRef(or);
                String name = o == null ? Messages.getString("RoomFrame.NO_OBJECT") : o.getName();
                idt = String.valueOf(Messages.getString("RoomFrame.STAT_OBJECT")) + name;
                this.frame.statSrc.setText(idt);
            }
            if (this.frame.tabs.getSelectedIndex() != 0) {
                return;
            }
        }
        if (leftButtonPressed) {
            this.processLeftButton(modifiers, type == 501, (Room.Piece)((Object)mc), new Point(x, y));
        } else if (this.cursor != null) {
            this.releaseCursor(new Point(x - this.offsetX, y - this.offsetY));
        }
        if (rightButtonPressed && mc != null) {
            this.processRightButton(modifiers, type == 501, (Room.Piece)((Object)mc), currentPosition);
        }
    }

    private <P extends Room.Piece> P getTopPiece(Point p, Class<P> c) {
        Iterator<P> pi = this.roomVisual.intersect(new Rectangle(p.x, p.y, 1, 1), c);
        Room.Piece piece = null;
        while (pi.hasNext()) {
            piece = (Room.Piece)pi.next();
        }
        return (P)piece;
    }

    private <P extends Room.Piece> P getTopPiece(Point p, Class<P> c, int depth) {
        Iterator<P> pi = this.roomVisual.intersect(new Rectangle(p.x, p.y, 1, 1), c, depth);
        Room.Piece piece = null;
        while (pi.hasNext()) {
            piece = (Room.Piece)pi.next();
        }
        return (P)piece;
    }

    protected int getTileDepth() {
        return (Integer)this.frame.tileLayer.getSelectedItem();
    }

    @Override
    public void setZoom(int z) {
        super.setZoom(z);
        if (z >= 1) {
            this.roomVisual.setGridFactor(1);
        } else {
            int sx = (Integer)this.room.get(Room.PRoom.SNAP_X);
            int sy = (Integer)this.room.get(Room.PRoom.SNAP_Y);
            this.roomVisual.setGridFactor((2 - z) / Util.gcd(2 - z, Util.gcd(sx < 2 ? 0 : sx, sy < 2 ? 0 : sy)));
        }
    }

    public static interface CommandHandler {
        public CodeFrame openInstanceCodeFrame(Instance var1);
    }

    public static enum PRoomEditor {
        SHOW_GRID,
        SHOW_OBJECTS(RoomVisual.Show.INSTANCES),
        SHOW_TILES,
        SHOW_BACKGROUNDS,
        SHOW_FOREGROUNDS,
        SHOW_VIEWS,
        DELETE_UNDERLYING_OBJECTS,
        DELETE_UNDERLYING_TILES,
        GRID_OFFSET_X,
        GRID_OFFSET_Y,
        ZOOM,
        SINGLE_SELECTION,
        MULTI_SELECTION,
        SNAP_TO_GRID,
        ADD_ON_TOP,
        ADD_MULTIPLE;

        final RoomVisual.Show rvBinding;

        private PRoomEditor() {
            String n2 = this.name();
            this.rvBinding = n2.startsWith("SHOW_") ? RoomVisual.Show.valueOf(n2.substring(5)) : null;
        }

        private PRoomEditor(RoomVisual.Show b) {
            this.rvBinding = b;
        }
    }

    private class RoomEditorPropertyValidator
    implements PropertyMap.PropertyValidator<PRoomEditor> {
        private RoomEditorPropertyValidator() {
        }

        @Override
        public Object validate(PRoomEditor k, Object v) {
            switch (k) {
                case GRID_OFFSET_X: {
                    RoomEditor.this.roomVisual.setGridXOffset((Integer)v);
                    break;
                }
                case GRID_OFFSET_Y: {
                    RoomEditor.this.roomVisual.setGridYOffset((Integer)v);
                    break;
                }
                case MULTI_SELECTION: {
                    if (((Boolean)v).booleanValue()) break;
                    RoomEditor.this.roomVisual.setSelection(null);
                    RoomEditor.this.selection = null;
                    break;
                }
                case ZOOM: {
                    int i = Math.max(-1, Math.min(2, (Integer)v));
                    RoomEditor.this.setZoom(i);
                    return i;
                }
                case SINGLE_SELECTION: 
                case SNAP_TO_GRID: 
                case ADD_ON_TOP: 
                case ADD_MULTIPLE: {
                    break;
                }
                case SHOW_GRID: 
                case SHOW_OBJECTS: 
                case SHOW_TILES: 
                case SHOW_BACKGROUNDS: 
                case SHOW_FOREGROUNDS: {
                    RoomEditor.this.roomVisual.setVisible(k.rvBinding, (Boolean)v);
                    break;
                }
                case SHOW_VIEWS: {
                    this.updateViewsObjectFollowingProperty();
                    RoomEditor.this.roomVisual.setVisible(k.rvBinding, (Boolean)v);
                    break;
                }
                case DELETE_UNDERLYING_OBJECTS: 
                case DELETE_UNDERLYING_TILES: {
                    if (!((Boolean)RoomEditor.this.room.get(Room.PRoom.REMEMBER_WINDOW_SIZE)).booleanValue()) break;
                    Room.PRoom prk = Room.PRoom.valueOf(k.name());
                    RoomEditor.this.validating = true;
                    try {
                        RoomEditor.this.room.put(prk, v);
                    }
                    finally {
                        RoomEditor.this.validating = false;
                    }
                    return RoomEditor.this.room.get(prk);
                }
            }
            return v;
        }

        private void updateViewsObjectFollowingProperty() {
            if (!((Boolean)RoomEditor.this.room.get(Room.PRoom.VIEWS_ENABLED)).booleanValue()) {
                return;
            }
            for (View view : ((RoomEditor)RoomEditor.this).room.views) {
                if (!((Boolean)view.properties.get(View.PView.VISIBLE)).booleanValue()) {
                    return;
                }
                ResourceReference objectToFollowReference = null;
                if (view.properties.get(View.PView.OBJECT) != null) {
                    objectToFollowReference = (ResourceReference)view.properties.get(View.PView.OBJECT);
                }
                if (objectToFollowReference == null) {
                    view.properties.put(View.PView.OBJECT_FOLLOWING_X, (Object)-1);
                    view.properties.put(View.PView.OBJECT_FOLLOWING_Y, (Object)-1);
                    continue;
                }
                Instance instanceToFollow = null;
                for (Instance instance : ((RoomEditor)RoomEditor.this).room.instances) {
                    ResourceReference instanceObject = (ResourceReference)instance.properties.get(Instance.PInstance.OBJECT);
                    if (instanceObject != objectToFollowReference) continue;
                    instanceToFollow = instance;
                    break;
                }
                if (instanceToFollow != null) {
                    Point viewPosition = new Point(0, 0);
                    int viewWidth = (Integer)view.properties.get(View.PView.VIEW_W);
                    int viewHeight = (Integer)view.properties.get(View.PView.VIEW_H);
                    Point instancePosition = new Point(0, 0);
                    instancePosition.x = (Integer)instanceToFollow.properties.get(Instance.PInstance.X);
                    instancePosition.y = (Integer)instanceToFollow.properties.get(Instance.PInstance.Y);
                    viewPosition.x = instancePosition.x - viewWidth / 2;
                    viewPosition.y = instancePosition.y - viewHeight / 2;
                    view.properties.put(View.PView.OBJECT_FOLLOWING_X, (Object)viewPosition.x);
                    view.properties.put(View.PView.OBJECT_FOLLOWING_Y, (Object)viewPosition.y);
                    continue;
                }
                view.properties.put(View.PView.OBJECT_FOLLOWING_X, (Object)-1);
                view.properties.put(View.PView.OBJECT_FOLLOWING_Y, (Object)-1);
            }
        }
    }

    private class RoomPropertyListener
    extends PropertyMap.PropertyUpdateListener<Room.PRoom> {
        private RoomPropertyListener() {
        }

        @Override
        public void updated(PropertyMap.PropertyUpdateEvent<Room.PRoom> e) {
            switch ((Room.PRoom)((Object)e.key)) {
                case SNAP_X: 
                case SNAP_Y: {
                    RoomEditor.this.setZoom((Integer)RoomEditor.this.properties.get(PRoomEditor.ZOOM));
                    break;
                }
                case SHOW_GRID: 
                case SHOW_OBJECTS: 
                case SHOW_TILES: 
                case SHOW_BACKGROUNDS: 
                case SHOW_FOREGROUNDS: 
                case SHOW_VIEWS: 
                case DELETE_UNDERLYING_OBJECTS: 
                case DELETE_UNDERLYING_TILES: {
                    if (RoomEditor.this.validating) break;
                    RoomEditor.this.properties.put(PRoomEditor.valueOf(((Room.PRoom)((Object)e.key)).name()), RoomEditor.this.room.get((Room.PRoom)((Object)e.key)));
                    break;
                }
                case REMEMBER_WINDOW_SIZE: {
                    if (!((Boolean)RoomEditor.this.room.get(Room.PRoom.REMEMBER_WINDOW_SIZE)).booleanValue()) break;
                    PRoomEditor[] pRoomEditorArray = PRoomEditor.values();
                    int n = pRoomEditorArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        PRoomEditor pre = pRoomEditorArray[n2];
                        try {
                            RoomEditor.this.room.put(Room.PRoom.valueOf(pre.name()), RoomEditor.this.properties.get(pre));
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                        ++n2;
                    }
                    break;
                }
            }
        }
    }
}

