/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.components.visual;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.lateralgm.components.visual.VisualPanel;
import org.lateralgm.main.UpdateSource;
import org.lateralgm.main.Util;
import org.lateralgm.resources.Path;
import org.lateralgm.resources.ResourceReference;
import org.lateralgm.resources.Room;
import org.lateralgm.resources.sub.PathPoint;
import org.lateralgm.ui.swing.visuals.BinVisual;
import org.lateralgm.ui.swing.visuals.GridVisual;
import org.lateralgm.ui.swing.visuals.RoomVisual;
import org.lateralgm.ui.swing.visuals.Visual;
import org.lateralgm.ui.swing.visuals.VisualBox;
import org.lateralgm.util.ActiveArrayList;
import org.lateralgm.util.PropertyMap;

public class PathEditor
extends VisualPanel
implements UpdateSource.UpdateListener {
    private static final int ROOM_LAYER = -1;
    private static final int BIN_LAYER = 0;
    private static final int GRID_LAYER = 1;
    private static final int POINT_SIZE = 8;
    private static final int POINT_MOUSE_RANGE = 8;
    private static final int ARROW_SIZE = 10;
    private static final int LINE_WIDTH = 5;
    private static final long serialVersionUID = 1L;
    private final Path path;
    private RoomVisual roomVisual;
    private final BinVisual binVisual;
    private final GridVisual gridVisual;
    private final PathPropertyListener ppl = new PathPropertyListener();
    private final PointListListener pll = new PointListListener();
    public final PropertyMap<PPathEditor> properties;
    private final PathEditorPropertyValidator pepv = new PathEditorPropertyValidator();
    private static final EnumMap<PPathEditor, Object> DEFS = PropertyMap.makeDefaultMap(PPathEditor.class, true, null);
    private final ArrayList<PointVisual> pvList;
    private final IdentityHashMap<PathPoint, PointVisual> pvMap;
    private PathArrow arrow;
    private boolean dragging = false;
    private Point dragOffset;
    private PathPoint ppPressed;
    static final int HPS = 4;
    final BufferedImage[] pointImage = new BufferedImage[2];
    static final int HLW = 3;
    static final Stroke STROKE_OUTER = new BasicStroke(5.0f, 1, 1);
    static final Stroke STROKE_INNER = new BasicStroke(2.17f, 1, 1);
    private int spPrecision;
    private float[] spBlending;
    private static final double ARROW_ANGLE = 2.0943951023931953;
    final IdentityHashMap<PathPoint, SmoothPathSegment> spsMap = new IdentityHashMap();
    final IdentityHashMap<PathPoint, LinearPathSegment> lpsMap = new IdentityHashMap();
    private static final EnumSet<RoomVisual.Show> ROOM_SHOW = EnumSet.of(RoomVisual.Show.BACKGROUNDS, RoomVisual.Show.INSTANCES, RoomVisual.Show.TILES, RoomVisual.Show.FOREGROUNDS);

    public PathEditor(Path p) {
        this.enableEvents(48L);
        this.properties = new PropertyMap<PPathEditor>(PPathEditor.class, this.pepv, DEFS);
        this.binVisual = new BinVisual(this.container, 128, 512, 512);
        this.put(0, this.binVisual);
        int sx = (Integer)p.get(Path.PPath.SNAP_X);
        int sy = (Integer)p.get(Path.PPath.SNAP_Y);
        this.gridVisual = new GridVisual(false, sx, sy);
        this.put(1, this.gridVisual);
        this.path = p;
        this.path.reference.updateSource.addListener(this);
        this.path.properties.updateSource.addListener(this.ppl);
        this.path.points.updateSource.addListener(this.pll);
        int s = this.path.points.size();
        this.pvList = new ArrayList(s);
        this.pvMap = new IdentityHashMap(Math.max((int)((float)s / 0.75f) + 1, 16));
        this.updatePointList();
        ResourceReference r = (ResourceReference)this.path.get(Path.PPath.BACKGROUND_ROOM);
        this.setRoom(r == null ? null : (Room)r.get());
    }

    @Override
    public void updated(UpdateSource.UpdateEvent e) {
        this.invalidate();
        this.repaint();
    }

    private void mouseEvent(MouseEvent e) {
        Point p = e.getPoint().getLocation();
        this.componentToVisual(p);
        int s = 5;
        Iterator<Visual> vi = this.binVisual.intersect(new Rectangle(p.x - s, p.y - s, 2 * s, 2 * s));
        PathPoint ppOver = null;
        int posd = 64;
        while (vi.hasNext()) {
            int yd;
            PathPoint pp;
            int xd;
            int sd;
            Visual v = vi.next();
            if (!(v instanceof PointVisual) || (sd = (xd = (pp = ((PointVisual)v).point).getX() - p.x) * xd + (yd = pp.getY() - p.y) * yd) > posd) continue;
            ppOver = pp;
            posd = sd;
            break;
        }
        switch (e.getID()) {
            case 501: {
                PathPoint pp;
                this.ppPressed = ppOver;
                switch (e.getButton()) {
                    case 1: {
                        if (ppOver == null) {
                            pp = (PathPoint)this.properties.get(PPathEditor.SELECTED_POINT);
                            ppOver = new PathPoint(p.x, p.y, pp == null ? 100 : pp.getSpeed());
                            if ((e.getModifiersEx() & 0x80) == 0) {
                                this.movePathPoint(ppOver, p.x, p.y, true);
                            }
                            this.path.points.add(ppOver);
                            this.ppPressed = ppOver;
                        } else if ((e.getModifiersEx() & 0x40) != 0) {
                            int i = this.path.points.indexOf(ppOver);
                            ppOver = new PathPoint(ppOver.getX(), ppOver.getY(), ppOver.getSpeed());
                            this.path.points.add(i, ppOver);
                            this.ppPressed = ppOver;
                        }
                        this.properties.put(PPathEditor.SELECTED_POINT, (Object)ppOver);
                        this.dragging = true;
                        this.dragOffset = p.getLocation();
                        this.dragOffset.translate(-ppOver.getX(), -ppOver.getY());
                    }
                }
                break;
            }
            case 506: {
                PathPoint pp;
                if (this.dragging) {
                    this.lockBounds();
                    pp = (PathPoint)this.properties.get(PPathEditor.SELECTED_POINT);
                    if (pp == null) {
                        this.ppPressed = null;
                        this.dragging = false;
                        this.unlockBounds();
                        break;
                    }
                    this.movePathPoint(pp, p.x - this.dragOffset.x, p.y - this.dragOffset.y, (e.getModifiersEx() & 0x80) == 0);
                    break;
                }
                if (this.ppPressed == ppOver) break;
                this.ppPressed = null;
                break;
            }
            case 502: {
                switch (e.getButton()) {
                    case 1: {
                        this.dragging = false;
                        this.unlockBounds();
                        break;
                    }
                    case 3: {
                        if (this.dragging) {
                            this.dragging = false;
                            this.unlockBounds();
                            break;
                        }
                        if (this.ppPressed == null) break;
                        this.path.points.remove(this.ppPressed);
                    }
                }
                this.ppPressed = null;
            }
        }
    }

    private void movePathPoint(PathPoint pp, int x, int y, boolean snap) {
        if (snap) {
            int sx = (Integer)this.path.get(Path.PPath.SNAP_X);
            int sy = (Integer)this.path.get(Path.PPath.SNAP_Y);
            pp.setX(Util.negDiv(x + sx / 2, sx) * sx);
            pp.setY(Util.negDiv(y + sy / 2, sy) * sy);
        } else {
            pp.setX(x);
            pp.setY(y);
        }
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent e) {
        this.mouseEvent(e);
        super.processMouseMotionEvent(e);
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        this.mouseEvent(e);
        super.processMouseEvent(e);
    }

    private float getBlending(int p, int t) {
        if (p != this.spPrecision) {
            this.spPrecision = p;
            this.spBlending = new float[1 + 3 * p];
            float isp = 1.0f / (float)(p * p);
            float ip = 1.0f / (float)p;
            int i = 0;
            while (i < p) {
                this.spBlending[i] = (float)(i * i) * isp * 0.5f;
                ++i;
            }
            i = p;
            while (i < 2 * p) {
                this.spBlending[i] = ((float)(-2 * i * i) * isp + (float)(6 * i) * ip - 3.0f) * 0.5f;
                ++i;
            }
            i = 2 * p;
            while (i <= 3 * p) {
                this.spBlending[i] = ((float)(i * i) * isp - (float)(6 * i) * ip + 9.0f) * 0.5f;
                ++i;
            }
        }
        return this.spBlending[t];
    }

    private void updatePointList() {
        Object p;
        for (SmoothPathSegment sps : this.spsMap.values()) {
            sps.remove();
        }
        this.spsMap.clear();
        for (LinearPathSegment lps : this.lpsMap.values()) {
            lps.remove();
        }
        this.lpsMap.clear();
        if (this.arrow != null) {
            this.arrow.remove();
        }
        Set pps = ((IdentityHashMap)this.pvMap.clone()).keySet();
        int s = this.pvList.size();
        ActiveArrayList<PathPoint> pp = this.path.points;
        int s2 = pp.size();
        while (s > s2) {
            this.pvList.remove(--s);
        }
        this.pvList.ensureCapacity(s2);
        int i = 0;
        while (i < s2) {
            p = (PathPoint)pp.get(i);
            PointVisual v = this.pvMap.get(p);
            if (v == null) {
                v = new PointVisual((PathPoint)p);
                this.pvMap.put((PathPoint)p, v);
            } else {
                pps.remove(p);
            }
            if (i >= s) {
                this.pvList.add(v);
            } else {
                this.pvList.set(i, v);
            }
            ++i;
        }
        if (pps.contains(this.properties.get(PPathEditor.SELECTED_POINT))) {
            this.properties.put(PPathEditor.SELECTED_POINT, (Object)null);
        }
        for (PathPoint pathPoint : pps) {
            this.pvMap.remove(pathPoint).remove();
        }
        if (((Boolean)this.path.get(Path.PPath.SMOOTH)).booleanValue()) {
            boolean closed = (Boolean)this.path.properties.get(Path.PPath.CLOSED);
            if (s2 >= 3) {
                PathPoint[] rpp = new PathPoint[4];
                int i2 = 0;
                while (i2 < 4) {
                    rpp[i2] = (PathPoint)pp.get(i2 % s2);
                    ++i2;
                }
                int i22 = closed ? s2 + 1 : s2 - 2;
                int i3 = 1;
                while (i3 < i22) {
                    PathPoint p2 = rpp[1];
                    this.spsMap.put(p2, new SmoothPathSegment(rpp));
                    rpp = Arrays.copyOfRange(rpp, 1, 5);
                    rpp[3] = (PathPoint)pp.get((i3 + 3) % s2);
                    ++i3;
                }
                if (!closed) {
                    PathPoint p3 = (PathPoint)pp.get(0);
                    this.spsMap.put(p3, new SmoothPathSegment(null, p3, (PathPoint)pp.get(1), (PathPoint)pp.get(2)));
                    p3 = (PathPoint)pp.get(s2 - 2);
                    this.spsMap.put(p3, new SmoothPathSegment((PathPoint)pp.get(s2 - 3), p3, (PathPoint)pp.get(s2 - 1), null));
                }
                this.arrow = new PathArrow(this.spsMap.get(pp.get(0)));
            }
        } else if (s2 >= 2) {
            i = 0;
            while (i < s2 - 1) {
                p = (PathPoint)this.path.points.get(i);
                this.lpsMap.put((PathPoint)p, new LinearPathSegment(new PathPoint[]{p, (PathPoint)this.path.points.get(i + 1)}));
                ++i;
            }
            if (((Boolean)this.path.properties.get(Path.PPath.CLOSED)).booleanValue()) {
                PathPoint p4 = (PathPoint)this.path.points.get(s2 - 1);
                this.lpsMap.put(p4, new LinearPathSegment(p4, (PathPoint)this.path.points.get(0)));
            }
            this.arrow = new PathArrow(null);
        }
    }

    private void setRoom(Room r) {
        if (this.roomVisual == null ? r == null : this.roomVisual.room == r) {
            return;
        }
        this.roomVisual = r == null ? null : new RoomVisual(this.container, r, ROOM_SHOW);
        this.put(-1, this.roomVisual);
    }

    private class LinearPathSegment
    extends PathVisual {
        final PathPoint[] pp;
        final Rectangle bounds;
        final PointPositionListener ppl;
        int px0;
        int py0;
        int px1;
        int py1;

        public LinearPathSegment(PathPoint ... p) {
            this.pp = new PathPoint[2];
            this.bounds = new Rectangle();
            this.ppl = new PointPositionListener();
            if (p.length != 2) {
                throw new IllegalArgumentException();
            }
            System.arraycopy(p, 0, this.pp, 0, 2);
            PathEditor.this.binVisual.setDepth(this, 1);
            PathPoint[] pathPointArray = p;
            int n = p.length;
            int n2 = 0;
            while (n2 < n) {
                PathPoint point = pathPointArray[n2];
                point.properties.getUpdateSource(PathPoint.PPathPoint.X).addListener(this.ppl);
                point.properties.getUpdateSource(PathPoint.PPathPoint.Y).addListener(this.ppl);
                ++n2;
            }
            this.validate();
        }

        protected void calculateBounds() {
            this.px0 = this.pp[0].getX();
            this.py0 = this.pp[0].getY();
            this.px1 = this.pp[1].getX();
            this.py1 = this.pp[1].getY();
            this.bounds.setBounds(0, 0, -1, -1);
            this.bounds.add(this.px0, this.py0);
            this.bounds.add(this.px1, this.py1);
            this.bounds.grow(3, 3);
            this.px0 -= this.bounds.x;
            this.py0 -= this.bounds.y;
            this.px1 -= this.bounds.x;
            this.py1 -= this.bounds.y;
        }

        @Override
        protected void validate() {
            this.calculateBounds();
            this.setBounds(this.bounds);
        }

        @Override
        public void paint(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setColor(Color.BLACK);
            g2.setStroke(STROKE_OUTER);
            g2.drawLine(this.px0, this.py0, this.px1, this.py1);
            g2.setColor(Color.WHITE);
            g2.setStroke(STROKE_INNER);
            g2.drawLine(this.px0, this.py0, this.px1, this.py1);
        }

        private class PointPositionListener
        extends PropertyMap.PropertyUpdateListener<PathPoint.PPathPoint> {
            private PointPositionListener() {
            }

            @Override
            public void updated(PropertyMap.PropertyUpdateEvent<PathPoint.PPathPoint> e) {
                LinearPathSegment.this.invalidate();
            }
        }
    }

    public static enum PPathEditor {
        SHOW_GRID,
        SELECTED_POINT;

    }

    private class PathArrow
    extends PathVisual {
        final PointPositionListener ppl;
        final SmoothPathSegment segment;
        final int[] px;
        final int[] py;

        public PathArrow(SmoothPathSegment s) {
            this.ppl = new PointPositionListener();
            this.px = new int[4];
            this.py = new int[4];
            this.segment = s;
            PathEditor.this.binVisual.setDepth(this, -1);
            int i2 = s == null ? 2 : ((Boolean)PathEditor.this.path.get(Path.PPath.CLOSED) != false ? 4 : 3);
            int i = 0;
            while (i < i2) {
                PathPoint p = (PathPoint)((PathEditor)PathEditor.this).path.points.get(i == 3 ? ((PathEditor)PathEditor.this).path.points.size() - 1 : i);
                p.properties.getUpdateSource(PathPoint.PPathPoint.X).addListener(this.ppl);
                p.properties.getUpdateSource(PathPoint.PPathPoint.Y).addListener(this.ppl);
                ++i;
            }
            this.validate();
        }

        private void calculatePoints(int x, int y, double d) {
            this.px[0] = x + (int)Math.round(10.0 * Math.cos(d));
            this.py[0] = y - (int)Math.round(10.0 * Math.sin(d));
            this.px[1] = x + (int)Math.round(10.0 * Math.cos(d + 2.0943951023931953));
            this.py[1] = y - (int)Math.round(10.0 * Math.sin(d + 2.0943951023931953));
            this.px[2] = x;
            this.py[2] = y;
            this.px[3] = x + (int)Math.round(10.0 * Math.cos(d - 2.0943951023931953));
            this.py[3] = y - (int)Math.round(10.0 * Math.sin(d - 2.0943951023931953));
        }

        private int sqrdist(int x, int y) {
            return x * x + y * y;
        }

        @Override
        protected void validate() {
            if (this.segment == null) {
                PathPoint p = (PathPoint)((PathEditor)PathEditor.this).path.points.get(0);
                PathPoint p2 = (PathPoint)((PathEditor)PathEditor.this).path.points.get(1);
                int x = p.getX();
                int y = p.getY();
                this.calculatePoints(x, y, Math.atan2(y - p2.getY(), p2.getX() - x));
            } else {
                this.segment.validate();
                if (((Boolean)PathEditor.this.path.get(Path.PPath.CLOSED)).booleanValue()) {
                    int i = this.segment.px.length - 1;
                    int x = this.segment.px[i];
                    int y = this.segment.py[i];
                    int i2 = i - 1;
                    while (i2 > 0 && this.sqrdist(this.segment.px[i2] - x, this.segment.py[i2] - y) < 4) {
                        --i2;
                    }
                    this.calculatePoints(x + this.segment.bounds.x, y + this.segment.bounds.y, Math.atan2(this.segment.py[i2] - y, x - this.segment.px[i2]));
                } else {
                    int x = this.segment.px[0];
                    int y = this.segment.py[0];
                    int i = 1;
                    while (i < this.segment.px.length - 1 && this.sqrdist(this.segment.px[i] - x, this.segment.py[i] - y) < 4) {
                        ++i;
                    }
                    this.calculatePoints(x + this.segment.bounds.x, y + this.segment.bounds.y, Math.atan2(y - this.segment.py[i], this.segment.px[i] - x));
                }
            }
            Rectangle bounds = new Rectangle(-1, -1);
            int i = 0;
            while (i < 4) {
                bounds.add(this.px[i], this.py[i]);
                ++i;
            }
            i = 0;
            while (i < 4) {
                int n = i;
                this.px[n] = this.px[n] - bounds.x;
                int n2 = i++;
                this.py[n2] = this.py[n2] - bounds.y;
            }
            this.setBounds(bounds);
        }

        @Override
        public void paint(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setColor(new Color(0, 224, 0));
            g2.fillPolygon(this.px, this.py, 4);
            g2.setColor(Color.BLACK);
            g2.drawPolygon(this.px, this.py, 4);
        }

        private class PointPositionListener
        extends PropertyMap.PropertyUpdateListener<PathPoint.PPathPoint> {
            private PointPositionListener() {
            }

            @Override
            public void updated(PropertyMap.PropertyUpdateEvent<PathPoint.PPathPoint> e) {
                PathArrow.this.invalidate();
            }
        }
    }

    private class PathEditorPropertyValidator
    implements PropertyMap.PropertyValidator<PPathEditor> {
        private PathEditorPropertyValidator() {
        }

        @Override
        public Object validate(PPathEditor k, Object v) {
            switch (k) {
                case SELECTED_POINT: {
                    PointVisual pv = (PointVisual)PathEditor.this.pvMap.get(PathEditor.this.properties.get(k));
                    if (pv != null) {
                        if (v == pv.point) break;
                        pv.setSelected(false);
                    }
                    if ((pv = (PointVisual)PathEditor.this.pvMap.get(v)) == null) {
                        if (PathEditor.this.pvList.size() < 1) {
                            return null;
                        }
                        pv = (PointVisual)PathEditor.this.pvList.get(0);
                    }
                    pv.setSelected(true);
                    return pv.point;
                }
                case SHOW_GRID: {
                    if (v instanceof Boolean) {
                        PathEditor.this.put(1, (Boolean)v != false ? PathEditor.this.gridVisual : null);
                        break;
                    }
                    return PathEditor.this.properties.get(k);
                }
            }
            return v;
        }
    }

    private class PathPropertyListener
    extends PropertyMap.PropertyUpdateListener<Path.PPath> {
        private PathPropertyListener() {
        }

        @Override
        public void updated(PropertyMap.PropertyUpdateEvent<Path.PPath> e) {
            switch ((Path.PPath)((Object)e.key)) {
                case SNAP_X: {
                    PathEditor.this.gridVisual.setWidth((Integer)PathEditor.this.path.get(Path.PPath.SNAP_X));
                    PathEditor.this.repaint();
                    break;
                }
                case SNAP_Y: {
                    PathEditor.this.gridVisual.setHeight((Integer)PathEditor.this.path.get(Path.PPath.SNAP_Y));
                    PathEditor.this.repaint();
                    break;
                }
                case PRECISION: {
                    for (SmoothPathSegment s : PathEditor.this.spsMap.values()) {
                        s.validate();
                    }
                    PathEditor.this.arrow.validate();
                    break;
                }
                case SMOOTH: 
                case CLOSED: {
                    PathEditor.this.updatePointList();
                    break;
                }
                case BACKGROUND_ROOM: {
                    ResourceReference r = (ResourceReference)PathEditor.this.path.get(Path.PPath.BACKGROUND_ROOM);
                    PathEditor.this.setRoom(r == null ? null : (Room)r.get());
                }
            }
        }
    }

    private abstract class PathVisual
    extends VisualBox {
        private boolean invalid;

        public PathVisual() {
            super(PathEditor.this.binVisual);
        }

        protected abstract void validate();

        protected final void invalidate() {
            if (this.invalid) {
                return;
            }
            this.invalid = true;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (PathVisual.this.invalid) {
                            PathVisual.this.validate();
                        }
                    }
                    finally {
                        PathVisual.this.invalid = false;
                    }
                }
            });
        }
    }

    private class PointListListener
    implements UpdateSource.UpdateListener {
        private PointListListener() {
        }

        @Override
        public void updated(UpdateSource.UpdateEvent e) {
            ActiveArrayList.ListUpdateEvent lue = (ActiveArrayList.ListUpdateEvent)e;
            switch (lue.type) {
                case ADDED: 
                case REMOVED: 
                case CHANGED: {
                    PathEditor.this.updatePointList();
                }
            }
        }
    }

    private class PointVisual
    extends PathVisual {
        final PathPoint point;
        final Rectangle bounds = new Rectangle(8, 8);
        final PointPositionListener ppl = new PointPositionListener();
        private boolean selected;

        public PointVisual(PathPoint p) {
            this.point = p;
            PathEditor.this.binVisual.setDepth(this, 0);
            p.properties.getUpdateSource(PathPoint.PPathPoint.X).addListener(this.ppl);
            p.properties.getUpdateSource(PathPoint.PPathPoint.Y).addListener(this.ppl);
            this.validate();
        }

        public void setSelected(boolean s) {
            this.selected = s;
            PathEditor.this.binVisual.setDepth(this, s ? -2 : 0);
        }

        protected void calculateBounds() {
            this.bounds.setLocation(this.point.getX() - 4, this.point.getY() - 4);
        }

        @Override
        protected void validate() {
            this.calculateBounds();
            this.setBounds(this.bounds);
        }

        @Override
        public void paint(Graphics g) {
            int i;
            int n = i = this.selected ? 1 : 0;
            if (PathEditor.this.pointImage[i] == null) {
                PathEditor.this.pointImage[i] = PathEditor.this.getGraphicsConfiguration().createCompatibleImage(8, 8, 2);
                Graphics2D g2 = PathEditor.this.pointImage[i].createGraphics();
                g2.setColor(this.selected ? Color.RED : Color.BLUE);
                g2.fillOval(0, 0, 7, 7);
                g2.setColor(Color.BLACK);
                g2.drawOval(0, 0, 7, 7);
            }
            g.drawImage(PathEditor.this.pointImage[i], 0, 0, null);
        }

        private class PointPositionListener
        extends PropertyMap.PropertyUpdateListener<PathPoint.PPathPoint> {
            private PointPositionListener() {
            }

            @Override
            public void updated(PropertyMap.PropertyUpdateEvent<PathPoint.PPathPoint> e) {
                PointVisual.this.invalidate();
            }
        }
    }

    private class SmoothPathSegment
    extends PathVisual {
        final PathPoint[] pp = new PathPoint[4];
        final Rectangle bounds = new Rectangle();
        final PointPositionListener ppl = new PointPositionListener();
        final InnerSegment innerSegment = new InnerSegment();
        int[] px;
        int[] py;

        public SmoothPathSegment(PathPoint ... p) {
            if (p.length != 4) {
                throw new IllegalArgumentException();
            }
            System.arraycopy(p, 0, this.pp, 0, 4);
            PathEditor.this.binVisual.setDepth(this, 2);
            PathPoint[] pathPointArray = p;
            int n = p.length;
            int n2 = 0;
            while (n2 < n) {
                PathPoint point = pathPointArray[n2];
                if (point != null) {
                    point.properties.getUpdateSource(PathPoint.PPathPoint.X).addListener(this.ppl);
                    point.properties.getUpdateSource(PathPoint.PPathPoint.Y).addListener(this.ppl);
                }
                ++n2;
            }
            this.validate();
        }

        @Override
        public void remove() {
            this.innerSegment.remove();
            super.remove();
        }

        private void pBlend(int i, int n, int t, int[] x, int[] y) {
            float w0 = PathEditor.this.getBlending(n, t + 1 + 2 * n);
            float w2 = PathEditor.this.getBlending(n, t + 1);
            this.px[i] = x[1] + Math.round(w0 * (float)(x[0] - x[1]) + w2 * (float)(x[2] - x[1]));
            this.py[i] = y[1] + Math.round(w0 * (float)(y[0] - y[1]) + w2 * (float)(y[2] - y[1]));
        }

        protected void calculateBounds() {
            int t;
            this.bounds.setBounds(0, 0, -1, -1);
            int[] x = new int[4];
            int[] y = new int[4];
            int i = 0;
            while (i < 4) {
                if (this.pp[i] != null) {
                    x[i] = this.pp[i].getX();
                    y[i] = this.pp[i].getY();
                }
                ++i;
            }
            int p = (Integer)((PathEditor)PathEditor.this).path.properties.get(Path.PPath.PRECISION);
            int n = 1 << p;
            if (this.pp[0] == null) {
                this.px = new int[2];
                this.py = new int[2];
                this.px[0] = x[1];
                this.py[0] = y[1];
                this.bounds.add(x[1], y[1]);
                this.pBlend(1, n, 0, Arrays.copyOfRange(x, 1, 4), Arrays.copyOfRange(y, 1, 4));
                this.bounds.add(this.px[1], this.py[1]);
            } else {
                this.px = new int[n];
                this.py = new int[n];
                t = 0;
                while (t < n - 1) {
                    this.pBlend(t, n, t, x, y);
                    this.bounds.add(this.px[t], this.py[t]);
                    ++t;
                }
                if (this.pp[3] == null) {
                    this.px[n - 1] = x[2];
                    this.py[n - 1] = y[2];
                } else {
                    this.pBlend(n - 1, n, 0, Arrays.copyOfRange(x, 1, 4), Arrays.copyOfRange(y, 1, 4));
                }
                this.bounds.add(this.px[n - 1], this.py[n - 1]);
            }
            this.bounds.grow(3, 3);
            t = 0;
            while (t < this.px.length) {
                int n2 = t;
                this.px[n2] = this.px[n2] - this.bounds.x;
                int n3 = t++;
                this.py[n3] = this.py[n3] - this.bounds.y;
            }
        }

        @Override
        protected void validate() {
            this.calculateBounds();
            this.setBounds(this.bounds);
            this.innerSegment.setBounds(this.bounds);
        }

        @Override
        public void paint(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setColor(Color.BLACK);
            g2.setStroke(STROKE_OUTER);
            g2.drawPolyline(this.px, this.py, this.px.length);
        }

        private class InnerSegment
        extends VisualBox {
            public InnerSegment() {
                super(PathEditor.this.binVisual);
                PathEditor.this.binVisual.setDepth(this, 1);
            }

            @Override
            protected void setBounds(Rectangle b) {
                super.setBounds(b);
            }

            @Override
            public void paint(Graphics g) {
                Graphics2D g2 = (Graphics2D)g;
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setColor(Color.WHITE);
                g2.setStroke(STROKE_INNER);
                g2.drawPolyline(SmoothPathSegment.this.px, SmoothPathSegment.this.py, SmoothPathSegment.this.px.length);
            }
        }

        private class PointPositionListener
        extends PropertyMap.PropertyUpdateListener<PathPoint.PPathPoint> {
            private PointPositionListener() {
            }

            @Override
            public void updated(PropertyMap.PropertyUpdateEvent<PathPoint.PPathPoint> e) {
                SmoothPathSegment.this.invalidate();
            }
        }
    }
}

