/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.components.visual;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JLabel;

public class FileChooserImagePreview
extends JLabel
implements PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    private ImageIcon prev = null;
    private static final int WIDTH = 150;
    private static final int HEIGHT = 150;

    public FileChooserImagePreview(JFileChooser choose) {
        choose.addPropertyChangeListener(this);
        this.setPreferredSize(new Dimension(150, 150));
        this.setHorizontalAlignment(0);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName() == "SelectedFileChangedProperty" && this.isShowing()) {
            File f = (File)e.getNewValue();
            if (f == null) {
                this.prev = null;
            } else {
                BufferedImage img = null;
                try {
                    img = ImageIO.read(f);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.prev = img != null ? (img.getWidth() > 150 && img.getHeight() > 150 ? new ImageIcon(img.getScaledInstance(img.getWidth() >= img.getHeight() ? 150 : -1, img.getHeight() > img.getWidth() ? 150 : -1, 2)) : (img.getWidth() > 150 || img.getHeight() > 150 ? new ImageIcon(img.getScaledInstance(img.getWidth() > 150 ? 150 : -1, img.getHeight() > 150 ? 150 : -1, 2)) : new ImageIcon(img))) : null;
            }
            this.setIcon(this.prev);
        }
    }
}

