/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.components.visual;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import org.lateralgm.components.visual.AbstractImagePreview;
import org.lateralgm.main.UpdateSource;
import org.lateralgm.main.Util;
import org.lateralgm.resources.Background;
import org.lateralgm.util.PropertyMap;

public class BackgroundPreview
extends AbstractImagePreview
implements UpdateSource.UpdateListener {
    private static final long serialVersionUID = 1L;
    private final Background background;
    private final BackgroundPropertyListener bpl = new BackgroundPropertyListener();

    public BackgroundPreview(Background b) {
        this.background = b;
        b.properties.updateSource.addListener(this.bpl);
        b.reference.updateSource.addListener(this);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.getImage() == null) {
            return;
        }
        if (!((Boolean)this.background.get(Background.PBackground.USE_AS_TILESET)).booleanValue()) {
            return;
        }
        int twidth = (Integer)this.background.get(Background.PBackground.TILE_WIDTH);
        int theight = (Integer)this.background.get(Background.PBackground.TILE_HEIGHT);
        twidth = (int)((double)twidth * this.zoom);
        theight = (int)((double)theight * this.zoom);
        if (twidth <= 2 || theight <= 2) {
            return;
        }
        g = g.create();
        this.reclipAndTranslate(g);
        int hoffset = (Integer)this.background.get(Background.PBackground.H_OFFSET);
        int voffset = (Integer)this.background.get(Background.PBackground.V_OFFSET);
        int hsep = (Integer)this.background.get(Background.PBackground.H_SEP);
        int vsep = (Integer)this.background.get(Background.PBackground.V_SEP);
        hoffset = (int)((double)hoffset * this.zoom);
        voffset = (int)((double)voffset * this.zoom);
        hsep = (int)((double)hsep * this.zoom);
        vsep = (int)((double)vsep * this.zoom);
        Dimension prefSize = this.getPreferredSize();
        Rectangle r = g.getClipBounds().intersection(new Rectangle(hoffset, voffset, prefSize.width - hoffset, prefSize.height - voffset));
        int newx = (r.x - hoffset) / (twidth + hsep) * (twidth + hsep) + hoffset;
        r.width += r.x - newx;
        r.x = newx;
        int newy = (r.y - voffset) / (theight + vsep) * (theight + vsep) + voffset;
        r.height += r.y - newy;
        r.y = newy;
        g.setXORMode(Color.BLACK);
        g.setColor(Color.WHITE);
        int i = r.x;
        while (i < r.x + r.width) {
            int j = r.y;
            while (j < r.y + r.height) {
                g.drawRect(i, j, twidth - 1, theight - 1);
                j += theight + vsep;
            }
            i += twidth + hsep;
        }
        g.dispose();
    }

    @Override
    protected BufferedImage getImage() {
        if (this.background == null) {
            return null;
        }
        if (!((Boolean)this.background.get(Background.PBackground.TRANSPARENT)).booleanValue()) {
            return this.background.getBackgroundImage();
        }
        return Util.getTransparentImage(this.background.getBackgroundImage());
    }

    @Override
    public void updated(UpdateSource.UpdateEvent e) {
        this.resizeAndRepaint();
    }

    private class BackgroundPropertyListener
    extends PropertyMap.PropertyUpdateListener<Background.PBackground> {
        private BackgroundPropertyListener() {
        }

        @Override
        public void updated(PropertyMap.PropertyUpdateEvent<Background.PBackground> e) {
            switch ((Background.PBackground)((Object)e.key)) {
                case TRANSPARENT: 
                case SMOOTH_EDGES: 
                case PRELOAD: {
                    return;
                }
            }
            BackgroundPreview.this.repaint();
        }
    }
}

