/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.components.visual;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import org.lateralgm.main.Util;

public abstract class AbstractImagePreview
extends JLabel {
    private static final long serialVersionUID = 1L;
    private BufferedImage transparentBackground = null;
    protected double zoom = 1.0;

    public AbstractImagePreview() {
        this.setOpaque(true);
    }

    protected abstract BufferedImage getImage();

    public Point getTopLeftCentered() {
        Dimension d = this.getPreferredSize();
        return new Point(this.getWidth() / 2 - d.width / 2, this.getHeight() / 2 - d.height / 2);
    }

    public Point translatePoint(Point p) {
        Point origin = this.getTopLeftCentered();
        Point t = new Point((int)Math.floor((double)p.x / this.zoom - (double)origin.x / this.zoom), (int)Math.floor((double)p.y / this.zoom - (double)origin.y / this.zoom));
        return t;
    }

    public Shape reclipAndTranslate(Graphics g) {
        Shape oldClip = g.getClip();
        Dimension prefSize = this.getPreferredSize();
        Graphics2D g2d = (Graphics2D)g;
        Point p = this.getTopLeftCentered();
        g2d.translate(p.x, p.y);
        g.clipRect(0, 0, prefSize.width, prefSize.height);
        return oldClip;
    }

    @Override
    public Dimension getPreferredSize() {
        BufferedImage bi = this.getImage();
        if (bi == null) {
            return super.getPreferredSize();
        }
        return new Dimension((int)((double)bi.getWidth() * this.zoom), (int)((double)bi.getHeight() * this.zoom));
    }

    public double getZoom() {
        return this.zoom;
    }

    public void setZoom(double nzoom) {
        this.zoom = nzoom;
        this.resizeAndRepaint();
    }

    public void zoomIn(Point point, JScrollPane scroll) {
        if (this.getZoom() >= 32.0) {
            return;
        }
        this.setZoom(this.getZoom() * 2.0);
        scroll.validate();
        Dimension size = scroll.getViewport().getSize();
        int newX = point.x * 2 - size.width / 2;
        int newY = point.y * 2 - size.height / 2;
        scroll.getViewport().setViewPosition(new Point(newX, newY));
    }

    public void zoomOut(Point point, JScrollPane scroll) {
        if (this.getZoom() <= 0.04) {
            return;
        }
        this.setZoom(this.getZoom() / 2.0);
        scroll.validate();
        Dimension size = scroll.getViewport().getSize();
        int newX = point.x / 2 - size.width / 2;
        int newY = point.y / 2 - size.height / 2;
        scroll.getViewport().setViewPosition(new Point(newX, newY));
    }

    public void zoomIn(JScrollPane scroll) {
        Dimension size = this.getPreferredSize();
        this.zoomIn(new Point(size.width / 2, size.height / 2), scroll);
    }

    public void zoomOut(JScrollPane scroll) {
        Dimension size = this.getPreferredSize();
        this.zoomOut(new Point(size.width / 2, size.height / 2), scroll);
    }

    protected void resizeAndRepaint() {
        this.revalidate();
        this.repaint();
    }

    @Override
    @Deprecated
    public void setIcon(Icon ico) {
        super.setIcon(ico);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        BufferedImage image = this.getImage();
        if (image == null) {
            this.setPreferredSize(new Dimension(0, 0));
            return;
        }
        g = g.create();
        this.reclipAndTranslate(g);
        Dimension prefSize = this.getPreferredSize();
        int width = (int)Math.ceil(prefSize.getWidth() / 10.0);
        int height = (int)Math.ceil(prefSize.getHeight() / 10.0);
        width = width < 1 ? 1 : width;
        int n = height = height < 1 ? 1 : height;
        if (this.transparentBackground == null || width != this.transparentBackground.getWidth() || height != this.transparentBackground.getHeight()) {
            this.transparentBackground = Util.paintBackground(width, height);
        }
        g.drawImage(this.transparentBackground, 0, 0, this.transparentBackground.getWidth() * 10, this.transparentBackground.getHeight() * 10, null);
        g.drawImage(image, 0, 0, prefSize.width, prefSize.height, null);
        g.dispose();
    }
}

