/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.components.mdi;

import java.awt.Component;
import java.awt.Rectangle;
import java.beans.PropertyVetoException;
import java.lang.ref.WeakReference;
import java.util.WeakHashMap;
import javax.swing.DesktopManager;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JScrollPane;
import org.lateralgm.components.mdi.MDIFrame;
import org.lateralgm.components.mdi.MDIManager;
import org.lateralgm.components.mdi.MDIMenu;
import org.lateralgm.subframes.InstantiableResourceFrame;
import org.lateralgm.util.WeakArrayList;

public class MDIPane
extends JDesktopPane {
    private static final long serialVersionUID = 1L;
    private int offset = -1;
    private static final int OFFSET_WIDTH = 24;
    private static final int OFFSET_HEIGHT = 24;
    private static final int OFFSET_MAX = 9;
    private final MDIMenu menu;
    public static final String SELECTED_FRAME_PROPERTY = "selectedFrame";
    private final WeakHashMap<Component, WeakArrayList<Component>> zMap;

    public MDIMenu getMenu() {
        return this.menu;
    }

    public MDIPane() {
        this.setDesktopManager(new MDIManager(this));
        this.menu = new MDIMenu(this);
        this.zMap = new WeakHashMap();
    }

    public void setScrollPane(JScrollPane scroll) {
        MDIManager man = this.getMDIManager();
        if (man != null) {
            man.setScrollPane(scroll);
        }
    }

    public void cascadeFrames() {
        this.offset = -1;
        JInternalFrame[] jInternalFrameArray = this.getAllFrames();
        int n = jInternalFrameArray.length;
        int n2 = 0;
        while (n2 < n) {
            JInternalFrame f = jInternalFrameArray[n2];
            if (f.isVisible() && !f.isIcon()) {
                this.incrementOffset();
                Rectangle r = f.getBounds();
                r.x = this.offset * 24;
                r.y = this.offset * 24;
                f.setBounds(r);
                f.toFront();
                try {
                    f.setSelected(true);
                }
                catch (PropertyVetoException e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
        this.resizeDesktop();
    }

    public void arrangeDesktopIcons() {
        int x = 2147474647;
        int y = this.getPreferredSize().height;
        JInternalFrame[] jInternalFrameArray = this.getAllFrames();
        int n = jInternalFrameArray.length;
        int n2 = 0;
        while (n2 < n) {
            JInternalFrame f = jInternalFrameArray[n2];
            if (f.isIcon()) {
                Rectangle r = f.getDesktopIcon().getBounds();
                if (x + r.width * 2 <= this.getPreferredSize().width) {
                    x += r.width;
                } else {
                    x = 0;
                    y -= r.height;
                }
                r.x = x;
                r.y = y;
                f.getDesktopIcon().setBounds(r);
            }
            ++n2;
        }
        this.resizeDesktop();
    }

    public void closeAll() {
        JInternalFrame[] jInternalFrameArray = this.getAllFrames();
        int n = jInternalFrameArray.length;
        int n2 = 0;
        while (n2 < n) {
            JInternalFrame f = jInternalFrameArray[n2];
            if (f instanceof InstantiableResourceFrame) {
                try {
                    f.setClosed(true);
                }
                catch (PropertyVetoException e) {
                    e.printStackTrace();
                }
            } else {
                f.setVisible(false);
            }
            ++n2;
        }
    }

    public void closeOthers() {
        if (this.getSelectedFrame() != null) {
            JInternalFrame[] jInternalFrameArray = this.getAllFrames();
            int n = jInternalFrameArray.length;
            int n2 = 0;
            while (n2 < n) {
                JInternalFrame f = jInternalFrameArray[n2];
                if (f != this.getSelectedFrame()) {
                    if (f instanceof InstantiableResourceFrame) {
                        try {
                            f.setClosed(true);
                        }
                        catch (PropertyVetoException e) {
                            e.printStackTrace();
                        }
                    } else {
                        f.setVisible(false);
                    }
                }
                ++n2;
            }
        }
    }

    public void iconizeAll() {
        JInternalFrame[] jInternalFrameArray = this.getAllFrames();
        int n = jInternalFrameArray.length;
        int n2 = 0;
        while (n2 < n) {
            JInternalFrame f = jInternalFrameArray[n2];
            if (f.isVisible()) {
                try {
                    f.setIcon(true);
                }
                catch (PropertyVetoException e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
        this.arrangeDesktopIcons();
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        this.resizeDesktop();
    }

    public MDIFrame add(MDIFrame f) {
        super.add(f);
        this.incrementOffset();
        Rectangle r = f.getBounds();
        r.x = this.offset * 24;
        r.y = this.offset * 24;
        f.setBounds(r);
        return f;
    }

    @Override
    public void remove(Component c) {
        super.remove(c);
        this.resizeDesktop();
    }

    public void resizeDesktop() {
        MDIManager mg = this.getMDIManager();
        if (mg != null) {
            mg.resizeDesktop();
        }
    }

    private void incrementOffset() {
        this.offset = this.offset >= 9 ? 0 : ++this.offset;
    }

    public boolean isMaximum() {
        JInternalFrame[] jInternalFrameArray = this.getAllFrames();
        int n = jInternalFrameArray.length;
        int n2 = 0;
        while (n2 < n) {
            JInternalFrame f = jInternalFrameArray[n2];
            if (f.isMaximum()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void bringMaximumToTop() {
        if (!this.isMaximum()) {
            return;
        }
        JInternalFrame[] jInternalFrameArray = this.getAllFrames();
        int n = jInternalFrameArray.length;
        int n2 = 0;
        while (n2 < n) {
            JInternalFrame f = jInternalFrameArray[n2];
            if (f.isMaximum() && f instanceof MDIFrame && f.isVisible()) {
                ((MDIFrame)f).toTop();
            }
            ++n2;
        }
    }

    private MDIManager getMDIManager() {
        DesktopManager man = this.getDesktopManager();
        if (man == null || !(man instanceof MDIManager)) {
            return null;
        }
        return (MDIManager)man;
    }

    @Override
    public void setSelectedFrame(JInternalFrame frame) {
        JInternalFrame old = this.getSelectedFrame();
        super.setSelectedFrame(frame);
        this.firePropertyChange(SELECTED_FRAME_PROPERTY, old, frame);
    }

    private void updateZChildren(Component p) {
        if (this.zMap == null) {
            return;
        }
        int fi = this.getIndexOf(p);
        int fl = this.getLayer(p);
        int fp = this.getPosition(p);
        WeakArrayList<Component> l = this.zMap.get(p);
        if (l == null) {
            return;
        }
        for (WeakReference<Component> weakReference : l) {
            int ci;
            Component c = (Component)weakReference.get();
            int n = ci = c == null ? -1 : this.getIndexOf(c);
            if (ci < 0 || ci <= fi) continue;
            this.setLayer(c, fl, fp);
        }
    }

    public void addZChild(Component p, Component c) {
        WeakArrayList<Component> l = this.zMap.get(p);
        if (l == null) {
            l = new WeakArrayList();
            this.zMap.put(p, l);
        }
        l.add((Component)((Object)new WeakReference<Component>(c)));
        this.updateZChildren(p);
    }

    @Override
    public void setLayer(Component c, int layer, int position) {
        super.setLayer(c, layer, position);
        this.updateZChildren(c);
    }
}

