/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.components.mdi;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.WeakHashMap;
import javax.swing.ButtonGroup;
import javax.swing.JInternalFrame;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import org.lateralgm.components.GmMenu;
import org.lateralgm.components.mdi.MDIFrame;
import org.lateralgm.components.mdi.MDIPane;
import org.lateralgm.messages.Messages;
import org.lateralgm.subframes.InstantiableResourceFrame;

public class MDIMenu
extends GmMenu
implements ActionListener,
ContainerListener {
    private static final long serialVersionUID = 1L;
    private MDIPane pane;
    private final ButtonGroup group = new ButtonGroup();
    protected final WeakHashMap<MDIFrame, FrameButton> frameButtons;
    protected JMenuItem cascade;
    protected JMenuItem arrangeIcons;
    protected JMenuItem closeAll;
    protected JMenuItem minimizeAll;
    protected JMenuItem close;
    protected JMenuItem closeOthers;

    public MDIMenu(MDIPane pane) {
        super(Messages.getString("MDIMenu.WINDOW"));
        this.pane = pane;
        this.frameButtons = new WeakHashMap();
        pane.addContainerListener(this);
        this.cascade = this.addItem("MDIMenu.CASCADE", this);
        this.arrangeIcons = this.addItem("MDIMenu.ARRANGE_ICONS", this);
        this.closeAll = this.addItem("MDIMenu.CLOSE_ALL", this);
        this.minimizeAll = this.addItem("MDIMenu.MINIMIZE_ALL", this);
        this.addSeparator();
        this.close = this.addItem("MDIMenu.CLOSE", this);
        this.closeOthers = this.addItem("MDIMenu.CLOSE_OTHERS", this);
        this.addSeparator();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().endsWith("CASCADE")) {
            this.pane.cascadeFrames();
            return;
        }
        if (e.getActionCommand().endsWith("ARRANGE_ICONS")) {
            this.pane.arrangeDesktopIcons();
            return;
        }
        if (e.getActionCommand().endsWith("CLOSE_ALL")) {
            this.pane.closeAll();
            return;
        }
        if (e.getActionCommand().endsWith("MINIMIZE_ALL")) {
            this.pane.iconizeAll();
            return;
        }
        if (e.getActionCommand().endsWith("CLOSE") && this.pane.getSelectedFrame() != null) {
            if (this.pane.getSelectedFrame() instanceof InstantiableResourceFrame) {
                try {
                    this.pane.getSelectedFrame().setClosed(true);
                }
                catch (PropertyVetoException e1) {
                    e1.printStackTrace();
                }
            } else {
                this.pane.getSelectedFrame().setVisible(false);
            }
            return;
        }
        if (e.getActionCommand().endsWith("CLOSE_OTHERS")) {
            this.pane.closeOthers();
            return;
        }
    }

    protected void addRadio(FrameButton item) {
        this.group.add(item);
        this.add(item);
    }

    protected void removeRadio(FrameButton item) {
        this.group.remove(item);
        this.remove(item);
    }

    @Override
    public void componentAdded(ContainerEvent e) {
        Component c = e.getChild();
        if (c instanceof MDIFrame) {
            new FrameButton((MDIFrame)c);
        }
    }

    @Override
    public void componentRemoved(ContainerEvent e) {
        Component c = e.getChild();
        FrameButton b = this.frameButtons.get(c);
        if (b != null) {
            b.dispose();
        }
    }

    @Override
    protected void fireMenuSelected() {
        boolean hasFrames = false;
        boolean hasIcons = false;
        int i = 0;
        while (i < this.pane.getComponentCount()) {
            Component comp = this.pane.getComponent(i);
            if (comp instanceof JInternalFrame && ((JInternalFrame)comp).isVisible()) {
                hasFrames = true;
                if (hasIcons) {
                    break;
                }
            } else if (comp instanceof JInternalFrame.JDesktopIcon) {
                hasIcons = true;
                if (hasFrames) break;
            }
            ++i;
        }
        this.cascade.setEnabled(hasFrames);
        this.arrangeIcons.setEnabled(hasIcons);
        this.closeAll.setEnabled(hasFrames);
        this.minimizeAll.setEnabled(hasFrames);
        boolean hasSelected = this.pane.getSelectedFrame() != null;
        this.close.setEnabled(hasSelected);
        this.closeOthers.setEnabled(hasSelected);
        super.fireMenuSelected();
    }

    private class FrameButton
    extends JRadioButtonMenuItem
    implements PropertyChangeListener {
        private static final long serialVersionUID = 1L;
        private IFListener ifl = new IFListener();
        private CListener cl = new CListener();
        protected MDIFrame mdif;

        public FrameButton(MDIFrame f) {
            this.mdif = f;
            MDIMenu.this.frameButtons.put(f, this);
            MDIMenu.this.addRadio(this);
            f.addInternalFrameListener(this.ifl);
            f.addPropertyChangeListener(this);
            f.addComponentListener(this.cl);
            this.update();
            this.setVisible(this.mdif.isVisible());
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FrameButton.this.mdif.toTop();
                }
            });
        }

        public void dispose() {
            MDIMenu.this.frameButtons.remove(this.mdif);
            MDIMenu.this.removeRadio(this);
            this.mdif.removeInternalFrameListener(this.ifl);
            this.mdif.removePropertyChangeListener(this);
            this.mdif.removeComponentListener(this.cl);
        }

        private void update() {
            this.setText(this.mdif.getTitle());
            this.setIcon(this.mdif.getFrameIcon());
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.update();
        }

        private class CListener
        extends ComponentAdapter {
            @Override
            public void componentHidden(ComponentEvent e) {
                FrameButton.this.setVisible(false);
            }

            @Override
            public void componentShown(ComponentEvent e) {
                FrameButton.this.setVisible(true);
            }
        }

        private class IFListener
        extends InternalFrameAdapter {
            @Override
            public void internalFrameActivated(InternalFrameEvent e) {
                FrameButton.this.setSelected(true);
            }
        }
    }
}

