/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.components.mdi;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.DefaultDesktopManager;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JScrollPane;
import org.lateralgm.components.mdi.MDIPane;

public class MDIManager
extends DefaultDesktopManager {
    private static final long serialVersionUID = 1L;
    public MDIPane pane;
    public JScrollPane scroll;

    public void setScrollPane(JScrollPane scroll) {
        this.scroll = scroll;
        this.scroll.setAutoscrolls(false);
        this.scroll.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent arg0) {
            }

            @Override
            public void componentMoved(ComponentEvent arg0) {
            }

            @Override
            public void componentResized(ComponentEvent arg0) {
            }

            @Override
            public void componentShown(ComponentEvent arg0) {
            }
        });
        this.resizeDesktop();
    }

    public MDIManager(MDIPane pane) {
        this.pane = pane;
    }

    @Override
    public void endResizingFrame(JComponent f) {
        super.endResizingFrame(f);
        this.resizeDesktop();
    }

    @Override
    public void endDraggingFrame(JComponent f) {
        super.endDraggingFrame(f);
        this.resizeDesktop();
    }

    public void resizeDesktop() {
        Rectangle viewrect = this.scroll.getViewport().getViewRect();
        int xmin = Integer.MAX_VALUE;
        int ymin = Integer.MAX_VALUE;
        int xmax = 0;
        int ymax = 0;
        JInternalFrame[] jInternalFrameArray = this.pane.getAllFrames();
        int n = jInternalFrameArray.length;
        int n2 = 0;
        while (n2 < n) {
            JInternalFrame f = jInternalFrameArray[n2];
            if (f.isVisible()) {
                if (!f.isMaximum()) {
                    JComponent comp = !f.isIcon() ? f : f.getDesktopIcon();
                    xmin = Math.min(comp.getX(), xmin);
                    ymin = Math.min(comp.getY(), ymin);
                    xmax = Math.max(comp.getX() + comp.getWidth(), xmax);
                    ymax = Math.max(comp.getY() + comp.getHeight(), ymax);
                } else {
                    f.setSize(this.pane.getSize());
                    return;
                }
            }
            ++n2;
        }
        int xcorrect = 0;
        int ycorrect = 0;
        xcorrect = viewrect.x < xmin ? -viewrect.x : -xmin;
        ycorrect = viewrect.y < ymin ? -viewrect.y : -ymin;
        Point newviewpos = new Point(viewrect.x + xcorrect, viewrect.y + ycorrect);
        Dimension newPaneSize = new Dimension(Math.max(xmax + xcorrect, newviewpos.x + Math.min(viewrect.width, this.pane.getPreferredSize().width)), Math.max(ymax + ycorrect, newviewpos.y + Math.min(viewrect.height, this.pane.getPreferredSize().height)));
        JInternalFrame[] jInternalFrameArray2 = this.pane.getAllFrames();
        int n3 = jInternalFrameArray2.length;
        int n4 = 0;
        while (n4 < n3) {
            Point p;
            JInternalFrame f1 = jInternalFrameArray2[n4];
            if (!f1.isIcon()) {
                p = f1.getLocation();
                f1.setLocation(new Point(p.x + xcorrect, p.y + ycorrect));
            }
            p = f1.getDesktopIcon().getLocation();
            f1.getDesktopIcon().setLocation(new Point(p.x + xcorrect, p.y + ycorrect));
            f1.repaint();
            ++n4;
        }
        this.scroll.getViewport().setViewPosition(newviewpos);
        this.pane.setPreferredSize(newPaneSize);
        this.pane.getParent().invalidate();
        this.pane.getParent().validate();
        this.pane.repaint();
    }
}

