/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.components.impl;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import org.lateralgm.components.NumberField;
import org.lateralgm.components.visual.SpriteStripPreview;
import org.lateralgm.messages.Messages;

public class SpriteStripDialog
extends JDialog
implements Iterable<Rectangle>,
ActionListener {
    private static final long serialVersionUID = 1L;
    public BufferedImage img;
    public SpriteStripPreview preview;
    public boolean confirmed = false;
    private NumberField[] fields;
    private static final int IMAGE_NUMBER = 0;
    private static final int IMAGES_PER_ROW = 1;
    private static final int CELL_WIDTH = 2;
    private static final int CELL_HEIGHT = 3;
    private static final int HOR_CELL_OFFSET = 4;
    private static final int VERT_CELL_OFFSET = 5;
    private static final int HOR_PIXEL_OFFSET = 6;
    private static final int VERT_PIXEL_OFFSET = 7;
    private static final int HOR_SEP = 8;
    private static final int VERT_SEP = 9;

    public SpriteStripDialog(Frame owner, BufferedImage src) {
        super(owner, Messages.getString("SpriteStripDialog.TITLE"), true);
        this.img = src;
        String[] labels = new String[]{"IMAGE_NUMBER", "IMAGES_PER_ROW", "CELL_WIDTH", "CELL_HEIGHT", "HOR_CELL_OFFSET", "VERT_CELL_OFFSET", "HOR_PIXEL_OFFSET", "VERT_PIXEL_OFFSET", "HOR_SEP", "VERT_SEP"};
        JLabel[] l = new JLabel[labels.length];
        this.fields = new NumberField[labels.length];
        JPanel p = new JPanel();
        GroupLayout layout = new GroupLayout(p);
        layout.setAutoCreateContainerGaps(true);
        p.setLayout(layout);
        GroupLayout.ParallelGroup g1 = layout.createParallelGroup();
        GroupLayout.ParallelGroup g2 = layout.createParallelGroup();
        GroupLayout.SequentialGroup g3 = layout.createSequentialGroup();
        this.preview = new SpriteStripPreview(this);
        this.fields[0] = new NumberField(1, 99999, 1);
        this.fields[1] = new NumberField(1, 99999, 1);
        this.fields[2] = new NumberField(1, 99999, 32);
        this.fields[3] = new NumberField(1, 99999, 32);
        this.fields[0].addValueChangeListener(new NumberField.ValueChangeListener(){

            @Override
            public void valueChange(NumberField.ValueChangeEvent evt) {
                if (SpriteStripDialog.this.fields[1].getValue().equals(evt.getOldValue())) {
                    SpriteStripDialog.this.fields[1].setValue(evt.getNewValue());
                }
            }
        });
        int i = 0;
        while (i < labels.length) {
            l[i] = new JLabel(Messages.getString("SpriteStripDialog." + labels[i]));
            g1.addComponent(l[i]);
            if (i > 3) {
                this.fields[i] = new NumberField(0);
            }
            this.fields[i].addValueChangeListener(this.preview);
            g2.addComponent(this.fields[i], 50, 50, 50);
            if (i > 1 && i % 2 == 0 || i == 1) {
                g3.addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED);
            } else {
                g3.addPreferredGap(LayoutStyle.ComponentPlacement.RELATED);
            }
            g3.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(l[i]).addComponent(this.fields[i]));
            ++i;
        }
        String str = "SpriteStripDialog.IMPORT";
        JButton ok = new JButton(Messages.getString(str));
        ok.setActionCommand(str);
        ok.addActionListener(this);
        this.getRootPane().setDefaultButton(ok);
        str = "SpriteStripDialog.CANCEL";
        JButton cancel = new JButton(Messages.getString(str));
        cancel.setActionCommand(str);
        cancel.addActionListener(this);
        layout.setHorizontalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addGroup(g1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(g2)).addGroup(layout.createSequentialGroup().addComponent(ok).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(cancel)));
        g3.addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED);
        g3.addGroup(layout.createParallelGroup().addComponent(ok).addComponent(cancel));
        layout.setVerticalGroup(g3);
        this.add((Component)p, "West");
        JScrollPane scroll = new JScrollPane(this.preview);
        scroll.setPreferredSize(new Dimension(300, 300));
        this.add((Component)scroll, "Center");
        this.pack();
    }

    public void setOrigin(int x, int y) {
        this.fields[4].setValue(0);
        this.fields[5].setValue(0);
        this.fields[6].setValue(x);
        this.fields[7].setValue(y);
    }

    public BufferedImage[] getStrip() {
        if (!this.confirmed) {
            return null;
        }
        BufferedImage[] ret = new BufferedImage[this.fields[0].getIntValue().intValue()];
        int i = 0;
        for (Rectangle r : this) {
            BufferedImage subimage = new BufferedImage(r.width, r.height, this.img.getType());
            Graphics2D g2d = subimage.createGraphics();
            g2d.setComposite(AlphaComposite.Src);
            g2d.drawImage((Image)this.img, -r.x, -r.y, null);
            g2d.dispose();
            ret[i++] = subimage;
        }
        return ret;
    }

    @Override
    public Iterator<Rectangle> iterator() {
        ArrayList<Rectangle> list = new ArrayList<Rectangle>();
        int cw = this.fields[2].getIntValue();
        int ch = this.fields[3].getIntValue();
        int x = this.fields[4].getIntValue() * cw;
        int y = this.fields[5].getIntValue() * ch;
        int xx = x += this.fields[6].getIntValue().intValue();
        int yy = y += this.fields[7].getIntValue().intValue();
        int i = 0;
        while (i < this.fields[0].getIntValue()) {
            if (i != 0 && i % this.fields[1].getIntValue() == 0) {
                xx = x;
                yy += ch + this.fields[9].getIntValue();
            }
            list.add(new Rectangle(xx, yy, cw, ch));
            xx += cw + this.fields[8].getIntValue();
            ++i;
        }
        return list.listIterator();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("SpriteStripDialog.IMPORT")) {
            this.confirmed = true;
        }
        this.setVisible(false);
    }
}

