/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.components.impl;

import java.awt.Point;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.lateralgm.resources.Room;
import org.lateralgm.resources.sub.Instance;
import org.lateralgm.resources.sub.Tile;
import org.lateralgm.subframes.RoomFrame;

public class ShiftPieceInstances
extends AbstractUndoableEdit {
    private static final long serialVersionUID = 1L;
    private int horizontalShift;
    private int verticalShift;
    private boolean tilesTabIsSelected;
    private RoomFrame roomFrame;

    public ShiftPieceInstances(RoomFrame roomFrame, boolean tilesTabIsSelected, int horizontalShift, int verticalShift) {
        this.horizontalShift = horizontalShift;
        this.verticalShift = verticalShift;
        this.roomFrame = roomFrame;
        this.tilesTabIsSelected = tilesTabIsSelected;
    }

    @Override
    public void undo() throws CannotUndoException {
        Room room = this.roomFrame.getRoomEditor().getRoom();
        if (this.tilesTabIsSelected) {
            for (Tile tile : room.tiles) {
                this.roomFrame.tList.setSelectedValue(tile, false);
                Point newPosition = new Point(tile.getPosition().x - this.horizontalShift, tile.getPosition().y - this.verticalShift);
                tile.setPosition(newPosition);
            }
        } else {
            for (Instance instance : room.instances) {
                this.roomFrame.oList.setSelectedValue(instance, false);
                Point newPosition = new Point(instance.getPosition().x - this.horizontalShift, instance.getPosition().y - this.verticalShift);
                instance.setPosition(newPosition);
            }
        }
    }

    @Override
    public void redo() throws CannotRedoException {
        Room room = this.roomFrame.getRoomEditor().getRoom();
        if (this.tilesTabIsSelected) {
            for (Tile tile : room.tiles) {
                this.roomFrame.tList.setSelectedValue(tile, false);
                Point newPosition = new Point(tile.getPosition().x + this.horizontalShift, tile.getPosition().y + this.verticalShift);
                tile.setPosition(newPosition);
            }
        } else {
            for (Instance instance : room.instances) {
                this.roomFrame.oList.setSelectedValue(instance, false);
                Point newPosition = new Point(instance.getPosition().x + this.horizontalShift, instance.getPosition().y + this.verticalShift);
                instance.setPosition(newPosition);
            }
        }
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean canRedo() {
        return true;
    }
}

