/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.components.impl;

import java.awt.Font;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JInternalFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import org.lateralgm.components.GmTreeGraphics;
import org.lateralgm.components.impl.DefaultNode;
import org.lateralgm.main.LGM;
import org.lateralgm.main.Listener;
import org.lateralgm.main.Prefs;
import org.lateralgm.main.UpdateSource;
import org.lateralgm.main.Util;
import org.lateralgm.messages.Messages;
import org.lateralgm.resources.Background;
import org.lateralgm.resources.GmObject;
import org.lateralgm.resources.InstantiableResource;
import org.lateralgm.resources.Resource;
import org.lateralgm.resources.ResourceReference;
import org.lateralgm.resources.Sprite;
import org.lateralgm.subframes.InstantiableResourceFrame;
import org.lateralgm.subframes.ResourceFrame;
import org.lateralgm.subframes.RoomFrame;
import org.lateralgm.subframes.SubframeInformer;

public class ResNode
extends DefaultNode
implements Transferable,
UpdateSource.UpdateListener {
    private static final long serialVersionUID = -2072032756973999470L;
    public static DataFlavor DATA_FLAVOR;
    private static final DataFlavor[] flavors;
    public static final Map<Class<?>, ImageIcon> ICON;
    public static final byte STATUS_PRIMARY = 1;
    public static final byte STATUS_GROUP = 2;
    public static final byte STATUS_SECONDARY = 3;
    public byte status;
    public Class<?> kind;
    private final ResourceReference<? extends Resource<?, ?>> res;
    public ResourceFrame<?, ?> frame = null;
    private final NameUpdater nameUpdater = new NameUpdater(this);
    private final UpdateSource.UpdateTrigger trigger = new UpdateSource.UpdateTrigger();
    public final UpdateSource updateSource = new UpdateSource(this, this.trigger);
    public boolean newRes = false;

    static {
        try {
            DATA_FLAVOR = Util.createJVMLocalDataFlavor(ResNode.class);
        }
        catch (ClassNotFoundException e) {
            LGM.showDefaultExceptionHandler(e);
        }
        flavors = new DataFlavor[]{DATA_FLAVOR};
        ICON = new HashMap();
        for (Map.Entry<String, Class<Resource<?, ?>>> k : Resource.kindsByName3.entrySet()) {
            ICON.put(k.getValue(), LGM.getIconForKey("Resource." + k.getKey()));
        }
    }

    @Override
    public Icon getIcon() {
        if (this.status == 3) {
            if (this.kind == Sprite.class || this.kind == Background.class || this.kind == GmObject.class) {
                if (this.icon == null) {
                    this.updateIcon();
                }
                return this.icon;
            }
            return ICON.get(this.kind);
        }
        if (Prefs.iconizeGroup && this.getChildCount() > 0) {
            ResNode n = (ResNode)this.getChildAt(0);
            if (n.status == 3) {
                return n.getIcon();
            }
        }
        return null;
    }

    @Override
    public Icon getIconisedGroup() {
        if (this.status != 1 && this.kind == Sprite.class || this.kind == Background.class || this.kind == GmObject.class) {
            return this.getIcon();
        }
        return null;
    }

    @Override
    public Icon getLeafIcon() {
        if (this.status == 3) {
            return this.getIcon();
        }
        return null;
    }

    public Font getFont(Font com) {
        com = Prefs.boldPrimaryNodes && this.status == 1 ? com.deriveFont(1) : com.deriveFont(0);
        return com;
    }

    private void updateIcon() {
        this.icon = GmTreeGraphics.getResourceIcon(this.res);
    }

    public ResNode(String name, byte status, Class<?> kind, ResourceReference<? extends Resource<?, ?>> res) {
        super(name);
        this.status = status;
        this.kind = kind;
        this.res = res;
        Resource<?, ?> r = this.deRef();
        if (r != null) {
            r.setNode(this);
            res.updateSource.addListener(this);
        }
    }

    public ResNode(String name, byte status, Class<?> kind) {
        this(name, status, kind, null);
    }

    public ResNode addChild(String name, byte stat, Class<?> k) {
        ResNode b = new ResNode(name, stat, k, null);
        this.add(b);
        return b;
    }

    @Override
    public boolean getAllowsChildren() {
        if (this.status == 3) {
            return false;
        }
        return !this.isRoot();
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return flavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavor.equals(DATA_FLAVOR);
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
        if (flavor != DATA_FLAVOR) {
            throw new UnsupportedFlavorException(flavor);
        }
        return this;
    }

    public void openFrame() {
        this.openFrame(false);
    }

    public void openFrame(boolean newRes) {
        this.newRes = newRes;
        Resource<?, ?> r = this.deRef();
        if (SubframeInformer.fireSubframeRequest(r, this)) {
            return;
        }
        ResourceFrame<?, ?> rf = this.frame;
        boolean wasVisible = false;
        if (this.frame == null) {
            ResourceFrame.ResourceFrameFactory factory = ResourceFrame.factories.get(this.kind);
            ResourceFrame<?, ?> resourceFrame = rf = factory == null ? null : factory.makeFrame(r, this);
            if (rf != null) {
                this.frame = rf;
                if (rf instanceof InstantiableResourceFrame) {
                    LGM.mdi.add(rf);
                }
            }
        } else {
            wasVisible = this.frame.isVisible();
        }
        if (rf != null) {
            SubframeInformer.fireSubframeAppear(rf, wasVisible);
            rf.toTop();
        }
    }

    private static JMenuItem makeMenuItem(String command, ActionListener al, boolean setIcon) {
        JMenuItem menuItem = new JMenuItem(Messages.getString(command));
        menuItem.setActionCommand(command);
        menuItem.addActionListener(al);
        ImageIcon icon = LGM.getIconForKey(command);
        if (icon != null && setIcon) {
            menuItem.setIcon(icon);
        }
        menuItem.addKeyListener(null);
        return menuItem;
    }

    public void showMenu(MouseEvent e) {
        JPopupMenu popup = new JPopupMenu();
        Listener.NodeMenuListener al = new Listener.NodeMenuListener(this);
        if (!this.isInstantiable()) {
            JMenuItem editItem = ResNode.makeMenuItem("Listener.TREE_PROPERTIES", al, true);
            popup.add(editItem);
            editItem.setFocusable(true);
            editItem.setAccelerator(KeyStroke.getKeyStroke(Messages.getKeyboardString("Listener.TREE_PROPERTIES")));
            popup.show(e.getComponent(), e.getX(), e.getY());
            return;
        }
        if (this.status == 3) {
            JMenuItem insertItem = ResNode.makeMenuItem("Listener.TREE_INSERT_RESOURCE", al, true);
            insertItem.setFocusable(true);
            popup.add(insertItem);
            insertItem.setAccelerator(KeyStroke.getKeyStroke(Messages.getKeyboardString("Listener.TREE_INSERT_RESOURCE")));
            JMenuItem duplicateItem = ResNode.makeMenuItem("Listener.TREE_DUPLICATE_RESOURCE", al, true);
            duplicateItem.setFocusable(true);
            popup.add(duplicateItem);
            duplicateItem.setAccelerator(KeyStroke.getKeyStroke(Messages.getKeyboardString("Listener.TREE_DUPLICATE_RESOURCE")));
            popup.add(ResNode.makeMenuItem("Listener.TREE_INSERT_GROUP", al, true));
        } else {
            popup.add(ResNode.makeMenuItem("Listener.TREE_CREATE_RESOURCE", al, true));
            popup.add(ResNode.makeMenuItem("Listener.TREE_CREATE_GROUP", al, true));
        }
        if (this.status != 3) {
            popup.add(ResNode.makeMenuItem("Listener.TREE_SORT", al, false));
        }
        if (this.status != 1) {
            popup.addSeparator();
            JMenuItem deleteItem = ResNode.makeMenuItem("Listener.TREE_DELETE", al, true);
            deleteItem.setFocusable(true);
            deleteItem.requestFocus();
            popup.add(deleteItem);
            deleteItem.setAccelerator(KeyStroke.getKeyStroke(Messages.getKeyboardString("Listener.TREE_DELETE")));
            JMenuItem renameItem = ResNode.makeMenuItem("Listener.TREE_RENAME", al, true);
            renameItem.setFocusable(true);
            popup.add(renameItem);
            renameItem.setAccelerator(KeyStroke.getKeyStroke(Messages.getKeyboardString("Listener.TREE_RENAME")));
        }
        if (this.status == 3) {
            JMenuItem editItem = ResNode.makeMenuItem("Listener.TREE_PROPERTIES", al, true);
            editItem.setFocusable(true);
            popup.add(editItem);
            editItem.setAccelerator(KeyStroke.getKeyStroke(Messages.getKeyboardString("Listener.TREE_PROPERTIES")));
        }
        popup.show(e.getComponent(), e.getX(), e.getY());
    }

    @Override
    public void add(MutableTreeNode arg0) {
        super.add(arg0);
        this.fireUpdate();
    }

    @Override
    public void insert(MutableTreeNode newChild, int childIndex) {
        super.insert(newChild, childIndex);
        this.fireUpdate();
    }

    @Override
    public void remove(int childIndex) {
        super.remove(childIndex);
        this.fireUpdate();
    }

    private void fireUpdate() {
        this.fireUpdate(this.trigger.getEvent());
    }

    private Resource<?, ?> deRef() {
        return Util.deRef(this.res);
    }

    private void fireUpdate(UpdateSource.UpdateEvent e) {
        this.trigger.fire(e);
        if (e != null && this.parent != null && this.parent instanceof ResNode) {
            ((ResNode)this.parent).fireUpdate(e);
        }
    }

    public boolean contains(ResourceReference<? extends Resource<?, ?>> res) {
        if (this.res == res) {
            return true;
        }
        if (this.children != null) {
            for (Object obj : this.children) {
                ResNode node;
                if (!(obj instanceof ResNode) || !((node = (ResNode)obj).isLeaf() ? node.res == res : node.contains(res))) continue;
                return true;
            }
        }
        return false;
    }

    public Vector<ResNode> getChildren() {
        return this.children;
    }

    public ResourceReference<? extends Resource<?, ?>> getRes() {
        return this.res;
    }

    @Override
    public void updated(UpdateSource.UpdateEvent e) {
        if (this.kind == Sprite.class || this.kind == Background.class || this.kind == GmObject.class) {
            JInternalFrame[] jInternalFrameArray = LGM.mdi.getAllFrames();
            int n = jInternalFrameArray.length;
            int n2 = 0;
            while (n2 < n) {
                JInternalFrame room = jInternalFrameArray[n2];
                if (room instanceof RoomFrame) {
                    ((RoomFrame)room).resetUndoManager();
                }
                ++n2;
            }
        }
        if (this.status == 3) {
            this.icon = null;
            Resource<?, ?> r = this.deRef();
            if (r != null) {
                this.setUserObject(r.getName());
                Util.invokeOnceLater(this.nameUpdater);
            } else {
                this.removeFromParent();
            }
        }
        this.fireUpdate(e);
    }

    public boolean isInstantiable() {
        return InstantiableResource.class.isAssignableFrom(this.kind);
    }

    public boolean isEditable() {
        return this.isInstantiable();
    }

    private class NameUpdater
    implements Runnable {
        ResNode node;

        public NameUpdater(ResNode resNode2) {
            this.node = resNode2;
        }

        @Override
        public void run() {
            if (ResNode.this.frame != null && ResNode.this.frame instanceof InstantiableResourceFrame) {
                InstantiableResourceFrame resFrame = (InstantiableResourceFrame)ResNode.this.frame;
                Resource r = ResNode.this.deRef();
                if (r != null) {
                    String n = r.getName();
                    resFrame.setTitle(n);
                    if (!resFrame.name.getText().equals(n)) {
                        resFrame.name.setText(n);
                    }
                }
            }
            if (LGM.tree == null) {
                return;
            }
            DefaultTreeModel model = (DefaultTreeModel)LGM.tree.getModel();
            model.nodeChanged(this.node);
        }
    }
}

