/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.components.impl;

import java.awt.Color;
import java.awt.Point;
import java.awt.geom.Point2D;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.lateralgm.resources.Room;
import org.lateralgm.resources.sub.Instance;
import org.lateralgm.subframes.RoomFrame;

public class ModifyPieceInstance
extends AbstractUndoableEdit {
    private static final long serialVersionUID = 1L;
    private final Room.Piece piece;
    private RoomFrame roomFrame;
    private Type type;
    private Object oldVal = null;
    private Object newVal = null;

    public ModifyPieceInstance(RoomFrame roomFrame, Room.Piece piece, Type type, Object oldVal, Object newVal) {
        this.roomFrame = roomFrame;
        this.piece = piece;
        this.type = type;
        this.oldVal = oldVal;
        this.newVal = newVal;
    }

    private void selectPiece() {
        if (this.piece instanceof Instance) {
            this.roomFrame.oList.setSelectedValue(this.piece, true);
            this.roomFrame.fireObjUpdate();
        } else {
            this.roomFrame.tList.setSelectedValue(this.piece, true);
            this.roomFrame.fireTileUpdate();
        }
    }

    @Override
    public void undo() throws CannotUndoException {
        this.selectPiece();
        switch (this.type) {
            case NAME: {
                this.piece.setName((String)this.oldVal);
                break;
            }
            case POSITION: {
                this.piece.setPosition((Point)this.oldVal);
                break;
            }
            case SCALE: {
                this.piece.setScale((Point2D)this.oldVal);
                break;
            }
            case ROTATION: {
                this.piece.setRotation((Double)this.oldVal);
                break;
            }
            case ALPHA: {
                this.piece.setAlpha((Integer)this.oldVal);
                break;
            }
            case COLOR: {
                this.piece.setColor((Color)this.oldVal);
            }
        }
    }

    @Override
    public void redo() throws CannotRedoException {
        this.selectPiece();
        switch (this.type) {
            case NAME: {
                this.piece.setName((String)this.newVal);
                break;
            }
            case POSITION: {
                this.piece.setPosition((Point)this.newVal);
                break;
            }
            case SCALE: {
                this.piece.setScale((Point2D)this.newVal);
                break;
            }
            case ROTATION: {
                this.piece.setRotation((Double)this.newVal);
                break;
            }
            case ALPHA: {
                this.piece.setAlpha((Integer)this.newVal);
                break;
            }
            case COLOR: {
                this.piece.setColor((Color)this.newVal);
            }
        }
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    public static enum Type {
        NAME,
        POSITION,
        SCALE,
        ROTATION,
        ALPHA,
        COLOR;

    }
}

